#define XERR
#include "decryptor.ih"

    // in: current input file, at 'PGP MESSAGE'
void Decryptor::process(istream &in)    // , ostream &out)
{
                                                    // obtain the PGP MESSAGE
    PGPSection pgpSection{ in, *d_pgpMessage };

    if (g_verbose)
         *g_verbose << fileInfo() << ": PGP HEADER" << endl;

    clearFiles();                                   // resize d_pgpMessage and
                                                    // d_decrypted to 0-size

                                                    // get the (complete)
    if (pgpSection.complete())                      // PGP section
    {
                                                    // decrypt it unless only
        if (not d_options.pgpRanges())              // ranges are requested
        {
            size_t attempt = 0;

            while (true)
            {
                d_pgpMessage->seekg(0);
                int ret;
                if 
                (
                    ret = d_gpgHandler.process(d_pgpMessage->fileName());
                    ret == 0
                )
                    break;                    

                if (attempt++ == 3)
                    error(ret, pgpSection.range());

                d_gpgHandler.getPassphrase(attempt);
            }
        }

        return;
    }
                                                    // unless suppressed:
    if (not d_options.skipIncomplete())             // show the INcomplete
        cout << d_pgpMessage->rdbuf();              // PGP MESSAGE
}



