
// copicatreplay1_neg_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  -1.000000
 // --table_div  44.133383
 // --table_op  0.040000

struct tablecopicatreplay1_neg { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablecopicatreplay1_neg_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablecopicatreplay1_neg&() const { return *(tablecopicatreplay1_neg*)this; }
};

 static tablecopicatreplay1_neg_imp<2048> copicatreplay1_neg_table __rt_data = {
	0,0.601351,81.88,2048, {
	0.000000000000,0.000552182129,0.001104014429,0.001655497089,0.002206630296,
	0.002757414239,0.003307849105,0.003857935082,0.004407672358,0.004957061121,
	0.005506101558,0.006054793857,0.006603138204,0.007151134787,0.007698783793,
	0.008246085409,0.008793039821,0.009339647217,0.009885907782,0.010431821704,
	0.010977389169,0.011522610363,0.012067485473,0.012612014683,0.013156198181,
	0.013700036151,0.014243528781,0.014786676255,0.015329478758,0.015871936477,
	0.016414049597,0.016955818302,0.017497242778,0.018038323209,0.018579059781,
	0.019119452679,0.019659502086,0.020199208188,0.020738571168,0.021277591212,
	0.021816268502,0.022354603225,0.022892595562,0.023430245699,0.023967553818,
	0.024504520104,0.025041144740,0.025577427910,0.026113369796,0.026648970583,
	0.027184230452,0.027719149588,0.028253728172,0.028787966389,0.029321864420,
	0.029855422447,0.030388640654,0.030921519223,0.031454058336,0.031986258175,
	0.032518118922,0.033049640759,0.033580823868,0.034111668430,0.034642174627,
	0.035172342641,0.035702172653,0.036231664844,0.036760819395,0.037289636488,
	0.037818116303,0.038346259021,0.038874064823,0.039401533890,0.039928666401,
	0.040455462538,0.040981922480,0.041508046409,0.042033834503,0.042559286943,
	0.043084403909,0.043609185581,0.044133632138,0.044657743759,0.045181520625,
	0.045704962914,0.046228070806,0.046750844480,0.047273284115,0.047795389889,
	0.048317161983,0.048838600573,0.049359705839,0.049880477960,0.050400917114,
	0.050921023478,0.051440797232,0.051960238553,0.052479347619,0.052998124608,
	0.053516569698,0.054034683066,0.054552464891,0.055069915349,0.055587034617,
	0.056103822874,0.056620280295,0.057136407059,0.057652203342,0.058167669320,
	0.058682805171,0.059197611071,0.059712087196,0.060226233724,0.060740050829,
	0.061253538689,0.061766697479,0.062279527376,0.062792028555,0.063304201192,
	0.063816045462,0.064327561542,0.064838749606,0.065349609831,0.065860142390,
	0.066370347460,0.066880225215,0.067389775830,0.067898999480,0.068407896340,
	0.068916466585,0.069424710388,0.069932627925,0.070440219369,0.070947484895,
	0.071454424677,0.071961038888,0.072467327703,0.072973291296,0.073478929840,
	0.073984243509,0.074489232476,0.074993896914,0.075498236997,0.076002252898,
	0.076505944791,0.077009312847,0.077512357240,0.078015078143,0.078517475728,
	0.079019550167,0.079521301634,0.080022730301,0.080523836339,0.081024619921,
	0.081525081219,0.082025220406,0.082525037651,0.083024533128,0.083523707009,
	0.084022559464,0.084521090664,0.085019300783,0.085517189989,0.086014758455,
	0.086512006352,0.087008933851,0.087505541122,0.088001828336,0.088497795663,
	0.088993443275,0.089488771341,0.089983780033,0.090478469519,0.090972839970,
	0.091466891557,0.091960624449,0.092454038815,0.092947134826,0.093439912651,
	0.093932372460,0.094424514422,0.094916338706,0.095407845482,0.095899034918,
	0.096389907184,0.096880462448,0.097370700880,0.097860622648,0.098350227920,
	0.098839516865,0.099328489651,0.099817146447,0.100305487421,0.100793512741,
	0.101281222575,0.101768617091,0.102255696456,0.102742460838,0.103228910406,
	0.103715045326,0.104200865765,0.104686371892,0.105171563872,0.105656441875,
	0.106141006065,0.106625256611,0.107109193678,0.107592817434,0.108076128046,
	0.108559125679,0.109041810500,0.109524182676,0.110006242372,0.110487989756,
	0.110969424991,0.111450548246,0.111931359685,0.112411859474,0.112892047778,
	0.113371924764,0.113851490597,0.114330745441,0.114809689463,0.115288322827,
	0.115766645698,0.116244658241,0.116722360621,0.117199753003,0.117676835552,
	0.118153608431,0.118630071805,0.119106225839,0.119582070697,0.120057606542,
	0.120532833540,0.121007751854,0.121482361647,0.121956663084,0.122430656328,
	0.122904341542,0.123377718891,0.123850788537,0.124323550644,0.124796005375,
	0.125268152893,0.125739993360,0.126211526940,0.126682753796,0.127153674090,
	0.127624287985,0.128094595643,0.128564597226,0.129034292898,0.129503682819,
	0.129972767153,0.130441546061,0.130910019705,0.131378188246,0.131846051848,
	0.132313610670,0.132780864875,0.133247814624,0.133714460079,0.134180801400,
	0.134646838748,0.135112572286,0.135578002173,0.136043128571,0.136507951640,
	0.136972471541,0.137436688435,0.137900602481,0.138364213841,0.138827522674,
	0.139290529141,0.139753233402,0.140215635616,0.140677735944,0.141139534546,
	0.141601031581,0.142062227208,0.142523121588,0.142983714879,0.143444007241,
	0.143903998833,0.144363689815,0.144823080345,0.145282170582,0.145740960685,
	0.146199450813,0.146657641124,0.147115531778,0.147573122932,0.148030414744,
	0.148487407374,0.148944100979,0.149400495717,0.149856591747,0.150312389226,
	0.150767888312,0.151223089163,0.151677991936,0.152132596789,0.152586903879,
	0.153040913364,0.153494625400,0.153948040146,0.154401157757,0.154853978392,
	0.155306502206,0.155758729357,0.156210660002,0.156662294296,0.157113632396,
	0.157564674459,0.158015420642,0.158465871099,0.158916025988,0.159365885464,
	0.159815449684,0.160264718802,0.160713692976,0.161162372360,0.161610757110,
	0.162058847382,0.162506643330,0.162954145111,0.163401352879,0.163848266790,
	0.164294886998,0.164741213658,0.165187246926,0.165632986956,0.166078433902,
	0.166523587919,0.166968449162,0.167413017784,0.167857293941,0.168301277786,
	0.168744969473,0.169188369157,0.169631476991,0.170074293130,0.170516817725,
	0.170959050933,0.171400992905,0.171842643796,0.172284003758,0.172725072945,
	0.173165851511,0.173606339607,0.174046537388,0.174486445006,0.174926062614,
	0.175365390364,0.175804428410,0.176243176903,0.176681635996,0.177119805842,
	0.177557686592,0.177995278400,0.178432581416,0.178869595793,0.179306321684,
	0.179742759238,0.180178908609,0.180614769948,0.181050343407,0.181485629136,
	0.181920627288,0.182355338013,0.182789761463,0.183223897788,0.183657747141,
	0.184091309670,0.184524585529,0.184957574866,0.185390277833,0.185822694581,
	0.186254825259,0.186686670019,0.187118229009,0.187549502381,0.187980490285,
	0.188411192871,0.188841610288,0.189271742686,0.189701590216,0.190131153026,
	0.190560431266,0.190989425086,0.191418134636,0.191846560063,0.192274701518,
	0.192702559150,0.193130133108,0.193557423540,0.193984430595,0.194411154423,
	0.194837595172,0.195263752990,0.195689628026,0.196115220428,0.196540530345,
	0.196965557925,0.197390303316,0.197814766666,0.198238948122,0.198662847834,
	0.199086465948,0.199509802612,0.199932857975,0.200355632182,0.200778125383,
	0.201200337724,0.201622269352,0.202043920414,0.202465291058,0.202886381431,
	0.203307191680,0.203727721950,0.204147972390,0.204567943145,0.204987634363,
	0.205407046189,0.205826178771,0.206245032253,0.206663606784,0.207081902508,
	0.207499919571,0.207917658120,0.208335118301,0.208752300259,0.209169204139,
	0.209585830089,0.210002178252,0.210418248774,0.210834041802,0.211249557479,
	0.211664795951,0.212079757364,0.212494441861,0.212908849589,0.213322980692,
	0.213736835314,0.214150413600,0.214563715695,0.214976741744,0.215389491890,
	0.215801966278,0.216214165052,0.216626088356,0.217037736334,0.217449109131,
	0.217860206890,0.218271029754,0.218681577868,0.219091851375,0.219501850419,
	0.219911575143,0.220321025690,0.220730202205,0.221139104828,0.221547733705,
	0.221956088978,0.222364170790,0.222771979283,0.223179514601,0.223586776886,
	0.223993766281,0.224400482927,0.224806926969,0.225213098547,0.225618997805,
	0.226024624884,0.226429979926,0.226835063074,0.227239874468,0.227644414252,
	0.228048682567,0.228452679555,0.228856405356,0.229259860113,0.229663043966,
	0.230065957058,0.230468599530,0.230870971522,0.231273073175,0.231674904631,
	0.232076466031,0.232477757515,0.232878779224,0.233279531299,0.233680013879,
	0.234080227107,0.234480171121,0.234879846063,0.235279252073,0.235678389290,
	0.236077257855,0.236475857907,0.236874189588,0.237272253035,0.237670048390,
	0.238067575791,0.238464835379,0.238861827293,0.239258551671,0.239655008655,
	0.240051198381,0.240447120991,0.240842776623,0.241238165415,0.241633287507,
	0.242028143037,0.242422732145,0.242817054969,0.243211111647,0.243604902318,
	0.243998427120,0.244391686192,0.244784679671,0.245177407697,0.245569870406,
	0.245962067938,0.246354000429,0.246745668018,0.247137070843,0.247528209040,
	0.247919082749,0.248309692105,0.248700037247,0.249090118312,0.249479935437,
	0.249869488759,0.250258778415,0.250647804543,0.251036567279,0.251425066760,
	0.251813303122,0.252201276504,0.252588987040,0.252976434868,0.253363620124,
	0.253750542944,0.254137203464,0.254523601822,0.254909738152,0.255295612592,
	0.255681225276,0.256066576340,0.256451665921,0.256836494155,0.257221061176,
	0.257605367120,0.257989412123,0.258373196320,0.258756719847,0.259139982838,
	0.259522985428,0.259905727754,0.260288209949,0.260670432149,0.261052394488,
	0.261434097102,0.261815540124,0.262196723690,0.262577647933,0.262958312989,
	0.263338718991,0.263718866074,0.264098754372,0.264478384019,0.264857755150,
	0.265236867897,0.265615722395,0.265994318777,0.266372657178,0.266750737731,
	0.267128560569,0.267506125826,0.267883433636,0.268260484130,0.268637277444,
	0.269013813709,0.269390093060,0.269766115628,0.270141881547,0.270517390950,
	0.270892643968,0.271267640736,0.271642381386,0.272016866049,0.272391094859,
	0.272765067948,0.273138785447,0.273512247490,0.273885454209,0.274258405734,
	0.274631102199,0.275003543735,0.275375730475,0.275747662548,0.276119340088,
	0.276490763226,0.276861932093,0.277232846821,0.277603507541,0.277973914385,
	0.278344067482,0.278713966965,0.279083612965,0.279453005612,0.279822145038,
	0.280191031372,0.280559664747,0.280928045291,0.281296173137,0.281664048414,
	0.282031671252,0.282399041783,0.282766160136,0.283133026442,0.283499640830,
	0.283866003430,0.284232114373,0.284597973788,0.284963581805,0.285328938554,
	0.285694044164,0.286058898765,0.286423502487,0.286787855458,0.287151957808,
	0.287515809666,0.287879411161,0.288242762423,0.288605863580,0.288968714762,
	0.289331316097,0.289693667713,0.290055769741,0.290417622307,0.290779225541,
	0.291140579572,0.291501684527,0.291862540535,0.292223147724,0.292583506222,
	0.292943616158,0.293303477658,0.293663090853,0.294022455868,0.294381572832,
	0.294740441873,0.295099063117,0.295457436694,0.295815562730,0.296173441352,
	0.296531072688,0.296888456866,0.297245594011,0.297602484252,0.297959127715,
	0.298315524528,0.298671674817,0.299027578709,0.299383236330,0.299738647808,
	0.300093813269,0.300448732839,0.300803406645,0.301157834812,0.301512017469,
	0.301865954739,0.302219646751,0.302573093629,0.302926295499,0.303279252489,
	0.303631964722,0.303984432326,0.304336655425,0.304688634146,0.305040368613,
	0.305391858953,0.305743105290,0.306094107750,0.306444866458,0.306795381540,
	0.307145653120,0.307495681323,0.307845466274,0.308195008098,0.308544306920,
	0.308893362865,0.309242176057,0.309590746620,0.309939074680,0.310287160360,
	0.310635003785,0.310982605079,0.311329964366,0.311677081770,0.312023957416,
	0.312370591428,0.312716983928,0.313063135042,0.313409044892,0.313754713603,
	0.314100141297,0.314445328100,0.314790274133,0.315134979520,0.315479444385,
	0.315823668851,0.316167653041,0.316511397078,0.316854901085,0.317198165185,
	0.317541189500,0.317883974155,0.318226519270,0.318568824970,0.318910891376,
	0.319252718611,0.319594306797,0.319935656057,0.320276766513,0.320617638287,
	0.320958271502,0.321298666279,0.321638822740,0.321978741008,0.322318421204,
	0.322657863449,0.322997067866,0.323336034577,0.323674763702,0.324013255363,
	0.324351509682,0.324689526779,0.325027306777,0.325364849796,0.325702155958,
	0.326039225383,0.326376058193,0.326712654508,0.327049014450,0.327385138138,
	0.327721025694,0.328056677238,0.328392092891,0.328727272773,0.329062217005,
	0.329396925707,0.329731399000,0.330065637002,0.330399639835,0.330733407619,
	0.331066940474,0.331400238518,0.331733301873,0.332066130658,0.332398724993,
	0.332731084997,0.333063210790,0.333395102492,0.333726760221,0.334058184097,
	0.334389374240,0.334720330768,0.335051053800,0.335381543457,0.335711799856,
	0.336041823116,0.336371613357,0.336701170698,0.337030495256,0.337359587150,
	0.337688446500,0.338017073423,0.338345468038,0.338673630464,0.339001560817,
	0.339329259218,0.339656725784,0.339983960632,0.340310963882,0.340637735650,
	0.340964276056,0.341290585215,0.341616663247,0.341942510269,0.342268126398,
	0.342593511752,0.342918666449,0.343243590605,0.343568284339,0.343892747767,
	0.344216981006,0.344540984173,0.344864757387,0.345188300762,0.345511614417,
	0.345834698469,0.346157553033,0.346480178227,0.346802574167,0.347124740969,
	0.347446678751,0.347768387629,0.348089867718,0.348411119136,0.348732141998,
	0.349052936420,0.349373502520,0.349693840411,0.350013950211,0.350333832036,
	0.350653486000,0.350972912220,0.351292110812,0.351611081890,0.351929825572,
	0.352248341971,0.352566631203,0.352884693384,0.353202528629,0.353520137052,
	0.353837518770,0.354154673897,0.354471602548,0.354788304838,0.355104780882,
	0.355421030795,0.355737054690,0.356052852684,0.356368424889,0.356683771422,
	0.356998892396,0.357313787926,0.357628458125,0.357942903109,0.358257122991,
	0.358571117885,0.358884887906,0.359198433167,0.359511753782,0.359824849866,
	0.360137721531,0.360450368891,0.360762792060,0.361074991152,0.361386966280,
	0.361698717558,0.362010245098,0.362321549014,0.362632629420,0.362943486428,
	0.363254120151,0.363564530703,0.363874718196,0.364184682744,0.364494424458,
	0.364803943453,0.365113239840,0.365422313732,0.365731165241,0.366039794481,
	0.366348201563,0.366656386600,0.366964349704,0.367272090988,0.367579610563,
	0.367886908541,0.368193985035,0.368500840157,0.368807474018,0.369113886730,
	0.369420078404,0.369726049154,0.370031799090,0.370337328323,0.370642636966,
	0.370947725129,0.371252592924,0.371557240463,0.371861667856,0.372165875214,
	0.372469862649,0.372773630273,0.373077178194,0.373380506526,0.373683615377,
	0.373986504860,0.374289175085,0.374591626162,0.374893858202,0.375195871316,
	0.375497665614,0.375799241206,0.376100598202,0.376401736714,0.376702656850,
	0.377003358722,0.377303842439,0.377604108111,0.377904155848,0.378203985760,
	0.378503597957,0.378802992548,0.379102169644,0.379401129353,0.379699871785,
	0.379998397050,0.380296705256,0.380594796515,0.380892670934,0.381190328622,
	0.381487769690,0.381784994246,0.382082002399,0.382378794257,0.382675369931,
	0.382971729528,0.383267873158,0.383563800929,0.383859512950,0.384155009329,
	0.384450290175,0.384745355596,0.385040205701,0.385334840598,0.385629260395,
	0.385923465200,0.386217455122,0.386511230268,0.386804790747,0.387098136666,
	0.387391268133,0.387684185257,0.387976888144,0.388269376903,0.388561651640,
	0.388853712465,0.389145559484,0.389437192804,0.389728612533,0.390019818778,
	0.390310811646,0.390601591245,0.390892157682,0.391182511064,0.391472651497,
	0.391762579088,0.392052293945,0.392341796175,0.392631085883,0.392920163177,
	0.393209028163,0.393497680948,0.393786121638,0.394074350339,0.394362367159,
	0.394650172203,0.394937765577,0.395225147388,0.395512317741,0.395799276744,
	0.396086024501,0.396372561118,0.396658886703,0.396945001359,0.397230905194,
	0.397516598312,0.397802080819,0.398087352822,0.398372414424,0.398657265732,
	0.398941906852,0.399226337887,0.399510558944,0.399794570128,0.400078371544,
	0.400361963297,0.400645345491,0.400928518232,0.401211481625,0.401494235775,
	0.401776780785,0.402059116762,0.402341243808,0.402623162030,0.402904871532,
	0.403186372417,0.403467664791,0.403748748757,0.404029624420,0.404310291884,
	0.404590751253,0.404871002632,0.405151046124,0.405430881832,0.405710509862,
	0.405989930317,0.406269143301,0.406548148916,0.406826947268,0.407105538459,
	0.407383922594,0.407662099774,0.407940070105,0.408217833689,0.408495390629,
	0.408772741029,0.409049884992,0.409326822621,0.409603554019,0.409880079289,
	0.410156398533,0.410432511856,0.410708419359,0.410984121145,0.411259617317,
	0.411534907977,0.411809993229,0.412084873174,0.412359547915,0.412634017555,
	0.412908282195,0.413182341938,0.413456196886,0.413729847141,0.414003292805,
	0.414276533981,0.414549570770,0.414822403275,0.415095031596,0.415367455836,
	0.415639676096,0.415911692479,0.416183505085,0.416455114016,0.416726519375,
	0.416997721261,0.417268719777,0.417539515023,0.417810107102,0.418080496113,
	0.418350682159,0.418620665341,0.418890445759,0.419160023514,0.419429398707,
	0.419698571439,0.419967541811,0.420236309924,0.420504875878,0.420773239773,
	0.421041401711,0.421309361791,0.421577120115,0.421844676782,0.422112031893,
	0.422379185548,0.422646137847,0.422912888890,0.423179438778,0.423445787610,
	0.423711935487,0.423977882507,0.424243628772,0.424509174381,0.424774519433,
	0.425039664028,0.425304608266,0.425569352247,0.425833896069,0.426098239832,
	0.426362383637,0.426626327580,0.426890071763,0.427153616285,0.427416961244,
	0.427680106739,0.427943052870,0.428205799735,0.428468347434,0.428730696065,
	0.428992845727,0.429254796519,0.429516548540,0.429778101887,0.430039456660,
	0.430300612957,0.430561570877,0.430822330517,0.431082891977,0.431343255354,
	0.431603420747,0.431863388254,0.432123157973,0.432382730002,0.432642104439,
	0.432901281382,0.433160260928,0.433419043177,0.433677628224,0.433936016169,
	0.434194207109,0.434452201140,0.434709998362,0.434967598871,0.435225002764,
	0.435482210140,0.435739221095,0.435996035727,0.436252654132,0.436509076409,
	0.436765302653,0.437021332963,0.437277167434,0.437532806165,0.437788249251,
	0.438043496789,0.438298548877,0.438553405611,0.438808067088,0.439062533404,
	0.439316804655,0.439570880938,0.439824762351,0.440078448987,0.440331940946,
	0.440585238321,0.440838341210,0.441091249709,0.441343963913,0.441596483920,
	0.441848809824,0.442100941722,0.442352879709,0.442604623881,0.442856174335,
	0.443107531165,0.443358694467,0.443609664337,0.443860440871,0.444111024163,
	0.444361414310,0.444611611406,0.444861615547,0.445111426828,0.445361045345,
	0.445610471192,0.445859704464,0.446108745257,0.446357593665,0.446606249783,
	0.446854713707,0.447102985531,0.447351065349,0.447598953257,0.447846649349,
	0.448094153719,0.448341466462,0.448588587674,0.448835517447,0.449082255876,
	0.449328803056,0.449575159081,0.449821324045,0.450067298042,0.450313081167,
	0.450558673513,0.450804075174,0.451049286244,0.451294306818,0.451539136988,
	0.451783776849,0.452028226494,0.452272486018,0.452516555513,0.452760435073,
	0.453004124791,0.453247624762,0.453490935078,0.453734055833,0.453976987120,
	0.454219729032,0.454462281663,0.454704645105,0.454946819452,0.455188804796,
	0.455430601231,0.455672208849,0.455913627743,0.456154858007,0.456395899732,
	0.456636753011,0.456877417938,0.457117894604,0.457358183103,0.457598283526,
	0.457838195966,0.458077920516,0.458317457267,0.458556806312,0.458795967743,
	0.459034941653,0.459273728133,0.459512327276,0.459750739172,0.459988963916,
	0.460227001597,0.460464852309,0.460702516142,0.460939993189,0.461177283541,
	0.461414387290,0.461651304527,0.461888035345,0.462124579833,0.462360938085,
	0.462597110190,0.462833096241,0.463068896329,0.463304510545,0.463539938979,
	0.463775181724,0.464010238870,0.464245110508,0.464479796729,0.464714297623,
	0.464948613283,0.465182743798,0.465416689260,0.465650449759,0.465884025385,
	0.466117416229,0.466350622382,0.466583643934,0.466816480975,0.467049133596,
	0.467281601888,0.467513885940,0.467745985843,0.467977901686,0.468209633560,
	0.468441181556,0.468672545762,0.468903726269,0.469134723167,0.469365536546,
	0.469596166495,0.469826613104,0.470056876463,0.470286956662,0.470516853789,
	0.470746567935,0.470976099190,0.471205447641,0.471434613380,0.471663596495,
	0.471892397076,0.472121015211,0.472349450990,0.472577704502,0.472805775836,
	0.473033665081,0.473261372327,0.473488897661,0.473716241174,0.473943402953,
	0.474170383087,0.474397181666,0.474623798777,0.474850234510,0.475076488953,
	0.475302562195,0.475528454323,0.475754165427,0.475979695595,0.476205044915,
	0.476430213475,0.476655201364,0.476880008669,0.477104635479,0.477329081882,
	0.477553347966,0.477777433819,0.478001339529,0.478225065183,0.478448610870,
	0.478671976677,0.478895162691,0.479118169001,0.479340995695,0.479563642859,
	0.479786110581,0.480008398949,0.480230508050,0.480452437972,0.480674188801,
	0.480895760625,0.481117153532,0.481338367607,0.481559402940,0.481780259615,
	0.482000937722,0.482221437346,0.482441758574,0.482661901493,0.482881866191,
	0.483101652753,0.483321261267,0.483540691819,0.483759944496,0.483979019384,
	0.484197916571,0.484416636141,0.484635178183,0.484853542781,0.485071730023,
	0.485289739995,0.485507572782,0.485725228472,0.485942707150,0.486160008903,
	0.486377133815,0.486594081974,0.486810853465,0.487027448375,0.487243866788,
	0.487460108791,0.487676174469,0.487892063909,0.488107777195,0.488323314414,
	0.488538675650,0.488753860990,0.488968870518,0.489183704321,0.489398362484,
	0.489612845091,0.489827152228,0.490041283980,0.490255240433,0.490469021672,
	0.490682627781,0.490896058845,0.491109314950,0.491322396181,0.491535302621,
	0.491748034357,0.491960591473,0.492172974053,0.492385182182,0.492597215946,
	0.492809075427,0.493020760712,0.493232271884,0.493443609028,0.493654772228,
	0.493865761568,0.494076577133,0.494287219008,0.494497687276,0.494707982021,
	0.494918103327,0.495128051279,0.495337825961,0.495547427456,0.495756855848,
	0.495966111222,0.496175193660,0.496384103248,0.496592840067,0.496801404203,
	0.497009795739,0.497218014758,0.497426061344,0.497633935581,0.497841637551,
	0.498049167338,0.498256525026,0.498463710697,0.498670724436,0.498877566324,
	0.499084236447,0.499290734885,0.499497061723,0.499703217044,0.499909200929,
	0.500115013464,0.500320654729,0.500526124809,0.500731423785,0.500936551741,
	0.501141508760,0.501346294923,0.501550910313,0.501755355014,0.501959629107,
	0.502163732675,0.502367665800,0.502571428565,0.502775021052,0.502978443343,
	0.503181695520,0.503384777666,0.503587689863,0.503790432193,0.503993004738,
	0.504195407579,0.504397640799,0.504599704480,0.504801598703,0.505003323551,
	0.505204879104,0.505406265446,0.505607482657,0.505808530818,0.506009410013,
	0.506210120321,0.506410661825,0.506611034606,0.506811238746,0.507011274325,
	0.507211141425,0.507410840128,0.507610370514,0.507809732665,0.508008926661,
	0.508207952585,0.508406810516,0.508605500536,0.508804022725,0.509002377166,
	0.509200563938,0.509398583122,0.509596434799,0.509794119050,0.509991635955,
	0.510188985595,0.510386168051,0.510583183403,0.510780031731,0.510976713116,
	0.511173227639,0.511369575380,0.511565756418,0.511761770835,0.511957618710,
	0.512153300124,0.512348815157,0.512544163888,0.512739346398,0.512934362767,
	0.513129213075,0.513323897402,0.513518415827,0.513712768431,0.513906955292,
	0.514100976492,0.514294832108,0.514488522222,0.514682046913,0.514875406260,
	0.515068600342,0.515261629240,0.515454493032,0.515647191799,0.515839725618,
	0.516032094570,0.516224298734,0.516416338189,0.516608213013,0.516799923287,
	0.516991469090,0.517182850499,0.517374067595,0.517565120455,0.517756009160,
	0.517946733787,0.518137294417,0.518327691126,0.518517923994,0.518707993101,
	0.518897898523,0.519087640341,0.519277218631,0.519466633474,0.519655884947,
	0.519844973129,0.520033898098,0.520222659932,0.520411258710,0.520599694510,
	0.520787967410,0.520976077488,0.521164024822,0.521351809490,0.521539431571,
	0.521726891143,0.521914188282,0.522101323067,0.522288295577,0.522475105888,
	0.522661754078,0.522848240226,0.523034564408,0.523220726703,0.523406727188,
	0.523592565940,0.523778243037,0.523963758557,0.524149112577,0.524334305173,
	0.524519336424,0.524704206408,0.524888915200,0.525073462878,0.525257849519,
	0.525442075201,0.525626140001,0.525810043995,0.525993787260,0.526177369874,
	0.526360791913,0.526544053455,0.526727154575,0.526910095351,0.527092875860,
	0.527275496177,0.527457956381,0.527640256546,0.527822396751,0.528004377071,
	0.528186197583,0.528367858363,0.528549359487,0.528730701033,0.528911883076,
	0.529092905693,0.529273768959,0.529454472951,0.529635017746,0.529815403418,
	0.529995630045,0.530175697702,0.530355606465,0.530535356410,0.530714947613,
	0.530894380150,0.531073654096,0.531252769528,0.531431726521,0.531610525150,
	0.531789165492,0.531967647622,0.532145971615,0.532324137547,0.532502145494,
	0.532679995530,0.532857687732,0.533035222174,0.533212598932,0.533389818081,
	0.533566879697,0.533743783854,0.533920530628,0.534097120093,0.534273552325,
	0.534449827399,0.534625945390,0.534801906372,0.534977710421,0.535153357611,
	0.535328848018,0.535504181715,0.535679358778,0.535854379282,0.536029243300,
	0.536203950908,0.536378502181,0.536552897191,0.536727136015,0.536901218727,
	0.537075145400,0.537248916110,0.537422530931,0.537595989936,0.537769293201,
	0.537942440799,0.538115432804,0.538288269291,0.538460950333,0.538633476006,
	0.538805846381,0.538978061535,0.539150121540,0.539322026470,0.539493776400,
	0.539665371403,0.539836811552,0.540008096922,0.540179227586,0.540350203618,
	0.540521025091,0.540691692079,0.540862204655,0.541032562894,0.541202766867,
	0.541372816649,0.541542712314,0.541712453933,0.541882041581,0.542051475331,
	0.542220755256,0.542389881429,0.542558853924,0.542727672813,0.542896338169,
	0.543064850065,0.543233208575,0.543401413771,0.543569465726,0.543737364513,
	0.543905110204,0.544072702873,0.544240142592,0.544407429434,0.544574563472,
	0.544741544777,0.544908373423,0.545075049483,0.545241573028,0.545407944131,
	0.545574162864,0.545740229300,0.545906143511,0.546071905570,0.546237515548,
	0.546402973518,0.546568279553,0.546733433723,0.546898436101,0.547063286760,
	0.547227985771,0.547392533206,0.547556929138,0.547721173637,0.547885266776,
	0.548049208627,0.548212999262,0.548376638752,0.548540127168,0.548703464584,
	0.548866651069,0.549029686696,0.549192571537,0.549355305662,0.549517889144,
	0.549680322053,0.549842604462,0.550004736441,0.550166718062,0.550328549395,
	0.550490230513,0.550651761487,0.550813142387,0.550974373285,0.551135454252,
	0.551296385359,0.551457166676,0.551617798276,0.551778280228,0.551938612604,
	0.552098795474,0.552258828910,0.552418712982,0.552578447760,0.552738033317,
	0.552897469721,0.553056757044,0.553215895357,0.553374884730,0.553533725233,
	0.553692416937,0.553850959913,0.554009354231,0.554167599960,0.554325697172,
	0.554483645937,0.554641446325,0.554799098407,0.554956602251,0.555113957929,
	0.555271165511,0.555428225067,0.555585136666,0.555741900379,0.555898516276,
	0.556054984426,0.556211304900,0.556367477767,0.556523503097,0.556679380960,
	0.556835111426,0.556990694564,0.557146130443,0.557301419135,0.557456560707,
	0.557611555230,0.557766402774,0.557921103407,0.558075657198,0.558230064219,
	0.558384324537,0.558538438222,0.558692405344,0.558846225972,0.558999900174,
	0.559153428020,0.559306809579,0.559460044921,0.559613134114,0.559766077227,
	0.559918874330,0.560071525491,0.560224030779,0.560376390264,0.560528604013,
	0.560680672096,0.560832594581,0.560984371538,0.561136003034,0.561287489139,
	0.561438829922,0.561590025450,0.561741075792,0.561891981018,0.562042741194,
	0.562193356391,0.562343826675,0.562494152116,0.562644332783,0.562794368742,
	0.562944260063,0.563094006813,0.563243609061,0.563393066875,0.563542380324,
	0.563691549474,0.563840574395,0.563989455154,0.564138191820,0.564286784459,
	0.564435233141,0.564583537933,0.564731698902,0.564879716117,0.565027589645,
	0.565175319554,0.565322905913,0.565470348787,0.565617648246,0.565764804356,
	0.565911817185,0.566058686801,0.566205413271,0.566351996663,0.566498437043,
	0.566644734480,0.566790889041,0.566936900793,0.567082769803,0.567228496138,
	0.567374079866,0.567519521054,0.567664819769,0.567809976077,0.567954990047,
	0.568099861745,0.568244591238,0.568389178594,0.568533623878,0.568677927157,
	0.568822088500,0.568966107972,0.569109985640,0.569253721572,0.569397315832,
	0.569540768490,0.569684079610,0.569827249260,0.569970277506,0.570113164414,
	0.570255910052,0.570398514486,0.570540977781,0.570683300005,0.570825481224,
	0.570967521504,0.571109420911,0.571251179512,0.571392797372,0.571534274559,
	0.571675611138,0.571816807176,0.571957862737,0.572098777889,0.572239552698,
	0.572380187229,0.572520681549,0.572661035722,0.572801249816,0.572941323896,
	0.573081258028,0.573221052277,0.573360706710,0.573500221391,0.573639596387,
	0.573778831764,0.573917927587,0.574056883921,0.574195700832,0.574334378385,
	0.574472916647,0.574611315682,0.574749575556,0.574887696334,0.575025678081,
	0.575163520864,0.575301224746,0.575438789794,0.575576216072,0.575713503646,
	0.575850652581,0.575987662941,0.576124534793,0.576261268200,0.576397863229,
	0.576534319943,0.576670638409,0.576806818690,0.576942860852,0.577078764959,
	0.577214531076,0.577350159269,0.577485649601,0.577621002138,0.577756216943,
	0.577891294083,0.578026233621,0.578161035621,0.578295700149,0.578430227269,
	0.578564617046,0.578698869543,0.578832984825,0.578966962957,0.579100804003,
	0.579234508027,0.579368075093,0.579501505266,0.579634798610,0.579767955189,
	0.579900975067,0.580033858309,0.580166604978,0.580299215138,0.580431688854,
	0.580564026189,0.580696227207,0.580828291972,0.580960220549,0.581092013000,
	0.581223669390,0.581355189783,0.581486574242,0.581617822831,0.581748935613,
	0.581879912653,0.582010754013,0.582141459758,0.582272029951,0.582402464656,
	0.582532763935,0.582662927853,0.582792956473,0.582922849858,0.583052608072,
	0.583182231178,0.583311719239,0.583441072318,0.583570290479,0.583699373785,
	0.583828322299,0.583957136084,0.584085815204,0.584214359721,0.584342769698,
	0.584471045199,0.584599186286,0.584727193022,0.584855065471,0.584982803694,
	0.585110407756,0.585237877718,0.585365213644,0.585492415596,0.585619483637,
	0.585746417829,0.585873218236,0.585999884920,0.586126417944,0.586252817369,
	0.586379083259,0.586505215676,0.586631214683,0.586757080342,0.586882812715,
	0.587008411865,0.587133877854,0.587259210745,0.587384410599,0.587509477479,
	0.587634411447,0.587759212566,0.587883880897,0.588008416502,0.588132819445,
	0.588257089786,0.588381227588,0.588505232912,0.588629105822,0.588752846378,
	0.588876454642,0.588999930677,0.589123274545,0.589246486306,0.589369566023,
	0.589492513758,0.589615329572,0.589738013528,0.589860565685,0.589982986108,
	0.590105274856,0.590227431991,0.590349457576,0.590471351671,0.590593114337,
	0.590714745638,0.590836245633,0.590957614384,0.591078851953,0.591199958401,
	0.591320933788,0.591441778178,0.591562491629,0.591683074205,0.591803525966,
	0.591923846972,0.592044037286,0.592164096969,0.592284026080,0.592403824682,
	0.592523492836,0.592643030601,0.592762438040,0.592881715213,0.593000862181,
	0.593119879005,0.593238765745,0.593357522463,0.593476149218,0.593594646073,
	0.593713013087,0.593831250322,0.593949357837,0.594067335694,0.594185183952,
	0.594302902673,0.594420491917,0.594537951745,0.594655282216,0.594772483392,
	0.594889555332,0.595006498098,0.595123311749,0.595239996346,0.595356551948,
	0.595472978617,0.595589276412,0.595705445394,0.595821485622,0.595937397158,
	0.596053180060,0.596168834389,0.596284360206,0.596399757569,0.596515026539,
	0.596630167176,0.596745179541,0.596860063691,0.596974819689,0.597089447593,
	0.597203947463,0.597318319359,0.597432563340,0.597546679468,0.597660667800,
	0.597774528397,0.597888261318,0.598001866623,0.598115344372,0.598228694624,
	0.598341917439,0.598455012875,0.598567980993,0.598680821852,0.598793535511,
	0.598906122030,0.599018581468,0.599130913884,0.599243119337,0.599355197888,
	0.599467149594,0.599578974516,0.599690672712,0.599802244241,0.599913689163,
	0.600025007537,0.600136199421,0.600247264876,0.600358203958,0.600469016729,
	0.600579703246,0.600690263569,0.600800697756,0.600911005866,0.601021187958,
	0.601131244091,0.601241174324,0.601350978715
	}
};

double always_inline copicatreplay1_negclip(double x) {
    double f = fabs(x);
    f = f * copicatreplay1_neg_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = copicatreplay1_neg_table.data[0];
    } else if (i >= copicatreplay1_neg_table.size-1) {
        f = copicatreplay1_neg_table.data[copicatreplay1_neg_table.size-1];
    } else {
    f -= i;
    f = copicatreplay1_neg_table.data[i]*(1-f) + copicatreplay1_neg_table.data[i+1]*f;
    }
    return copysign(f, x);
}

