% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foldchange.R
\name{foldchange}
\alias{foldchange}
\alias{logratio2foldchange}
\alias{foldchange2logratio}
\title{Compute fold-change or convert between log-ratio and fold-change.}
\usage{
foldchange(num, denom)

logratio2foldchange(logratio, base = 2)

foldchange2logratio(foldchange, base = 2)
}
\arguments{
\item{num, denom}{vector/matrix of numeric values}

\item{logratio}{vector/matrix of log-ratio values}

\item{base}{Exponential base for the log-ratio.}

\item{foldchange}{vector/matrix of fold-change values}
}
\value{
A vector or matrix of the same dimensions as the input containing
the converted values.
}
\description{
\code{foldchange} computes the fold change for two sets of values.
\code{logratio2foldchange} converts values from log-ratios to fold changes.
\code{foldchange2logratio} does the reverse.
}
\details{
Fold changes are commonly used in the biological sciences as a mechanism for
comparing the relative size of two measurements.  They are computed as:
\eqn{\frac{num}{denom}}{num/denom} if \eqn{num>denom}, and as
\eqn{\frac{-denom}{num}}{-denom/num} otherwise.

Fold-changes have the advantage of ease of interpretation and symmetry about
\eqn{num=denom}, but suffer from a discontinuity between -1 and 1, which can
cause significant problems when performing data analysis.  Consequently
statisticians prefer to use log-ratios.
}
\section{Functions}{
\itemize{
\item \code{foldchange}: Compute fold-change.

\item \code{logratio2foldchange}: Compute foldchange from log-ratio values.

\item \code{foldchange2logratio}: Compute log-ratio from fold-change values.
}}

\examples{


a <- 1:21
b <- 21:1

f <- foldchange(a, b)

cbind(a, b, f)
}
\author{
Gregory R. Warnes \email{greg@warnes.net}
}
\keyword{math}
