/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "icons.h"
#include "tube.h"
#include "tube_pair.h"

TubePair::TubePair(GtkWidget* table, int row, int col) 
   : _right_pair(0), _bottom_pair(0)
{
   _direction = TubePair::Right;
   _left_tube = _upper_tube = new RightTube;
   _right_tube = _lower_tube = new RightTube;

   /* now for the pixmap from gdk */
   GtkWidget* button = gtk_button_new();

   _pixmapwid = gtk_image_new_from_stock(GROUNDHOG_STOCK_TUBE_RIGHT,
					 Icons::Size());
   /* a button to contain the pixmap widget */
   gtk_container_add(GTK_CONTAINER(button), _pixmapwid);

/*   gtk_table_attach_defaults(GTK_TABLE(table), button, col, col + 1, 
     row, row + 1); */
   gtk_table_attach(GTK_TABLE(table), button, col, col + 1, 
		    row, row + 1, GTK_EXPAND, GTK_EXPAND, 0, 0);

   g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(&TubePair::Toggle),
		    (gpointer) this);
}

void
TubePair::Toggle(GtkWidget *widget, gpointer data)
{
   ((TubePair*) data)->ToggleDirection();
}

void
TubePair::ConnectLeft(TubePair* pair)
{
   pair->ConnectRight(_left_tube);
}

void
TubePair::ConnectLeft(Element* element)
{
   _left_tube->ConnectLeft(element);
   element->ConnectRight(_left_tube);
}

void
TubePair::ConnectTop(TubePair* pair)
{
   pair->ConnectBottom(_upper_tube);
}

void
TubePair::ConnectTop(Element* element)
{
   _upper_tube->ConnectTop(element);
   element->ConnectBottom(_upper_tube);
}

void
TubePair::ConnectRight(TubePair* pair)
{
   pair->ConnectLeft(_right_tube);
   _right_pair = pair;
}

void
TubePair::ConnectRight(Element* element)
{
   _right_tube->ConnectRight(element);
   element->ConnectLeft(_right_tube);
}

void
TubePair::ConnectBottom(TubePair* pair)
{
   pair->ConnectTop(_lower_tube);
   _bottom_pair = pair;
}

void
TubePair::ConnectBottom(Element* element)
{
   _lower_tube->ConnectBottom(element);
   element->ConnectTop(_lower_tube);
}

void
TubePair::ToggleDirection()
{
   Element* left_element;
   Element* top_element;
   Element* right_element;
   Element* bottom_element;
   Tube* new_upper_tube;
   Tube* new_lower_tube;
   
   if (_direction == TubePair::Right) {
      new_upper_tube = new LeftTube(*_upper_tube);
      new_lower_tube = new LeftTube(*_lower_tube);
      delete _upper_tube;
      delete _lower_tube;
      _upper_tube = new_upper_tube;
      _lower_tube = new_lower_tube;

      left_element = _upper_tube->GetStart();
      top_element = _upper_tube->GetEnd();
      right_element = _lower_tube->GetEnd();
      bottom_element = _lower_tube->GetStart();
      _left_tube = _lower_tube;
      _right_tube = _upper_tube;
      _direction = TubePair::Left;
      gtk_image_set_from_stock(GTK_IMAGE(_pixmapwid),
			       GROUNDHOG_STOCK_TUBE_LEFT, Icons::Size());
   } else {
      new_upper_tube = new RightTube(*_upper_tube);
      new_lower_tube = new RightTube(*_lower_tube);
      delete _upper_tube;
      delete _lower_tube;
      _upper_tube = new_upper_tube;
      _lower_tube = new_lower_tube;

      left_element = _lower_tube->GetStart();
      top_element = _upper_tube->GetStart();
      right_element = _upper_tube->GetEnd();
      bottom_element = _lower_tube->GetEnd();
      _left_tube = _upper_tube;
      _right_tube = _lower_tube;
      _direction = TubePair::Right;
      gtk_image_set_from_stock(GTK_IMAGE(_pixmapwid), 
			       GROUNDHOG_STOCK_TUBE_RIGHT, Icons::Size());
   }
   ConnectLeft(left_element);
   ConnectTop(top_element);
   ConnectRight(right_element);
   ConnectBottom(bottom_element);
}

void
SetOffTubePairs::Shuffle()
{
   for (std::list<TubePair*>::iterator i = _set.begin(); i != _set.end(); i++)
      if (rand() % 2)
	 (*i)->ToggleDirection();
}
