/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _ICONS_H
#define _ICONS_H

#include <gtk/gtk.h>

class Icons {
   GtkIconFactory*	_factory;
   static GtkIconSize	_size;

   void Add(const gchar *stock_id, const char **xpm_data);
public:
   Icons();
   void Init();
   static GtkIconSize Size() {return _size;}
};

#define GROUNDHOG_SIZE			"groundhog-size"

#define GROUNDHOG_STOCK_ABOUT		"groundhog-about"
#define GROUNDHOG_STOCK_CHAMPAGNE	"groundhog-champagne"
#define GROUNDHOG_STOCK_HIGHSCORE	"groundhog-highscore"
#define GROUNDHOG_STOCK_NEW		"groundhog-new"
#define GROUNDHOG_STOCK_TUBE_LEFT	"groundhog-tube-left"
#define GROUNDHOG_STOCK_TUBE_RIGHT	"groundhog-tube-right"

#define GROUNDHOG_STOCK_LEFT_BLUE	"groundhog-left-blue"
#define GROUNDHOG_STOCK_LEFT_GREEN	"groundhog-left-green"
#define GROUNDHOG_STOCK_LEFT_RED	"groundhog-left-red"
#define GROUNDHOG_STOCK_LEFT_YELLOW	"groundhog-left-yellow"
#define GROUNDHOG_STOCK_LOWER_BLUE	"groundhog-lower-blue"
#define GROUNDHOG_STOCK_LOWER_GREEN	"groundhog-lower-green"
#define GROUNDHOG_STOCK_LOWER_RED	"groundhog-lower-red"
#define GROUNDHOG_STOCK_LOWER_YELLOW	"groundhog-lower-yellow"
#define GROUNDHOG_STOCK_RIGHT_BLUE	"groundhog-right-blue"
#define GROUNDHOG_STOCK_RIGHT_GREEN	"groundhog-right-green"
#define GROUNDHOG_STOCK_RIGHT_RED	"groundhog-right-red"
#define GROUNDHOG_STOCK_RIGHT_YELLOW	"groundhog-right-yellow"
#define GROUNDHOG_STOCK_UPPER_BLUE	"groundhog-upper-blue"
#define GROUNDHOG_STOCK_UPPER_GREEN	"groundhog-upper-green"
#define GROUNDHOG_STOCK_UPPER_RED	"groundhog-upper-red"
#define GROUNDHOG_STOCK_UPPER_YELLOW	"groundhog-upper-yellow"

#endif // _ICONS_H
