/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _HIGHSCORE_DIALOG_H
#define _HIGHSCORE_DIALOG_H

#include "dialog.h"
#include "highscore.h"

class HighScoreTab;

class HighScoreDialog : public Dialog {
   GtkWidget*		_notebook;
   HighScoreTab*	_beginner;
   HighScoreTab*	_intermediate;
   HighScoreTab*	_expert;

   void ShowTab(gint page) {
      gtk_notebook_set_page(GTK_NOTEBOOK(_notebook), page);}
protected:
public:
   HighScoreDialog();
   ~HighScoreDialog();
   void SetHighScore(HighScore& high_score);
   void ShowBeginnerTab() {ShowTab(0);}
   void ShowIntermediateTab() {ShowTab(1);}
   void ShowExpertTab() {ShowTab(2);}
};

#endif // _HIGHSCORE_DIALOG_H
