.TH GOTMAIL 1
.\" NAME should be all caps, SECTION should be 1-8, maybe w/ subsection
.\" other parms are allowed: see man(7), man(1)
.rn SH Sh
.de SH
.br
.ne 11
.Sh "\\$1"
..
.rn SS Ss
.de SS
.br
.ne 10
.Ss "\\$1"
..
.rn TP Tp
.de TP
.br 
.ne 9
.Tp \\$1
..
.rn RS Rs
.de RS
.na
.nf
.Rs
..
.rn RE Re
.de RE
.Re
.fi
.ad
..
.de Sx
.PP
.ne \\$1
.RS
..
.de Ex
.RE
.PP
..
.SH NAME
gotmail \- A script to fetch mail from a Hotmail mailbox.
.SH SYNOPSIS
.B gotmail
.I [\-u username] [\-p password] [\-\-help] [\-\-version] ...
.SH "DESCRIPTION"
This manual page documents the
.BR gotmail
script.
.PP
.B Gotmail
is a perl script to fetch mail out of a Hotmail account and either place
it into the current directory in unix mbox format or forward it to
another email address.
.SH OPTIONS
.TP
.B \-?, \-\-help, \-\-usage
Show summary of options.
.TP
.B \-u, \-\-username username
Specify your hotmail account username.
.TP
.B \-p, \-\-password password
Specify your hotmail account password. (Warning: using this on the
command line is insecure. It is suggested that you use a configuration
file\-\-see below)
.TP
.B \-d, \-\-domain domain 
Specify an acceptable hotmail domain: hotmail.com (default), 
hotmail.com (default), msn.com, charter.com, compaq.net, 
hotmail.co.jp, hotmail.co.uk, hotmail.de, hotmail.fr, hotmail.it, 
messengeruser.com, passport.com, webtv.net
.TP
.B \-\-version
Print the version number.
.TP
.B \-\-debug
Print and log debug spew.
.TP
.B \-v, \-\-verbose
Be verbose.
.TP
.B \-\-silent
Be as quiet as possible.
.TP
.B \-c, \-\-config\-file file
Specifies a different configuration file than the default (~/.gotmailrc).
See below.
.TP
.B \-\-proxy host:port
Specify an HTTP proxy to use. Format is host:port \- eg: localhost:3128
.TP
.B \-f, \-\-forward address
Specify an email address to forward to. If a forwarding address is not
given, messages will be saved to disk.
.TP
.B \-s, \-\-smtpserver server
Send email via the specified smtp server, rather than with sendmail.
This allows use of Gotmail under Windows 2000, at least. May work
elsewhere.
.TP
.B \-\-exclude\-folders "folders"
Do not get these folders (list of folders in quotes, i.e.: "Inbox, Bulk Mail")
.TP
.B \-\-folders folderlist
The \-\-folders option only downloads messages from folders that are in
the list given. eg. gotmail \-\-folders "bulk mail, inbox" will get the
bulk mail and inbox folders only. The list separator should now be a
comma, optionally with whitespace on either side.
.TP
.B \-\-folder\-dir /my/dir
Specify which directory to put email folders in. The folders will be saved
as mbox\-compatible files named after the folders on Hotmail.
.TP
.B \-\-only\-new
Only previously unread messages will be retrieved.
.TP
.B \-\-mark\-read
Mark messages as read once they have been downloaded.
.TP
.B \-\-delete
Delete messages once they have been downloaded.
This option is being deprecated as of version 0.8.2.  Use the 
--move <folder> command to move downloaded mails to the Trash Can
instead.
.TP
.B \-\-move <folder>
Move mails to the named folder after downloading.
.TP
.B \-\-speed\-limit
Add a small delay after each message to stop the local MTA from being
overloaded.
.TP
.B \-\-retry\-limit num_tries
Maximum number of times to retry a download.
.TP
.B \-\-save\-to\-login
When this option is specified, saves messages to "username-foldername"
in the folder-dir directory. The Inbox folder is saved to just
"username".
.TP
.B \-\-use\-procmail
This option sends all messages only to procmail(1). Options to forward
or save to mailboxes are ignored.
.TP
.B \-\-procmail\-bin /path/to/procmail
Allows user to set location of the procmail binary. Default is
"/usr/bin/procmail".
.TP
.B \-\-procmail\-option <opt>
Pass options through to procmail
.TP
.B \-\-curl\-bin /path/to/curl
Allows user to set location of the curl binary. Default is to search
the path.
.TP
.B \-\-use\-sa
Use SpamAssassin to detect junk mail.
.TP
.B \-\-delete\-spam
Delete junk mail instead of just ignoring it (requires \-\-use\-sa option).
.TP
.B \-\-move\-spam folder
Move spam to this folder (requires \-\-use\-sa option).
.TP
.B \-\-spam\-score score
SpamAssassin score to be considered spam.  Default is 4.5.
.TP
.B \-\-nodownload
Don't actually download or forward mail. Useful when used with 
the \-\-delete\-spam option.
.TP
.B \-\-summary
Print the number of messages received one line per folder.
.TP
.B \-\-remove\-header
Automatically remove X-Message-Info header to not trigger X_MESSAGE_INFO rule 
in SpamAssassin.
.SH EXAMPLES
Download all the mail from the account of "billyjoe@hotmail.com" with
password "sEcReT" and forward it to "john@ab.com".
.Sx 3
gotmail \-u billyjoe \-p sEcReT \-f john@ab.com
(This is insecure!)
.Ex
Download, and delete, new mail only in the Inbox and MyMail folders of
uro_levu's Hotmail account. Save the resulting mail in mbox files named
after the folders ("Inbox" and "MyMail") under the warmmail/ directory.
.Sx 3
gotmail \-u uro_levu \-p my_password \-\-delete \-\-only\-new \\
     \-\-folder\-dir $HOME/warmmail \-\-folders "Inbox, MyMail"
(This is insecure!)
.Ex
Scan the mail in the Inbox and move anything with a SpamAssassin
score of 5 or better to a folder named Spam, but don't actually
download anything.
.Sx
gotmail \-\-folders "Inbox" \-u billyjoe \-p sEcReT \-\-use\-sa \\
     \-\-nodownload \-\-move\-spam Spam \-\-spam\-score 5
(This is insecure!)
.Ex
.SH Configuration Files
You can put the configuration for gotmail in a file. This has the
significant advantage of not putting your username and password on the
command line, where it is possible for others on your machine to read
them. By default, gotmail will look for a file in your home directory
called ".gotmailrc". You can specify a different one with the
\-\-config\-file option. Options on the command line will override
options in the configuration file.
.PP
Configuration files may contain comments (Lines beginning with #).
Options in the file are identical to the long arguments listed above,
and are assigned values using an = sign. Do not add extra whitespace
before or after the =.
.PP
This very simple configuration file gets all the mail from the account
of randomuser@hotmail.com, password "ger0nim34":
.Sx 3
# randomuser's gotmailrc file
username=randomuser
password=ger0nim34
.Ex
This slightly more complex example causes gotmail to quietly download
and delete all mail in the account of linux@hotmail.com, and forward it
to linux@yahoo.com.
.Sx 3
# .gotmailrc

username=linux
password=FreesOftwareForever
forward=linux@yahoo.com
silent
delete
.Ex
.SH AUTHORS
This manual page was written by Peter Hawkins <peter@hawkins.emu.id.au>,
for the Debian GNU/Linux system (but may be used by others). Additions
were made by paul cannon <pik@debian.org> and James Turnbull
<james@lovedthanlost.net>.  

Additional contributions from John Fruetel, Jon Phillips, Guyang Mao, Didier CLERC, Leigh Purdie, Sh, Patrick Froede, Herman Mereles, Kamal Kantawala, Andrei Popov, Kamal Mahyuddin, Hindu, Joel Mejeur,  Wesley Hosking, Max Hales, Brian Almeida, Jens Preikschat, Jonas Smedegaard, Robert Lazzurs, Tim Dijkstra, Hari Sundararaghavan, Silas S. Brown, Adrian Chung, Lalit Chhabra, Loic TREGOUET, Sean D. True, Timothy Lee, stripes, David Holland, Sergio Rua, Lee, William X. Walsh,Chris Ham, Angel Luis Jimenez Martinez, James Ascroft-Leigh, Andrea Briganti,cageek, Brad Donison, Jens E. Madsen Jr., Paul Howarth, Gertjan Harkink, Jos De Laender, jdanwhite, and Manoajv Sridhar.
