/*
 * Copyright (c) 2011 Paulo Zanoni
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef XDG_UTILS_H
#define XDG_UTILS_H

#include <string>

#define ITERATE_STRTOK_R(s, delim, ptrptr, tokStr) \
	for(tokStr = strtok_r(s, delim, ptrptr); \
	    tokStr != NULL; \
	    tokStr = strtok_r(NULL, delim, ptrptr))

#define ITERATE_ESCAPED_STRTOK_R(s, delim, ptrptr, tokStr) \
	for(tokStr = XDGUtils::escapedStrTok_r(s, delim, ptrptr); \
	    tokStr != NULL; \
	    tokStr = XDGUtils::escapedStrTok_r(NULL, delim, ptrptr))

class XDGUtils
{
    public:

	static bool validSemicolonList(const char *list);

	static char *escapedStrTok_r(char *s, const char *delim,
				     char **ptrptr);

	static bool findFileInPath(const char *fileName,
				   std::string& fullPath);

	static bool fileExists(const char *filePath);

	enum XDGLogLevel {
	    Quiet   = 0,
	    Verbose = 1,
	    Debug   = 2
	};

	static void setLogLevel(XDGLogLevel logLevel);
	static void log(XDGLogLevel logLevel, const char *fmt, ...);

    private:
	static XDGLogLevel logLevel_;

};

#endif
