// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/recommender/v1/recommender_service.proto

package recommender

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request for the `ListRecommendations` method.
type ListRecommendationsRequest struct {
	// Required. The container resource on which to execute the request.
	// Acceptable formats:
	//
	// 1.
	// "projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]",
	//
	// LOCATION here refers to GCP Locations:
	// https://cloud.google.com/about/locations/
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return from this request.  Non-positive
	// values are ignored. If not specified, the server will determine the number
	// of results to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, retrieves the next batch of results from the preceding call to
	// this method. `page_token` must be the value of `next_page_token` from the
	// previous response. The values of other method parameters must be identical
	// to those in the previous call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter expression to restrict the recommendations returned. Supported
	// filter fields: state_info.state
	// Eg: `state_info.state:"DISMISSED" or state_info.state:"FAILED"
	Filter               string   `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRecommendationsRequest) Reset()         { *m = ListRecommendationsRequest{} }
func (m *ListRecommendationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListRecommendationsRequest) ProtoMessage()    {}
func (*ListRecommendationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3b10e41519d11d6c, []int{0}
}

func (m *ListRecommendationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRecommendationsRequest.Unmarshal(m, b)
}
func (m *ListRecommendationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRecommendationsRequest.Marshal(b, m, deterministic)
}
func (m *ListRecommendationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRecommendationsRequest.Merge(m, src)
}
func (m *ListRecommendationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListRecommendationsRequest.Size(m)
}
func (m *ListRecommendationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRecommendationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListRecommendationsRequest proto.InternalMessageInfo

func (m *ListRecommendationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListRecommendationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListRecommendationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListRecommendationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response to the `ListRecommendations` method.
type ListRecommendationsResponse struct {
	// The set of recommendations for the `parent` resource.
	Recommendations []*Recommendation `protobuf:"bytes,1,rep,name=recommendations,proto3" json:"recommendations,omitempty"`
	// A token that can be used to request the next page of results. This field is
	// empty if there are no additional results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRecommendationsResponse) Reset()         { *m = ListRecommendationsResponse{} }
func (m *ListRecommendationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListRecommendationsResponse) ProtoMessage()    {}
func (*ListRecommendationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3b10e41519d11d6c, []int{1}
}

func (m *ListRecommendationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRecommendationsResponse.Unmarshal(m, b)
}
func (m *ListRecommendationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRecommendationsResponse.Marshal(b, m, deterministic)
}
func (m *ListRecommendationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRecommendationsResponse.Merge(m, src)
}
func (m *ListRecommendationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListRecommendationsResponse.Size(m)
}
func (m *ListRecommendationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRecommendationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListRecommendationsResponse proto.InternalMessageInfo

func (m *ListRecommendationsResponse) GetRecommendations() []*Recommendation {
	if m != nil {
		return m.Recommendations
	}
	return nil
}

func (m *ListRecommendationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to the `GetRecommendation` method.
type GetRecommendationRequest struct {
	// Required. Name of the recommendation.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRecommendationRequest) Reset()         { *m = GetRecommendationRequest{} }
func (m *GetRecommendationRequest) String() string { return proto.CompactTextString(m) }
func (*GetRecommendationRequest) ProtoMessage()    {}
func (*GetRecommendationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3b10e41519d11d6c, []int{2}
}

func (m *GetRecommendationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRecommendationRequest.Unmarshal(m, b)
}
func (m *GetRecommendationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRecommendationRequest.Marshal(b, m, deterministic)
}
func (m *GetRecommendationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRecommendationRequest.Merge(m, src)
}
func (m *GetRecommendationRequest) XXX_Size() int {
	return xxx_messageInfo_GetRecommendationRequest.Size(m)
}
func (m *GetRecommendationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRecommendationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRecommendationRequest proto.InternalMessageInfo

func (m *GetRecommendationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the `MarkRecommendationClaimed` Method.
type MarkRecommendationClaimedRequest struct {
	// Required. Name of the recommendation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// State properties to include with this state. Overwrites any existing
	// `state_metadata`.
	// Keys must match the regex /^[a-z0-9][a-z0-9_.-]{0,62}$/.
	// Values must match the regex /^[a-zA-Z0-9_./-]{0,255}$/.
	StateMetadata map[string]string `protobuf:"bytes,2,rep,name=state_metadata,json=stateMetadata,proto3" json:"state_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Fingerprint of the Recommendation. Provides optimistic locking.
	Etag                 string   `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MarkRecommendationClaimedRequest) Reset()         { *m = MarkRecommendationClaimedRequest{} }
func (m *MarkRecommendationClaimedRequest) String() string { return proto.CompactTextString(m) }
func (*MarkRecommendationClaimedRequest) ProtoMessage()    {}
func (*MarkRecommendationClaimedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3b10e41519d11d6c, []int{3}
}

func (m *MarkRecommendationClaimedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MarkRecommendationClaimedRequest.Unmarshal(m, b)
}
func (m *MarkRecommendationClaimedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MarkRecommendationClaimedRequest.Marshal(b, m, deterministic)
}
func (m *MarkRecommendationClaimedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MarkRecommendationClaimedRequest.Merge(m, src)
}
func (m *MarkRecommendationClaimedRequest) XXX_Size() int {
	return xxx_messageInfo_MarkRecommendationClaimedRequest.Size(m)
}
func (m *MarkRecommendationClaimedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MarkRecommendationClaimedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MarkRecommendationClaimedRequest proto.InternalMessageInfo

func (m *MarkRecommendationClaimedRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MarkRecommendationClaimedRequest) GetStateMetadata() map[string]string {
	if m != nil {
		return m.StateMetadata
	}
	return nil
}

func (m *MarkRecommendationClaimedRequest) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// Request for the `MarkRecommendationSucceeded` Method.
type MarkRecommendationSucceededRequest struct {
	// Required. Name of the recommendation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// State properties to include with this state. Overwrites any existing
	// `state_metadata`.
	// Keys must match the regex /^[a-z0-9][a-z0-9_.-]{0,62}$/.
	// Values must match the regex /^[a-zA-Z0-9_./-]{0,255}$/.
	StateMetadata map[string]string `protobuf:"bytes,2,rep,name=state_metadata,json=stateMetadata,proto3" json:"state_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Fingerprint of the Recommendation. Provides optimistic locking.
	Etag                 string   `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MarkRecommendationSucceededRequest) Reset()         { *m = MarkRecommendationSucceededRequest{} }
func (m *MarkRecommendationSucceededRequest) String() string { return proto.CompactTextString(m) }
func (*MarkRecommendationSucceededRequest) ProtoMessage()    {}
func (*MarkRecommendationSucceededRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3b10e41519d11d6c, []int{4}
}

func (m *MarkRecommendationSucceededRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MarkRecommendationSucceededRequest.Unmarshal(m, b)
}
func (m *MarkRecommendationSucceededRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MarkRecommendationSucceededRequest.Marshal(b, m, deterministic)
}
func (m *MarkRecommendationSucceededRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MarkRecommendationSucceededRequest.Merge(m, src)
}
func (m *MarkRecommendationSucceededRequest) XXX_Size() int {
	return xxx_messageInfo_MarkRecommendationSucceededRequest.Size(m)
}
func (m *MarkRecommendationSucceededRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MarkRecommendationSucceededRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MarkRecommendationSucceededRequest proto.InternalMessageInfo

func (m *MarkRecommendationSucceededRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MarkRecommendationSucceededRequest) GetStateMetadata() map[string]string {
	if m != nil {
		return m.StateMetadata
	}
	return nil
}

func (m *MarkRecommendationSucceededRequest) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// Request for the `MarkRecommendationFailed` Method.
type MarkRecommendationFailedRequest struct {
	// Required. Name of the recommendation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// State properties to include with this state. Overwrites any existing
	// `state_metadata`.
	// Keys must match the regex /^[a-z0-9][a-z0-9_.-]{0,62}$/.
	// Values must match the regex /^[a-zA-Z0-9_./-]{0,255}$/.
	StateMetadata map[string]string `protobuf:"bytes,2,rep,name=state_metadata,json=stateMetadata,proto3" json:"state_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Fingerprint of the Recommendation. Provides optimistic locking.
	Etag                 string   `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MarkRecommendationFailedRequest) Reset()         { *m = MarkRecommendationFailedRequest{} }
func (m *MarkRecommendationFailedRequest) String() string { return proto.CompactTextString(m) }
func (*MarkRecommendationFailedRequest) ProtoMessage()    {}
func (*MarkRecommendationFailedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3b10e41519d11d6c, []int{5}
}

func (m *MarkRecommendationFailedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MarkRecommendationFailedRequest.Unmarshal(m, b)
}
func (m *MarkRecommendationFailedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MarkRecommendationFailedRequest.Marshal(b, m, deterministic)
}
func (m *MarkRecommendationFailedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MarkRecommendationFailedRequest.Merge(m, src)
}
func (m *MarkRecommendationFailedRequest) XXX_Size() int {
	return xxx_messageInfo_MarkRecommendationFailedRequest.Size(m)
}
func (m *MarkRecommendationFailedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MarkRecommendationFailedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MarkRecommendationFailedRequest proto.InternalMessageInfo

func (m *MarkRecommendationFailedRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MarkRecommendationFailedRequest) GetStateMetadata() map[string]string {
	if m != nil {
		return m.StateMetadata
	}
	return nil
}

func (m *MarkRecommendationFailedRequest) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func init() {
	proto.RegisterType((*ListRecommendationsRequest)(nil), "google.cloud.recommender.v1.ListRecommendationsRequest")
	proto.RegisterType((*ListRecommendationsResponse)(nil), "google.cloud.recommender.v1.ListRecommendationsResponse")
	proto.RegisterType((*GetRecommendationRequest)(nil), "google.cloud.recommender.v1.GetRecommendationRequest")
	proto.RegisterType((*MarkRecommendationClaimedRequest)(nil), "google.cloud.recommender.v1.MarkRecommendationClaimedRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommender.v1.MarkRecommendationClaimedRequest.StateMetadataEntry")
	proto.RegisterType((*MarkRecommendationSucceededRequest)(nil), "google.cloud.recommender.v1.MarkRecommendationSucceededRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommender.v1.MarkRecommendationSucceededRequest.StateMetadataEntry")
	proto.RegisterType((*MarkRecommendationFailedRequest)(nil), "google.cloud.recommender.v1.MarkRecommendationFailedRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommender.v1.MarkRecommendationFailedRequest.StateMetadataEntry")
}

func init() {
	proto.RegisterFile("google/cloud/recommender/v1/recommender_service.proto", fileDescriptor_3b10e41519d11d6c)
}

var fileDescriptor_3b10e41519d11d6c = []byte{
	// 855 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x56, 0x41, 0x6f, 0xe3, 0x44,
	0x14, 0xd6, 0x38, 0x6d, 0xc5, 0xce, 0xaa, 0xec, 0x32, 0x20, 0xd6, 0xeb, 0x20, 0x35, 0xf2, 0x61,
	0x15, 0xb2, 0xc5, 0x26, 0x8b, 0x56, 0xac, 0x02, 0x2b, 0x70, 0x42, 0xbb, 0x17, 0xba, 0x04, 0x87,
	0x72, 0xe0, 0x12, 0x4d, 0x9d, 0x57, 0xd7, 0xc4, 0xf6, 0x18, 0xcf, 0x24, 0xa1, 0x45, 0xbd, 0xc0,
	0x4f, 0xe0, 0x0a, 0x97, 0x1e, 0xf9, 0x0b, 0x88, 0x03, 0x1c, 0x7b, 0x84, 0x5b, 0x4e, 0x3d, 0x70,
	0xe5, 0x0f, 0x54, 0x42, 0x42, 0x1e, 0xbb, 0xd4, 0x49, 0x9a, 0xb4, 0x51, 0x22, 0xf5, 0xe6, 0x79,
	0x6f, 0xde, 0x7b, 0xdf, 0xf7, 0x79, 0xfc, 0x79, 0xf0, 0x53, 0x97, 0x31, 0xd7, 0x07, 0xd3, 0xf1,
	0x59, 0xaf, 0x63, 0xc6, 0xe0, 0xb0, 0x20, 0x80, 0xb0, 0x03, 0xb1, 0xd9, 0xaf, 0xe6, 0x97, 0x6d,
	0x0e, 0x71, 0xdf, 0x73, 0xc0, 0x88, 0x62, 0x26, 0x18, 0x29, 0xa6, 0x65, 0x86, 0x2c, 0x33, 0x72,
	0xfb, 0x8c, 0x7e, 0x55, 0x7b, 0x2b, 0xeb, 0x49, 0x23, 0xcf, 0xa4, 0x61, 0xc8, 0x04, 0x15, 0x1e,
	0x0b, 0x79, 0x5a, 0xaa, 0x3d, 0xc8, 0x65, 0x1d, 0xdf, 0x83, 0x50, 0x64, 0x89, 0x8d, 0x5c, 0x62,
	0xdf, 0x03, 0xbf, 0xd3, 0xde, 0x83, 0x03, 0xda, 0xf7, 0x58, 0x9c, 0x6d, 0x78, 0x98, 0xdb, 0x10,
	0x03, 0x67, 0xbd, 0xf8, 0x02, 0x8f, 0xf6, 0xee, 0x8d, 0x68, 0x48, 0x1c, 0x69, 0x85, 0xfe, 0x07,
	0xc2, 0xda, 0xa7, 0x1e, 0x17, 0xf6, 0x48, 0x92, 0xdb, 0xf0, 0x4d, 0x0f, 0xb8, 0x20, 0xdb, 0x78,
	0x2d, 0xa2, 0x31, 0x84, 0x42, 0x45, 0x25, 0x54, 0xbe, 0x53, 0x37, 0xce, 0x2c, 0xe5, 0xdc, 0x2a,
	0xe3, 0x47, 0x79, 0xae, 0xe9, 0x50, 0x1a, 0x79, 0xdc, 0x70, 0x58, 0x60, 0xda, 0x97, 0x29, 0x3b,
	0xab, 0x26, 0x25, 0x7c, 0x27, 0xa2, 0x2e, 0xb4, 0xb9, 0x77, 0x04, 0xaa, 0x52, 0x42, 0xe5, 0xd5,
	0x7a, 0xe1, 0xcc, 0x42, 0xf6, 0x2b, 0x49, 0xb4, 0xe5, 0x1d, 0x01, 0xd1, 0x31, 0x96, 0x3b, 0x04,
	0xeb, 0x42, 0xa8, 0x16, 0xe4, 0x34, 0xb9, 0x45, 0x16, 0x7e, 0x91, 0x44, 0xc9, 0x9b, 0x78, 0x6d,
	0xdf, 0xf3, 0x05, 0xc4, 0xea, 0x6a, 0x92, 0xb7, 0xb3, 0x95, 0xfe, 0x13, 0xc2, 0xc5, 0x2b, 0x49,
	0xf0, 0x88, 0x85, 0x1c, 0xc8, 0x2e, 0xbe, 0x37, 0x4a, 0x9e, 0xab, 0xa8, 0x54, 0x28, 0xdf, 0x7d,
	0xf2, 0xd8, 0x98, 0xf1, 0x02, 0x8d, 0xd1, 0x76, 0xf6, 0x78, 0x0f, 0xf2, 0x08, 0xdf, 0x0b, 0xe1,
	0x5b, 0xd1, 0xce, 0xe1, 0x56, 0x24, 0xae, 0xf5, 0x24, 0xdc, 0xbc, 0x80, 0xad, 0x53, 0xac, 0xbe,
	0x80, 0x31, 0x70, 0x17, 0x02, 0x6f, 0xe1, 0x95, 0x90, 0x06, 0x90, 0xc9, 0x5b, 0x95, 0xf2, 0x3e,
	0xc6, 0x6f, 0xdf, 0x44, 0xde, 0xb4, 0x8f, 0x2c, 0xd7, 0x7f, 0x53, 0x70, 0x69, 0x87, 0xc6, 0xdd,
	0xd1, 0x64, 0xc3, 0xa7, 0x5e, 0x00, 0x9d, 0xe5, 0xce, 0x22, 0x03, 0xfc, 0x2a, 0x17, 0x54, 0x40,
	0x3b, 0x00, 0x41, 0x3b, 0x54, 0x50, 0x55, 0x91, 0x62, 0x36, 0x67, 0x8a, 0x79, 0x1d, 0x3a, 0xa3,
	0x95, 0xf4, 0xdc, 0xc9, 0x5a, 0x6e, 0x85, 0x22, 0x3e, 0xb4, 0xd7, 0x79, 0x3e, 0x46, 0x1e, 0xe0,
	0x15, 0x10, 0xd4, 0xbd, 0x3c, 0x1c, 0x8a, 0x2d, 0x03, 0xda, 0xc7, 0x98, 0x4c, 0x56, 0x93, 0xfb,
	0xb8, 0xd0, 0x85, 0xc3, 0x94, 0xad, 0x9d, 0x3c, 0x92, 0x37, 0xf0, 0x6a, 0x9f, 0xfa, 0x3d, 0xc8,
	0x5e, 0x53, 0xba, 0xa8, 0x29, 0xcf, 0x90, 0xfe, 0xbb, 0x82, 0xf5, 0x49, 0x84, 0xad, 0x9e, 0xe3,
	0x00, 0x74, 0x96, 0xae, 0xe0, 0xe1, 0x14, 0x05, 0xed, 0x39, 0x15, 0x1c, 0xc7, 0x77, 0xbb, 0x1a,
	0xfe, 0xaa, 0xe0, 0x8d, 0x49, 0x8c, 0xdb, 0xd4, 0xf3, 0x97, 0x2e, 0x60, 0x7f, 0x8a, 0x80, 0x9f,
	0xcd, 0x29, 0xe0, 0x08, 0xb8, 0x5b, 0x55, 0xef, 0xc9, 0xcf, 0x18, 0xdf, 0xcd, 0x39, 0x27, 0xf9,
	0x07, 0xe1, 0xd7, 0xaf, 0xf0, 0x34, 0xf2, 0xfe, 0x4c, 0x8a, 0xd3, 0xad, 0x5c, 0x7b, 0x36, 0x7f,
	0x61, 0x6a, 0x9f, 0xba, 0x33, 0xb4, 0x32, 0x1f, 0x1f, 0x5a, 0xeb, 0xe9, 0xc3, 0x66, 0xea, 0xbc,
	0xdf, 0xff, 0xf5, 0xf7, 0x8f, 0xca, 0x27, 0xa4, 0x9e, 0xfc, 0x5e, 0xbe, 0x4b, 0x33, 0xcf, 0xa3,
	0x98, 0x7d, 0x0d, 0x8e, 0xe0, 0x66, 0xc5, 0xf4, 0x99, 0x93, 0xb6, 0x32, 0x2b, 0xf9, 0x9f, 0x11,
	0x37, 0x2b, 0xc7, 0xe6, 0xb8, 0x99, 0x9e, 0x22, 0xfc, 0xda, 0x84, 0x4b, 0x92, 0xa7, 0x33, 0x41,
	0x4f, 0x73, 0x55, 0x6d, 0x1e, 0x5f, 0xd7, 0x3f, 0x1f, 0x5a, 0xf2, 0x54, 0x8d, 0x90, 0x49, 0x02,
	0x37, 0xa3, 0x32, 0xce, 0xc4, 0xac, 0x1c, 0x93, 0x7f, 0x11, 0x7e, 0x38, 0xd5, 0xf0, 0xc8, 0xf3,
	0x85, 0x8c, 0x72, 0x3e, 0x72, 0x62, 0x68, 0xa9, 0x09, 0x97, 0xcd, 0xd1, 0xef, 0x65, 0x33, 0x39,
	0xb5, 0x92, 0x70, 0x4b, 0x7f, 0xb9, 0x38, 0xe1, 0x5a, 0x40, 0xe3, 0x6e, 0x06, 0xb3, 0x86, 0x2a,
	0xe4, 0x07, 0x05, 0x17, 0x67, 0xd8, 0x15, 0xf9, 0x68, 0x41, 0xa3, 0x9b, 0x4f, 0x83, 0xfe, 0x75,
	0x1a, 0xec, 0xea, 0xcd, 0x25, 0x69, 0xf0, 0x3f, 0xd0, 0x44, 0x85, 0x73, 0x84, 0xd5, 0x69, 0x9e,
	0x43, 0x3e, 0x5c, 0xc4, 0xaa, 0xe6, 0xe3, 0xcf, 0xaf, 0xe3, 0x6f, 0xeb, 0x3b, 0x4b, 0xe2, 0x9f,
	0xa2, 0xac, 0xa1, 0x8a, 0xf6, 0xf2, 0xd4, 0xd2, 0xa6, 0xdb, 0xfa, 0x9f, 0x96, 0x71, 0x20, 0x44,
	0xc4, 0x6b, 0xa6, 0x39, 0x18, 0x0c, 0xc6, 0x3d, 0x9f, 0xf6, 0xc4, 0x41, 0x7a, 0x87, 0x7d, 0x27,
	0xf2, 0xa9, 0xd8, 0x67, 0x71, 0x50, 0x3f, 0x41, 0x78, 0xc3, 0x61, 0xc1, 0x2c, 0xde, 0xf5, 0xfb,
	0x39, 0x03, 0x6d, 0x26, 0xd7, 0xdb, 0x26, 0xfa, 0x6a, 0x3b, 0x2b, 0x70, 0x99, 0x4f, 0x43, 0xd7,
	0x60, 0xb1, 0x6b, 0xba, 0x10, 0xca, 0xcb, 0xaf, 0x79, 0x39, 0xf6, 0xca, 0x1b, 0xf3, 0x07, 0xb9,
	0xe5, 0x89, 0xb2, 0xd2, 0xb0, 0xb7, 0x1a, 0xbf, 0x28, 0xc5, 0x17, 0x69, 0xbf, 0x86, 0x04, 0x90,
	0x1b, 0x68, 0x7c, 0x59, 0xdd, 0x5b, 0x93, 0x7d, 0xdf, 0xfb, 0x2f, 0x00, 0x00, 0xff, 0xff, 0x0d,
	0x61, 0xf7, 0x7b, 0x4f, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// RecommenderClient is the client API for Recommender service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RecommenderClient interface {
	// Lists recommendations for a Cloud project. Requires the recommender.*.list
	// IAM permission for the specified recommender.
	ListRecommendations(ctx context.Context, in *ListRecommendationsRequest, opts ...grpc.CallOption) (*ListRecommendationsResponse, error)
	// Gets the requested recommendation. Requires the recommender.*.get
	// IAM permission for the specified recommender.
	GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*Recommendation, error)
	// Mark the Recommendation State as Claimed. Users can use this method to
	// indicate to the Recommender API that they are starting to apply the
	// recommendation themselves. This stops the recommendation content from being
	// updated.
	//
	// MarkRecommendationClaimed can be applied to recommendations in CLAIMED,
	// SUCCEEDED, FAILED, or ACTIVE state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationClaimed(ctx context.Context, in *MarkRecommendationClaimedRequest, opts ...grpc.CallOption) (*Recommendation, error)
	// Mark the Recommendation State as Succeeded. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation was successful. This stops the recommendation
	// content from being updated.
	//
	// MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationSucceeded(ctx context.Context, in *MarkRecommendationSucceededRequest, opts ...grpc.CallOption) (*Recommendation, error)
	// Mark the Recommendation State as Failed. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation failed. This stops the recommendation content
	// from being updated.
	//
	// MarkRecommendationFailed can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationFailed(ctx context.Context, in *MarkRecommendationFailedRequest, opts ...grpc.CallOption) (*Recommendation, error)
}

type recommenderClient struct {
	cc *grpc.ClientConn
}

func NewRecommenderClient(cc *grpc.ClientConn) RecommenderClient {
	return &recommenderClient{cc}
}

func (c *recommenderClient) ListRecommendations(ctx context.Context, in *ListRecommendationsRequest, opts ...grpc.CallOption) (*ListRecommendationsResponse, error) {
	out := new(ListRecommendationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1.Recommender/ListRecommendations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1.Recommender/GetRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) MarkRecommendationClaimed(ctx context.Context, in *MarkRecommendationClaimedRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1.Recommender/MarkRecommendationClaimed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) MarkRecommendationSucceeded(ctx context.Context, in *MarkRecommendationSucceededRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1.Recommender/MarkRecommendationSucceeded", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) MarkRecommendationFailed(ctx context.Context, in *MarkRecommendationFailedRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1.Recommender/MarkRecommendationFailed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecommenderServer is the server API for Recommender service.
type RecommenderServer interface {
	// Lists recommendations for a Cloud project. Requires the recommender.*.list
	// IAM permission for the specified recommender.
	ListRecommendations(context.Context, *ListRecommendationsRequest) (*ListRecommendationsResponse, error)
	// Gets the requested recommendation. Requires the recommender.*.get
	// IAM permission for the specified recommender.
	GetRecommendation(context.Context, *GetRecommendationRequest) (*Recommendation, error)
	// Mark the Recommendation State as Claimed. Users can use this method to
	// indicate to the Recommender API that they are starting to apply the
	// recommendation themselves. This stops the recommendation content from being
	// updated.
	//
	// MarkRecommendationClaimed can be applied to recommendations in CLAIMED,
	// SUCCEEDED, FAILED, or ACTIVE state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationClaimed(context.Context, *MarkRecommendationClaimedRequest) (*Recommendation, error)
	// Mark the Recommendation State as Succeeded. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation was successful. This stops the recommendation
	// content from being updated.
	//
	// MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationSucceeded(context.Context, *MarkRecommendationSucceededRequest) (*Recommendation, error)
	// Mark the Recommendation State as Failed. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation failed. This stops the recommendation content
	// from being updated.
	//
	// MarkRecommendationFailed can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationFailed(context.Context, *MarkRecommendationFailedRequest) (*Recommendation, error)
}

// UnimplementedRecommenderServer can be embedded to have forward compatible implementations.
type UnimplementedRecommenderServer struct {
}

func (*UnimplementedRecommenderServer) ListRecommendations(ctx context.Context, req *ListRecommendationsRequest) (*ListRecommendationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRecommendations not implemented")
}
func (*UnimplementedRecommenderServer) GetRecommendation(ctx context.Context, req *GetRecommendationRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRecommendation not implemented")
}
func (*UnimplementedRecommenderServer) MarkRecommendationClaimed(ctx context.Context, req *MarkRecommendationClaimedRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkRecommendationClaimed not implemented")
}
func (*UnimplementedRecommenderServer) MarkRecommendationSucceeded(ctx context.Context, req *MarkRecommendationSucceededRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkRecommendationSucceeded not implemented")
}
func (*UnimplementedRecommenderServer) MarkRecommendationFailed(ctx context.Context, req *MarkRecommendationFailedRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkRecommendationFailed not implemented")
}

func RegisterRecommenderServer(s *grpc.Server, srv RecommenderServer) {
	s.RegisterService(&_Recommender_serviceDesc, srv)
}

func _Recommender_ListRecommendations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRecommendationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).ListRecommendations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1.Recommender/ListRecommendations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).ListRecommendations(ctx, req.(*ListRecommendationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_GetRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).GetRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1.Recommender/GetRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).GetRecommendation(ctx, req.(*GetRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_MarkRecommendationClaimed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkRecommendationClaimedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).MarkRecommendationClaimed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1.Recommender/MarkRecommendationClaimed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).MarkRecommendationClaimed(ctx, req.(*MarkRecommendationClaimedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_MarkRecommendationSucceeded_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkRecommendationSucceededRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).MarkRecommendationSucceeded(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1.Recommender/MarkRecommendationSucceeded",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).MarkRecommendationSucceeded(ctx, req.(*MarkRecommendationSucceededRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_MarkRecommendationFailed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkRecommendationFailedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).MarkRecommendationFailed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1.Recommender/MarkRecommendationFailed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).MarkRecommendationFailed(ctx, req.(*MarkRecommendationFailedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Recommender_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recommender.v1.Recommender",
	HandlerType: (*RecommenderServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListRecommendations",
			Handler:    _Recommender_ListRecommendations_Handler,
		},
		{
			MethodName: "GetRecommendation",
			Handler:    _Recommender_GetRecommendation_Handler,
		},
		{
			MethodName: "MarkRecommendationClaimed",
			Handler:    _Recommender_MarkRecommendationClaimed_Handler,
		},
		{
			MethodName: "MarkRecommendationSucceeded",
			Handler:    _Recommender_MarkRecommendationSucceeded_Handler,
		},
		{
			MethodName: "MarkRecommendationFailed",
			Handler:    _Recommender_MarkRecommendationFailed_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recommender/v1/recommender_service.proto",
}
