// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/containeranalysis/v1alpha1/containeranalysis.proto

package containeranalysis

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_iam_v11 "google.golang.org/genproto/googleapis/iam/v1"
import google_iam_v1 "google.golang.org/genproto/googleapis/iam/v1"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import _ "github.com/golang/protobuf/ptypes/any"
import google_protobuf3 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf4 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This must be 1:1 with members of our oneofs, it can be used for filtering
// Note and Occurrence on their kind.
type Note_Kind int32

const (
	// Unknown
	Note_KIND_UNSPECIFIED Note_Kind = 0
	// The note and occurrence represent a package vulnerability.
	Note_PACKAGE_VULNERABILITY Note_Kind = 2
	// The note and occurrence assert build provenance.
	Note_BUILD_DETAILS Note_Kind = 3
	// This represents an image basis relationship.
	Note_IMAGE_BASIS Note_Kind = 4
	// This represents a package installed via a package manager.
	Note_PACKAGE_MANAGER Note_Kind = 5
	// The note and occurrence track deployment events.
	Note_DEPLOYABLE Note_Kind = 6
	// The note and occurrence track the initial discovery status of a resource.
	Note_DISCOVERY Note_Kind = 7
)

var Note_Kind_name = map[int32]string{
	0: "KIND_UNSPECIFIED",
	2: "PACKAGE_VULNERABILITY",
	3: "BUILD_DETAILS",
	4: "IMAGE_BASIS",
	5: "PACKAGE_MANAGER",
	6: "DEPLOYABLE",
	7: "DISCOVERY",
}
var Note_Kind_value = map[string]int32{
	"KIND_UNSPECIFIED":      0,
	"PACKAGE_VULNERABILITY": 2,
	"BUILD_DETAILS":         3,
	"IMAGE_BASIS":           4,
	"PACKAGE_MANAGER":       5,
	"DEPLOYABLE":            6,
	"DISCOVERY":             7,
}

func (x Note_Kind) String() string {
	return proto.EnumName(Note_Kind_name, int32(x))
}
func (Note_Kind) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{1, 0} }

// Types of platforms.
type Deployable_Deployment_Platform int32

const (
	// Unknown
	Deployable_Deployment_PLATFORM_UNSPECIFIED Deployable_Deployment_Platform = 0
	// Google Container Engine
	Deployable_Deployment_GKE Deployable_Deployment_Platform = 1
	// Google App Engine: Flexible Environment
	Deployable_Deployment_FLEX Deployable_Deployment_Platform = 2
	// Custom user-defined platform
	Deployable_Deployment_CUSTOM Deployable_Deployment_Platform = 3
)

var Deployable_Deployment_Platform_name = map[int32]string{
	0: "PLATFORM_UNSPECIFIED",
	1: "GKE",
	2: "FLEX",
	3: "CUSTOM",
}
var Deployable_Deployment_Platform_value = map[string]int32{
	"PLATFORM_UNSPECIFIED": 0,
	"GKE":    1,
	"FLEX":   2,
	"CUSTOM": 3,
}

func (x Deployable_Deployment_Platform) String() string {
	return proto.EnumName(Deployable_Deployment_Platform_name, int32(x))
}
func (Deployable_Deployment_Platform) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{2, 0, 0}
}

// Public key formats
type BuildSignature_KeyType int32

const (
	// `KeyType` is not set.
	BuildSignature_KEY_TYPE_UNSPECIFIED BuildSignature_KeyType = 0
	// `PGP ASCII Armored` public key.
	BuildSignature_PGP_ASCII_ARMORED BuildSignature_KeyType = 1
	// `PKIX PEM` public key.
	BuildSignature_PKIX_PEM BuildSignature_KeyType = 2
)

var BuildSignature_KeyType_name = map[int32]string{
	0: "KEY_TYPE_UNSPECIFIED",
	1: "PGP_ASCII_ARMORED",
	2: "PKIX_PEM",
}
var BuildSignature_KeyType_value = map[string]int32{
	"KEY_TYPE_UNSPECIFIED": 0,
	"PGP_ASCII_ARMORED":    1,
	"PKIX_PEM":             2,
}

func (x BuildSignature_KeyType) String() string {
	return proto.EnumName(BuildSignature_KeyType_name, int32(x))
}
func (BuildSignature_KeyType) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{5, 0} }

// `Occurrence` includes information about analysis occurrences for an image.
type Occurrence struct {
	// Output only. The name of the `Occurrence` in the form
	// "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The unique URL of the image or the container for which the `Occurrence`
	// applies. For example, https://gcr.io/project/image@sha256:foo This field
	// can be used as a filter in list requests.
	ResourceUrl string `protobuf:"bytes,2,opt,name=resource_url,json=resourceUrl" json:"resource_url,omitempty"`
	// An analysis note associated with this image, in the form
	// "providers/{provider_id}/notes/{NOTE_ID}"
	// This field can be used as a filter in list requests.
	NoteName string `protobuf:"bytes,3,opt,name=note_name,json=noteName" json:"note_name,omitempty"`
	// Output only. This explicitly denotes which of the `Occurrence` details are
	// specified. This field can be used as a filter in list requests.
	Kind Note_Kind `protobuf:"varint,6,opt,name=kind,enum=google.devtools.containeranalysis.v1alpha1.Note_Kind" json:"kind,omitempty"`
	// Describes the details of the vulnerability `Note` found in this resource.
	//
	// Types that are valid to be assigned to Details:
	//	*Occurrence_VulnerabilityDetails
	//	*Occurrence_BuildDetails
	//	*Occurrence_DerivedImage
	//	*Occurrence_Installation
	//	*Occurrence_Deployment
	//	*Occurrence_Discovered
	Details isOccurrence_Details `protobuf_oneof:"details"`
	// A description of actions that can be taken to remedy the `Note`
	Remediation string `protobuf:"bytes,5,opt,name=remediation" json:"remediation,omitempty"`
	// Output only. The time this `Occurrence` was created.
	CreateTime *google_protobuf1.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// Output only. The time this `Occurrence` was last updated.
	UpdateTime *google_protobuf1.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
}

func (m *Occurrence) Reset()                    { *m = Occurrence{} }
func (m *Occurrence) String() string            { return proto.CompactTextString(m) }
func (*Occurrence) ProtoMessage()               {}
func (*Occurrence) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

type isOccurrence_Details interface {
	isOccurrence_Details()
}

type Occurrence_VulnerabilityDetails struct {
	VulnerabilityDetails *VulnerabilityType_VulnerabilityDetails `protobuf:"bytes,8,opt,name=vulnerability_details,json=vulnerabilityDetails,oneof"`
}
type Occurrence_BuildDetails struct {
	BuildDetails *BuildDetails `protobuf:"bytes,7,opt,name=build_details,json=buildDetails,oneof"`
}
type Occurrence_DerivedImage struct {
	DerivedImage *DockerImage_Derived `protobuf:"bytes,11,opt,name=derived_image,json=derivedImage,oneof"`
}
type Occurrence_Installation struct {
	Installation *PackageManager_Installation `protobuf:"bytes,12,opt,name=installation,oneof"`
}
type Occurrence_Deployment struct {
	Deployment *Deployable_Deployment `protobuf:"bytes,14,opt,name=deployment,oneof"`
}
type Occurrence_Discovered struct {
	Discovered *Discovery_Discovered `protobuf:"bytes,15,opt,name=discovered,oneof"`
}

func (*Occurrence_VulnerabilityDetails) isOccurrence_Details() {}
func (*Occurrence_BuildDetails) isOccurrence_Details()         {}
func (*Occurrence_DerivedImage) isOccurrence_Details()         {}
func (*Occurrence_Installation) isOccurrence_Details()         {}
func (*Occurrence_Deployment) isOccurrence_Details()           {}
func (*Occurrence_Discovered) isOccurrence_Details()           {}

func (m *Occurrence) GetDetails() isOccurrence_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *Occurrence) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Occurrence) GetResourceUrl() string {
	if m != nil {
		return m.ResourceUrl
	}
	return ""
}

func (m *Occurrence) GetNoteName() string {
	if m != nil {
		return m.NoteName
	}
	return ""
}

func (m *Occurrence) GetKind() Note_Kind {
	if m != nil {
		return m.Kind
	}
	return Note_KIND_UNSPECIFIED
}

func (m *Occurrence) GetVulnerabilityDetails() *VulnerabilityType_VulnerabilityDetails {
	if x, ok := m.GetDetails().(*Occurrence_VulnerabilityDetails); ok {
		return x.VulnerabilityDetails
	}
	return nil
}

func (m *Occurrence) GetBuildDetails() *BuildDetails {
	if x, ok := m.GetDetails().(*Occurrence_BuildDetails); ok {
		return x.BuildDetails
	}
	return nil
}

func (m *Occurrence) GetDerivedImage() *DockerImage_Derived {
	if x, ok := m.GetDetails().(*Occurrence_DerivedImage); ok {
		return x.DerivedImage
	}
	return nil
}

func (m *Occurrence) GetInstallation() *PackageManager_Installation {
	if x, ok := m.GetDetails().(*Occurrence_Installation); ok {
		return x.Installation
	}
	return nil
}

func (m *Occurrence) GetDeployment() *Deployable_Deployment {
	if x, ok := m.GetDetails().(*Occurrence_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (m *Occurrence) GetDiscovered() *Discovery_Discovered {
	if x, ok := m.GetDetails().(*Occurrence_Discovered); ok {
		return x.Discovered
	}
	return nil
}

func (m *Occurrence) GetRemediation() string {
	if m != nil {
		return m.Remediation
	}
	return ""
}

func (m *Occurrence) GetCreateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Occurrence) GetUpdateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Occurrence) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Occurrence_OneofMarshaler, _Occurrence_OneofUnmarshaler, _Occurrence_OneofSizer, []interface{}{
		(*Occurrence_VulnerabilityDetails)(nil),
		(*Occurrence_BuildDetails)(nil),
		(*Occurrence_DerivedImage)(nil),
		(*Occurrence_Installation)(nil),
		(*Occurrence_Deployment)(nil),
		(*Occurrence_Discovered)(nil),
	}
}

func _Occurrence_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Occurrence)
	// details
	switch x := m.Details.(type) {
	case *Occurrence_VulnerabilityDetails:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.VulnerabilityDetails); err != nil {
			return err
		}
	case *Occurrence_BuildDetails:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BuildDetails); err != nil {
			return err
		}
	case *Occurrence_DerivedImage:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DerivedImage); err != nil {
			return err
		}
	case *Occurrence_Installation:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Installation); err != nil {
			return err
		}
	case *Occurrence_Deployment:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Deployment); err != nil {
			return err
		}
	case *Occurrence_Discovered:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Discovered); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Occurrence.Details has unexpected type %T", x)
	}
	return nil
}

func _Occurrence_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Occurrence)
	switch tag {
	case 8: // details.vulnerability_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VulnerabilityType_VulnerabilityDetails)
		err := b.DecodeMessage(msg)
		m.Details = &Occurrence_VulnerabilityDetails{msg}
		return true, err
	case 7: // details.build_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BuildDetails)
		err := b.DecodeMessage(msg)
		m.Details = &Occurrence_BuildDetails{msg}
		return true, err
	case 11: // details.derived_image
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DockerImage_Derived)
		err := b.DecodeMessage(msg)
		m.Details = &Occurrence_DerivedImage{msg}
		return true, err
	case 12: // details.installation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PackageManager_Installation)
		err := b.DecodeMessage(msg)
		m.Details = &Occurrence_Installation{msg}
		return true, err
	case 14: // details.deployment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Deployable_Deployment)
		err := b.DecodeMessage(msg)
		m.Details = &Occurrence_Deployment{msg}
		return true, err
	case 15: // details.discovered
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Discovery_Discovered)
		err := b.DecodeMessage(msg)
		m.Details = &Occurrence_Discovered{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Occurrence_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Occurrence)
	// details
	switch x := m.Details.(type) {
	case *Occurrence_VulnerabilityDetails:
		s := proto.Size(x.VulnerabilityDetails)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Occurrence_BuildDetails:
		s := proto.Size(x.BuildDetails)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Occurrence_DerivedImage:
		s := proto.Size(x.DerivedImage)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Occurrence_Installation:
		s := proto.Size(x.Installation)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Occurrence_Deployment:
		s := proto.Size(x.Deployment)
		n += proto.SizeVarint(14<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Occurrence_Discovered:
		s := proto.Size(x.Discovered)
		n += proto.SizeVarint(15<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Provides a detailed description of a `Note`.
type Note struct {
	// The name of the note in the form
	// "providers/{provider_id}/notes/{NOTE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A one sentence description of this `Note`.
	ShortDescription string `protobuf:"bytes,3,opt,name=short_description,json=shortDescription" json:"short_description,omitempty"`
	// A detailed description of this `Note`.
	LongDescription string `protobuf:"bytes,4,opt,name=long_description,json=longDescription" json:"long_description,omitempty"`
	// Output only. This explicitly denotes which kind of note is specified. This
	// field can be used as a filter in list requests.
	Kind Note_Kind `protobuf:"varint,9,opt,name=kind,enum=google.devtools.containeranalysis.v1alpha1.Note_Kind" json:"kind,omitempty"`
	// The type of note.
	//
	// Types that are valid to be assigned to NoteType:
	//	*Note_VulnerabilityType
	//	*Note_BuildType
	//	*Note_BaseImage
	//	*Note_Package
	//	*Note_Deployable
	//	*Note_Discovery
	NoteType isNote_NoteType `protobuf_oneof:"note_type"`
	// URLs associated with this note
	RelatedUrl []*Note_RelatedUrl `protobuf:"bytes,7,rep,name=related_url,json=relatedUrl" json:"related_url,omitempty"`
	// Time of expiration for this note, null if note does not expire.
	ExpirationTime *google_protobuf1.Timestamp `protobuf:"bytes,10,opt,name=expiration_time,json=expirationTime" json:"expiration_time,omitempty"`
	// Output only. The time this note was created. This field can be used as a
	// filter in list requests.
	CreateTime *google_protobuf1.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// Output only. The time this note was last updated. This field can be used as
	// a filter in list requests.
	UpdateTime *google_protobuf1.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
}

func (m *Note) Reset()                    { *m = Note{} }
func (m *Note) String() string            { return proto.CompactTextString(m) }
func (*Note) ProtoMessage()               {}
func (*Note) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

type isNote_NoteType interface {
	isNote_NoteType()
}

type Note_VulnerabilityType struct {
	VulnerabilityType *VulnerabilityType `protobuf:"bytes,6,opt,name=vulnerability_type,json=vulnerabilityType,oneof"`
}
type Note_BuildType struct {
	BuildType *BuildType `protobuf:"bytes,8,opt,name=build_type,json=buildType,oneof"`
}
type Note_BaseImage struct {
	BaseImage *DockerImage_Basis `protobuf:"bytes,13,opt,name=base_image,json=baseImage,oneof"`
}
type Note_Package struct {
	Package *PackageManager_Package `protobuf:"bytes,14,opt,name=package,oneof"`
}
type Note_Deployable struct {
	Deployable *Deployable `protobuf:"bytes,17,opt,name=deployable,oneof"`
}
type Note_Discovery struct {
	Discovery *Discovery `protobuf:"bytes,18,opt,name=discovery,oneof"`
}

func (*Note_VulnerabilityType) isNote_NoteType() {}
func (*Note_BuildType) isNote_NoteType()         {}
func (*Note_BaseImage) isNote_NoteType()         {}
func (*Note_Package) isNote_NoteType()           {}
func (*Note_Deployable) isNote_NoteType()        {}
func (*Note_Discovery) isNote_NoteType()         {}

func (m *Note) GetNoteType() isNote_NoteType {
	if m != nil {
		return m.NoteType
	}
	return nil
}

func (m *Note) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Note) GetShortDescription() string {
	if m != nil {
		return m.ShortDescription
	}
	return ""
}

func (m *Note) GetLongDescription() string {
	if m != nil {
		return m.LongDescription
	}
	return ""
}

func (m *Note) GetKind() Note_Kind {
	if m != nil {
		return m.Kind
	}
	return Note_KIND_UNSPECIFIED
}

func (m *Note) GetVulnerabilityType() *VulnerabilityType {
	if x, ok := m.GetNoteType().(*Note_VulnerabilityType); ok {
		return x.VulnerabilityType
	}
	return nil
}

func (m *Note) GetBuildType() *BuildType {
	if x, ok := m.GetNoteType().(*Note_BuildType); ok {
		return x.BuildType
	}
	return nil
}

func (m *Note) GetBaseImage() *DockerImage_Basis {
	if x, ok := m.GetNoteType().(*Note_BaseImage); ok {
		return x.BaseImage
	}
	return nil
}

func (m *Note) GetPackage() *PackageManager_Package {
	if x, ok := m.GetNoteType().(*Note_Package); ok {
		return x.Package
	}
	return nil
}

func (m *Note) GetDeployable() *Deployable {
	if x, ok := m.GetNoteType().(*Note_Deployable); ok {
		return x.Deployable
	}
	return nil
}

func (m *Note) GetDiscovery() *Discovery {
	if x, ok := m.GetNoteType().(*Note_Discovery); ok {
		return x.Discovery
	}
	return nil
}

func (m *Note) GetRelatedUrl() []*Note_RelatedUrl {
	if m != nil {
		return m.RelatedUrl
	}
	return nil
}

func (m *Note) GetExpirationTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.ExpirationTime
	}
	return nil
}

func (m *Note) GetCreateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Note) GetUpdateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Note) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Note_OneofMarshaler, _Note_OneofUnmarshaler, _Note_OneofSizer, []interface{}{
		(*Note_VulnerabilityType)(nil),
		(*Note_BuildType)(nil),
		(*Note_BaseImage)(nil),
		(*Note_Package)(nil),
		(*Note_Deployable)(nil),
		(*Note_Discovery)(nil),
	}
}

func _Note_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Note)
	// note_type
	switch x := m.NoteType.(type) {
	case *Note_VulnerabilityType:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.VulnerabilityType); err != nil {
			return err
		}
	case *Note_BuildType:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BuildType); err != nil {
			return err
		}
	case *Note_BaseImage:
		b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BaseImage); err != nil {
			return err
		}
	case *Note_Package:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Package); err != nil {
			return err
		}
	case *Note_Deployable:
		b.EncodeVarint(17<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Deployable); err != nil {
			return err
		}
	case *Note_Discovery:
		b.EncodeVarint(18<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Discovery); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Note.NoteType has unexpected type %T", x)
	}
	return nil
}

func _Note_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Note)
	switch tag {
	case 6: // note_type.vulnerability_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VulnerabilityType)
		err := b.DecodeMessage(msg)
		m.NoteType = &Note_VulnerabilityType{msg}
		return true, err
	case 8: // note_type.build_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BuildType)
		err := b.DecodeMessage(msg)
		m.NoteType = &Note_BuildType{msg}
		return true, err
	case 13: // note_type.base_image
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DockerImage_Basis)
		err := b.DecodeMessage(msg)
		m.NoteType = &Note_BaseImage{msg}
		return true, err
	case 14: // note_type.package
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PackageManager_Package)
		err := b.DecodeMessage(msg)
		m.NoteType = &Note_Package{msg}
		return true, err
	case 17: // note_type.deployable
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Deployable)
		err := b.DecodeMessage(msg)
		m.NoteType = &Note_Deployable{msg}
		return true, err
	case 18: // note_type.discovery
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Discovery)
		err := b.DecodeMessage(msg)
		m.NoteType = &Note_Discovery{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Note_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Note)
	// note_type
	switch x := m.NoteType.(type) {
	case *Note_VulnerabilityType:
		s := proto.Size(x.VulnerabilityType)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Note_BuildType:
		s := proto.Size(x.BuildType)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Note_BaseImage:
		s := proto.Size(x.BaseImage)
		n += proto.SizeVarint(13<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Note_Package:
		s := proto.Size(x.Package)
		n += proto.SizeVarint(14<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Note_Deployable:
		s := proto.Size(x.Deployable)
		n += proto.SizeVarint(17<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Note_Discovery:
		s := proto.Size(x.Discovery)
		n += proto.SizeVarint(18<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Metadata for any related URL information
type Note_RelatedUrl struct {
	// Specific URL to associate with the note
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
	// Label to describe usage of the URL
	Label string `protobuf:"bytes,2,opt,name=label" json:"label,omitempty"`
}

func (m *Note_RelatedUrl) Reset()                    { *m = Note_RelatedUrl{} }
func (m *Note_RelatedUrl) String() string            { return proto.CompactTextString(m) }
func (*Note_RelatedUrl) ProtoMessage()               {}
func (*Note_RelatedUrl) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1, 0} }

func (m *Note_RelatedUrl) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Note_RelatedUrl) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

// An artifact that can be deployed in some runtime.
type Deployable struct {
	// Resource URI for the artifact being deployed.
	ResourceUri []string `protobuf:"bytes,1,rep,name=resource_uri,json=resourceUri" json:"resource_uri,omitempty"`
}

func (m *Deployable) Reset()                    { *m = Deployable{} }
func (m *Deployable) String() string            { return proto.CompactTextString(m) }
func (*Deployable) ProtoMessage()               {}
func (*Deployable) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *Deployable) GetResourceUri() []string {
	if m != nil {
		return m.ResourceUri
	}
	return nil
}

// The period during which some deployable was active in a runtime.
type Deployable_Deployment struct {
	// Identity of the user that triggered this deployment.
	UserEmail string `protobuf:"bytes,1,opt,name=user_email,json=userEmail" json:"user_email,omitempty"`
	// Beginning of the lifetime of this deployment.
	DeployTime *google_protobuf1.Timestamp `protobuf:"bytes,2,opt,name=deploy_time,json=deployTime" json:"deploy_time,omitempty"`
	// End of the lifetime of this deployment.
	UndeployTime *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=undeploy_time,json=undeployTime" json:"undeploy_time,omitempty"`
	// Configuration used to create this deployment.
	Config string `protobuf:"bytes,8,opt,name=config" json:"config,omitempty"`
	// Address of the runtime element hosting this deployment.
	Address string `protobuf:"bytes,5,opt,name=address" json:"address,omitempty"`
	// Output only. Resource URI for the artifact being deployed taken from the
	// deployable field with the same name.
	ResourceUri []string `protobuf:"bytes,6,rep,name=resource_uri,json=resourceUri" json:"resource_uri,omitempty"`
	// Platform hosting this deployment.
	Platform Deployable_Deployment_Platform `protobuf:"varint,7,opt,name=platform,enum=google.devtools.containeranalysis.v1alpha1.Deployable_Deployment_Platform" json:"platform,omitempty"`
}

func (m *Deployable_Deployment) Reset()                    { *m = Deployable_Deployment{} }
func (m *Deployable_Deployment) String() string            { return proto.CompactTextString(m) }
func (*Deployable_Deployment) ProtoMessage()               {}
func (*Deployable_Deployment) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2, 0} }

func (m *Deployable_Deployment) GetUserEmail() string {
	if m != nil {
		return m.UserEmail
	}
	return ""
}

func (m *Deployable_Deployment) GetDeployTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.DeployTime
	}
	return nil
}

func (m *Deployable_Deployment) GetUndeployTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UndeployTime
	}
	return nil
}

func (m *Deployable_Deployment) GetConfig() string {
	if m != nil {
		return m.Config
	}
	return ""
}

func (m *Deployable_Deployment) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *Deployable_Deployment) GetResourceUri() []string {
	if m != nil {
		return m.ResourceUri
	}
	return nil
}

func (m *Deployable_Deployment) GetPlatform() Deployable_Deployment_Platform {
	if m != nil {
		return m.Platform
	}
	return Deployable_Deployment_PLATFORM_UNSPECIFIED
}

// A note that indicates a type of analysis a provider would perform. This note
// exists in a provider's project. A `Discovery` occurrence is created in a
// consumer's project at the start of analysis. The occurrence's operation will
// indicate the status of the analysis. Absence of an occurrence linked to this
// note for a resource indicates that analysis hasn't started.
type Discovery struct {
	// The kind of analysis that is handled by this discovery.
	AnalysisKind Note_Kind `protobuf:"varint,1,opt,name=analysis_kind,json=analysisKind,enum=google.devtools.containeranalysis.v1alpha1.Note_Kind" json:"analysis_kind,omitempty"`
}

func (m *Discovery) Reset()                    { *m = Discovery{} }
func (m *Discovery) String() string            { return proto.CompactTextString(m) }
func (*Discovery) ProtoMessage()               {}
func (*Discovery) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *Discovery) GetAnalysisKind() Note_Kind {
	if m != nil {
		return m.AnalysisKind
	}
	return Note_KIND_UNSPECIFIED
}

// Provides information about the scan status of a discovered resource.
type Discovery_Discovered struct {
	// Output only. An operation that indicates the status of the current scan.
	Operation *google_longrunning.Operation `protobuf:"bytes,1,opt,name=operation" json:"operation,omitempty"`
}

func (m *Discovery_Discovered) Reset()                    { *m = Discovery_Discovered{} }
func (m *Discovery_Discovered) String() string            { return proto.CompactTextString(m) }
func (*Discovery_Discovered) ProtoMessage()               {}
func (*Discovery_Discovered) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3, 0} }

func (m *Discovery_Discovered) GetOperation() *google_longrunning.Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

// Note holding the version of the provider's builder and the signature of
// the provenance message in linked BuildDetails.
type BuildType struct {
	// Version of the builder which produced this Note.
	BuilderVersion string `protobuf:"bytes,1,opt,name=builder_version,json=builderVersion" json:"builder_version,omitempty"`
	// Signature of the build in Occurrences pointing to the Note containing this
	// `BuilderDetails`.
	Signature *BuildSignature `protobuf:"bytes,2,opt,name=signature" json:"signature,omitempty"`
}

func (m *BuildType) Reset()                    { *m = BuildType{} }
func (m *BuildType) String() string            { return proto.CompactTextString(m) }
func (*BuildType) ProtoMessage()               {}
func (*BuildType) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *BuildType) GetBuilderVersion() string {
	if m != nil {
		return m.BuilderVersion
	}
	return ""
}

func (m *BuildType) GetSignature() *BuildSignature {
	if m != nil {
		return m.Signature
	}
	return nil
}

// Message encapsulating the signature of the verified build.
type BuildSignature struct {
	// Public key of the builder which can be used to verify that the related
	// findings are valid and unchanged. If `key_type` is empty, this defaults
	// to PEM encoded public keys.
	//
	// This field may be empty if `key_id` references an external key.
	//
	// For Cloud Container Builder based signatures, this is a PEM encoded public
	// key. To verify the Cloud Container Builder signature, place the contents of
	// this field into a file (public.pem). The signature field is base64-decoded
	// into its binary representation in signature.bin, and the provenance bytes
	// from `BuildDetails` are base64-decoded into a binary representation in
	// signed.bin. OpenSSL can then verify the signature:
	// `openssl sha256 -verify public.pem -signature signature.bin signed.bin`
	PublicKey string `protobuf:"bytes,1,opt,name=public_key,json=publicKey" json:"public_key,omitempty"`
	// Signature of the related `BuildProvenance`, encoded in a base64 string.
	Signature string `protobuf:"bytes,2,opt,name=signature" json:"signature,omitempty"`
	// An Id for the key used to sign. This could be either an Id for the key
	// stored in `public_key` (such as the Id or fingerprint for a PGP key, or the
	// CN for a cert), or a reference to an external key (such as a reference to a
	// key in Cloud Key Management Service).
	KeyId string `protobuf:"bytes,3,opt,name=key_id,json=keyId" json:"key_id,omitempty"`
	// The type of the key, either stored in `public_key` or referenced in
	// `key_id`
	KeyType BuildSignature_KeyType `protobuf:"varint,4,opt,name=key_type,json=keyType,enum=google.devtools.containeranalysis.v1alpha1.BuildSignature_KeyType" json:"key_type,omitempty"`
}

func (m *BuildSignature) Reset()                    { *m = BuildSignature{} }
func (m *BuildSignature) String() string            { return proto.CompactTextString(m) }
func (*BuildSignature) ProtoMessage()               {}
func (*BuildSignature) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *BuildSignature) GetPublicKey() string {
	if m != nil {
		return m.PublicKey
	}
	return ""
}

func (m *BuildSignature) GetSignature() string {
	if m != nil {
		return m.Signature
	}
	return ""
}

func (m *BuildSignature) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *BuildSignature) GetKeyType() BuildSignature_KeyType {
	if m != nil {
		return m.KeyType
	}
	return BuildSignature_KEY_TYPE_UNSPECIFIED
}

// Message encapsulating build provenance details.
type BuildDetails struct {
	// The actual provenance
	Provenance *BuildProvenance `protobuf:"bytes,1,opt,name=provenance" json:"provenance,omitempty"`
	// Serialized JSON representation of the provenance, used in generating the
	// `BuildSignature` in the corresponding Result. After verifying the
	// signature, `provenance_bytes` can be unmarshalled and compared to the
	// provenance to confirm that it is unchanged. A base64-encoded string
	// representation of the provenance bytes is used for the signature in order
	// to interoperate with openssl which expects this format for signature
	// verification.
	//
	// The serialized form is captured both to avoid ambiguity in how the
	// provenance is marshalled to json as well to prevent incompatibilities with
	// future changes.
	ProvenanceBytes string `protobuf:"bytes,2,opt,name=provenance_bytes,json=provenanceBytes" json:"provenance_bytes,omitempty"`
}

func (m *BuildDetails) Reset()                    { *m = BuildDetails{} }
func (m *BuildDetails) String() string            { return proto.CompactTextString(m) }
func (*BuildDetails) ProtoMessage()               {}
func (*BuildDetails) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *BuildDetails) GetProvenance() *BuildProvenance {
	if m != nil {
		return m.Provenance
	}
	return nil
}

func (m *BuildDetails) GetProvenanceBytes() string {
	if m != nil {
		return m.ProvenanceBytes
	}
	return ""
}

// Request to get a Occurrence.
type GetOccurrenceRequest struct {
	// The name of the occurrence of the form
	// "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetOccurrenceRequest) Reset()                    { *m = GetOccurrenceRequest{} }
func (m *GetOccurrenceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetOccurrenceRequest) ProtoMessage()               {}
func (*GetOccurrenceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *GetOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list occurrences.
type ListOccurrencesRequest struct {
	// The name field contains the project Id. For example:
	// "projects/{project_id}
	// @Deprecated
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// This contains the project Id for example: projects/{project_id}.
	Parent string `protobuf:"bytes,5,opt,name=parent" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// Number of occurrences to return in the list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListOccurrencesRequest) Reset()                    { *m = ListOccurrencesRequest{} }
func (m *ListOccurrencesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListOccurrencesRequest) ProtoMessage()               {}
func (*ListOccurrencesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *ListOccurrencesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListOccurrencesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListOccurrencesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListOccurrencesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListOccurrencesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response including listed active occurrences.
type ListOccurrencesResponse struct {
	// The occurrences requested.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences" json:"occurrences,omitempty"`
	// The next pagination token in the list response. It should be used as
	// `page_token` for the following request. An empty value means no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListOccurrencesResponse) Reset()                    { *m = ListOccurrencesResponse{} }
func (m *ListOccurrencesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListOccurrencesResponse) ProtoMessage()               {}
func (*ListOccurrencesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *ListOccurrencesResponse) GetOccurrences() []*Occurrence {
	if m != nil {
		return m.Occurrences
	}
	return nil
}

func (m *ListOccurrencesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to delete a occurrence
type DeleteOccurrenceRequest struct {
	// The name of the occurrence in the form of
	// "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteOccurrenceRequest) Reset()                    { *m = DeleteOccurrenceRequest{} }
func (m *DeleteOccurrenceRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteOccurrenceRequest) ProtoMessage()               {}
func (*DeleteOccurrenceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *DeleteOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to insert a new occurrence.
type CreateOccurrenceRequest struct {
	// The name of the project.  Should be of the form "projects/{project_id}".
	// @Deprecated
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// This field contains the project Id for example: "projects/{project_id}"
	Parent string `protobuf:"bytes,3,opt,name=parent" json:"parent,omitempty"`
	// The occurrence to be inserted
	Occurrence *Occurrence `protobuf:"bytes,2,opt,name=occurrence" json:"occurrence,omitempty"`
}

func (m *CreateOccurrenceRequest) Reset()                    { *m = CreateOccurrenceRequest{} }
func (m *CreateOccurrenceRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateOccurrenceRequest) ProtoMessage()               {}
func (*CreateOccurrenceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *CreateOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateOccurrenceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateOccurrenceRequest) GetOccurrence() *Occurrence {
	if m != nil {
		return m.Occurrence
	}
	return nil
}

// Request to update an existing occurrence
type UpdateOccurrenceRequest struct {
	// The name of the occurrence.
	// Should be of the form "projects/{project_id}/occurrences/{OCCURRENCE_ID}".
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The updated occurrence.
	Occurrence *Occurrence `protobuf:"bytes,2,opt,name=occurrence" json:"occurrence,omitempty"`
	// The fields to update.
	UpdateMask *google_protobuf4.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateOccurrenceRequest) Reset()                    { *m = UpdateOccurrenceRequest{} }
func (m *UpdateOccurrenceRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateOccurrenceRequest) ProtoMessage()               {}
func (*UpdateOccurrenceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *UpdateOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateOccurrenceRequest) GetOccurrence() *Occurrence {
	if m != nil {
		return m.Occurrence
	}
	return nil
}

func (m *UpdateOccurrenceRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request to get a Note.
type GetNoteRequest struct {
	// The name of the note in the form of
	// "providers/{provider_id}/notes/{NOTE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetNoteRequest) Reset()                    { *m = GetNoteRequest{} }
func (m *GetNoteRequest) String() string            { return proto.CompactTextString(m) }
func (*GetNoteRequest) ProtoMessage()               {}
func (*GetNoteRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *GetNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to get the note to which this occurrence is attached.
type GetOccurrenceNoteRequest struct {
	// The name of the occurrence in the form
	// "projects/{project_id}/occurrences/{OCCURRENCE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetOccurrenceNoteRequest) Reset()                    { *m = GetOccurrenceNoteRequest{} }
func (m *GetOccurrenceNoteRequest) String() string            { return proto.CompactTextString(m) }
func (*GetOccurrenceNoteRequest) ProtoMessage()               {}
func (*GetOccurrenceNoteRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

func (m *GetOccurrenceNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list notes.
type ListNotesRequest struct {
	// The name field will contain the project Id for example:
	// "providers/{provider_id}
	// @Deprecated
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// This field contains the project Id for example:
	// "project/{project_id}
	Parent string `protobuf:"bytes,5,opt,name=parent" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// Number of notes to return in the list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListNotesRequest) Reset()                    { *m = ListNotesRequest{} }
func (m *ListNotesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListNotesRequest) ProtoMessage()               {}
func (*ListNotesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *ListNotesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListNotesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListNotesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListNotesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNotesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response including listed notes.
type ListNotesResponse struct {
	// The occurrences requested
	Notes []*Note `protobuf:"bytes,1,rep,name=notes" json:"notes,omitempty"`
	// The next pagination token in the list response. It should be used as
	// page_token for the following request. An empty value means no more result.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListNotesResponse) Reset()                    { *m = ListNotesResponse{} }
func (m *ListNotesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListNotesResponse) ProtoMessage()               {}
func (*ListNotesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

func (m *ListNotesResponse) GetNotes() []*Note {
	if m != nil {
		return m.Notes
	}
	return nil
}

func (m *ListNotesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to delete a note
type DeleteNoteRequest struct {
	// The name of the note in the form of
	// "providers/{provider_id}/notes/{NOTE_ID}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteNoteRequest) Reset()                    { *m = DeleteNoteRequest{} }
func (m *DeleteNoteRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteNoteRequest) ProtoMessage()               {}
func (*DeleteNoteRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{17} }

func (m *DeleteNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to insert a new note
type CreateNoteRequest struct {
	// The name of the project.
	// Should be of the form "providers/{provider_id}".
	// @Deprecated
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// This field contains the project Id for example:
	// "project/{project_id}
	Parent string `protobuf:"bytes,4,opt,name=parent" json:"parent,omitempty"`
	// The ID to use for this note.
	NoteId string `protobuf:"bytes,2,opt,name=note_id,json=noteId" json:"note_id,omitempty"`
	// The Note to be inserted
	Note *Note `protobuf:"bytes,3,opt,name=note" json:"note,omitempty"`
}

func (m *CreateNoteRequest) Reset()                    { *m = CreateNoteRequest{} }
func (m *CreateNoteRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateNoteRequest) ProtoMessage()               {}
func (*CreateNoteRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{18} }

func (m *CreateNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateNoteRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateNoteRequest) GetNoteId() string {
	if m != nil {
		return m.NoteId
	}
	return ""
}

func (m *CreateNoteRequest) GetNote() *Note {
	if m != nil {
		return m.Note
	}
	return nil
}

// Request to update an existing note
type UpdateNoteRequest struct {
	// The name of the note.
	// Should be of the form "projects/{provider_id}/notes/{note_id}".
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The updated note.
	Note *Note `protobuf:"bytes,2,opt,name=note" json:"note,omitempty"`
	// The fields to update.
	UpdateMask *google_protobuf4.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateNoteRequest) Reset()                    { *m = UpdateNoteRequest{} }
func (m *UpdateNoteRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateNoteRequest) ProtoMessage()               {}
func (*UpdateNoteRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{19} }

func (m *UpdateNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateNoteRequest) GetNote() *Note {
	if m != nil {
		return m.Note
	}
	return nil
}

func (m *UpdateNoteRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request to list occurrences.
type ListNoteOccurrencesRequest struct {
	// The name field will contain the note name for example:
	//   "provider/{provider_id}/notes/{note_id}"
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// Number of notes to return in the list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListNoteOccurrencesRequest) Reset()                    { *m = ListNoteOccurrencesRequest{} }
func (m *ListNoteOccurrencesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListNoteOccurrencesRequest) ProtoMessage()               {}
func (*ListNoteOccurrencesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{20} }

func (m *ListNoteOccurrencesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListNoteOccurrencesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListNoteOccurrencesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNoteOccurrencesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response including listed occurrences for a note.
type ListNoteOccurrencesResponse struct {
	// The occurrences attached to the specified note.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences" json:"occurrences,omitempty"`
	// Token to receive the next page of notes.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListNoteOccurrencesResponse) Reset()                    { *m = ListNoteOccurrencesResponse{} }
func (m *ListNoteOccurrencesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListNoteOccurrencesResponse) ProtoMessage()               {}
func (*ListNoteOccurrencesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{21} }

func (m *ListNoteOccurrencesResponse) GetOccurrences() []*Occurrence {
	if m != nil {
		return m.Occurrences
	}
	return nil
}

func (m *ListNoteOccurrencesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Metadata for all operations used and required for all operations
// that created by Container Analysis Providers
type OperationMetadata struct {
	// Output only. The time this operation was created.
	CreateTime *google_protobuf1.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// Output only. The time that this operation was marked completed or failed.
	EndTime *google_protobuf1.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
}

func (m *OperationMetadata) Reset()                    { *m = OperationMetadata{} }
func (m *OperationMetadata) String() string            { return proto.CompactTextString(m) }
func (*OperationMetadata) ProtoMessage()               {}
func (*OperationMetadata) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{22} }

func (m *OperationMetadata) GetCreateTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *OperationMetadata) GetEndTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// Request to get the vulnz summary for some set of vulnerability Occurrences.
type GetVulnzOccurrencesSummaryRequest struct {
	// This contains the project Id for example: projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
}

func (m *GetVulnzOccurrencesSummaryRequest) Reset()         { *m = GetVulnzOccurrencesSummaryRequest{} }
func (m *GetVulnzOccurrencesSummaryRequest) String() string { return proto.CompactTextString(m) }
func (*GetVulnzOccurrencesSummaryRequest) ProtoMessage()    {}
func (*GetVulnzOccurrencesSummaryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{23}
}

func (m *GetVulnzOccurrencesSummaryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *GetVulnzOccurrencesSummaryRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// A summary of how many vulnz occurrences there are per severity type.
// counts by groups, or if we should have different summary messages
// like this.
type GetVulnzOccurrencesSummaryResponse struct {
	// A map of how many occurrences were found for each severity.
	Counts []*GetVulnzOccurrencesSummaryResponse_SeverityCount `protobuf:"bytes,1,rep,name=counts" json:"counts,omitempty"`
}

func (m *GetVulnzOccurrencesSummaryResponse) Reset()         { *m = GetVulnzOccurrencesSummaryResponse{} }
func (m *GetVulnzOccurrencesSummaryResponse) String() string { return proto.CompactTextString(m) }
func (*GetVulnzOccurrencesSummaryResponse) ProtoMessage()    {}
func (*GetVulnzOccurrencesSummaryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{24}
}

func (m *GetVulnzOccurrencesSummaryResponse) GetCounts() []*GetVulnzOccurrencesSummaryResponse_SeverityCount {
	if m != nil {
		return m.Counts
	}
	return nil
}

// The number of occurrences created for a specific severity.
type GetVulnzOccurrencesSummaryResponse_SeverityCount struct {
	// The severity of the occurrences.
	Severity VulnerabilityType_Severity `protobuf:"varint,1,opt,name=severity,enum=google.devtools.containeranalysis.v1alpha1.VulnerabilityType_Severity" json:"severity,omitempty"`
	// The number of occurrences with the severity.
	Count int64 `protobuf:"varint,2,opt,name=count" json:"count,omitempty"`
}

func (m *GetVulnzOccurrencesSummaryResponse_SeverityCount) Reset() {
	*m = GetVulnzOccurrencesSummaryResponse_SeverityCount{}
}
func (m *GetVulnzOccurrencesSummaryResponse_SeverityCount) String() string {
	return proto.CompactTextString(m)
}
func (*GetVulnzOccurrencesSummaryResponse_SeverityCount) ProtoMessage() {}
func (*GetVulnzOccurrencesSummaryResponse_SeverityCount) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{24, 0}
}

func (m *GetVulnzOccurrencesSummaryResponse_SeverityCount) GetSeverity() VulnerabilityType_Severity {
	if m != nil {
		return m.Severity
	}
	return VulnerabilityType_SEVERITY_UNSPECIFIED
}

func (m *GetVulnzOccurrencesSummaryResponse_SeverityCount) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func init() {
	proto.RegisterType((*Occurrence)(nil), "google.devtools.containeranalysis.v1alpha1.Occurrence")
	proto.RegisterType((*Note)(nil), "google.devtools.containeranalysis.v1alpha1.Note")
	proto.RegisterType((*Note_RelatedUrl)(nil), "google.devtools.containeranalysis.v1alpha1.Note.RelatedUrl")
	proto.RegisterType((*Deployable)(nil), "google.devtools.containeranalysis.v1alpha1.Deployable")
	proto.RegisterType((*Deployable_Deployment)(nil), "google.devtools.containeranalysis.v1alpha1.Deployable.Deployment")
	proto.RegisterType((*Discovery)(nil), "google.devtools.containeranalysis.v1alpha1.Discovery")
	proto.RegisterType((*Discovery_Discovered)(nil), "google.devtools.containeranalysis.v1alpha1.Discovery.Discovered")
	proto.RegisterType((*BuildType)(nil), "google.devtools.containeranalysis.v1alpha1.BuildType")
	proto.RegisterType((*BuildSignature)(nil), "google.devtools.containeranalysis.v1alpha1.BuildSignature")
	proto.RegisterType((*BuildDetails)(nil), "google.devtools.containeranalysis.v1alpha1.BuildDetails")
	proto.RegisterType((*GetOccurrenceRequest)(nil), "google.devtools.containeranalysis.v1alpha1.GetOccurrenceRequest")
	proto.RegisterType((*ListOccurrencesRequest)(nil), "google.devtools.containeranalysis.v1alpha1.ListOccurrencesRequest")
	proto.RegisterType((*ListOccurrencesResponse)(nil), "google.devtools.containeranalysis.v1alpha1.ListOccurrencesResponse")
	proto.RegisterType((*DeleteOccurrenceRequest)(nil), "google.devtools.containeranalysis.v1alpha1.DeleteOccurrenceRequest")
	proto.RegisterType((*CreateOccurrenceRequest)(nil), "google.devtools.containeranalysis.v1alpha1.CreateOccurrenceRequest")
	proto.RegisterType((*UpdateOccurrenceRequest)(nil), "google.devtools.containeranalysis.v1alpha1.UpdateOccurrenceRequest")
	proto.RegisterType((*GetNoteRequest)(nil), "google.devtools.containeranalysis.v1alpha1.GetNoteRequest")
	proto.RegisterType((*GetOccurrenceNoteRequest)(nil), "google.devtools.containeranalysis.v1alpha1.GetOccurrenceNoteRequest")
	proto.RegisterType((*ListNotesRequest)(nil), "google.devtools.containeranalysis.v1alpha1.ListNotesRequest")
	proto.RegisterType((*ListNotesResponse)(nil), "google.devtools.containeranalysis.v1alpha1.ListNotesResponse")
	proto.RegisterType((*DeleteNoteRequest)(nil), "google.devtools.containeranalysis.v1alpha1.DeleteNoteRequest")
	proto.RegisterType((*CreateNoteRequest)(nil), "google.devtools.containeranalysis.v1alpha1.CreateNoteRequest")
	proto.RegisterType((*UpdateNoteRequest)(nil), "google.devtools.containeranalysis.v1alpha1.UpdateNoteRequest")
	proto.RegisterType((*ListNoteOccurrencesRequest)(nil), "google.devtools.containeranalysis.v1alpha1.ListNoteOccurrencesRequest")
	proto.RegisterType((*ListNoteOccurrencesResponse)(nil), "google.devtools.containeranalysis.v1alpha1.ListNoteOccurrencesResponse")
	proto.RegisterType((*OperationMetadata)(nil), "google.devtools.containeranalysis.v1alpha1.OperationMetadata")
	proto.RegisterType((*GetVulnzOccurrencesSummaryRequest)(nil), "google.devtools.containeranalysis.v1alpha1.GetVulnzOccurrencesSummaryRequest")
	proto.RegisterType((*GetVulnzOccurrencesSummaryResponse)(nil), "google.devtools.containeranalysis.v1alpha1.GetVulnzOccurrencesSummaryResponse")
	proto.RegisterType((*GetVulnzOccurrencesSummaryResponse_SeverityCount)(nil), "google.devtools.containeranalysis.v1alpha1.GetVulnzOccurrencesSummaryResponse.SeverityCount")
	proto.RegisterEnum("google.devtools.containeranalysis.v1alpha1.Note_Kind", Note_Kind_name, Note_Kind_value)
	proto.RegisterEnum("google.devtools.containeranalysis.v1alpha1.Deployable_Deployment_Platform", Deployable_Deployment_Platform_name, Deployable_Deployment_Platform_value)
	proto.RegisterEnum("google.devtools.containeranalysis.v1alpha1.BuildSignature_KeyType", BuildSignature_KeyType_name, BuildSignature_KeyType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ContainerAnalysis service

type ContainerAnalysisClient interface {
	// Returns the requested `Occurrence`.
	GetOccurrence(ctx context.Context, in *GetOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Lists active `Occurrences` for a given project matching the filters.
	ListOccurrences(ctx context.Context, in *ListOccurrencesRequest, opts ...grpc.CallOption) (*ListOccurrencesResponse, error)
	// Deletes the given `Occurrence` from the system. Use this when
	// an `Occurrence` is no longer applicable for the given resource.
	DeleteOccurrence(ctx context.Context, in *DeleteOccurrenceRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Creates a new `Occurrence`. Use this method to create `Occurrences`
	// for a resource.
	CreateOccurrence(ctx context.Context, in *CreateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Updates an existing occurrence.
	UpdateOccurrence(ctx context.Context, in *UpdateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Gets the `Note` attached to the given `Occurrence`.
	GetOccurrenceNote(ctx context.Context, in *GetOccurrenceNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Returns the requested `Note`.
	GetNote(ctx context.Context, in *GetNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Lists all `Notes` for a given project.
	ListNotes(ctx context.Context, in *ListNotesRequest, opts ...grpc.CallOption) (*ListNotesResponse, error)
	// Deletes the given `Note` from the system.
	DeleteNote(ctx context.Context, in *DeleteNoteRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Creates a new `Note`.
	CreateNote(ctx context.Context, in *CreateNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Updates an existing `Note`.
	UpdateNote(ctx context.Context, in *UpdateNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Lists `Occurrences` referencing the specified `Note`. Use this method to
	// get all occurrences referencing your `Note` across all your customer
	// projects.
	ListNoteOccurrences(ctx context.Context, in *ListNoteOccurrencesRequest, opts ...grpc.CallOption) (*ListNoteOccurrencesResponse, error)
	// Gets a summary of the number and severity of occurrences.
	GetVulnzOccurrencesSummary(ctx context.Context, in *GetVulnzOccurrencesSummaryRequest, opts ...grpc.CallOption) (*GetVulnzOccurrencesSummaryResponse, error)
	// Sets the access control policy on the specified `Note` or `Occurrence`.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a `Note` or an `Occurrence`, respectively.
	// Attempting to call this method without these permissions will result in a `
	// `PERMISSION_DENIED` error.
	// Attempting to call this method on a non-existent resource will result in a
	// `NOT_FOUND` error if the user has `containeranalysis.notes.list` permission
	// on a `Note` or `containeranalysis.occurrences.list` on an `Occurrence`, or
	// a `PERMISSION_DENIED` error otherwise. The resource takes the following
	// formats: `projects/{projectid}/occurrences/{occurrenceid}` for occurrences
	// and projects/{projectid}/notes/{noteid} for notes
	SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// Gets the access control policy for a note or an `Occurrence` resource.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a note or occurrence, respectively.
	// Attempting to call this method on a resource without the required
	// permission will result in a `PERMISSION_DENIED` error. Attempting to call
	// this method on a non-existent resource will result in a `NOT_FOUND` error
	// if the user has list permission on the project, or a `PERMISSION_DENIED`
	// error otherwise. The resource takes the following formats:
	// `projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for occurrences and
	// projects/{PROJECT_ID}/notes/{NOTE_ID} for notes
	GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// Returns the permissions that a caller has on the specified note or
	// occurrence resource. Requires list permission on the project (for example,
	// "storage.objects.list" on the containing bucket for testing permission of
	// an object). Attempting to call this method on a non-existent resource will
	// result in a `NOT_FOUND` error if the user has list permission on the
	// project, or a `PERMISSION_DENIED` error otherwise. The resource takes the
	// following formats: `projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for
	// `Occurrences` and `projects/{PROJECT_ID}/notes/{NOTE_ID}` for `Notes`
	TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error)
}

type containerAnalysisClient struct {
	cc *grpc.ClientConn
}

func NewContainerAnalysisClient(cc *grpc.ClientConn) ContainerAnalysisClient {
	return &containerAnalysisClient{cc}
}

func (c *containerAnalysisClient) GetOccurrence(ctx context.Context, in *GetOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetOccurrence", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) ListOccurrences(ctx context.Context, in *ListOccurrencesRequest, opts ...grpc.CallOption) (*ListOccurrencesResponse, error) {
	out := new(ListOccurrencesResponse)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListOccurrences", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) DeleteOccurrence(ctx context.Context, in *DeleteOccurrenceRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/DeleteOccurrence", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) CreateOccurrence(ctx context.Context, in *CreateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/CreateOccurrence", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) UpdateOccurrence(ctx context.Context, in *UpdateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/UpdateOccurrence", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) GetOccurrenceNote(ctx context.Context, in *GetOccurrenceNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetOccurrenceNote", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) GetNote(ctx context.Context, in *GetNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetNote", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) ListNotes(ctx context.Context, in *ListNotesRequest, opts ...grpc.CallOption) (*ListNotesResponse, error) {
	out := new(ListNotesResponse)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListNotes", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) DeleteNote(ctx context.Context, in *DeleteNoteRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/DeleteNote", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) CreateNote(ctx context.Context, in *CreateNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/CreateNote", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) UpdateNote(ctx context.Context, in *UpdateNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/UpdateNote", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) ListNoteOccurrences(ctx context.Context, in *ListNoteOccurrencesRequest, opts ...grpc.CallOption) (*ListNoteOccurrencesResponse, error) {
	out := new(ListNoteOccurrencesResponse)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListNoteOccurrences", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) GetVulnzOccurrencesSummary(ctx context.Context, in *GetVulnzOccurrencesSummaryRequest, opts ...grpc.CallOption) (*GetVulnzOccurrencesSummaryResponse, error) {
	out := new(GetVulnzOccurrencesSummaryResponse)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetVulnzOccurrencesSummary", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/SetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *containerAnalysisClient) TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error) {
	out := new(google_iam_v11.TestIamPermissionsResponse)
	err := grpc.Invoke(ctx, "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/TestIamPermissions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ContainerAnalysis service

type ContainerAnalysisServer interface {
	// Returns the requested `Occurrence`.
	GetOccurrence(context.Context, *GetOccurrenceRequest) (*Occurrence, error)
	// Lists active `Occurrences` for a given project matching the filters.
	ListOccurrences(context.Context, *ListOccurrencesRequest) (*ListOccurrencesResponse, error)
	// Deletes the given `Occurrence` from the system. Use this when
	// an `Occurrence` is no longer applicable for the given resource.
	DeleteOccurrence(context.Context, *DeleteOccurrenceRequest) (*google_protobuf3.Empty, error)
	// Creates a new `Occurrence`. Use this method to create `Occurrences`
	// for a resource.
	CreateOccurrence(context.Context, *CreateOccurrenceRequest) (*Occurrence, error)
	// Updates an existing occurrence.
	UpdateOccurrence(context.Context, *UpdateOccurrenceRequest) (*Occurrence, error)
	// Gets the `Note` attached to the given `Occurrence`.
	GetOccurrenceNote(context.Context, *GetOccurrenceNoteRequest) (*Note, error)
	// Returns the requested `Note`.
	GetNote(context.Context, *GetNoteRequest) (*Note, error)
	// Lists all `Notes` for a given project.
	ListNotes(context.Context, *ListNotesRequest) (*ListNotesResponse, error)
	// Deletes the given `Note` from the system.
	DeleteNote(context.Context, *DeleteNoteRequest) (*google_protobuf3.Empty, error)
	// Creates a new `Note`.
	CreateNote(context.Context, *CreateNoteRequest) (*Note, error)
	// Updates an existing `Note`.
	UpdateNote(context.Context, *UpdateNoteRequest) (*Note, error)
	// Lists `Occurrences` referencing the specified `Note`. Use this method to
	// get all occurrences referencing your `Note` across all your customer
	// projects.
	ListNoteOccurrences(context.Context, *ListNoteOccurrencesRequest) (*ListNoteOccurrencesResponse, error)
	// Gets a summary of the number and severity of occurrences.
	GetVulnzOccurrencesSummary(context.Context, *GetVulnzOccurrencesSummaryRequest) (*GetVulnzOccurrencesSummaryResponse, error)
	// Sets the access control policy on the specified `Note` or `Occurrence`.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a `Note` or an `Occurrence`, respectively.
	// Attempting to call this method without these permissions will result in a `
	// `PERMISSION_DENIED` error.
	// Attempting to call this method on a non-existent resource will result in a
	// `NOT_FOUND` error if the user has `containeranalysis.notes.list` permission
	// on a `Note` or `containeranalysis.occurrences.list` on an `Occurrence`, or
	// a `PERMISSION_DENIED` error otherwise. The resource takes the following
	// formats: `projects/{projectid}/occurrences/{occurrenceid}` for occurrences
	// and projects/{projectid}/notes/{noteid} for notes
	SetIamPolicy(context.Context, *google_iam_v11.SetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// Gets the access control policy for a note or an `Occurrence` resource.
	// Requires `containeranalysis.notes.setIamPolicy` or
	// `containeranalysis.occurrences.setIamPolicy` permission if the resource is
	// a note or occurrence, respectively.
	// Attempting to call this method on a resource without the required
	// permission will result in a `PERMISSION_DENIED` error. Attempting to call
	// this method on a non-existent resource will result in a `NOT_FOUND` error
	// if the user has list permission on the project, or a `PERMISSION_DENIED`
	// error otherwise. The resource takes the following formats:
	// `projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for occurrences and
	// projects/{PROJECT_ID}/notes/{NOTE_ID} for notes
	GetIamPolicy(context.Context, *google_iam_v11.GetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// Returns the permissions that a caller has on the specified note or
	// occurrence resource. Requires list permission on the project (for example,
	// "storage.objects.list" on the containing bucket for testing permission of
	// an object). Attempting to call this method on a non-existent resource will
	// result in a `NOT_FOUND` error if the user has list permission on the
	// project, or a `PERMISSION_DENIED` error otherwise. The resource takes the
	// following formats: `projects/{PROJECT_ID}/occurrences/{OCCURRENCE_ID}` for
	// `Occurrences` and `projects/{PROJECT_ID}/notes/{NOTE_ID}` for `Notes`
	TestIamPermissions(context.Context, *google_iam_v11.TestIamPermissionsRequest) (*google_iam_v11.TestIamPermissionsResponse, error)
}

func RegisterContainerAnalysisServer(s *grpc.Server, srv ContainerAnalysisServer) {
	s.RegisterService(&_ContainerAnalysis_serviceDesc, srv)
}

func _ContainerAnalysis_GetOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).GetOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).GetOccurrence(ctx, req.(*GetOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_ListOccurrences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOccurrencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).ListOccurrences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListOccurrences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).ListOccurrences(ctx, req.(*ListOccurrencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_DeleteOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).DeleteOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/DeleteOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).DeleteOccurrence(ctx, req.(*DeleteOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_CreateOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).CreateOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/CreateOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).CreateOccurrence(ctx, req.(*CreateOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_UpdateOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).UpdateOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/UpdateOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).UpdateOccurrence(ctx, req.(*UpdateOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_GetOccurrenceNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOccurrenceNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).GetOccurrenceNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetOccurrenceNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).GetOccurrenceNote(ctx, req.(*GetOccurrenceNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_GetNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).GetNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).GetNote(ctx, req.(*GetNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_ListNotes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).ListNotes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListNotes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).ListNotes(ctx, req.(*ListNotesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_DeleteNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).DeleteNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/DeleteNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).DeleteNote(ctx, req.(*DeleteNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_CreateNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).CreateNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/CreateNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).CreateNote(ctx, req.(*CreateNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_UpdateNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).UpdateNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/UpdateNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).UpdateNote(ctx, req.(*UpdateNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_ListNoteOccurrences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNoteOccurrencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).ListNoteOccurrences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/ListNoteOccurrences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).ListNoteOccurrences(ctx, req.(*ListNoteOccurrencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_GetVulnzOccurrencesSummary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVulnzOccurrencesSummaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).GetVulnzOccurrencesSummary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetVulnzOccurrencesSummary",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).GetVulnzOccurrencesSummary(ctx, req.(*GetVulnzOccurrencesSummaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).SetIamPolicy(ctx, req.(*google_iam_v11.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).GetIamPolicy(ctx, req.(*google_iam_v11.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContainerAnalysis_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContainerAnalysisServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.containeranalysis.v1alpha1.ContainerAnalysis/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContainerAnalysisServer).TestIamPermissions(ctx, req.(*google_iam_v11.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ContainerAnalysis_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.containeranalysis.v1alpha1.ContainerAnalysis",
	HandlerType: (*ContainerAnalysisServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetOccurrence",
			Handler:    _ContainerAnalysis_GetOccurrence_Handler,
		},
		{
			MethodName: "ListOccurrences",
			Handler:    _ContainerAnalysis_ListOccurrences_Handler,
		},
		{
			MethodName: "DeleteOccurrence",
			Handler:    _ContainerAnalysis_DeleteOccurrence_Handler,
		},
		{
			MethodName: "CreateOccurrence",
			Handler:    _ContainerAnalysis_CreateOccurrence_Handler,
		},
		{
			MethodName: "UpdateOccurrence",
			Handler:    _ContainerAnalysis_UpdateOccurrence_Handler,
		},
		{
			MethodName: "GetOccurrenceNote",
			Handler:    _ContainerAnalysis_GetOccurrenceNote_Handler,
		},
		{
			MethodName: "GetNote",
			Handler:    _ContainerAnalysis_GetNote_Handler,
		},
		{
			MethodName: "ListNotes",
			Handler:    _ContainerAnalysis_ListNotes_Handler,
		},
		{
			MethodName: "DeleteNote",
			Handler:    _ContainerAnalysis_DeleteNote_Handler,
		},
		{
			MethodName: "CreateNote",
			Handler:    _ContainerAnalysis_CreateNote_Handler,
		},
		{
			MethodName: "UpdateNote",
			Handler:    _ContainerAnalysis_UpdateNote_Handler,
		},
		{
			MethodName: "ListNoteOccurrences",
			Handler:    _ContainerAnalysis_ListNoteOccurrences_Handler,
		},
		{
			MethodName: "GetVulnzOccurrencesSummary",
			Handler:    _ContainerAnalysis_GetVulnzOccurrencesSummary_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _ContainerAnalysis_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _ContainerAnalysis_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _ContainerAnalysis_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/containeranalysis/v1alpha1/containeranalysis.proto",
}

func init() {
	proto.RegisterFile("google/devtools/containeranalysis/v1alpha1/containeranalysis.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 2432 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xdd, 0x6f, 0x23, 0x57,
	0x15, 0xdf, 0x89, 0x93, 0x38, 0x3e, 0xce, 0x87, 0x7d, 0xbb, 0xdb, 0xb8, 0x6e, 0x0b, 0xe9, 0x94,
	0xd2, 0x6d, 0x16, 0x6c, 0x12, 0xba, 0x14, 0x92, 0xae, 0xb6, 0xfe, 0x8a, 0xd7, 0xe4, 0xcb, 0x1a,
	0x27, 0xd1, 0x6e, 0x5b, 0x3a, 0xba, 0xf6, 0xdc, 0xb8, 0x83, 0xc7, 0x33, 0xc3, 0xcc, 0xd8, 0xaa,
	0x17, 0xf5, 0x05, 0x90, 0x50, 0x11, 0x5f, 0x02, 0x09, 0x21, 0x21, 0x40, 0xaa, 0x10, 0x12, 0xf0,
	0x52, 0x21, 0xf1, 0xc6, 0x13, 0xe2, 0x15, 0x5e, 0x78, 0x46, 0x7d, 0xe1, 0x81, 0x37, 0xfe, 0x05,
	0x74, 0xef, 0xdc, 0x6b, 0x8f, 0x3f, 0x92, 0x78, 0xe2, 0xad, 0xd4, 0xa7, 0x9d, 0x7b, 0xee, 0xb9,
	0xbf, 0x73, 0xee, 0x99, 0xf3, 0xf1, 0x9b, 0xac, 0x21, 0xdf, 0xb4, 0xac, 0xa6, 0x41, 0xb2, 0x1a,
	0xe9, 0x7a, 0x96, 0x65, 0xb8, 0xd9, 0x86, 0x65, 0x7a, 0x58, 0x37, 0x89, 0x83, 0x4d, 0x6c, 0xf4,
	0x5c, 0xdd, 0xcd, 0x76, 0xb7, 0xb0, 0x61, 0xbf, 0x8b, 0xb7, 0xc6, 0xb7, 0x32, 0xb6, 0x63, 0x79,
	0x16, 0xda, 0xf4, 0x31, 0x32, 0x02, 0x23, 0x33, 0xae, 0x28, 0x30, 0xd2, 0xcf, 0x71, 0x7b, 0xd8,
	0xd6, 0xb3, 0xd8, 0x34, 0x2d, 0x0f, 0x7b, 0xba, 0x65, 0x72, 0xa4, 0x74, 0x18, 0x6f, 0xea, 0xba,
	0x61, 0xa8, 0xd6, 0xb9, 0xda, 0xc6, 0x1e, 0x71, 0x74, 0x6c, 0x08, 0x8c, 0xd7, 0x43, 0x60, 0xe8,
	0x6d, 0xdc, 0x24, 0x6a, 0x1d, 0xf7, 0xef, 0x92, 0xde, 0x0b, 0x71, 0xda, 0xc6, 0x8d, 0x16, 0x3d,
	0xdf, 0xed, 0x18, 0x74, 0xbf, 0xae, 0x1b, 0xba, 0xd7, 0xe3, 0x38, 0xbb, 0x61, 0x70, 0x1c, 0xab,
	0x4b, 0x4c, 0x6c, 0x36, 0x08, 0x3f, 0xfc, 0x19, 0x7e, 0x58, 0xc7, 0xed, 0x6c, 0x77, 0x8b, 0xfe,
	0xa3, 0xda, 0x96, 0xa1, 0x37, 0x04, 0x78, 0x7a, 0x78, 0x7f, 0x68, 0xef, 0x45, 0xbe, 0x67, 0x58,
	0x66, 0xd3, 0xe9, 0x98, 0xa6, 0x6e, 0x36, 0xb3, 0x96, 0x4d, 0x9c, 0xa1, 0x38, 0x3f, 0xc3, 0x95,
	0xd8, 0xaa, 0xde, 0x39, 0xcf, 0x62, 0x53, 0x9c, 0x7f, 0x76, 0x74, 0x8b, 0xb4, 0xed, 0xfe, 0xad,
	0x36, 0x46, 0x37, 0xcf, 0x75, 0x62, 0x68, 0x6a, 0x1b, 0xbb, 0x2d, 0xae, 0xf1, 0xd9, 0x51, 0x0d,
	0x4f, 0x6f, 0x13, 0xd7, 0xc3, 0x6d, 0xdb, 0x57, 0x90, 0x3f, 0x8e, 0x02, 0x1c, 0x37, 0x1a, 0x1d,
	0xc7, 0x21, 0x66, 0x83, 0x20, 0x04, 0xf3, 0x26, 0x6e, 0x93, 0x94, 0xb4, 0x21, 0xdd, 0x8e, 0x29,
	0xec, 0x19, 0xbd, 0x00, 0xcb, 0x0e, 0x71, 0xad, 0x8e, 0xd3, 0x20, 0x6a, 0xc7, 0x31, 0x52, 0x73,
	0x6c, 0x2f, 0x2e, 0x64, 0xa7, 0x8e, 0x81, 0x9e, 0x85, 0x98, 0x69, 0x79, 0x44, 0x65, 0x67, 0x23,
	0x6c, 0x7f, 0x89, 0x0a, 0x8e, 0xe8, 0xf9, 0x0a, 0xcc, 0xb7, 0x74, 0x53, 0x4b, 0x2d, 0x6e, 0x48,
	0xb7, 0x57, 0xb7, 0xef, 0x66, 0xa6, 0x4f, 0xcf, 0xcc, 0x91, 0xe5, 0x91, 0xcc, 0xbe, 0x6e, 0x6a,
	0x0a, 0x83, 0x40, 0x1f, 0x48, 0x70, 0x6b, 0xe8, 0xf5, 0xaa, 0x1a, 0xf1, 0xb0, 0x6e, 0xb8, 0xa9,
	0xa5, 0x0d, 0xe9, 0x76, 0x7c, 0x5b, 0x09, 0x03, 0x7e, 0x16, 0x04, 0x3a, 0xe9, 0xd9, 0x64, 0x58,
	0x52, 0xf4, 0x91, 0x1f, 0xdc, 0x50, 0x6e, 0x76, 0x27, 0xc8, 0x91, 0x0a, 0x2b, 0xf5, 0x8e, 0x6e,
	0x68, 0x7d, 0x17, 0xa2, 0xcc, 0x85, 0xaf, 0x86, 0x71, 0x21, 0x4f, 0x01, 0x06, 0x86, 0x96, 0xeb,
	0x81, 0x35, 0x3a, 0x87, 0x15, 0x8d, 0x38, 0x7a, 0x97, 0x68, 0x2a, 0x2b, 0x8c, 0x54, 0x9c, 0x19,
	0xb8, 0x1f, 0xc6, 0x40, 0xd1, 0x6a, 0xb4, 0x88, 0x53, 0xa1, 0xc7, 0x33, 0x45, 0x1f, 0x8c, 0xda,
	0xe1, 0xb8, 0x4c, 0x8e, 0xda, 0xb0, 0xac, 0x9b, 0xae, 0x87, 0x0d, 0x83, 0x25, 0x65, 0x6a, 0x99,
	0x99, 0x29, 0x87, 0x31, 0x53, 0xf5, 0x4b, 0xef, 0x10, 0x9b, 0xb8, 0x49, 0x9c, 0x4c, 0x25, 0x00,
	0x47, 0xcd, 0x05, 0xe1, 0x51, 0x03, 0x40, 0x23, 0xb6, 0x61, 0xf5, 0xda, 0xc4, 0xf4, 0x52, 0xab,
	0xcc, 0x58, 0x2e, 0xd4, 0x9d, 0xd8, 0x69, 0x5c, 0x37, 0x08, 0x7f, 0xa4, 0x40, 0x0f, 0x6e, 0x28,
	0x01, 0x58, 0x54, 0x07, 0xd0, 0x74, 0xb7, 0x61, 0x75, 0x89, 0x43, 0xb4, 0xd4, 0x1a, 0x33, 0xf2,
	0x46, 0x28, 0x23, 0xfc, 0x74, 0xaf, 0xff, 0xc4, 0x22, 0x17, 0x40, 0x45, 0x1b, 0x10, 0x77, 0x48,
	0x9b, 0x68, 0xba, 0x1f, 0xb6, 0x05, 0x51, 0x16, 0x7d, 0x11, 0xda, 0x85, 0x78, 0xc3, 0x21, 0xd8,
	0x23, 0x2a, 0x2d, 0xbb, 0x54, 0x8c, 0xb9, 0x91, 0x16, 0x6e, 0x88, 0x9a, 0xcc, 0x9c, 0x88, 0x9a,
	0x54, 0xc0, 0x57, 0xa7, 0x02, 0x7a, 0xb8, 0x63, 0x6b, 0xfd, 0xc3, 0x70, 0xf5, 0x61, 0x5f, 0x9d,
	0x0a, 0xf2, 0x31, 0x88, 0xf2, 0xb4, 0x94, 0xff, 0x1b, 0x83, 0x79, 0x5a, 0x47, 0x13, 0x6b, 0xfb,
	0x0e, 0x24, 0xdd, 0x77, 0x2d, 0xc7, 0x53, 0x35, 0xe2, 0x36, 0x1c, 0xdd, 0x66, 0x37, 0xf1, 0x0b,
	0x38, 0xc1, 0x36, 0x8a, 0x03, 0x39, 0x7a, 0x05, 0x12, 0xb4, 0x8d, 0x0d, 0xe9, 0xce, 0x33, 0xdd,
	0x35, 0x2a, 0x0f, 0xaa, 0x8a, 0x9a, 0x8f, 0xcd, 0x5e, 0xf3, 0x26, 0xa0, 0xe1, 0x92, 0xf7, 0x7a,
	0x36, 0x61, 0xcd, 0x24, 0xbe, 0x7d, 0x6f, 0xa6, 0x7a, 0x7f, 0x70, 0x43, 0x49, 0x76, 0x47, 0x85,
	0xe8, 0x0c, 0xc0, 0xaf, 0x6b, 0x66, 0xc7, 0xef, 0x2b, 0x77, 0x43, 0x17, 0x35, 0xc7, 0x8f, 0xd5,
	0xc5, 0x02, 0xbd, 0x03, 0x50, 0xc7, 0x2e, 0xe1, 0xb5, 0xbc, 0x12, 0xde, 0xff, 0x60, 0x2d, 0xe7,
	0xe9, 0x8c, 0x64, 0xf8, 0xd8, 0x25, 0x7e, 0x19, 0xbf, 0x03, 0x51, 0x3e, 0x01, 0x79, 0x51, 0xe5,
	0x67, 0xa8, 0x60, 0xbe, 0x7c, 0x70, 0x43, 0x11, 0xa0, 0xe8, 0xa1, 0xa8, 0x5b, 0x5a, 0x79, 0xa9,
	0x24, 0x33, 0xf1, 0x95, 0xeb, 0xd5, 0xed, 0xa0, 0x58, 0xe9, 0x0a, 0x9d, 0x42, 0x4c, 0x94, 0x55,
	0x2f, 0x85, 0xc2, 0x07, 0xbc, 0x5f, 0xab, 0x34, 0x20, 0x7d, 0x24, 0xf4, 0x36, 0xad, 0x4f, 0x03,
	0x7b, 0x44, 0x63, 0x63, 0x2b, 0xba, 0x11, 0xb9, 0x1d, 0xdf, 0xde, 0x0d, 0x9d, 0x8a, 0x8a, 0x8f,
	0x71, 0xea, 0x18, 0x0a, 0x38, 0xfd, 0x67, 0x54, 0x80, 0x35, 0xf2, 0x9e, 0xad, 0xfb, 0x83, 0x7c,
	0xda, 0x12, 0x5d, 0x1d, 0x1c, 0x11, 0x35, 0x1e, 0x6c, 0x10, 0xf1, 0x59, 0x1a, 0xc4, 0x72, 0x98,
	0x06, 0x91, 0x7e, 0x15, 0x60, 0x70, 0x31, 0x94, 0x80, 0x08, 0x0d, 0x91, 0xdf, 0x19, 0xe8, 0x23,
	0xba, 0x09, 0x0b, 0x06, 0xae, 0x13, 0x31, 0xed, 0xfd, 0x85, 0xfc, 0x13, 0x09, 0xe6, 0x69, 0x69,
	0xa2, 0x9b, 0x90, 0xd8, 0xaf, 0x1c, 0x15, 0xd5, 0xd3, 0xa3, 0x5a, 0xb5, 0x54, 0xa8, 0xec, 0x55,
	0x4a, 0xc5, 0xc4, 0x0d, 0xf4, 0x0c, 0xdc, 0xaa, 0xe6, 0x0a, 0xfb, 0xb9, 0x72, 0x49, 0x3d, 0x3b,
	0x3d, 0x38, 0x2a, 0x29, 0xb9, 0x7c, 0xe5, 0xa0, 0x72, 0xf2, 0x28, 0x31, 0x87, 0x92, 0xb0, 0x92,
	0x3f, 0xad, 0x1c, 0x14, 0xd5, 0x62, 0xe9, 0x24, 0x57, 0x39, 0xa8, 0x25, 0x22, 0x68, 0x0d, 0xe2,
	0x95, 0x43, 0xaa, 0x9b, 0xcf, 0xd5, 0x2a, 0xb5, 0xc4, 0x3c, 0x7a, 0x0a, 0xd6, 0xc4, 0xf1, 0xc3,
	0xdc, 0x51, 0xae, 0x5c, 0x52, 0x12, 0x0b, 0x68, 0x15, 0xa0, 0x58, 0xaa, 0x1e, 0x1c, 0x3f, 0xca,
	0xe5, 0x0f, 0x4a, 0x89, 0x45, 0xb4, 0x02, 0xb1, 0x62, 0xa5, 0x56, 0x38, 0x3e, 0x2b, 0x29, 0x8f,
	0x12, 0xd1, 0x7c, 0x9c, 0x33, 0x0f, 0x5a, 0xac, 0xf2, 0xbf, 0x23, 0x00, 0x83, 0x2c, 0x1b, 0x21,
	0x2e, 0x7a, 0x4a, 0xda, 0x88, 0x0c, 0x13, 0x17, 0x3d, 0xfd, 0xa7, 0xfe, 0x09, 0x36, 0x36, 0x9e,
	0x07, 0xe8, 0xb8, 0xc4, 0x51, 0x49, 0x1b, 0xeb, 0x22, 0x1c, 0x31, 0x2a, 0x29, 0x51, 0x01, 0x8d,
	0xb8, 0x9f, 0xb6, 0x7e, 0xc4, 0xe7, 0xae, 0x8e, 0xb8, 0xaf, 0xce, 0x5e, 0xd7, 0x7d, 0x58, 0xe9,
	0x98, 0xc1, 0xe3, 0x91, 0x2b, 0x8f, 0x2f, 0x8b, 0x03, 0x0c, 0xe0, 0x69, 0x58, 0x6c, 0x58, 0xe6,
	0xb9, 0xde, 0x64, 0x4d, 0x29, 0xa6, 0xf0, 0x15, 0x4a, 0x41, 0x14, 0x6b, 0x9a, 0x43, 0x5c, 0x97,
	0xcf, 0x20, 0xb1, 0x1c, 0x0b, 0xc0, 0xe2, 0x58, 0x00, 0xd0, 0x39, 0x2c, 0xd9, 0x06, 0xf6, 0xce,
	0x2d, 0xa7, 0xcd, 0x08, 0xcc, 0xea, 0xf6, 0xd7, 0x67, 0x9e, 0xc5, 0x99, 0x2a, 0x47, 0x54, 0xfa,
	0xd8, 0x72, 0x01, 0x96, 0x84, 0x14, 0xa5, 0xe0, 0x66, 0xf5, 0x20, 0x77, 0xb2, 0x77, 0xac, 0x1c,
	0x8e, 0x24, 0x50, 0x14, 0x22, 0xe5, 0xfd, 0x52, 0x42, 0x42, 0x4b, 0x30, 0xbf, 0x77, 0x50, 0x7a,
	0x98, 0x98, 0x43, 0x00, 0x8b, 0x85, 0xd3, 0xda, 0xc9, 0xf1, 0x61, 0x22, 0x22, 0xff, 0x59, 0x82,
	0x58, 0xbf, 0xd8, 0xd1, 0x9b, 0xb0, 0x22, 0x1c, 0x52, 0xd9, 0xb0, 0x91, 0x66, 0x19, 0x36, 0xcb,
	0x62, 0x93, 0xae, 0xd2, 0x15, 0x80, 0xc1, 0xdc, 0x47, 0xbb, 0x10, 0xeb, 0x73, 0x76, 0x66, 0x25,
	0xbe, 0xfd, 0xbc, 0xb0, 0x12, 0x20, 0xf6, 0x99, 0x63, 0xa1, 0xa4, 0x0c, 0xf4, 0xe5, 0x1f, 0x4b,
	0x10, 0xeb, 0x8f, 0x04, 0xf4, 0x32, 0xac, 0xb1, 0x91, 0x40, 0x1c, 0xb5, 0x4b, 0x1c, 0x57, 0x00,
	0xc6, 0x94, 0x55, 0x2e, 0x3e, 0xf3, 0xa5, 0xe8, 0x21, 0xc4, 0x5c, 0xbd, 0x69, 0x62, 0xaf, 0xe3,
	0x88, 0x4c, 0xdb, 0x09, 0x3d, 0x85, 0x6a, 0x02, 0x41, 0x19, 0x80, 0xc9, 0x3f, 0x9a, 0x83, 0xd5,
	0xe1, 0x5d, 0x9a, 0xf7, 0x76, 0xa7, 0x6e, 0xe8, 0x0d, 0xb5, 0x45, 0x7a, 0x22, 0xef, 0x7d, 0xc9,
	0x3e, 0xe9, 0xa1, 0xe7, 0x46, 0x7d, 0x89, 0x05, 0xf0, 0xd0, 0x2d, 0x58, 0x6c, 0x91, 0x9e, 0xaa,
	0x6b, 0x9c, 0x38, 0x2c, 0xb4, 0x48, 0xaf, 0xa2, 0xa1, 0x6f, 0xc0, 0x12, 0x15, 0xb3, 0x29, 0x3a,
	0xcf, 0xde, 0x4c, 0xfe, 0xfa, 0xfe, 0x67, 0xf6, 0x09, 0x9b, 0xce, 0x4a, 0xb4, 0xe5, 0x3f, 0xc8,
	0x0f, 0x20, 0xca, 0x65, 0x34, 0x9f, 0xf6, 0x4b, 0x8f, 0xd4, 0x93, 0x47, 0xd5, 0xd2, 0x48, 0x3e,
	0xdd, 0x82, 0x64, 0xb5, 0x5c, 0x55, 0x73, 0xb5, 0x42, 0xa5, 0xa2, 0xe6, 0x94, 0xc3, 0x63, 0xa5,
	0x54, 0x4c, 0x48, 0x68, 0x19, 0x96, 0xaa, 0xfb, 0x95, 0x87, 0x6a, 0xb5, 0x74, 0x98, 0x98, 0x93,
	0x7f, 0x21, 0xc1, 0x72, 0x90, 0x88, 0xa3, 0xb7, 0x00, 0x06, 0xdf, 0x80, 0xfc, 0x7d, 0xef, 0x86,
	0xf6, 0xbd, 0xda, 0x87, 0x50, 0x02, 0x70, 0x94, 0x44, 0x0d, 0x56, 0x6a, 0xbd, 0xe7, 0x11, 0x97,
	0x87, 0x74, 0x6d, 0x20, 0xcf, 0x53, 0xb1, 0xbc, 0x09, 0x37, 0xcb, 0xc4, 0x1b, 0x7c, 0x9d, 0x29,
	0xe4, 0x5b, 0x1d, 0xe2, 0x7a, 0x93, 0x88, 0x9c, 0xfc, 0x4b, 0x09, 0x9e, 0x3e, 0xd0, 0xdd, 0x80,
	0xb6, 0x7b, 0x89, 0x3a, 0xed, 0x25, 0x36, 0x76, 0x28, 0x01, 0xf7, 0x5b, 0x06, 0x5f, 0x51, 0xf9,
	0xb9, 0x6e, 0x78, 0xc4, 0xe1, 0x3e, 0xf1, 0x15, 0xfd, 0xc0, 0xb3, 0xe9, 0xb7, 0xb5, 0xab, 0x3f,
	0xf6, 0x1b, 0xd7, 0x82, 0xb2, 0x44, 0x05, 0x35, 0xfd, 0xb1, 0x9f, 0x3d, 0x74, 0xd3, 0xb3, 0x5a,
	0x44, 0x30, 0x42, 0xa6, 0x7e, 0x42, 0x05, 0xf2, 0xaf, 0x24, 0x58, 0x1f, 0x73, 0xcd, 0xb5, 0x2d,
	0xd3, 0xa5, 0xa4, 0x22, 0x6e, 0x0d, 0xc4, 0xac, 0x43, 0x87, 0x64, 0x15, 0x81, 0xf0, 0x04, 0xa1,
	0xd0, 0xe7, 0x61, 0xcd, 0x24, 0xef, 0x79, 0x6a, 0xc0, 0x33, 0xff, 0x4a, 0x2b, 0x54, 0x5c, 0xed,
	0x7b, 0xf7, 0x45, 0x58, 0x2f, 0x12, 0x83, 0x78, 0x64, 0xba, 0x38, 0xff, 0x5a, 0x82, 0xf5, 0x02,
	0x9b, 0xc1, 0x53, 0xe9, 0x07, 0x02, 0x1d, 0x19, 0x0a, 0xf4, 0x19, 0xc0, 0xc0, 0x5b, 0x5e, 0xdf,
	0xd7, 0xbd, 0x77, 0x00, 0x49, 0xfe, 0x9b, 0x04, 0xeb, 0xa7, 0x6c, 0xcc, 0x4f, 0xe7, 0xdf, 0x27,
	0xe4, 0x47, 0x80, 0x9c, 0xb4, 0xb1, 0xdb, 0xba, 0x70, 0xd6, 0xed, 0xe9, 0xc4, 0xd0, 0x0e, 0xb1,
	0xdb, 0x12, 0xe4, 0x84, 0x3e, 0xcb, 0x9f, 0x83, 0xd5, 0x32, 0xf1, 0x68, 0x6f, 0xbe, 0xec, 0x55,
	0x64, 0x20, 0x35, 0x54, 0x1e, 0x57, 0xe9, 0xff, 0x4c, 0x82, 0x04, 0xcd, 0x43, 0xaa, 0xf7, 0xa9,
	0x29, 0x8e, 0xef, 0x4a, 0x90, 0x0c, 0x38, 0xc5, 0xcb, 0x62, 0x0f, 0x16, 0x28, 0xab, 0x11, 0x05,
	0xf1, 0xa5, 0xb0, 0x23, 0x4d, 0xf1, 0x8f, 0x4f, 0x5d, 0x04, 0x2f, 0x43, 0xd2, 0x2f, 0x82, 0xab,
	0x62, 0xf8, 0x1b, 0x09, 0x92, 0x7e, 0xfa, 0x5f, 0xa1, 0x19, 0x08, 0xe2, 0xfc, 0x50, 0x10, 0xd7,
	0x21, 0xca, 0x08, 0x9b, 0xae, 0x89, 0x28, 0xd2, 0x65, 0x45, 0x43, 0x45, 0x98, 0xa7, 0x4f, 0x3c,
	0x55, 0xc2, 0x5f, 0x99, 0x9d, 0x96, 0xff, 0x28, 0x41, 0xd2, 0xcf, 0xff, 0xab, 0x1c, 0x14, 0xf6,
	0xe6, 0x66, 0xb1, 0x37, 0x5b, 0x9e, 0x7f, 0x4f, 0x82, 0xb4, 0x78, 0xf9, 0xd3, 0x37, 0xee, 0x27,
	0x9e, 0x83, 0xbf, 0x95, 0xe0, 0xd9, 0x89, 0x6e, 0x7c, 0x6a, 0x9a, 0xf4, 0xf7, 0x25, 0x48, 0xf6,
	0xc9, 0xd5, 0x21, 0xf1, 0xb0, 0x86, 0x3d, 0x3c, 0xfa, 0xf5, 0x24, 0x85, 0xfa, 0x7a, 0xba, 0x0b,
	0x4b, 0xc4, 0xd4, 0xa6, 0x25, 0xf2, 0x51, 0x62, 0x6a, 0x74, 0x25, 0xd7, 0xe0, 0x85, 0x32, 0xf1,
	0xce, 0x3a, 0x86, 0xf9, 0x38, 0x10, 0xaa, 0x5a, 0xa7, 0xdd, 0xc6, 0x4e, 0x4f, 0xbc, 0xb8, 0x41,
	0xee, 0x4b, 0xd3, 0x34, 0x10, 0xf9, 0xf7, 0x73, 0x20, 0x5f, 0x86, 0xca, 0xdf, 0x83, 0x47, 0x3f,
	0x00, 0x3a, 0xa6, 0x27, 0x5e, 0xc1, 0xdb, 0x61, 0x5e, 0xc1, 0xd5, 0xf8, 0x99, 0x1a, 0xe9, 0x12,
	0x47, 0xf7, 0x7a, 0x05, 0x6a, 0x44, 0xe1, 0xb6, 0xd2, 0x1f, 0x48, 0xb0, 0x32, 0xb4, 0x83, 0xea,
	0xb0, 0xe4, 0x72, 0x01, 0xe7, 0xdc, 0x7b, 0xb3, 0xfd, 0xdd, 0x55, 0xc0, 0x2b, 0x7d, 0x5c, 0xfa,
	0xfd, 0xc9, 0xec, 0xb3, 0x48, 0x45, 0x14, 0x7f, 0xb1, 0xfd, 0x87, 0x75, 0x48, 0x16, 0x04, 0x72,
	0x8e, 0x23, 0xa3, 0xbf, 0x4a, 0xb0, 0x32, 0x34, 0x09, 0xd0, 0x1b, 0x21, 0x23, 0x33, 0x36, 0x2b,
	0xd3, 0xd7, 0x4c, 0x6f, 0x79, 0xeb, 0x3b, 0xff, 0xfa, 0xcf, 0xcf, 0xe7, 0xee, 0xa0, 0x57, 0x06,
	0xff, 0x9f, 0xf0, 0x6d, 0x5a, 0xb8, 0xf7, 0x6c, 0xc7, 0xfa, 0x26, 0x69, 0x78, 0x6e, 0x76, 0x33,
	0x1b, 0xa8, 0x80, 0xec, 0xe6, 0xfb, 0xe8, 0x1f, 0x12, 0xac, 0x8d, 0xf0, 0x23, 0x14, 0x8a, 0x2a,
	0x4f, 0xe6, 0x7d, 0xe9, 0xc2, 0x4c, 0x18, 0x7e, 0x4e, 0x4c, 0xbc, 0x8f, 0x9f, 0xcd, 0x81, 0x1b,
	0xbd, 0x1f, 0xbc, 0x12, 0xfa, 0x50, 0x82, 0xc4, 0x28, 0xa5, 0x42, 0x85, 0x70, 0x5f, 0x95, 0x13,
	0x09, 0x59, 0xfa, 0xe9, 0xb1, 0x0a, 0x2d, 0xb5, 0x6d, 0xaf, 0x27, 0x9c, 0xdc, 0x0c, 0x11, 0xf4,
	0x7f, 0x4a, 0x90, 0x18, 0xe5, 0x71, 0xe1, 0x9c, 0xbc, 0x80, 0x05, 0x5e, 0x3b, 0x73, 0xee, 0xb1,
	0x4b, 0xbc, 0x26, 0x4f, 0x1f, 0xe9, 0x9d, 0x20, 0xe1, 0xa2, 0x17, 0x1a, 0x25, 0x7e, 0xe1, 0x2e,
	0x74, 0x01, 0x6d, 0x9c, 0xf5, 0x42, 0xdb, 0xd3, 0xbf, 0x95, 0xa1, 0x0b, 0xfd, 0x5d, 0x82, 0xe4,
	0x18, 0xbf, 0x43, 0xc5, 0x6b, 0x57, 0x76, 0x80, 0x0f, 0xa4, 0x43, 0x4f, 0x7b, 0xf9, 0x35, 0x76,
	0x99, 0x2d, 0x94, 0x9d, 0xfa, 0x32, 0x59, 0x9f, 0x82, 0xfd, 0x4e, 0x82, 0x28, 0x27, 0xb3, 0x68,
	0x27, 0xa4, 0xf3, 0xb3, 0xb9, 0x7c, 0x87, 0xb9, 0xfc, 0x12, 0x7a, 0xf1, 0x12, 0x97, 0x99, 0x8f,
	0xb4, 0x1e, 0xfe, 0x22, 0x41, 0xac, 0xcf, 0x43, 0xd1, 0xeb, 0x61, 0x5b, 0x47, 0x90, 0x53, 0xa7,
	0xef, 0x5d, 0xf3, 0x34, 0x6f, 0x39, 0x93, 0xfc, 0x9e, 0x50, 0x08, 0x7e, 0x78, 0x7f, 0x2a, 0x01,
	0x0c, 0xa8, 0x2b, 0xba, 0x17, 0xbe, 0xcd, 0x04, 0x83, 0x7c, 0x51, 0x83, 0xe1, 0x2e, 0x6d, 0x4e,
	0x15, 0xca, 0x8f, 0x24, 0x80, 0x01, 0x47, 0x0e, 0xe7, 0xd2, 0x18, 0xb7, 0xbe, 0xc6, 0x7b, 0xe7,
	0xdd, 0x50, 0x9e, 0x26, 0x7e, 0x3b, 0x3e, 0x8b, 0xa5, 0x2e, 0x0f, 0x58, 0x73, 0x38, 0x97, 0xc7,
	0xd8, 0xf6, 0xf5, 0x5d, 0xde, 0x9e, 0x26, 0xbe, 0xdc, 0xe5, 0x8f, 0x25, 0x78, 0x6a, 0x02, 0x69,
	0x45, 0x7b, 0xd7, 0x49, 0xbe, 0x09, 0xd3, 0xb3, 0x3c, 0x33, 0x0e, 0x4f, 0xe7, 0x69, 0x3a, 0x87,
	0xb8, 0xdb, 0xd0, 0x1c, 0xfd, 0x9f, 0x04, 0xe9, 0x8b, 0x59, 0x1b, 0x3a, 0x7c, 0x52, 0xec, 0xcf,
	0xbf, 0xef, 0xd1, 0x93, 0x25, 0x93, 0xf2, 0x36, 0xbb, 0xf6, 0x17, 0xd0, 0xe6, 0xe5, 0x59, 0xd8,
	0xa5, 0x30, 0x2e, 0xbf, 0xd2, 0x0f, 0x24, 0x58, 0xae, 0x11, 0xaf, 0x82, 0xdb, 0x55, 0xf6, 0x1b,
	0x0a, 0x24, 0x0b, 0xa7, 0x74, 0xdc, 0xce, 0x74, 0xb7, 0x32, 0xc1, 0x4d, 0xe1, 0xf8, 0xad, 0x11,
	0x1d, 0x7f, 0x57, 0xbe, 0xcf, 0xec, 0x7f, 0x4d, 0x7e, 0x35, 0x60, 0x5f, 0xfc, 0xe1, 0x7b, 0x62,
	0x5a, 0xb9, 0x01, 0xec, 0x1d, 0x69, 0x93, 0x39, 0x53, 0xbe, 0xcc, 0x99, 0xf2, 0x27, 0xe8, 0x4c,
	0x73, 0xc4, 0x99, 0x8f, 0x24, 0x40, 0x27, 0xc4, 0x65, 0x42, 0xe2, 0xb4, 0x75, 0xd7, 0xd5, 0x2d,
	0xd3, 0x45, 0xb7, 0x47, 0xcc, 0x8d, 0xab, 0x08, 0xc7, 0x5e, 0x99, 0x42, 0x93, 0xbf, 0xb9, 0x12,
	0x73, 0xf6, 0xbe, 0xbc, 0x33, 0xad, 0xb3, 0xde, 0x18, 0xd6, 0x8e, 0xb4, 0x99, 0xff, 0xa1, 0x04,
	0x2f, 0x35, 0xac, 0xb6, 0xb0, 0x7b, 0x71, 0x36, 0x55, 0xa5, 0x37, 0xdf, 0xe2, 0x4a, 0x4d, 0xcb,
	0xc0, 0x66, 0x33, 0x63, 0x39, 0xcd, 0x6c, 0x93, 0x98, 0xac, 0x09, 0x67, 0xfd, 0x2d, 0x6c, 0xeb,
	0xee, 0x34, 0xbf, 0xde, 0xd9, 0x1d, 0xdb, 0xfa, 0x70, 0x2e, 0x52, 0x2e, 0xe4, 0xea, 0x8b, 0x0c,
	0xed, 0xcb, 0xff, 0x0f, 0x00, 0x00, 0xff, 0xff, 0x50, 0x37, 0x6f, 0x01, 0x62, 0x25, 0x00, 0x00,
}
