/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(0)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/* BINDTOOL_HEADER_FILE(mpsk_snr_est.h)                                        */
/* BINDTOOL_HEADER_FILE_HASH(d9ecc2af2d83ec2254bc299411d36403)                     */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/digital/mpsk_snr_est.h>
// pydoc.h is automatically generated in the build directory
#include <mpsk_snr_est_pydoc.h>

void bind_mpsk_snr_est(py::module& m)
{

    using mpsk_snr_est = ::gr::digital::mpsk_snr_est;
    using mpsk_snr_est_simple = ::gr::digital::mpsk_snr_est_simple;
    using mpsk_snr_est_skew = ::gr::digital::mpsk_snr_est_skew;
    using mpsk_snr_est_m2m4 = ::gr::digital::mpsk_snr_est_m2m4;
    using snr_est_m2m4 = ::gr::digital::snr_est_m2m4;
    using mpsk_snr_est_svr = ::gr::digital::mpsk_snr_est_svr;


    py::class_<mpsk_snr_est, std::shared_ptr<mpsk_snr_est>>(
        m, "mpsk_snr_est", D(mpsk_snr_est))

        .def(py::init<double>(), py::arg("alpha"), D(mpsk_snr_est, mpsk_snr_est, 0))
        .def(py::init<gr::digital::mpsk_snr_est const&>(),
             py::arg("arg0"),
             D(mpsk_snr_est, mpsk_snr_est, 1))


        .def("alpha", &mpsk_snr_est::alpha, D(mpsk_snr_est, alpha))


        .def("set_alpha",
             &mpsk_snr_est::set_alpha,
             py::arg("alpha"),
             D(mpsk_snr_est, set_alpha))


        .def("update",
             &mpsk_snr_est::update,
             py::arg("noutput_items"),
             py::arg("input"),
             D(mpsk_snr_est, update))


        .def("snr", &mpsk_snr_est::snr, D(mpsk_snr_est, snr))


        .def("signal", &mpsk_snr_est::signal, D(mpsk_snr_est, signal))


        .def("noise", &mpsk_snr_est::noise, D(mpsk_snr_est, noise))

        ;


    py::class_<mpsk_snr_est_simple,
               gr::digital::mpsk_snr_est,
               std::shared_ptr<mpsk_snr_est_simple>>(
        m, "mpsk_snr_est_simple", D(mpsk_snr_est_simple))

        .def(py::init<double>(),
             py::arg("alpha"),
             D(mpsk_snr_est_simple, mpsk_snr_est_simple, 0))
        .def(py::init<gr::digital::mpsk_snr_est_simple const&>(),
             py::arg("arg0"),
             D(mpsk_snr_est_simple, mpsk_snr_est_simple, 1))


        .def("update",
             &mpsk_snr_est_simple::update,
             py::arg("noutput_items"),
             py::arg("input"),
             D(mpsk_snr_est_simple, update))


        .def("snr", &mpsk_snr_est_simple::snr, D(mpsk_snr_est_simple, snr))

        ;


    py::class_<mpsk_snr_est_skew,
               gr::digital::mpsk_snr_est,
               std::shared_ptr<mpsk_snr_est_skew>>(
        m, "mpsk_snr_est_skew", D(mpsk_snr_est_skew))

        .def(py::init<double>(),
             py::arg("alpha"),
             D(mpsk_snr_est_skew, mpsk_snr_est_skew, 0))
        .def(py::init<gr::digital::mpsk_snr_est_skew const&>(),
             py::arg("arg0"),
             D(mpsk_snr_est_skew, mpsk_snr_est_skew, 1))


        .def("update",
             &mpsk_snr_est_skew::update,
             py::arg("noutput_items"),
             py::arg("input"),
             D(mpsk_snr_est_skew, update))


        .def("snr", &mpsk_snr_est_skew::snr, D(mpsk_snr_est_skew, snr))

        ;


    py::class_<mpsk_snr_est_m2m4,
               gr::digital::mpsk_snr_est,
               std::shared_ptr<mpsk_snr_est_m2m4>>(
        m, "mpsk_snr_est_m2m4", D(mpsk_snr_est_m2m4))

        .def(py::init<double>(),
             py::arg("alpha"),
             D(mpsk_snr_est_m2m4, mpsk_snr_est_m2m4, 0))
        .def(py::init<gr::digital::mpsk_snr_est_m2m4 const&>(),
             py::arg("arg0"),
             D(mpsk_snr_est_m2m4, mpsk_snr_est_m2m4, 1))


        .def("update",
             &mpsk_snr_est_m2m4::update,
             py::arg("noutput_items"),
             py::arg("input"),
             D(mpsk_snr_est_m2m4, update))


        .def("snr", &mpsk_snr_est_m2m4::snr, D(mpsk_snr_est_m2m4, snr))

        ;


    py::class_<snr_est_m2m4, gr::digital::mpsk_snr_est, std::shared_ptr<snr_est_m2m4>>(
        m, "snr_est_m2m4", D(snr_est_m2m4))

        .def(py::init<double, double, double>(),
             py::arg("alpha"),
             py::arg("ka"),
             py::arg("kw"),
             D(snr_est_m2m4, snr_est_m2m4, 0))
        .def(py::init<gr::digital::snr_est_m2m4 const&>(),
             py::arg("arg0"),
             D(snr_est_m2m4, snr_est_m2m4, 1))


        .def("update",
             &snr_est_m2m4::update,
             py::arg("noutput_items"),
             py::arg("input"),
             D(snr_est_m2m4, update))


        .def("snr", &snr_est_m2m4::snr, D(snr_est_m2m4, snr))

        ;


    py::class_<mpsk_snr_est_svr,
               gr::digital::mpsk_snr_est,
               std::shared_ptr<mpsk_snr_est_svr>>(
        m, "mpsk_snr_est_svr", D(mpsk_snr_est_svr))

        .def(py::init<double>(),
             py::arg("alpha"),
             D(mpsk_snr_est_svr, mpsk_snr_est_svr, 0))
        .def(py::init<gr::digital::mpsk_snr_est_svr const&>(),
             py::arg("arg0"),
             D(mpsk_snr_est_svr, mpsk_snr_est_svr, 1))


        .def("update",
             &mpsk_snr_est_svr::update,
             py::arg("noutput_items"),
             py::arg("input"),
             D(mpsk_snr_est_svr, update))


        .def("snr", &mpsk_snr_est_svr::snr, D(mpsk_snr_est_svr, snr))

        ;

    py::enum_<::gr::digital::snr_est_type_t>(m, "snr_est_type_t")
        .value("SNR_EST_SIMPLE", ::gr::digital::SNR_EST_SIMPLE) // 0
        .value("SNR_EST_SKEW", ::gr::digital::SNR_EST_SKEW)     // 1
        .value("SNR_EST_M2M4", ::gr::digital::SNR_EST_M2M4)     // 2
        .value("SNR_EST_SVR", ::gr::digital::SNR_EST_SVR)       // 3
        .export_values();

    py::implicitly_convertible<int, ::gr::digital::snr_est_type_t>();
}
