/*  GnomeKiss - A KiSS viewer for the GNOME desktop
    Copyright (C) 2000-2002  Nick Lamb <njl195@zepler.org.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <ctype.h>

#include <gnome.h>
#include "kiss.h"

static GSList *variables;

static KissVariable *var_new(gchar *name);

/* NB returns the value component only */

KissVariable *var_find(gchar *name) {
  GSList *list;
  KissVariable *current;

  for (list= variables; list != NULL; list= g_slist_next(list)) {
    current= (KissVariable *) list->data;
    if (!g_strcasecmp(current->name, name))
      return current;
  }

  return var_new(name);
}

void var_describe(KissVariable *var) {
  if (isdigit(var->name[0]) || var->name[0]=='-') {
    fprintf(stderr, "%d", var->value);
  } else {
    fprintf(stderr, "%s=%d", var->name, var->value);
  }
}

void reset_variables() {
  GSList *list;
  KissVariable *current;
  
  for (list= variables; list != NULL; list= g_slist_next(list)) {
    current= (KissVariable *) list->data;
    g_free(current->name);
    g_free(current);
  }
  g_slist_free(variables);
  variables= NULL;

}

static KissVariable *var_new(gchar *name) {
  KissVariable *var;

  var= g_new0(KissVariable, 1);
  var->name= g_strdup(name);

  /* Add to object and global display lists */
  variables = g_slist_prepend(variables, var);

  return var;
}
