#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gnome.h>

/* arbitrary limit */

#define PALETTES 100

/* Kiss/GS */

#define SETS 10
#define COLS 10

#define KISS_MFO 32767

/* event stack */

#define MAX_DEPTH 16

#define KISS_PENDING 0
#define KISS_DONE 1

extern GtkWidget *app, *area, *appbar, *pref_dialog, *error_clist;
extern GtkWidget *about, *error_list, *set_open, *config_open, *add_open;
extern GtkWidget *buttons[SETS], *items[SETS];

extern int mouse_x, mouse_y;

extern int view;
extern int global_lock; /* if KISS_PENDING, redraw will refresh rgb_buf */
extern guchar *global_start, *global_end;


typedef GSList *KissActionList;

typedef struct {
  KissActionList press;      /* fKiSS press("name.cel")    */
  KissActionList unfix;      /* fKiSS unfix("name.cel")    */
  KissActionList catch;      /* fKiSS catch("name.cel")    */
  KissActionList fixcatch;   /* fKiSS fixcatch("name.cel") */
  KissActionList drop;       /* fKiSS drop("name.cel")     */
  KissActionList fixdrop;    /* fKiSS fixdrop("name.cel")  */
  KissActionList release;    /* fKiSS release("name.cel")  */
} KissCellEvents;

typedef struct {
  int id;                    /* Object #id */
  GSList *cells;             /* KissCellRefs in this object */
  int x[SETS], y[SETS];      /* co-ordinatess */
  int ox[SETS], oy[SETS];    /* original co-ordinatess */
  int width, height;         /* Object size */
  int fix;                   /* +ve values indicate fixed */

  KissActionList press;      /* fKiSS press(#1)    */
  KissActionList unfix;      /* fKiSS unfix(#1)    */
  KissActionList catch;      /* fKiSS catch(#1)    */
  KissActionList fixcatch;   /* fKiSS fixcatch(#1) */
  KissActionList drop;       /* fKiSS drop(#1)     */
  KissActionList fixdrop;    /* fKiSS fixdrop(#1)  */
  KissActionList release;    /* fKiSS release(#1)  */

  GSList *cell_collisions;   /* fKiSS collide("name.cel","other.cel") etc. */
  GSList *obj_collisions;    /* fKiSS in(#1,#2) stillout(#1,#2) etc. */
} KissObject;
 
typedef struct {
  gchar *name;              /* Name of CEL file */
  guchar *index, *argb;      /* Image buffers */

  guint width, height;       /* Image size */
  int offx, offy;            /* offset co-ordinatess */

  KissCellEvents *events;    /* fKiSS events */

  unsigned int mapped;       /* boolean map/ unmap -- share ? */
  int alpha;                 /* (signed) cell-level alpha -- share ? */

  /* Not shareable */

  KissObject *object;

  int x[SETS], y[SETS];      /* co-ords */
  unsigned int visible;      /* 1 << N FALSE if hidden */
  unsigned int ghosted;      /* positive is ghosted */
  unsigned int duplicate;    /* not set for first instance */
  unsigned int palette;      /* palette number */

} KissCell;

typedef enum {
  ACTION_FKISS_VER_1 = 100,
  ACTION_ALTMAP_CELL,
  ACTION_ALTMAP_OBJECT,
  ACTION_CHANGESET,
  ACTION_CHANGECOL,
  ACTION_DEBUG,
  ACTION_MAP_CELL,
  ACTION_MAP_OBJECT,
  ACTION_MOVE_OBJECT,
  ACTION_NOP,
  ACTION_QUIT,
  ACTION_RANDOMTIMER,
  ACTION_SHELL,
  ACTION_SOUND,
  ACTION_SOUND_CANCEL,
  ACTION_TIMER,
  ACTION_TRANSPARENT_CELL,
  ACTION_TRANSPARENT_OBJECT,
  ACTION_UNMAP_CELL,
  ACTION_UNMAP_OBJECT,
  ACTION_VIEWPORT,
  ACTION_WINDOW_SIZE,
/* FKiSS 2 */
  ACTION_FKISS_VER_2 = 200,
  ACTION_MOVE_BYX,
  ACTION_MOVE_BYY,
  ACTION_MOVE_TO,
  ACTION_MUSIC,
  ACTION_MUSIC_CANCEL,
  ACTION_NOTIFY,
/* FKiSS 2.1 */
  ACTION_FKISS_VER_2_1 = 300,
  ACTION_IF_FIXED,
  ACTION_IF_MAPPED,
  ACTION_IF_MOVED,
  ACTION_IF_NOT_FIXED,
  ACTION_IF_NOT_MAPPED,
  ACTION_IF_NOT_MOVED,
  ACTION_MOVE_RANDX,
  ACTION_MOVE_RANDY,
  ACTION_MOVE_TORAND,
  ACTION_SETFIX,
/* FKiSS 3.0 */
  ACTION_FKISS_VER_3 = 400,
  ACTION_VAR_LET,
  ACTION_VAR_ADD,
  ACTION_VAR_SUB,
  ACTION_VAR_MUL,
  ACTION_VAR_DIV,
  ACTION_VAR_MOD,
  ACTION_VAR_RANDOM,
  ACTION_VAR_OBJECT_X,
  ACTION_VAR_OBJECT_Y,
  ACTION_VAR_OBJECT_FIX,
  ACTION_VAR_CELL_MAPPED,
  ACTION_VAR_SET,
  ACTION_VAR_PAL,
  ACTION_VAR_MOUSE_X,
  ACTION_VAR_MOUSE_Y,
  ACTION_VAR_CATCH,
  ACTION_VAR_COLLIDE,
  ACTION_VAR_INSIDE,
  ACTION_VAR_CELL_TRANSPARENT,

/* Ghost has been redefined, a pref controlling this would be good */

  ACTION_GHOST_CELL,
  ACTION_GHOST_OBJECT,

/* Control structures */
  CONTROL = 500,
  CONTROL_EXIT_EVENT,
  CONTROL_GOTO,
  CONTROL_GOSUB,
  CONTROL_GOTO_RANDOM,
  CONTROL_GOSUB_RANDOM,

  CONTROL_CONDITIONAL = 600,
  CONTROL_EQUAL,
  CONTROL_NOT_EQUAL,
  CONTROL_GREATER_THAN,
  CONTROL_LESS_THAN,
  CONTROL_ELSE,
  CONTROL_ENDIF,
/* Last action in the system */
  ACTION_NONEXISTENT
} KissActionType;

typedef void * KissValue;

#define KissCell(x) ((KissCell *) x)
#define KissObject(x) ((KissObject *) x)
#define KissString(x) ((gchar *) x)
#define KissVariable(x) ((KissVariable *) x)
#define KissValue(x) (((KissVariable *) x)->value)

typedef struct {
  KissActionType type;
  guint line;
  KissValue args[3];
} KissAction;

typedef struct {
  gchar *name;
  gint32 value;
} KissVariable;

typedef struct {
  int together;
  KissActionList collide, apart;
} KissCollisionEvents;

typedef struct {
  KissCell *cell1, *cell2;
  KissCollisionEvents *events;
} KissCellCollision;

typedef struct {
  KissObject *obj1, *obj2;
  KissActionList in, out;
  KissActionList stillin, stillout;
  int together;
} KissObjectCollision;

typedef struct micro_timer {
  long when; /* relative to previous event */
  KissActionList what;
  struct micro_timer *next;
  struct micro_timer *prev;

} MicroTimer;

typedef struct {
  gchar *filename;             /* config filename */
  gchar *description;          /* longer description */
  KissActionList init;         /* fKiSS initialize() */
  KissActionList begin;        /* fKiSS begin() */
  KissActionList version;      /* fKiSS version() */
  KissActionList never;        /* fKiSS never() */
  KissActionList end;          /* fKiSS end() */
  KissActionList overflow;     /* fKiSS overflow() */

  KissActionList sets[SETS];     /* fKiSS set()s */
  KissActionList cols[COLS];     /* fKiSS col()s */
  GHashTable *alarms;            /* fKiSS alarm()s */
  GHashTable *labels;            /* fKiSS labels()s */

  GSList *variables;           /* numeric variables and constants */
  GHashTable *objects;         /* hash table of KissObjects */

  guchar *rgb_buf;             /* RGB buffer */
  gint32 width, height;        /* RGB buffer size */
  gint32 row_stride;           /* RGB row stride */

  gint   pal_set[SETS];        /* default palette set */
  guchar bg_color;             /* KiSS background color */

  KissCell *target;            /* cell currently being dragged */
  KissCell *selected;          /* cell current "selected" */

} KissConfig;

typedef struct {
  gboolean midi;               /* play MIDI */
  gchar  * midi_player;        /* external program to play MIDI */
  gboolean esound;             /* play WAVs and AUs with GNOME esound */

  gboolean ignore_colon;       /* treat : without set numbers as ALL */
  gboolean default_palette;    /* a 256 color default palette */
  gboolean fkiss_case;         /* ignore case of FKiSS */
  guint    min_timer;          /* minimum timer interval 1... */
  guint    speed_factor;       /* slow down factor, higher is slower */
  gboolean catch_drop;         /* catch / fixcatch mutually exclusive */

  gboolean error_list;         /* show diagnostic error list */
  gboolean warnings;           /* include warnings */
  gboolean trace;              /* run-time action tracing */
} KissPrefs;

extern KissConfig config;
extern KissPrefs prefs;

extern guint fk_timer_source; /* Source of timers */
extern MicroTimer *timers; /* Timers ready to fire */

extern GSList *cells; /* Global list of ALL KissCells */

extern guchar *palettes[PALETTES * COLS]; /* KCF palettes */

/* KissActions */

extern KissActionList fkiss_errors;      /* fKiSS errors... */

/* functions */

void set_timer(int which, long when);
void reset_timers(void);

void render_object(KissObject *object);
void render_cell(KissCell *cell);
void render_all(void);
void cell_render(gpointer data, gpointer user_data);
KissCell *cell_new(guint objid, guint pal, gchar *filename);
void cell_delete(KissCell *cell);
KissCell *cell_intersect(KissCell *cell, int x, int y);
KissCell *cell_find(gchar *name);
KissObject *object_id(guint id);
KissObject *object_find(char *ref);
void object_move(KissObject *object, int x, int y);
void object_set_location(KissObject *object, int x, int y);
void reset_cells(void);

KissVariable *var_find(gchar *name);
void var_describe(KissVariable *var);
void reset_variables(void);

KissCollisionEvents *collision_find(char *cell_one, char *cell_two);
KissObjectCollision *impact_find(char *one, char *two);
int cell_collision(KissCell *cell1, KissCell *cell2);
void check_collisions(KissObject *object, int ignore);
int object_collision(KissObject *obj1, KissObject *obj2);

char *lha_open(const char *filename);
void lha_extend(const char *filename);
void lha_close(void);

void parse_file(const char *filename);

void reset_french(void);
void parse_action(gchar *text);
void events(KissActionList list);

long numeric(gchar *integer);
KissActionList *event_find(GHashTable *table, gint id);
KissActionList *event_find_or_insert(GHashTable *table, gint id);
void clean_up(void);
#define FREE_ACTION_LIST(L) do { free_action_list(L); L= NULL; } while(0);
void free_action_list(GSList *list);
void change_cursor(GdkWindow *window, GdkCursorType type);
int case_fixup(char *filename);
FILE *open_any(const char *path, const char *mode);
void open_either(const char *filename);
KissCell *intersect(int x, int y);
void switch_color(int col);
void switch_view(int set);

void log_error(char *format, ...);
void log_warning(char *format, ...);
void set_line(guint line);
guint get_line(void);


