// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gtk {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class EntryBuffer : GLib.Object {

		public EntryBuffer (IntPtr raw) : base(raw) {}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_entry_buffer_new(IntPtr initial_chars, int n_initial_chars);

		public EntryBuffer (string initial_chars, int n_initial_chars) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (EntryBuffer)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			IntPtr native_initial_chars = GLib.Marshaller.StringToPtrGStrdup (initial_chars);
			Raw = gtk_entry_buffer_new(native_initial_chars, n_initial_chars);
			GLib.Marshaller.Free (native_initial_chars);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_entry_buffer_get_text(IntPtr raw);

		[GLib.Property ("text")]
		public string Text {
			get  {
				IntPtr raw_ret = gtk_entry_buffer_get_text(Handle);
				string ret = GLib.Marshaller.Utf8PtrToString (raw_ret);
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("text", val);
				val.Dispose ();
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gtk_entry_buffer_get_length(IntPtr raw);

		[GLib.Property ("length")]
		public uint Length {
			get  {
				uint raw_ret = gtk_entry_buffer_get_length(Handle);
				uint ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gtk_entry_buffer_get_max_length(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_entry_buffer_set_max_length(IntPtr raw, int max_length);

		[GLib.Property ("max-length")]
		public int MaxLength {
			get  {
				int raw_ret = gtk_entry_buffer_get_max_length(Handle);
				int ret = raw_ret;
				return ret;
			}
			set  {
				gtk_entry_buffer_set_max_length(Handle, value);
			}
		}

		[GLib.Signal("inserted-text")]
		public event Gtk.InsertedTextHandler InsertedText {
			add {
				this.AddSignalHandler ("inserted-text", value, typeof (Gtk.InsertedTextArgs));
			}
			remove {
				this.RemoveSignalHandler ("inserted-text", value);
			}
		}

		[GLib.Signal("deleted-text")]
		public event Gtk.DeletedTextHandler DeletedText {
			add {
				this.AddSignalHandler ("deleted-text", value, typeof (Gtk.DeletedTextArgs));
			}
			remove {
				this.RemoveSignalHandler ("deleted-text", value);
			}
		}

		static InsertedTextNativeDelegate InsertedText_cb_delegate;
		static InsertedTextNativeDelegate InsertedTextVMCallback {
			get {
				if (InsertedText_cb_delegate == null)
					InsertedText_cb_delegate = new InsertedTextNativeDelegate (InsertedText_cb);
				return InsertedText_cb_delegate;
			}
		}

		static void OverrideInsertedText (GLib.GType gtype)
		{
			OverrideInsertedText (gtype, InsertedTextVMCallback);
		}

		static void OverrideInsertedText (GLib.GType gtype, InsertedTextNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("inserted_text"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void InsertedTextNativeDelegate (IntPtr inst, uint position, IntPtr chars, uint n_chars);

		static void InsertedText_cb (IntPtr inst, uint position, IntPtr chars, uint n_chars)
		{
			try {
				EntryBuffer __obj = GLib.Object.GetObject (inst, false) as EntryBuffer;
				__obj.OnInsertedText (position, GLib.Marshaller.Utf8PtrToString (chars), n_chars);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.EntryBuffer), ConnectionMethod="OverrideInsertedText")]
		protected virtual void OnInsertedText (uint position, string chars, uint n_chars)
		{
			InternalInsertedText (position, chars, n_chars);
		}

		private void InternalInsertedText (uint position, string chars, uint n_chars)
		{
			InsertedTextNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("inserted_text"));
				unmanaged = (InsertedTextNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(InsertedTextNativeDelegate));
			}
			if (unmanaged == null) return;

			IntPtr native_chars = GLib.Marshaller.StringToPtrGStrdup (chars);
			unmanaged (this.Handle, position, native_chars, n_chars);
			GLib.Marshaller.Free (native_chars);
		}

		static DeletedTextNativeDelegate DeletedText_cb_delegate;
		static DeletedTextNativeDelegate DeletedTextVMCallback {
			get {
				if (DeletedText_cb_delegate == null)
					DeletedText_cb_delegate = new DeletedTextNativeDelegate (DeletedText_cb);
				return DeletedText_cb_delegate;
			}
		}

		static void OverrideDeletedText (GLib.GType gtype)
		{
			OverrideDeletedText (gtype, DeletedTextVMCallback);
		}

		static void OverrideDeletedText (GLib.GType gtype, DeletedTextNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("deleted_text"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DeletedTextNativeDelegate (IntPtr inst, uint position, uint n_chars);

		static void DeletedText_cb (IntPtr inst, uint position, uint n_chars)
		{
			try {
				EntryBuffer __obj = GLib.Object.GetObject (inst, false) as EntryBuffer;
				__obj.OnDeletedText (position, n_chars);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.EntryBuffer), ConnectionMethod="OverrideDeletedText")]
		protected virtual void OnDeletedText (uint position, uint n_chars)
		{
			InternalDeletedText (position, n_chars);
		}

		private void InternalDeletedText (uint position, uint n_chars)
		{
			DeletedTextNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("deleted_text"));
				unmanaged = (DeletedTextNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DeletedTextNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, position, n_chars);
		}

		static GetTextNativeDelegate GetText_cb_delegate;
		static GetTextNativeDelegate GetTextVMCallback {
			get {
				if (GetText_cb_delegate == null)
					GetText_cb_delegate = new GetTextNativeDelegate (GetText_cb);
				return GetText_cb_delegate;
			}
		}

		static void OverrideGetText (GLib.GType gtype)
		{
			OverrideGetText (gtype, GetTextVMCallback);
		}

		static void OverrideGetText (GLib.GType gtype, GetTextNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("get_text"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate IntPtr GetTextNativeDelegate (IntPtr inst, out UIntPtr n_bytes);

		static IntPtr GetText_cb (IntPtr inst, out UIntPtr n_bytes)
		{
			try {
				EntryBuffer __obj = GLib.Object.GetObject (inst, false) as EntryBuffer;
				string __result;
				ulong myn_bytes;
				__result = __obj.OnGetText (out myn_bytes);
				n_bytes = new UIntPtr (myn_bytes);
				return GLib.Marshaller.StringToPtrGStrdup(__result);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.EntryBuffer), ConnectionMethod="OverrideGetText")]
		protected virtual string OnGetText (out ulong n_bytes)
		{
			return InternalGetText (out n_bytes);
		}

		private string InternalGetText (out ulong n_bytes)
		{
			GetTextNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("get_text"));
				unmanaged = (GetTextNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(GetTextNativeDelegate));
			}
			if (unmanaged == null) throw new InvalidOperationException ("No base method to invoke");

			UIntPtr native_n_bytes;
			IntPtr __result = unmanaged (this.Handle, out native_n_bytes);
			n_bytes = (ulong) native_n_bytes;
			return GLib.Marshaller.PtrToStringGFree(__result);
		}

		static GetLengthNativeDelegate GetLength_cb_delegate;
		static GetLengthNativeDelegate GetLengthVMCallback {
			get {
				if (GetLength_cb_delegate == null)
					GetLength_cb_delegate = new GetLengthNativeDelegate (GetLength_cb);
				return GetLength_cb_delegate;
			}
		}

		static void OverrideGetLength (GLib.GType gtype)
		{
			OverrideGetLength (gtype, GetLengthVMCallback);
		}

		static void OverrideGetLength (GLib.GType gtype, GetLengthNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("get_length"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate uint GetLengthNativeDelegate (IntPtr inst);

		static uint GetLength_cb (IntPtr inst)
		{
			try {
				EntryBuffer __obj = GLib.Object.GetObject (inst, false) as EntryBuffer;
				uint __result;
				__result = __obj.OnGetLength ();
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.EntryBuffer), ConnectionMethod="OverrideGetLength")]
		protected virtual uint OnGetLength ()
		{
			return InternalGetLength ();
		}

		private uint InternalGetLength ()
		{
			GetLengthNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("get_length"));
				unmanaged = (GetLengthNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(GetLengthNativeDelegate));
			}
			if (unmanaged == null) return 0;

			uint __result = unmanaged (this.Handle);
			return __result;
		}

		static InsertTextNativeDelegate InsertText_cb_delegate;
		static InsertTextNativeDelegate InsertTextVMCallback {
			get {
				if (InsertText_cb_delegate == null)
					InsertText_cb_delegate = new InsertTextNativeDelegate (InsertText_cb);
				return InsertText_cb_delegate;
			}
		}

		static void OverrideInsertText (GLib.GType gtype)
		{
			OverrideInsertText (gtype, InsertTextVMCallback);
		}

		static void OverrideInsertText (GLib.GType gtype, InsertTextNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("insert_text"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate uint InsertTextNativeDelegate (IntPtr inst, uint position, IntPtr chars, uint n_chars);

		static uint InsertText_cb (IntPtr inst, uint position, IntPtr chars, uint n_chars)
		{
			try {
				EntryBuffer __obj = GLib.Object.GetObject (inst, false) as EntryBuffer;
				uint __result;
				__result = __obj.OnInsertText (position, GLib.Marshaller.Utf8PtrToString (chars), n_chars);
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.EntryBuffer), ConnectionMethod="OverrideInsertText")]
		protected virtual uint OnInsertText (uint position, string chars, uint n_chars)
		{
			return InternalInsertText (position, chars, n_chars);
		}

		private uint InternalInsertText (uint position, string chars, uint n_chars)
		{
			InsertTextNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("insert_text"));
				unmanaged = (InsertTextNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(InsertTextNativeDelegate));
			}
			if (unmanaged == null) return 0;

			IntPtr native_chars = GLib.Marshaller.StringToPtrGStrdup (chars);
			uint __result = unmanaged (this.Handle, position, native_chars, n_chars);
			GLib.Marshaller.Free (native_chars);
			return __result;
		}

		static DeleteTextNativeDelegate DeleteText_cb_delegate;
		static DeleteTextNativeDelegate DeleteTextVMCallback {
			get {
				if (DeleteText_cb_delegate == null)
					DeleteText_cb_delegate = new DeleteTextNativeDelegate (DeleteText_cb);
				return DeleteText_cb_delegate;
			}
		}

		static void OverrideDeleteText (GLib.GType gtype)
		{
			OverrideDeleteText (gtype, DeleteTextVMCallback);
		}

		static void OverrideDeleteText (GLib.GType gtype, DeleteTextNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("delete_text"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate uint DeleteTextNativeDelegate (IntPtr inst, uint position, uint n_chars);

		static uint DeleteText_cb (IntPtr inst, uint position, uint n_chars)
		{
			try {
				EntryBuffer __obj = GLib.Object.GetObject (inst, false) as EntryBuffer;
				uint __result;
				__result = __obj.OnDeleteText (position, n_chars);
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.EntryBuffer), ConnectionMethod="OverrideDeleteText")]
		protected virtual uint OnDeleteText (uint position, uint n_chars)
		{
			return InternalDeleteText (position, n_chars);
		}

		private uint InternalDeleteText (uint position, uint n_chars)
		{
			DeleteTextNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("delete_text"));
				unmanaged = (DeleteTextNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DeleteTextNativeDelegate));
			}
			if (unmanaged == null) return 0;

			uint __result = unmanaged (this.Handle, position, n_chars);
			return __result;
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _class_abi = null;
		static public new GLib.AbiStruct class_abi {
			get {
				if (_class_abi == null)
					_class_abi = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("inserted_text"
							, GLib.Object.class_abi.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // inserted_text
							, null
							, "deleted_text"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("deleted_text"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // deleted_text
							, "inserted_text"
							, "get_text"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("get_text"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // get_text
							, "deleted_text"
							, "get_length"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("get_length"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // get_length
							, "get_text"
							, "insert_text"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("insert_text"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // insert_text
							, "get_length"
							, "delete_text"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("delete_text"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // delete_text
							, "insert_text"
							, "_gtk_reserved1"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved1"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved1
							, "delete_text"
							, "_gtk_reserved2"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved2"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved2
							, "_gtk_reserved1"
							, "_gtk_reserved3"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved3"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved3
							, "_gtk_reserved2"
							, "_gtk_reserved4"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved4"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved4
							, "_gtk_reserved3"
							, "_gtk_reserved5"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved5"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved5
							, "_gtk_reserved4"
							, "_gtk_reserved6"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved6"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved6
							, "_gtk_reserved5"
							, "_gtk_reserved7"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved7"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved7
							, "_gtk_reserved6"
							, "_gtk_reserved8"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved8"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved8
							, "_gtk_reserved7"
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _class_abi;
			}
		}


		// End of the ABI representation.

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gtk_entry_buffer_delete_text(IntPtr raw, uint position, int n_chars);

		public uint DeleteText(uint position, int n_chars) {
			uint raw_ret = gtk_entry_buffer_delete_text(Handle, position, n_chars);
			uint ret = raw_ret;
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_entry_buffer_emit_deleted_text(IntPtr raw, uint position, uint n_chars);

		public void EmitDeletedText(uint position, uint n_chars) {
			gtk_entry_buffer_emit_deleted_text(Handle, position, n_chars);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_entry_buffer_emit_inserted_text(IntPtr raw, uint position, IntPtr chars, uint n_chars);

		public void EmitInsertedText(uint position, string chars, uint n_chars) {
			IntPtr native_chars = GLib.Marshaller.StringToPtrGStrdup (chars);
			gtk_entry_buffer_emit_inserted_text(Handle, position, native_chars, n_chars);
			GLib.Marshaller.Free (native_chars);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern UIntPtr gtk_entry_buffer_get_bytes(IntPtr raw);

		public ulong Bytes { 
			get {
				UIntPtr raw_ret = gtk_entry_buffer_get_bytes(Handle);
				ulong ret = (ulong) raw_ret;
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_entry_buffer_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = gtk_entry_buffer_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gtk_entry_buffer_insert_text(IntPtr raw, uint position, IntPtr chars, int n_chars);

		public uint InsertText(uint position, string chars, int n_chars) {
			IntPtr native_chars = GLib.Marshaller.StringToPtrGStrdup (chars);
			uint raw_ret = gtk_entry_buffer_insert_text(Handle, position, native_chars, n_chars);
			uint ret = raw_ret;
			GLib.Marshaller.Free (native_chars);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_entry_buffer_set_text(IntPtr raw, IntPtr chars, int n_chars);

		public void SetText(string chars, int n_chars) {
			IntPtr native_chars = GLib.Marshaller.StringToPtrGStrdup (chars);
			gtk_entry_buffer_set_text(Handle, native_chars, n_chars);
			GLib.Marshaller.Free (native_chars);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _abi_info = null;
		static public new GLib.AbiStruct abi_info {
			get {
				if (_abi_info == null)
					_abi_info = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("priv"
							, GLib.Object.abi_info.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // priv
							, null
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _abi_info;
			}
		}


		// End of the ABI representation.

#endregion
	}
}
