#ifndef __GM_WORLD_INPUT_VIEW_H__
#define __GM_WORLD_INPUT_VIEW_H__

#include <gtk/gtk.h>
#include "gm-color-table.h"

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_WORLD_INPUT_VIEW				(gm_world_input_view_get_type())
#define GM_WORLD_INPUT_VIEW(obj)				(G_TYPE_CHECK_INSTANCE_CAST((obj), GM_TYPE_WORLD_INPUT_VIEW, GmWorldInputView))
#define GM_WORLD_INPUT_VIEW_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), GM_TYPE_WORLD_INPUT_VIEW, GmWorldInputView const))
#define GM_WORLD_INPUT_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), GM_TYPE_WORLD_INPUT_VIEW, GmWorldInputViewClass))
#define GM_IS_WORLD_INPUT_VIEW(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), GM_TYPE_WORLD_INPUT_VIEW))
#define GM_IS_WORLD_INPUT_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), GM_TYPE_WORLD_INPUT_VIEW))
#define GM_WORLD_INPUT_VIEW_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), GM_TYPE_WORLD_INPUT_VIEW, GmWorldInputViewClass))

/* Private structure type */
typedef struct _GmWorldInputViewPrivate GmWorldInputViewPrivate;

/*
 * Main object structure
 */
typedef struct _GmWorldInputView GmWorldInputView;
 
struct _GmWorldInputView {
	GtkTextView textview;
	
	/*< private > */
	GmWorldInputViewPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmWorldInputViewClass 	GmWorldInputViewClass;

struct _GmWorldInputViewClass {
	GtkTextViewClass parent_class;

	/* Signals */
	void (* text_activate) (GmWorldInputView *view, const gchar *text);
};

GType gm_world_input_view_get_type(void) G_GNUC_CONST;
GtkWidget *gm_world_input_view_new();
GtkWidget *gm_world_input_view_new_with_color_table(GmColorTable *table);
void gm_world_input_view_set_color_table(GmWorldInputView *view, 
		GmColorTable *color_table);
GmColorTable *gm_world_input_view_color_table(GmWorldInputView *view);
void gm_world_input_view_set_history(GmWorldInputView *view, GList **history);
GList **gm_world_input_view_history(GmWorldInputView *view);

G_END_DECLS
#endif /* __GM_WORLD_INPUT_VIEW_H__ */
