#include <glib-object.h>
#include "gm-mcp-session.h"
#include "gm-mcp-package.h"
#include "gm-support.h"

#define GM_MCP_PACKAGE_GET_PRIVATE(object)( \
		G_TYPE_INSTANCE_GET_PRIVATE((object), \
		GM_TYPE_MCP_PACKAGE, GmMcpPackagePrivate))

struct _GmMcpPackagePrivate {
	GmMcpSession *session;
	gdouble version;
};

/* Signals

enum {
	PROTO
	NUM_SIGNALS
};

static guint gm_mcp_package_signals[NUM_SIGNALS] = {0};*/

G_DEFINE_TYPE(GmMcpPackage, gm_mcp_package, G_TYPE_OBJECT)
void gm_mcp_package_set_session_real(GmMcpPackage *package, GObject *session);

static void
gm_mcp_package_finalize(GObject *object) {
	//GmMcpPackage *package = GM_MCP_PACKAGE(object);	
	G_OBJECT_CLASS(gm_mcp_package_parent_class)->finalize(object);
}

static void
gm_mcp_package_class_init(GmMcpPackageClass *klass) {
	GObjectClass *object_class = G_OBJECT_CLASS(klass);
	
	object_class->finalize = gm_mcp_package_finalize;

	/*gm_mcp_package_signals[PROTO] = 
		g_signal_new("proto",
			G_OBJECT_CLASS_TYPE(object_class),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET(GmMcpPackageClass, proto),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0);*/
	
	klass->handle_simple = NULL;
	klass->handle_multi = NULL;
	klass->create_view = NULL;
	klass->set_session = &gm_mcp_package_set_session_real;
	
	klass->depends = NULL;
	klass->overrides = NULL;
	klass->name = NULL;
	klass->min_version = 1.0;
	klass->max_version = 1.0;
	
	g_type_class_add_private(object_class, sizeof(GmMcpPackagePrivate));
}

static void
gm_mcp_package_init(GmMcpPackage *obj) {
	obj->priv = GM_MCP_PACKAGE_GET_PRIVATE(obj);
	obj->priv->session = NULL;
	obj->priv->version = 1.0;
}

void
gm_mcp_package_set_session_real(GmMcpPackage *package, GObject *session) {
	package->priv->session = GM_MCP_SESSION(session);
}

/* Public */
GmMcpPackage *
gm_mcp_package_new() {
	GmMcpPackage *obj = GM_MCP_PACKAGE(g_object_new(GM_TYPE_MCP_PACKAGE, NULL));
	return obj;
}

void
gm_mcp_package_handle_simple(GmMcpPackage *package, gchar *suffix, 
		GList *fields) {
	return GM_MCP_PACKAGE_GET_CLASS(package)->handle_simple(package, 
			suffix, fields);
}

gboolean
gm_mcp_package_can_handle_simple(GmMcpPackage *package) {
	return (GM_MCP_PACKAGE_GET_CLASS(package)->handle_simple != NULL);
}

gboolean
gm_mcp_package_handle_multi(GmMcpPackage *package, gchar *data_tag, 
		gchar *key, gchar *value, GList *allValues) {
	return GM_MCP_PACKAGE_GET_CLASS(package)->handle_multi(package, 
			data_tag, key, value, allValues);
}

gboolean
gm_mcp_package_can_handle_multi(GmMcpPackage *package) {
	return (GM_MCP_PACKAGE_GET_CLASS(package)->handle_multi != NULL);
}

void
gm_mcp_package_create_view(GmMcpPackage *package, GObject *parent) {
	if (gm_mcp_package_can_create_view(package)) {
		GM_MCP_PACKAGE_GET_CLASS(package)->create_view(package, 
				parent);
	}
}

gboolean
gm_mcp_package_can_create_view(GmMcpPackage *package) {
	return (GM_MCP_PACKAGE_GET_CLASS(package)->create_view != NULL);
}

void
gm_mcp_package_set_session(GmMcpPackage *package, GObject *session) {
	GM_MCP_PACKAGE_GET_CLASS(package)->set_session(package, session);
}

GObject *
gm_mcp_package_get_session(GmMcpPackage *package) {
	return G_OBJECT(package->priv->session);
}

void
gm_mcp_package_set_version(GmMcpPackage *package, gdouble version) {
	package->priv->version = version;
}

gdouble
gm_mcp_package_get_version(GmMcpPackage *package) {
	return package->priv->version;
}

gchar const *
gm_mcp_package_get_name(GmMcpPackage *package) {
	return GM_MCP_PACKAGE_GET_CLASS(package)->name;
}

gchar **
gm_mcp_package_get_depends(GmMcpPackage *package) {
	return GM_MCP_PACKAGE_GET_CLASS(package)->depends;
}

gchar **
gm_mcp_package_get_overrides(GmMcpPackage *package) {
	return GM_MCP_PACKAGE_GET_CLASS(package)->overrides;
}

gdouble
gm_mcp_package_get_min_version(GmMcpPackage *package) {
	return GM_MCP_PACKAGE_GET_CLASS(package)->min_version;
}

gdouble
gm_mcp_package_get_max_version(GmMcpPackage *package) {
	return GM_MCP_PACKAGE_GET_CLASS(package)->max_version;
}
