#ifndef __GM_ANSI_H__
#define __GM_ANSI_H__

/** \defgroup ansi 
  *  @{
  */

/** \brief enum indicating ansi code
  * 
  * Enumeration which indicates the ansi code
  */ 
typedef enum _ansi_code {
	A_DEFAULT = 0,            /**< default (reset all attributes) */
	A_BOLD = 1,               /**< bold text */
	A_FAINT = 2,              /**< faint text */
	A_ITALIC = 3,             /**< italic text */
	A_UNDERLINE = 4,          /**< underlined text */
	A_BLINK = 5,              /**< blink text */
	A_BLINK_FAST = 6,         /**< blink fast */
	A_INVERSE = 7,            /**< inverse foreground/background colors */
	A_INVISIBLE = 8,          /**< invisible text */
	A_CROSSOUT = 9,           /**< crossed out text */
	A_DOUBLE_UNDERLINE = 21,  /**< double underlined text */

	A_BOLD_OFF = 22,          /**< text no longer bold */
	A_ITALIC_OFF = 23,        /**< text no longer italic */
	A_UNDERLINE_OFF = 24,     /**< text no longer underlined */
	A_BLINK_OFF = 25,         /**< text no longer underlined */
	A_BLINK_FAST_OFF = 26,    /**< text no longer underlined */
	A_INVERSE_OFF = 27,       /**< text no longer inversed */
	A_INVISIBLE_OFF = 28,     /**< text no longer invisible */
	A_CROSSOUT_OFF = 29,      /**< text no longer crossed out */

	A_FG_BLACK = 30,          /**< foreground color black */
	A_FG_RED = 31,            /**< foreground color red */
	A_FG_GREEN = 32,          /**< foreground color green */
	A_FG_YELLOW = 33,         /**< foreground color yellow */
	A_FG_BLUE = 34,           /**< foreground color blue */
	A_FG_PURPLE = 35,         /**< foreground color purple */
	A_FG_CYAN = 36,           /**< foreground color cyan */
	A_FG_WHITE = 37,          /**< foreground color white */
	A_FG_DEFAULT = 39,        /**< foreground color default */

	A_BG_BLACK = 40,          /**< background color black */
	A_BG_RED = 41,            /**< background color red */
	A_BG_GREEN = 42,          /**< background color green */
	A_BG_YELLOW = 43,         /**< background color yellow */
	A_BG_BLUE = 44,           /**< background color blue */
	A_BG_PURPLE = 45,         /**< background color purple */
	A_BG_CYAN = 46,           /**< background color cyan */
	A_BG_WHITE = 47,          /**< background color white */
	A_BG_DEFAULT = 49,        /**< background color default */

	A_NOWRAP = 50,            /**< do not wrap this text */

	A_FG_BLACK_H,             /**< foreground color black high */
	A_FG_RED_H,               /**< foreground color red high */
	A_FG_GREEN_H,             /**< foreground color green high */
	A_FG_YELLOW_H,            /**< foreground color yellow high */
	A_FG_BLUE_H,              /**< foreground color blue high */
	A_FG_PURPLE_H,            /**< foreground color purple high */
	A_FG_CYAN_H,              /**< foreground color cyan high */
	A_FG_WHITE_H,             /**< foreground color white high */
	A_FG_DEFAULT_H           /**< foreground color default high */
} ansi_code;

/** \brief struct for containing ansi-name pair
  * 
  * Struct can be used to create a code to name to code mapping
  */ 
typedef struct _ansinamepair {
	const ansi_code code; /**< the ansi code */
	const char *name;     /**< the ansi name */
} ansinamepair;

/** \brief array containing color code/name mapping
  *
  * Array which can be used for color code/name mapping 
  */ 
static const ansinamepair ansi_colors[] = {
	{A_FG_BLACK, "fg_black"},
	{A_FG_RED, "fg_red"},
	{A_FG_GREEN, "fg_green"},
	{A_FG_YELLOW, "fg_yellow"},
	{A_FG_BLUE, "fg_blue"},
	{A_FG_PURPLE, "fg_purple"},
	{A_FG_CYAN, "fg_cyan"},
	{A_FG_WHITE, "fg_white"},
	{A_FG_DEFAULT, "fg_default"},
	{A_FG_BLACK_H, "fg_black_h"},
	{A_FG_RED_H, "fg_red_h"},
	{A_FG_GREEN_H, "fg_green_h"},
	{A_FG_YELLOW_H, "fg_yellow_h"},
	{A_FG_BLUE_H, "fg_blue_h"},
	{A_FG_PURPLE_H, "fg_purple_h"},
	{A_FG_CYAN_H, "fg_cyan_h"},
	{A_FG_WHITE_H, "fg_white_h"},
	{A_FG_DEFAULT_H, "fg_default_h"},
	{A_BG_BLACK, "bg_black"},
	{A_BG_RED, "bg_red"},
	{A_BG_GREEN, "bg_green"},
	{A_BG_YELLOW, "bg_yellow"},
	{A_BG_BLUE, "bg_blue"},
	{A_BG_PURPLE, "bg_purple"},
	{A_BG_CYAN, "bg_cyan"},
	{A_BG_WHITE, "bg_white"},
	{A_BG_DEFAULT, "bg_default"}
};

/** \brief array containing style code/name mapping
  *
  * Array which can be used for style code/name mapping 
  */ 
static const ansinamepair ansi_styles[] = {
	{A_BOLD, "bold"},
	{A_FAINT, "faint"},
	{A_BOLD_OFF, "bold-off"},
	{A_UNDERLINE, "underline"},
	{A_DOUBLE_UNDERLINE, "dblunderline"},
	{A_UNDERLINE_OFF, "underline-off"},
	{A_CROSSOUT, "crossout"},
	{A_CROSSOUT_OFF, "crossout-off"},
	{A_ITALIC, "italic"},
	{A_ITALIC_OFF, "italic-off"},
	{A_INVISIBLE, "invisible"},
	{A_INVISIBLE_OFF, "invisible-off"}
};

/** @} */
#endif /* __GM_ANSI_H__ */
