# Summary

- [About](./intro.md)
- [Gmsh fundamentals](./fundamentals.md)
- [The OpenCASCADE kernel](./occ.md)
- [Geometry](./geometry.md)
  - [Transformations](./geometry/transforms.md)
  - [Surface holes](./geometry/holes.md)
  - [OpenCASCADE examples](./geometry/occ-demo.md)
  - [STEP file manipulation](./geometry/step.md)
  - [Point in curve](./geometry/embed-point.md)
- [Mesh](./mesh.md)
  - [Extruded meshes](./mesh/extrude.md)
  - [Mesh sizes](./mesh/mesh-sizes.md)
  - [Transfinite meshing](./mesh/transfinite.md)
  - [Background meshes](./mesh/background.md)
  - [Size fields](./mesh/size-fields.md)
  - [Quad meshes](./mesh/quad.md)
  - [Compound meshes](./mesh/compound.md)
  - [Remesh a STL file](./mesh/stl.md)
  - [Homology](./mesh/homology.md)
  - [Embedded points, lines and surfaces](./mesh/embedded.md)
  - [Anisotropic background mesh](./mesh/anisotropic.md)
  - [Periodic meshes](./mesh/periodic.md)
  - [Mesh partitions](./mesh/partition.md)
  - [Line segments](./mesh/line-segments.md)
- [Post processing](./postpro.md)
  - [Views](./postpro/intro.md)
  - [Plugins](./postpro/plugins.md)
  - [List of view names](./postpro/view-names.md)
- [Tutorial](./tutorial.md)
