/*****************************************************************
 * gmerlin-avdecoder - a general purpose multimedia decoding library
 *
 * Copyright (c) 2001 - 2011 Members of the Gmerlin project
 * gmerlin-general@lists.sourceforge.net
 * http://gmerlin.sourceforge.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * *****************************************************************/

//  Default Palettes for Quicktime Files
//  Automatically generated from a utility derived from XAnim:
//    http://xanim.va.pubnix.com/home.html

#include <avdec_private.h>

const bgav_palette_entry_t bgav_qt_default_palette_2[] = {
 { 0xFFFF, 0xFFFF, 0xFFFF, 0x0000 },
 { 0x0000, 0x0000, 0x0000, 0x0000 },
};

const bgav_palette_entry_t bgav_qt_default_palette_4[] = {
 { 0x9393, 0x6565, 0x5E5E, 0xFFFF },
 { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF },
 { 0xDFDF, 0xD0D0, 0xABAB, 0xFFFF },
 { 0x0000, 0x0000, 0x0000, 0xFFFF } 
};

const bgav_palette_entry_t bgav_qt_default_palette_16[] = {
 { 0xFFFF, 0xFBFB, 0xFFFF, 0xFFFF },
 { 0xEFEF, 0xD9D9, 0xBBBB, 0xFFFF },
 { 0xE8E8, 0xC9C9, 0xB1B1, 0xFFFF },
 { 0x9393, 0x6565, 0x5E5E, 0xFFFF },
 { 0xFCFC, 0xDEDE, 0xE8E8, 0xFFFF },
 { 0x9D9D, 0x8888, 0x9191, 0xFFFF },
 { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF },
 { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF },
 { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF },
 { 0x4747, 0x4848, 0x3737, 0xFFFF },
 { 0x7A7A, 0x5E5E, 0x5555, 0xFFFF },
 { 0xDFDF, 0xD0D0, 0xABAB, 0xFFFF },
 { 0xFFFF, 0xFBFB, 0xF9F9, 0xFFFF },
 { 0xE8E8, 0xCACA, 0xC5C5, 0xFFFF },
 { 0x8A8A, 0x7C7C, 0x7777, 0xFFFF },
 { 0x0000, 0x0000, 0x0000, 0xFFFF } 
};

const bgav_palette_entry_t bgav_qt_default_palette_256[] = {
{ 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF },
{ 0xFFFF, 0xFFFF, 0xCCCC, 0xFFFF },
{ 0xFFFF, 0xFFFF, 0x9999, 0xFFFF },
{ 0xFFFF, 0xFFFF, 0x6666, 0xFFFF },
{ 0xFFFF, 0xFFFF, 0x3333, 0xFFFF },
{ 0xFFFF, 0xFFFF, 0x0000, 0xFFFF },
{ 0xFFFF, 0xCCCC, 0xFFFF, 0xFFFF },
{ 0xFFFF, 0xCCCC, 0xCCCC, 0xFFFF },
{ 0xFFFF, 0xCCCC, 0x9999, 0xFFFF },
{ 0xFFFF, 0xCCCC, 0x6666, 0xFFFF },
{ 0xFFFF, 0xCCCC, 0x3333, 0xFFFF },
{ 0xFFFF, 0xCCCC, 0x0000, 0xFFFF },
{ 0xFFFF, 0x9999, 0xFFFF, 0xFFFF },
{ 0xFFFF, 0x9999, 0xCCCC, 0xFFFF },
{ 0xFFFF, 0x9999, 0x9999, 0xFFFF },
{ 0xFFFF, 0x9999, 0x6666, 0xFFFF },
{ 0xFFFF, 0x9999, 0x3333, 0xFFFF },
{ 0xFFFF, 0x9999, 0x0000, 0xFFFF },
{ 0xFFFF, 0x6666, 0xFFFF, 0xFFFF },
{ 0xFFFF, 0x6666, 0xCCCC, 0xFFFF },
{ 0xFFFF, 0x6666, 0x9999, 0xFFFF },
{ 0xFFFF, 0x6666, 0x6666, 0xFFFF },
{ 0xFFFF, 0x6666, 0x3333, 0xFFFF },
{ 0xFFFF, 0x6666, 0x0000, 0xFFFF },
{ 0xFFFF, 0x3333, 0xFFFF, 0xFFFF },
{ 0xFFFF, 0x3333, 0xCCCC, 0xFFFF },
{ 0xFFFF, 0x3333, 0x9999, 0xFFFF },
{ 0xFFFF, 0x3333, 0x6666, 0xFFFF },
{ 0xFFFF, 0x3333, 0x3333, 0xFFFF },
{ 0xFFFF, 0x3333, 0x0000, 0xFFFF },
{ 0xFFFF, 0x0000, 0xFFFF, 0xFFFF },
{ 0xFFFF, 0x0000, 0xCCCC, 0xFFFF },
{ 0xFFFF, 0x0000, 0x9999, 0xFFFF },
{ 0xFFFF, 0x0000, 0x6666, 0xFFFF },
{ 0xFFFF, 0x0000, 0x3333, 0xFFFF },
{ 0xFFFF, 0x0000, 0x0000, 0xFFFF },
{ 0xCCCC, 0xFFFF, 0xFFFF, 0xFFFF },
{ 0xCCCC, 0xFFFF, 0xCCCC, 0xFFFF },
{ 0xCCCC, 0xFFFF, 0x9999, 0xFFFF },
{ 0xCCCC, 0xFFFF, 0x6666, 0xFFFF },
{ 0xCCCC, 0xFFFF, 0x3333, 0xFFFF },
{ 0xCCCC, 0xFFFF, 0x0000, 0xFFFF },
{ 0xCCCC, 0xCCCC, 0xFFFF, 0xFFFF },
{ 0xCCCC, 0xCCCC, 0xCCCC, 0xFFFF },
{ 0xCCCC, 0xCCCC, 0x9999, 0xFFFF },
{ 0xCCCC, 0xCCCC, 0x6666, 0xFFFF },
{ 0xCCCC, 0xCCCC, 0x3333, 0xFFFF },
{ 0xCCCC, 0xCCCC, 0x0000, 0xFFFF },
{ 0xCCCC, 0x9999, 0xFFFF, 0xFFFF },
{ 0xCCCC, 0x9999, 0xCCCC, 0xFFFF },
{ 0xCCCC, 0x9999, 0x9999, 0xFFFF },
{ 0xCCCC, 0x9999, 0x6666, 0xFFFF },
{ 0xCCCC, 0x9999, 0x3333, 0xFFFF },
{ 0xCCCC, 0x9999, 0x0000, 0xFFFF },
{ 0xCCCC, 0x6666, 0xFFFF, 0xFFFF },
{ 0xCCCC, 0x6666, 0xCCCC, 0xFFFF },
{ 0xCCCC, 0x6666, 0x9999, 0xFFFF },
{ 0xCCCC, 0x6666, 0x6666, 0xFFFF },
{ 0xCCCC, 0x6666, 0x3333, 0xFFFF },
{ 0xCCCC, 0x6666, 0x0000, 0xFFFF },
{ 0xCCCC, 0x3333, 0xFFFF, 0xFFFF },
{ 0xCCCC, 0x3333, 0xCCCC, 0xFFFF },
{ 0xCCCC, 0x3333, 0x9999, 0xFFFF },
{ 0xCCCC, 0x3333, 0x6666, 0xFFFF },
{ 0xCCCC, 0x3333, 0x3333, 0xFFFF },
{ 0xCCCC, 0x3333, 0x0000, 0xFFFF },
{ 0xCCCC, 0x0000, 0xFFFF, 0xFFFF },
{ 0xCCCC, 0x0000, 0xCCCC, 0xFFFF },
{ 0xCCCC, 0x0000, 0x9999, 0xFFFF },
{ 0xCCCC, 0x0000, 0x6666, 0xFFFF },
{ 0xCCCC, 0x0000, 0x3333, 0xFFFF },
{ 0xCCCC, 0x0000, 0x0000, 0xFFFF },
{ 0x9999, 0xFFFF, 0xFFFF, 0xFFFF },
{ 0x9999, 0xFFFF, 0xCCCC, 0xFFFF },
{ 0x9999, 0xFFFF, 0x9999, 0xFFFF },
{ 0x9999, 0xFFFF, 0x6666, 0xFFFF },
{ 0x9999, 0xFFFF, 0x3333, 0xFFFF },
{ 0x9999, 0xFFFF, 0x0000, 0xFFFF },
{ 0x9999, 0xCCCC, 0xFFFF, 0xFFFF },
{ 0x9999, 0xCCCC, 0xCCCC, 0xFFFF },
{ 0x9999, 0xCCCC, 0x9999, 0xFFFF },
{ 0x9999, 0xCCCC, 0x6666, 0xFFFF },
{ 0x9999, 0xCCCC, 0x3333, 0xFFFF },
{ 0x9999, 0xCCCC, 0x0000, 0xFFFF },
{ 0x9999, 0x9999, 0xFFFF, 0xFFFF },
{ 0x9999, 0x9999, 0xCCCC, 0xFFFF },
{ 0x9999, 0x9999, 0x9999, 0xFFFF },
{ 0x9999, 0x9999, 0x6666, 0xFFFF },
{ 0x9999, 0x9999, 0x3333, 0xFFFF },
{ 0x9999, 0x9999, 0x0000, 0xFFFF },
{ 0x9999, 0x6666, 0xFFFF, 0xFFFF },
{ 0x9999, 0x6666, 0xCCCC, 0xFFFF },
{ 0x9999, 0x6666, 0x9999, 0xFFFF },
{ 0x9999, 0x6666, 0x6666, 0xFFFF },
{ 0x9999, 0x6666, 0x3333, 0xFFFF },
{ 0x9999, 0x6666, 0x0000, 0xFFFF },
{ 0x9999, 0x3333, 0xFFFF, 0xFFFF },
{ 0x9999, 0x3333, 0xCCCC, 0xFFFF },
{ 0x9999, 0x3333, 0x9999, 0xFFFF },
{ 0x9999, 0x3333, 0x6666, 0xFFFF },
{ 0x9999, 0x3333, 0x3333, 0xFFFF },
{ 0x9999, 0x3333, 0x0000, 0xFFFF },
{ 0x9999, 0x0000, 0xFFFF, 0xFFFF },
{ 0x9999, 0x0000, 0xCCCC, 0xFFFF },
{ 0x9999, 0x0000, 0x9999, 0xFFFF },
{ 0x9999, 0x0000, 0x6666, 0xFFFF },
{ 0x9999, 0x0000, 0x3333, 0xFFFF },
{ 0x9999, 0x0000, 0x0000, 0xFFFF },
{ 0x6666, 0xFFFF, 0xFFFF, 0xFFFF },
{ 0x6666, 0xFFFF, 0xCCCC, 0xFFFF },
{ 0x6666, 0xFFFF, 0x9999, 0xFFFF },
{ 0x6666, 0xFFFF, 0x6666, 0xFFFF },
{ 0x6666, 0xFFFF, 0x3333, 0xFFFF },
{ 0x6666, 0xFFFF, 0x0000, 0xFFFF },
{ 0x6666, 0xCCCC, 0xFFFF, 0xFFFF },
{ 0x6666, 0xCCCC, 0xCCCC, 0xFFFF },
{ 0x6666, 0xCCCC, 0x9999, 0xFFFF },
{ 0x6666, 0xCCCC, 0x6666, 0xFFFF },
{ 0x6666, 0xCCCC, 0x3333, 0xFFFF },
{ 0x6666, 0xCCCC, 0x0000, 0xFFFF },
{ 0x6666, 0x9999, 0xFFFF, 0xFFFF },
{ 0x6666, 0x9999, 0xCCCC, 0xFFFF },
{ 0x6666, 0x9999, 0x9999, 0xFFFF },
{ 0x6666, 0x9999, 0x6666, 0xFFFF },
{ 0x6666, 0x9999, 0x3333, 0xFFFF },
{ 0x6666, 0x9999, 0x0000, 0xFFFF },
{ 0x6666, 0x6666, 0xFFFF, 0xFFFF },
{ 0x6666, 0x6666, 0xCCCC, 0xFFFF },
{ 0x6666, 0x6666, 0x9999, 0xFFFF },
{ 0x6666, 0x6666, 0x6666, 0xFFFF },
{ 0x6666, 0x6666, 0x3333, 0xFFFF },
{ 0x6666, 0x6666, 0x0000, 0xFFFF },
{ 0x6666, 0x3333, 0xFFFF, 0xFFFF },
{ 0x6666, 0x3333, 0xCCCC, 0xFFFF },
{ 0x6666, 0x3333, 0x9999, 0xFFFF },
{ 0x6666, 0x3333, 0x6666, 0xFFFF },
{ 0x6666, 0x3333, 0x3333, 0xFFFF },
{ 0x6666, 0x3333, 0x0000, 0xFFFF },
{ 0x6666, 0x0000, 0xFFFF, 0xFFFF },
{ 0x6666, 0x0000, 0xCCCC, 0xFFFF },
{ 0x6666, 0x0000, 0x9999, 0xFFFF },
{ 0x6666, 0x0000, 0x6666, 0xFFFF },
{ 0x6666, 0x0000, 0x3333, 0xFFFF },
{ 0x6666, 0x0000, 0x0000, 0xFFFF },
{ 0x3333, 0xFFFF, 0xFFFF, 0xFFFF },
{ 0x3333, 0xFFFF, 0xCCCC, 0xFFFF },
{ 0x3333, 0xFFFF, 0x9999, 0xFFFF },
{ 0x3333, 0xFFFF, 0x6666, 0xFFFF },
{ 0x3333, 0xFFFF, 0x3333, 0xFFFF },
{ 0x3333, 0xFFFF, 0x0000, 0xFFFF },
{ 0x3333, 0xCCCC, 0xFFFF, 0xFFFF },
{ 0x3333, 0xCCCC, 0xCCCC, 0xFFFF },
{ 0x3333, 0xCCCC, 0x9999, 0xFFFF },
{ 0x3333, 0xCCCC, 0x6666, 0xFFFF },
{ 0x3333, 0xCCCC, 0x3333, 0xFFFF },
{ 0x3333, 0xCCCC, 0x0000, 0xFFFF },
{ 0x3333, 0x9999, 0xFFFF, 0xFFFF },
{ 0x3333, 0x9999, 0xCCCC, 0xFFFF },
{ 0x3333, 0x9999, 0x9999, 0xFFFF },
{ 0x3333, 0x9999, 0x6666, 0xFFFF },
{ 0x3333, 0x9999, 0x3333, 0xFFFF },
{ 0x3333, 0x9999, 0x0000, 0xFFFF },
{ 0x3333, 0x6666, 0xFFFF, 0xFFFF },
{ 0x3333, 0x6666, 0xCCCC, 0xFFFF },
{ 0x3333, 0x6666, 0x9999, 0xFFFF },
{ 0x3333, 0x6666, 0x6666, 0xFFFF },
{ 0x3333, 0x6666, 0x3333, 0xFFFF },
{ 0x3333, 0x6666, 0x0000, 0xFFFF },
{ 0x3333, 0x3333, 0xFFFF, 0xFFFF },
{ 0x3333, 0x3333, 0xCCCC, 0xFFFF },
{ 0x3333, 0x3333, 0x9999, 0xFFFF },
{ 0x3333, 0x3333, 0x6666, 0xFFFF },
{ 0x3333, 0x3333, 0x3333, 0xFFFF },
{ 0x3333, 0x3333, 0x0000, 0xFFFF },
{ 0x3333, 0x0000, 0xFFFF, 0xFFFF },
{ 0x3333, 0x0000, 0xCCCC, 0xFFFF },
{ 0x3333, 0x0000, 0x9999, 0xFFFF },
{ 0x3333, 0x0000, 0x6666, 0xFFFF },
{ 0x3333, 0x0000, 0x3333, 0xFFFF },
{ 0x3333, 0x0000, 0x0000, 0xFFFF },
{ 0x0000, 0xFFFF, 0xFFFF, 0xFFFF },
{ 0x0000, 0xFFFF, 0xCCCC, 0xFFFF },
{ 0x0000, 0xFFFF, 0x9999, 0xFFFF },
{ 0x0000, 0xFFFF, 0x6666, 0xFFFF },
{ 0x0000, 0xFFFF, 0x3333, 0xFFFF },
{ 0x0000, 0xFFFF, 0x0000, 0xFFFF },
{ 0x0000, 0xCCCC, 0xFFFF, 0xFFFF },
{ 0x0000, 0xCCCC, 0xCCCC, 0xFFFF },
{ 0x0000, 0xCCCC, 0x9999, 0xFFFF },
{ 0x0000, 0xCCCC, 0x6666, 0xFFFF },
{ 0x0000, 0xCCCC, 0x3333, 0xFFFF },
{ 0x0000, 0xCCCC, 0x0000, 0xFFFF },
{ 0x0000, 0x9999, 0xFFFF, 0xFFFF },
{ 0x0000, 0x9999, 0xCCCC, 0xFFFF },
{ 0x0000, 0x9999, 0x9999, 0xFFFF },
{ 0x0000, 0x9999, 0x6666, 0xFFFF },
{ 0x0000, 0x9999, 0x3333, 0xFFFF },
{ 0x0000, 0x9999, 0x0000, 0xFFFF },
{ 0x0000, 0x6666, 0xFFFF, 0xFFFF },
{ 0x0000, 0x6666, 0xCCCC, 0xFFFF },
{ 0x0000, 0x6666, 0x9999, 0xFFFF },
{ 0x0000, 0x6666, 0x6666, 0xFFFF },
{ 0x0000, 0x6666, 0x3333, 0xFFFF },
{ 0x0000, 0x6666, 0x0000, 0xFFFF },
{ 0x0000, 0x3333, 0xFFFF, 0xFFFF },
{ 0x0000, 0x3333, 0xCCCC, 0xFFFF },
{ 0x0000, 0x3333, 0x9999, 0xFFFF },
{ 0x0000, 0x3333, 0x6666, 0xFFFF },
{ 0x0000, 0x3333, 0x3333, 0xFFFF },
{ 0x0000, 0x3333, 0x0000, 0xFFFF },
{ 0x0000, 0x0000, 0xFFFF, 0xFFFF },
{ 0x0000, 0x0000, 0xCCCC, 0xFFFF },
{ 0x0000, 0x0000, 0x9999, 0xFFFF },
{ 0x0000, 0x0000, 0x6666, 0xFFFF },
{ 0x0000, 0x0000, 0x3333, 0xFFFF },
{ 0xEEEE, 0x0000, 0x0000, 0xFFFF },
{ 0xDDDD, 0x0000, 0x0000, 0xFFFF },
{ 0xBBBB, 0x0000, 0x0000, 0xFFFF },
{ 0xAAAA, 0x0000, 0x0000, 0xFFFF },
{ 0x8888, 0x0000, 0x0000, 0xFFFF },
{ 0x7777, 0x0000, 0x0000, 0xFFFF },
{ 0x5555, 0x0000, 0x0000, 0xFFFF },
{ 0x4444, 0x0000, 0x0000, 0xFFFF },
{ 0x2222, 0x0000, 0x0000, 0xFFFF },
{ 0x1111, 0x0000, 0x0000, 0xFFFF },
{ 0x0000, 0xEEEE, 0x0000, 0xFFFF },
{ 0x0000, 0xDDDD, 0x0000, 0xFFFF },
{ 0x0000, 0xBBBB, 0x0000, 0xFFFF },
{ 0x0000, 0xAAAA, 0x0000, 0xFFFF },
{ 0x0000, 0x8888, 0x0000, 0xFFFF },
{ 0x0000, 0x7777, 0x0000, 0xFFFF },
{ 0x0000, 0x5555, 0x0000, 0xFFFF },
{ 0x0000, 0x4444, 0x0000, 0xFFFF },
{ 0x0000, 0x2222, 0x0000, 0xFFFF },
{ 0x0000, 0x1111, 0x0000, 0xFFFF },
{ 0x0000, 0x0000, 0xEEEE, 0xFFFF },
{ 0x0000, 0x0000, 0xDDDD, 0xFFFF },
{ 0x0000, 0x0000, 0xBBBB, 0xFFFF },
{ 0x0000, 0x0000, 0xAAAA, 0xFFFF },
{ 0x0000, 0x0000, 0x8888, 0xFFFF },
{ 0x0000, 0x0000, 0x7777, 0xFFFF },
{ 0x0000, 0x0000, 0x5555, 0xFFFF },
{ 0x0000, 0x0000, 0x4444, 0xFFFF },
{ 0x0000, 0x0000, 0x2222, 0xFFFF },
{ 0x0000, 0x0000, 0x1111, 0xFFFF },
{ 0xEEEE, 0xEEEE, 0xEEEE, 0xFFFF },
{ 0xDDDD, 0xDDDD, 0xDDDD, 0xFFFF },
{ 0xBBBB, 0xBBBB, 0xBBBB, 0xFFFF },
{ 0xAAAA, 0xAAAA, 0xAAAA, 0xFFFF },
{ 0x8888, 0x8888, 0x8888, 0xFFFF },
{ 0x7777, 0x7777, 0x7777, 0xFFFF },
{ 0x5555, 0x5555, 0x5555, 0xFFFF },
{ 0x4444, 0x4444, 0x4444, 0xFFFF },
{ 0x2222, 0x2222, 0x2222, 0xFFFF },
{ 0x1111, 0x1111, 0x1111, 0xFFFF },
{ 0x0000, 0x0000, 0x0000, 0xFFFF }
};

const bgav_palette_entry_t bgav_qt_default_palette_4_gray[] = {
 { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF },
 { 0xAAAA, 0xAAAA, 0xAAAA, 0xFFFF },
 { 0x5555, 0x5555, 0x5555, 0xFFFF },
 { 0x0000, 0x0000, 0x0000, 0xFFFF },
};

const bgav_palette_entry_t bgav_qt_default_palette_16_gray[] = {
 { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF },
 { 0xEEEE, 0xEEEE, 0xEEEE, 0xFFFF },
 { 0xDDDD, 0xDDDD, 0xDDDD, 0xFFFF },
 { 0xCCCC, 0xCCCC, 0xCCCC, 0xFFFF },
 { 0xBBBB, 0xBBBB, 0xBBBB, 0xFFFF },
 { 0xAAAA, 0xAAAA, 0xAAAA, 0xFFFF },
 { 0x9999, 0x9999, 0x9999, 0xFFFF },
 { 0x8888, 0x8888, 0x8888, 0xFFFF },
 { 0x7777, 0x7777, 0x7777, 0xFFFF },
 { 0x6666, 0x6666, 0x6666, 0xFFFF },
 { 0x5555, 0x5555, 0x5555, 0xFFFF },
 { 0x4444, 0x4444, 0x4444, 0xFFFF },
 { 0x3333, 0x3333, 0x3333, 0xFFFF },
 { 0x2222, 0x2222, 0x2222, 0xFFFF },
 { 0x1111, 0x1111, 0x1111, 0xFFFF },
 { 0x0000, 0x0000, 0x0000, 0xFFFF },
};

const bgav_palette_entry_t bgav_qt_default_palette_256_gray[] = {
 { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF },
 { 0xFEFE, 0xFEFE, 0xFEFE, 0xFFFF },
 { 0xFDFD, 0xFDFD, 0xFDFD, 0xFFFF },
 { 0xFCFC, 0xFCFC, 0xFCFC, 0xFFFF },
 { 0xFBFB, 0xFBFB, 0xFBFB, 0xFFFF },
 { 0xFAFA, 0xFAFA, 0xFAFA, 0xFFFF },
 { 0xF9F9, 0xF9F9, 0xF9F9, 0xFFFF },
 { 0xF8F8, 0xF8F8, 0xF8F8, 0xFFFF },
 { 0xF7F7, 0xF7F7, 0xF7F7, 0xFFFF },
 { 0xF6F6, 0xF6F6, 0xF6F6, 0xFFFF },
 { 0xF5F5, 0xF5F5, 0xF5F5, 0xFFFF },
 { 0xF4F4, 0xF4F4, 0xF4F4, 0xFFFF },
 { 0xF3F3, 0xF3F3, 0xF3F3, 0xFFFF },
 { 0xF2F2, 0xF2F2, 0xF2F2, 0xFFFF },
 { 0xF1F1, 0xF1F1, 0xF1F1, 0xFFFF },
 { 0xF0F0, 0xF0F0, 0xF0F0, 0xFFFF },
 { 0xEFEF, 0xEFEF, 0xEFEF, 0xFFFF },
 { 0xEEEE, 0xEEEE, 0xEEEE, 0xFFFF },
 { 0xEDED, 0xEDED, 0xEDED, 0xFFFF },
 { 0xECEC, 0xECEC, 0xECEC, 0xFFFF },
 { 0xEBEB, 0xEBEB, 0xEBEB, 0xFFFF },
 { 0xEAEA, 0xEAEA, 0xEAEA, 0xFFFF },
 { 0xE9E9, 0xE9E9, 0xE9E9, 0xFFFF },
 { 0xE8E8, 0xE8E8, 0xE8E8, 0xFFFF },
 { 0xE7E7, 0xE7E7, 0xE7E7, 0xFFFF },
 { 0xE6E6, 0xE6E6, 0xE6E6, 0xFFFF },
 { 0xE5E5, 0xE5E5, 0xE5E5, 0xFFFF },
 { 0xE4E4, 0xE4E4, 0xE4E4, 0xFFFF },
 { 0xE3E3, 0xE3E3, 0xE3E3, 0xFFFF },
 { 0xE2E2, 0xE2E2, 0xE2E2, 0xFFFF },
 { 0xE1E1, 0xE1E1, 0xE1E1, 0xFFFF },
 { 0xE0E0, 0xE0E0, 0xE0E0, 0xFFFF },
 { 0xDFDF, 0xDFDF, 0xDFDF, 0xFFFF },
 { 0xDEDE, 0xDEDE, 0xDEDE, 0xFFFF },
 { 0xDDDD, 0xDDDD, 0xDDDD, 0xFFFF },
 { 0xDCDC, 0xDCDC, 0xDCDC, 0xFFFF },
 { 0xDBDB, 0xDBDB, 0xDBDB, 0xFFFF },
 { 0xDADA, 0xDADA, 0xDADA, 0xFFFF },
 { 0xD9D9, 0xD9D9, 0xD9D9, 0xFFFF },
 { 0xD8D8, 0xD8D8, 0xD8D8, 0xFFFF },
 { 0xD7D7, 0xD7D7, 0xD7D7, 0xFFFF },
 { 0xD6D6, 0xD6D6, 0xD6D6, 0xFFFF },
 { 0xD5D5, 0xD5D5, 0xD5D5, 0xFFFF },
 { 0xD4D4, 0xD4D4, 0xD4D4, 0xFFFF },
 { 0xD3D3, 0xD3D3, 0xD3D3, 0xFFFF },
 { 0xD2D2, 0xD2D2, 0xD2D2, 0xFFFF },
 { 0xD1D1, 0xD1D1, 0xD1D1, 0xFFFF },
 { 0xD0D0, 0xD0D0, 0xD0D0, 0xFFFF },
 { 0xCFCF, 0xCFCF, 0xCFCF, 0xFFFF },
 { 0xCECE, 0xCECE, 0xCECE, 0xFFFF },
 { 0xCDCD, 0xCDCD, 0xCDCD, 0xFFFF },
 { 0xCCCC, 0xCCCC, 0xCCCC, 0xFFFF },
 { 0xCBCB, 0xCBCB, 0xCBCB, 0xFFFF },
 { 0xCACA, 0xCACA, 0xCACA, 0xFFFF },
 { 0xC9C9, 0xC9C9, 0xC9C9, 0xFFFF },
 { 0xC8C8, 0xC8C8, 0xC8C8, 0xFFFF },
 { 0xC7C7, 0xC7C7, 0xC7C7, 0xFFFF },
 { 0xC6C6, 0xC6C6, 0xC6C6, 0xFFFF },
 { 0xC5C5, 0xC5C5, 0xC5C5, 0xFFFF },
 { 0xC4C4, 0xC4C4, 0xC4C4, 0xFFFF },
 { 0xC3C3, 0xC3C3, 0xC3C3, 0xFFFF },
 { 0xC2C2, 0xC2C2, 0xC2C2, 0xFFFF },
 { 0xC1C1, 0xC1C1, 0xC1C1, 0xFFFF },
 { 0xC0C0, 0xC0C0, 0xC0C0, 0xFFFF },
 { 0xBFBF, 0xBFBF, 0xBFBF, 0xFFFF },
 { 0xBEBE, 0xBEBE, 0xBEBE, 0xFFFF },
 { 0xBDBD, 0xBDBD, 0xBDBD, 0xFFFF },
 { 0xBCBC, 0xBCBC, 0xBCBC, 0xFFFF },
 { 0xBBBB, 0xBBBB, 0xBBBB, 0xFFFF },
 { 0xBABA, 0xBABA, 0xBABA, 0xFFFF },
 { 0xB9B9, 0xB9B9, 0xB9B9, 0xFFFF },
 { 0xB8B8, 0xB8B8, 0xB8B8, 0xFFFF },
 { 0xB7B7, 0xB7B7, 0xB7B7, 0xFFFF },
 { 0xB6B6, 0xB6B6, 0xB6B6, 0xFFFF },
 { 0xB5B5, 0xB5B5, 0xB5B5, 0xFFFF },
 { 0xB4B4, 0xB4B4, 0xB4B4, 0xFFFF },
 { 0xB3B3, 0xB3B3, 0xB3B3, 0xFFFF },
 { 0xB2B2, 0xB2B2, 0xB2B2, 0xFFFF },
 { 0xB1B1, 0xB1B1, 0xB1B1, 0xFFFF },
 { 0xB0B0, 0xB0B0, 0xB0B0, 0xFFFF },
 { 0xAFAF, 0xAFAF, 0xAFAF, 0xFFFF },
 { 0xAEAE, 0xAEAE, 0xAEAE, 0xFFFF },
 { 0xADAD, 0xADAD, 0xADAD, 0xFFFF },
 { 0xACAC, 0xACAC, 0xACAC, 0xFFFF },
 { 0xABAB, 0xABAB, 0xABAB, 0xFFFF },
 { 0xAAAA, 0xAAAA, 0xAAAA, 0xFFFF },
 { 0xA9A9, 0xA9A9, 0xA9A9, 0xFFFF },
 { 0xA8A8, 0xA8A8, 0xA8A8, 0xFFFF },
 { 0xA7A7, 0xA7A7, 0xA7A7, 0xFFFF },
 { 0xA6A6, 0xA6A6, 0xA6A6, 0xFFFF },
 { 0xA5A5, 0xA5A5, 0xA5A5, 0xFFFF },
 { 0xA4A4, 0xA4A4, 0xA4A4, 0xFFFF },
 { 0xA3A3, 0xA3A3, 0xA3A3, 0xFFFF },
 { 0xA2A2, 0xA2A2, 0xA2A2, 0xFFFF },
 { 0xA1A1, 0xA1A1, 0xA1A1, 0xFFFF },
 { 0xA0A0, 0xA0A0, 0xA0A0, 0xFFFF },
 { 0x9F9F, 0x9F9F, 0x9F9F, 0xFFFF },
 { 0x9E9E, 0x9E9E, 0x9E9E, 0xFFFF },
 { 0x9D9D, 0x9D9D, 0x9D9D, 0xFFFF },
 { 0x9C9C, 0x9C9C, 0x9C9C, 0xFFFF },
 { 0x9B9B, 0x9B9B, 0x9B9B, 0xFFFF },
 { 0x9A9A, 0x9A9A, 0x9A9A, 0xFFFF },
 { 0x9999, 0x9999, 0x9999, 0xFFFF },
 { 0x9898, 0x9898, 0x9898, 0xFFFF },
 { 0x9797, 0x9797, 0x9797, 0xFFFF },
 { 0x9696, 0x9696, 0x9696, 0xFFFF },
 { 0x9595, 0x9595, 0x9595, 0xFFFF },
 { 0x9494, 0x9494, 0x9494, 0xFFFF },
 { 0x9393, 0x9393, 0x9393, 0xFFFF },
 { 0x9292, 0x9292, 0x9292, 0xFFFF },
 { 0x9191, 0x9191, 0x9191, 0xFFFF },
 { 0x9090, 0x9090, 0x9090, 0xFFFF },
 { 0x8F8F, 0x8F8F, 0x8F8F, 0xFFFF },
 { 0x8E8E, 0x8E8E, 0x8E8E, 0xFFFF },
 { 0x8D8D, 0x8D8D, 0x8D8D, 0xFFFF },
 { 0x8C8C, 0x8C8C, 0x8C8C, 0xFFFF },
 { 0x8B8B, 0x8B8B, 0x8B8B, 0xFFFF },
 { 0x8A8A, 0x8A8A, 0x8A8A, 0xFFFF },
 { 0x8989, 0x8989, 0x8989, 0xFFFF },
 { 0x8888, 0x8888, 0x8888, 0xFFFF },
 { 0x8787, 0x8787, 0x8787, 0xFFFF },
 { 0x8686, 0x8686, 0x8686, 0xFFFF },
 { 0x8585, 0x8585, 0x8585, 0xFFFF },
 { 0x8484, 0x8484, 0x8484, 0xFFFF },
 { 0x8383, 0x8383, 0x8383, 0xFFFF },
 { 0x8282, 0x8282, 0x8282, 0xFFFF },
 { 0x8181, 0x8181, 0x8181, 0xFFFF },
 { 0x8080, 0x8080, 0x8080, 0xFFFF },
 { 0x7F7F, 0x7F7F, 0x7F7F, 0xFFFF },
 { 0x7E7E, 0x7E7E, 0x7E7E, 0xFFFF },
 { 0x7D7D, 0x7D7D, 0x7D7D, 0xFFFF },
 { 0x7C7C, 0x7C7C, 0x7C7C, 0xFFFF },
 { 0x7B7B, 0x7B7B, 0x7B7B, 0xFFFF },
 { 0x7A7A, 0x7A7A, 0x7A7A, 0xFFFF },
 { 0x7979, 0x7979, 0x7979, 0xFFFF },
 { 0x7878, 0x7878, 0x7878, 0xFFFF },
 { 0x7777, 0x7777, 0x7777, 0xFFFF },
 { 0x7676, 0x7676, 0x7676, 0xFFFF },
 { 0x7575, 0x7575, 0x7575, 0xFFFF },
 { 0x7474, 0x7474, 0x7474, 0xFFFF },
 { 0x7373, 0x7373, 0x7373, 0xFFFF },
 { 0x7272, 0x7272, 0x7272, 0xFFFF },
 { 0x7171, 0x7171, 0x7171, 0xFFFF },
 { 0x7070, 0x7070, 0x7070, 0xFFFF },
 { 0x6F6F, 0x6F6F, 0x6F6F, 0xFFFF },
 { 0x6E6E, 0x6E6E, 0x6E6E, 0xFFFF },
 { 0x6D6D, 0x6D6D, 0x6D6D, 0xFFFF },
 { 0x6C6C, 0x6C6C, 0x6C6C, 0xFFFF },
 { 0x6B6B, 0x6B6B, 0x6B6B, 0xFFFF },
 { 0x6A6A, 0x6A6A, 0x6A6A, 0xFFFF },
 { 0x6969, 0x6969, 0x6969, 0xFFFF },
 { 0x6868, 0x6868, 0x6868, 0xFFFF },
 { 0x6767, 0x6767, 0x6767, 0xFFFF },
 { 0x6666, 0x6666, 0x6666, 0xFFFF },
 { 0x6565, 0x6565, 0x6565, 0xFFFF },
 { 0x6464, 0x6464, 0x6464, 0xFFFF },
 { 0x6363, 0x6363, 0x6363, 0xFFFF },
 { 0x6262, 0x6262, 0x6262, 0xFFFF },
 { 0x6161, 0x6161, 0x6161, 0xFFFF },
 { 0x6060, 0x6060, 0x6060, 0xFFFF },
 { 0x5F5F, 0x5F5F, 0x5F5F, 0xFFFF },
 { 0x5E5E, 0x5E5E, 0x5E5E, 0xFFFF },
 { 0x5D5D, 0x5D5D, 0x5D5D, 0xFFFF },
 { 0x5C5C, 0x5C5C, 0x5C5C, 0xFFFF },
 { 0x5B5B, 0x5B5B, 0x5B5B, 0xFFFF },
 { 0x5A5A, 0x5A5A, 0x5A5A, 0xFFFF },
 { 0x5959, 0x5959, 0x5959, 0xFFFF },
 { 0x5858, 0x5858, 0x5858, 0xFFFF },
 { 0x5757, 0x5757, 0x5757, 0xFFFF },
 { 0x5656, 0x5656, 0x5656, 0xFFFF },
 { 0x5555, 0x5555, 0x5555, 0xFFFF },
 { 0x5454, 0x5454, 0x5454, 0xFFFF },
 { 0x5353, 0x5353, 0x5353, 0xFFFF },
 { 0x5252, 0x5252, 0x5252, 0xFFFF },
 { 0x5151, 0x5151, 0x5151, 0xFFFF },
 { 0x5050, 0x5050, 0x5050, 0xFFFF },
 { 0x4F4F, 0x4F4F, 0x4F4F, 0xFFFF },
 { 0x4E4E, 0x4E4E, 0x4E4E, 0xFFFF },
 { 0x4D4D, 0x4D4D, 0x4D4D, 0xFFFF },
 { 0x4C4C, 0x4C4C, 0x4C4C, 0xFFFF },
 { 0x4B4B, 0x4B4B, 0x4B4B, 0xFFFF },
 { 0x4A4A, 0x4A4A, 0x4A4A, 0xFFFF },
 { 0x4949, 0x4949, 0x4949, 0xFFFF },
 { 0x4848, 0x4848, 0x4848, 0xFFFF },
 { 0x4747, 0x4747, 0x4747, 0xFFFF },
 { 0x4646, 0x4646, 0x4646, 0xFFFF },
 { 0x4545, 0x4545, 0x4545, 0xFFFF },
 { 0x4444, 0x4444, 0x4444, 0xFFFF },
 { 0x4343, 0x4343, 0x4343, 0xFFFF },
 { 0x4242, 0x4242, 0x4242, 0xFFFF },
 { 0x4141, 0x4141, 0x4141, 0xFFFF },
 { 0x4040, 0x4040, 0x4040, 0xFFFF },
 { 0x3F3F, 0x3F3F, 0x3F3F, 0xFFFF },
 { 0x3E3E, 0x3E3E, 0x3E3E, 0xFFFF },
 { 0x3D3D, 0x3D3D, 0x3D3D, 0xFFFF },
 { 0x3C3C, 0x3C3C, 0x3C3C, 0xFFFF },
 { 0x3B3B, 0x3B3B, 0x3B3B, 0xFFFF },
 { 0x3A3A, 0x3A3A, 0x3A3A, 0xFFFF },
 { 0x3939, 0x3939, 0x3939, 0xFFFF },
 { 0x3838, 0x3838, 0x3838, 0xFFFF },
 { 0x3737, 0x3737, 0x3737, 0xFFFF },
 { 0x3636, 0x3636, 0x3636, 0xFFFF },
 { 0x3535, 0x3535, 0x3535, 0xFFFF },
 { 0x3434, 0x3434, 0x3434, 0xFFFF },
 { 0x3333, 0x3333, 0x3333, 0xFFFF },
 { 0x3232, 0x3232, 0x3232, 0xFFFF },
 { 0x3131, 0x3131, 0x3131, 0xFFFF },
 { 0x3030, 0x3030, 0x3030, 0xFFFF },
 { 0x2F2F, 0x2F2F, 0x2F2F, 0xFFFF },
 { 0x2E2E, 0x2E2E, 0x2E2E, 0xFFFF },
 { 0x2D2D, 0x2D2D, 0x2D2D, 0xFFFF },
 { 0x2C2C, 0x2C2C, 0x2C2C, 0xFFFF },
 { 0x2B2B, 0x2B2B, 0x2B2B, 0xFFFF },
 { 0x2A2A, 0x2A2A, 0x2A2A, 0xFFFF },
 { 0x2929, 0x2929, 0x2929, 0xFFFF },
 { 0x2828, 0x2828, 0x2828, 0xFFFF },
 { 0x2727, 0x2727, 0x2727, 0xFFFF },
 { 0x2626, 0x2626, 0x2626, 0xFFFF },
 { 0x2525, 0x2525, 0x2525, 0xFFFF },
 { 0x2424, 0x2424, 0x2424, 0xFFFF },
 { 0x2323, 0x2323, 0x2323, 0xFFFF },
 { 0x2222, 0x2222, 0x2222, 0xFFFF },
 { 0x2121, 0x2121, 0x2121, 0xFFFF },
 { 0x2020, 0x2020, 0x2020, 0xFFFF },
 { 0x1F1F, 0x1F1F, 0x1F1F, 0xFFFF },
 { 0x1E1E, 0x1E1E, 0x1E1E, 0xFFFF },
 { 0x1D1D, 0x1D1D, 0x1D1D, 0xFFFF },
 { 0x1C1C, 0x1C1C, 0x1C1C, 0xFFFF },
 { 0x1B1B, 0x1B1B, 0x1B1B, 0xFFFF },
 { 0x1A1A, 0x1A1A, 0x1A1A, 0xFFFF },
 { 0x1919, 0x1919, 0x1919, 0xFFFF },
 { 0x1818, 0x1818, 0x1818, 0xFFFF },
 { 0x1717, 0x1717, 0x1717, 0xFFFF },
 { 0x1616, 0x1616, 0x1616, 0xFFFF },
 { 0x1515, 0x1515, 0x1515, 0xFFFF },
 { 0x1414, 0x1414, 0x1414, 0xFFFF },
 { 0x1313, 0x1313, 0x1313, 0xFFFF },
 { 0x1212, 0x1212, 0x1212, 0xFFFF },
 { 0x1111, 0x1111, 0x1111, 0xFFFF },
 { 0x1010, 0x1010, 0x1010, 0xFFFF },
 { 0x0F0F, 0x0F0F, 0x0F0F, 0xFFFF },
 { 0x0E0E, 0x0E0E, 0x0E0E, 0xFFFF },
 { 0x0D0D, 0x0D0D, 0x0D0D, 0xFFFF },
 { 0x0C0C, 0x0C0C, 0x0C0C, 0xFFFF },
 { 0x0B0B, 0x0B0B, 0x0B0B, 0xFFFF },
 { 0x0A0A, 0x0A0A, 0x0A0A, 0xFFFF },
 { 0x0909, 0x0909, 0x0909, 0xFFFF },
 { 0x0808, 0x0808, 0x0808, 0xFFFF },
 { 0x0707, 0x0707, 0x0707, 0xFFFF },
 { 0x0606, 0x0606, 0x0606, 0xFFFF },
 { 0x0505, 0x0505, 0x0505, 0xFFFF },
 { 0x0404, 0x0404, 0x0404, 0xFFFF },
 { 0x0303, 0x0303, 0x0303, 0xFFFF },
 { 0x0202, 0x0202, 0x0202, 0xFFFF },
 { 0x0101, 0x0101, 0x0101, 0xFFFF },
 { 0x0000, 0x0000, 0x0000, 0xFFFF },
};

