/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * Definitions for RLI data used by LRC for LRC -> RLI updates.
 */

/* The function declaration should be as void *function_name (void *arg)
This is required by the pthread_create routine. */

extern void *lrc_init(void*);

/* the original declaration of the lrc_init function has three args. But none of
them were needed to be passed as all the three were extern variables. However
to preserve the old declaration of lrc_init, declare a structure with elements
db_name, db_user and db_passwd. */

extern void	lrc_end();
extern void	lrc_getbf(void *lrch);
void		lrc_updatenow();
extern globus_bool_t is_lrc_init_done();

typedef struct lrc_init_args_s {
  char *dbname;
  char *db_user;
  char *db_pwd;
} lrc_init_args_t;
