// ==========================================================================
// file: givadicqfq.C
// Copyright(c)'1994-2009 by The Givaro group
// This file is part of Givaro.
// Givaro is governed by the CeCILL-B license under French law
// and abiding by the rules of distribution of free software.
// see the COPYRIGHT file for more details.
// Time-stamp: <11 Jun 07 18:20:54 Jean-Guillaume.Dumas@imag.fr>
// author: Jean-Guillaume.Dumas
// Description:
//   t-adic max sizes for BLAS based linear algebra over extension fields
// see:
// [Dumas, Gautier, Pernet 2002] Finite field linear algebra subroutines.
// ISSAC'02: Proceedings of the 2002 International Symposium on Symbolic
// and Algebraic Computation, Lille, France pp 63--74.
// ==========================================================================
#include "givaro/givtablelimits.h"

namespace Givaro {

const size_t AdicSize::n_max_53[][_GIVARO_FF_MAXEXPONENT_] = {
/* 2 */ {  104028, 517, 47, 11, 4, 2, 1},
/* 3 */ {  26007, 129, 11, 2, 1},
/* 5 */ {  6501, 32, 2},
/* 7 */ {  2889, 14, 1},
/* 11 */ {  1040, 5},
/* 13 */ {  722, 3},
/* 17 */ {  406, 2},
/* 19 */ {  321, 1},
/* 23 */ {  214, 1},
/* 29 */ {  132},
/* 31 */ {  115},
/* 37 */ {  80},
/* 41 */ {  65},
/* 43 */ {  58},
/* 47 */ {  49},
/* 53 */ {  38},
/* 59 */ {  30},
/* 61 */ {  28},
/* 67 */ {  23},
/* 71 */ {  21},
/* 73 */ {  20},
/* 79 */ {  17},
/* 83 */ {  15},
/* 89 */ {  13},
/* 97 */ {  11},
/* 101 */ {  10},
/* 103 */ {  9},
/* 107 */ {  9},
/* 109 */ {  8},
/* 113 */ {  8},
/* 127 */ {  6},
/* 131 */ {  6},
/* 137 */ {  5},
/* 139 */ {  5},
/* 149 */ {  4},
/* 151 */ {  4},
/* 157 */ {  4},
/* 163 */ {  3},
/* 167 */ {  3},
/* 173 */ {  3},
/* 179 */ {  3},
/* 181 */ {  3},
/* 191 */ {  2},
/* 193 */ {  2},
/* 197 */ {  2},
/* 199 */ {  2},
/* 211 */ {  2},
/* 223 */ {  2},
/* 227 */ {  2},
/* 229 */ {  2},
/* 233 */ {  1},
/* 239 */ {  1},
/* 241 */ {  1},
/* 251 */ {  1},
/* 257 */ {  1},
/* 263 */ {  1},
/* 269 */ {  1},
/* 271 */ {  1},
/* 277 */ {  1},
/* 281 */ {  1},
/* 283 */ {  1},
/* 293 */ {  1},
/* 307 */ {  1},
/* 311 */ {  1},
/* 313 */ {  1},
/* 317 */ {  1}
};

const size_t AdicSize::qadic_53[][_GIVARO_FF_MAXEXPONENT_] = {
/* 2 */ {  208057, 1553, 191, 59, 29, 17, 11},
/* 3 */ {  208057, 1549, 179, 41, 29},
/* 5 */ {  208037, 1543, 131},
/* 7 */ {  208009, 1523, 149},
/* 11 */ {  208001, 1511},
/* 13 */ {  207941, 1297},
/* 17 */ {  207877, 1543},
/* 19 */ {  208009, 977},
/* 23 */ {  207169, 1453},
/* 29 */ {  206993},
/* 31 */ {  207013},
/* 37 */ {  207367},
/* 41 */ {  208001},
/* 43 */ {  204641},
/* 47 */ {  207371},
/* 53 */ {  205507},
/* 59 */ {  201847},
/* 61 */ {  201611},
/* 67 */ {  200381},
/* 71 */ {  205817},
/* 73 */ {  207367},
/* 79 */ {  206879},
/* 83 */ {  201731},
/* 89 */ {  201359},
/* 97 */ {  202753},
/* 101 */ {  200003},
/* 103 */ {  187273},
/* 107 */ {  202277},
/* 109 */ {  186629},
/* 113 */ {  200713},
/* 127 */ {  190523},
/* 131 */ {  202817},
/* 137 */ {  184967},
/* 139 */ {  190471},
/* 149 */ {  175261},
/* 151 */ {  180001},
/* 157 */ {  194707},
/* 163 */ {  157477},
/* 167 */ {  165343},
/* 173 */ {  177511},
/* 179 */ {  190121},
/* 181 */ {  194413},
/* 191 */ {  144407},
/* 193 */ {  147457},
/* 197 */ {  153689},
/* 199 */ {  156817},
/* 211 */ {  176401},
/* 223 */ {  197137},
/* 227 */ {  204311},
/* 229 */ {  207941},
/* 233 */ {  107671},
/* 239 */ {  113327},
/* 241 */ {  115201},
/* 251 */ {  125003},
/* 257 */ {  131101},
/* 263 */ {  137303},
/* 269 */ {  143651},
/* 271 */ {  145807},
/* 277 */ {  152363},
/* 281 */ {  156817},
/* 283 */ {  159059},
/* 293 */ {  170537},
/* 307 */ {  187273},
/* 311 */ {  192229},
/* 313 */ {  194707},
/* 317 */ {  199721}
};


const size_t AdicSize::n_max_64[][_GIVARO_FF_MAXEXPONENT_] = {
/* 2 */ {  1321119, 2376, 140, 27, 8, 4, 2, 1, 1},
/* 3 */ {  330279, 594, 35, 6, 2, 1},
/* 5 */ {  82569, 148, 8, 1},
/* 7 */ {  36697, 66, 3},
/* 11 */ {  13211, 23, 1},
/* 13 */ {  9174, 16},
/* 17 */ {  5160, 9},
/* 19 */ {  4077, 7},
/* 23 */ {  2729, 4},
/* 29 */ {  1685, 3},
/* 31 */ {  1467, 2},
/* 37 */ {  1019, 1},
/* 41 */ {  825, 1},
/* 43 */ {  748, 1},
/* 47 */ {  624, 1},
/* 53 */ {  488},
/* 59 */ {  392},
/* 61 */ {  366},
/* 67 */ {  303},
/* 71 */ {  269},
/* 73 */ {  254},
/* 79 */ {  217},
/* 83 */ {  196},
/* 89 */ {  170},
/* 97 */ {  143},
/* 101 */ {  132},
/* 103 */ {  126},
/* 107 */ {  117},
/* 109 */ {  113},
/* 113 */ {  105},
/* 127 */ {  83},
/* 131 */ {  78},
/* 137 */ {  71},
/* 139 */ {  69},
/* 149 */ {  60},
/* 151 */ {  58},
/* 157 */ {  54},
/* 163 */ {  50},
/* 167 */ {  47},
/* 173 */ {  44},
/* 179 */ {  41},
/* 181 */ {  40},
/* 191 */ {  36},
/* 193 */ {  35},
/* 197 */ {  34},
/* 199 */ {  33},
/* 211 */ {  29},
/* 223 */ {  26},
/* 227 */ {  25},
/* 229 */ {  25},
/* 233 */ {  24},
/* 239 */ {  23},
/* 241 */ {  22},
/* 251 */ {  21},
/* 257 */ {  20},
/* 263 */ {  19},
/* 269 */ {  18},
/* 271 */ {  18},
/* 277 */ {  17},
/* 281 */ {  16},
/* 283 */ {  16},
/* 293 */ {  15},
/* 307 */ {  14},
/* 311 */ {  13},
/* 313 */ {  13},
/* 317 */ {  13},
/* 331 */ {  12},
/* 337 */ {  11},
/* 347 */ {  11},
/* 349 */ {  10},
/* 353 */ {  10},
/* 359 */ {  10},
/* 367 */ {  9},
/* 373 */ {  9},
/* 379 */ {  9},
/* 383 */ {  9},
/* 389 */ {  8},
/* 397 */ {  8},
/* 401 */ {  8},
/* 409 */ {  7},
/* 419 */ {  7},
/* 421 */ {  7},
/* 431 */ {  7},
/* 433 */ {  7},
/* 439 */ {  6},
/* 443 */ {  6},
/* 449 */ {  6},
/* 457 */ {  6},
/* 461 */ {  6},
/* 463 */ {  6},
/* 467 */ {  6},
/* 479 */ {  5},
/* 487 */ {  5},
/* 491 */ {  5},
/* 499 */ {  5},
/* 503 */ {  5},
/* 509 */ {  5},
/* 521 */ {  4},
/* 523 */ {  4},
/* 541 */ {  4},
/* 547 */ {  4},
/* 557 */ {  4},
/* 563 */ {  4},
/* 569 */ {  4},
/* 571 */ {  4},
/* 577 */ {  3},
/* 587 */ {  3},
/* 593 */ {  3},
/* 599 */ {  3},
/* 601 */ {  3},
/* 607 */ {  3},
/* 613 */ {  3},
/* 617 */ {  3},
/* 619 */ {  3},
/* 631 */ {  3},
/* 641 */ {  3},
/* 643 */ {  3},
/* 647 */ {  3},
/* 653 */ {  3},
/* 659 */ {  3},
/* 661 */ {  3},
/* 673 */ {  2},
/* 677 */ {  2},
/* 683 */ {  2},
/* 691 */ {  2},
/* 701 */ {  2},
/* 709 */ {  2},
/* 719 */ {  2},
/* 727 */ {  2},
/* 733 */ {  2},
/* 739 */ {  2},
/* 743 */ {  2},
/* 751 */ {  2},
/* 757 */ {  2},
/* 761 */ {  2},
/* 769 */ {  2},
/* 773 */ {  2},
/* 787 */ {  2},
/* 797 */ {  2},
/* 809 */ {  2},
/* 811 */ {  2},
/* 821 */ {  1},
/* 823 */ {  1},
/* 827 */ {  1},
/* 829 */ {  1},
/* 839 */ {  1},
/* 853 */ {  1},
/* 857 */ {  1},
/* 859 */ {  1},
/* 863 */ {  1},
/* 877 */ {  1},
/* 881 */ {  1},
/* 883 */ {  1},
/* 887 */ {  1},
/* 907 */ {  1},
/* 911 */ {  1},
/* 919 */ {  1},
/* 929 */ {  1},
/* 937 */ {  1},
/* 941 */ {  1},
/* 947 */ {  1},
/* 953 */ {  1},
/* 967 */ {  1},
/* 971 */ {  1},
/* 977 */ {  1},
/* 983 */ {  1},
/* 991 */ {  1},
/* 997 */ {  1},
/* 1009 */ {  1},
/* 1013 */ {  1},
/* 1019 */ {  1},
/* 1021 */ {  1},
/* 1031 */ {  1},
/* 1033 */ {  1},
/* 1039 */ {  1},
/* 1049 */ {  1},
/* 1051 */ {  1},
/* 1061 */ {  1},
/* 1063 */ {  1},
/* 1069 */ {  1},
/* 1087 */ {  1},
/* 1091 */ {  1},
/* 1093 */ {  1},
/* 1097 */ {  1},
/* 1103 */ {  1},
/* 1109 */ {  1},
/* 1117 */ {  1},
/* 1123 */ {  1},
/* 1129 */ {  1}
};

const size_t AdicSize::qadic_64[][_GIVARO_FF_MAXEXPONENT_] = {
/* 2 */ {  2642239, 7129, 563, 137, 53, 29, 17, 11, 11},
/* 3 */ {  2642239, 7129, 563, 127, 53, 29},
/* 5 */ {  2642231, 7109, 521, 83},
/* 7 */ {  2642201, 7129, 433},
/* 11 */ {  2642201, 6907, 401},
/* 13 */ {  2642117, 6917},
/* 17 */ {  2641921, 6917},
/* 19 */ {  2641901, 6823},
/* 23 */ {  2641687, 5813},
/* 29 */ {  2642111, 7057},
/* 31 */ {  2640643, 5407},
/* 37 */ {  2641277, 3889},
/* 41 */ {  2640013, 4801},
/* 43 */ {  2638949, 5297},
/* 47 */ {  2640779, 6353},
/* 53 */ {  2639107},
/* 59 */ {  2637379},
/* 61 */ {  2635229},
/* 67 */ {  2639759},
/* 71 */ {  2636203},
/* 73 */ {  2633473},
/* 79 */ {  2640497},
/* 83 */ {  2635819},
/* 89 */ {  2632967},
/* 97 */ {  2635783},
/* 101 */ {  2640013},
/* 103 */ {  2621819},
/* 107 */ {  2629243},
/* 109 */ {  2636077},
/* 113 */ {  2634241},
/* 127 */ {  2635429},
/* 131 */ {  2636401},
/* 137 */ {  2626433},
/* 139 */ {  2628077},
/* 149 */ {  2628481},
/* 151 */ {  2610059},
/* 157 */ {  2628331},
/* 163 */ {  2624411},
/* 167 */ {  2590271},
/* 173 */ {  2603401},
/* 179 */ {  2598091},
/* 181 */ {  2592043},
/* 191 */ {  2599217},
/* 193 */ {  2580493},
/* 197 */ {  2612297},
/* 199 */ {  2587499},
/* 211 */ {  2557813},
/* 223 */ {  2562803},
/* 227 */ {  2553823},
/* 229 */ {  2599217},
/* 233 */ {  2583557},
/* 239 */ {  2605627},
/* 241 */ {  2534401},
/* 251 */ {  2625001},
/* 257 */ {  2621447},
/* 263 */ {  2608483},
/* 269 */ {  2585707},
/* 271 */ {  2624411},
/* 277 */ {  2589991},
/* 281 */ {  2508823},
/* 283 */ {  2544769},
/* 293 */ {  2557931},
/* 307 */ {  2621819},
/* 311 */ {  2498603},
/* 313 */ {  2530961},
/* 317 */ {  2596277},
/* 331 */ {  2613601},
/* 337 */ {  2483713},
/* 347 */ {  2633783},
/* 349 */ {  2422087},
/* 353 */ {  2478083},
/* 359 */ {  2563291},
/* 367 */ {  2411209},
/* 373 */ {  2490931},
/* 379 */ {  2571937},
/* 383 */ {  2626633},
/* 389 */ {  2408723},
/* 397 */ {  2509061},
/* 401 */ {  2560021},
/* 409 */ {  2330501},
/* 419 */ {  2446139},
/* 421 */ {  2469629},
/* 431 */ {  2588611},
/* 433 */ {  2612749},
/* 439 */ {  2302151},
/* 443 */ {  2344379},
/* 449 */ {  2408501},
/* 457 */ {  2495239},
/* 461 */ {  2539213},
/* 463 */ {  2561341},
/* 467 */ {  2605909},
/* 479 */ {  2284859},
/* 487 */ {  2361977},
/* 491 */ {  2401013},
/* 499 */ {  2480053},
/* 503 */ {  2520073},
/* 509 */ {  2580647},
/* 521 */ {  2163221},
/* 523 */ {  2179897},
/* 541 */ {  2332817},
/* 547 */ {  2384951},
/* 557 */ {  2473099},
/* 563 */ {  2526763},
/* 569 */ {  2580997},
/* 571 */ {  2599217},
/* 577 */ {  1990657},
/* 587 */ {  2060389},
/* 593 */ {  2102791},
/* 599 */ {  2145629},
/* 601 */ {  2160001},
/* 607 */ {  2203427},
/* 613 */ {  2247277},
/* 617 */ {  2276737},
/* 619 */ {  2291557},
/* 631 */ {  2381413},
/* 641 */ {  2457607},
/* 643 */ {  2473019},
/* 647 */ {  2503909},
/* 653 */ {  2550641},
/* 659 */ {  2597809},
/* 661 */ {  2613601},
/* 673 */ {  1806341},
/* 677 */ {  1827929},
/* 683 */ {  1860503},
/* 691 */ {  1904407},
/* 701 */ {  1960009},
/* 709 */ {  2005057},
/* 719 */ {  2062129},
/* 727 */ {  2108317},
/* 733 */ {  2143313},
/* 739 */ {  2178581},
/* 743 */ {  2202269},
/* 751 */ {  2250013},
/* 757 */ {  2286149},
/* 761 */ {  2310421},
/* 769 */ {  2359303},
/* 773 */ {  2383943},
/* 787 */ {  2471201},
/* 797 */ {  2534471},
/* 809 */ {  2611457},
/* 811 */ {  2624411},
/* 821 */ {  1344821},
/* 823 */ {  1351373},
/* 827 */ {  1364569},
/* 829 */ {  1371179},
/* 839 */ {  1404497},
/* 853 */ {  1451831},
/* 857 */ {  1465481},
/* 859 */ {  1472333},
/* 863 */ {  1486091},
/* 877 */ {  1534783},
/* 881 */ {  1548847},
/* 883 */ {  1555861},
/* 887 */ {  1570007},
/* 907 */ {  1641709},
/* 911 */ {  1656203},
/* 919 */ {  1685449},
/* 929 */ {  1722373},
/* 937 */ {  1752193},
/* 941 */ {  1767203},
/* 947 */ {  1789849},
/* 953 */ {  1812611},
/* 967 */ {  1866331},
/* 971 */ {  1881811},
/* 977 */ {  1905157},
/* 983 */ {  1928653},
/* 991 */ {  1960201},
/* 997 */ {  1984039},
/* 1009 */ {  2032133},
/* 1013 */ {  2048327},
/* 1019 */ {  2072663},
/* 1021 */ {  2080801},
/* 1031 */ {  2121803},
/* 1033 */ {  2130061},
/* 1039 */ {  2154899},
/* 1049 */ {  2196611},
/* 1051 */ {  2205001},
/* 1061 */ {  2247209},
/* 1063 */ {  2255717},
/* 1069 */ {  2281249},
/* 1087 */ {  2358799},
/* 1091 */ {  2376203},
/* 1093 */ {  2384951},
/* 1097 */ {  2402441},
/* 1103 */ {  2428859},
/* 1109 */ {  2455337},
/* 1117 */ {  2490931},
/* 1123 */ {  2517797},
/* 1129 */ {  2544769}
};

} // namespace Givaro
