<?xml version="1.0" encoding="utf-8"?> 

<xsl:stylesheet
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
   xmlns:k="http://www.inkscape.org/namespaces/keys"
   xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape"
   xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd"
   xmlns:xlink="http://www.w3.org/1999/xlink"
   exclude-result-prefixes="k inkscape sodipodi xlink"
   >

   <xsl:param name="reference.lang" select="''" />
   
   <xsl:output method="xml"
            encoding="utf-8" 
            indent="yes"
            doctype-public="-//OASIS//DTD DocBook XML V4.3//EN"
            doctype-system="http://www.docbook.org/xml/4.3/docbookx.dtd"
            />

  <xsl:template match="k:root">
    <xsl:comment>
      Do not edit this file.  It is generated automatically from
      quickreference/gimp-keys.xml.
    </xsl:comment>
    <reference>
      <xsl:attribute name="lang">
          <xsl:value-of select="$reference.lang" />
        </xsl:attribute>
        <title>Keys and Mouse Reference</title>

        <xsl:apply-templates select="k:p"/>

        <xsl:apply-templates select="k:column"/>

    </reference>
  </xsl:template>

  <xsl:template match="k:p">
    <para><xsl:apply-templates/></para>
  </xsl:template>

  <xsl:template match="k:root/text() | k:column/text() | k:title | k:note"/>

  <xsl:template match="k:column">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="k:section">
    <refentry>
      <refmeta>
       <refentrytitle>
         <xsl:value-of select="child::k:title"/>
       </refentrytitle>
      </refmeta>

      <refnamediv>
        <refname><xsl:value-of select="child::k:title" /></refname>
        <refpurpose>
          Key reference for <guimenuitem>
            <xsl:value-of select="child::k:title" />
          </guimenuitem> menu
        </refpurpose>
      </refnamediv>
      
      <refsect1>
        <title><xsl:value-of select="child::k:title" /></title>
        <xsl:apply-templates />
      </refsect1>
    </refentry>
  </xsl:template>
  
  <xsl:template match="k:group">
    <variablelist>
      <xsl:if test="k:title/text() != ''">
        <title><xsl:value-of select="k:title/text()" /></title>
      </xsl:if>

       <xsl:apply-templates />
    </variablelist>
    
    <xsl:if test="k:note">
      <note>
        <para>
          <xsl:value-of select="k:note/text()" />
        </para>
       </note>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="k:keys | k:mouse">
     <varlistentry>
        <term>
          <xsl:choose>
            <xsl:when test="count(k:key) = 2">
              <xsl:apply-templates select="k:key[1]"/>,
              <xsl:apply-templates select="k:key[2]"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates select="k:key[1]"/>
            </xsl:otherwise>
          </xsl:choose>
        </term>
        <listitem>
          <para>
            <xsl:apply-templates select="k:action"/>
          </para>
        </listitem>
    </varlistentry>
  </xsl:template>
  
  <xsl:template match="k:action">
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="k:key">
    <xsl:apply-templates />
  </xsl:template>
  
  <xsl:template match="k:shift">
     <keycap function="shift">Shift</keycap>+
  </xsl:template>
  
  <xsl:template match="k:ctrl">
    <keycap function="control">Ctrl</keycap>+
  </xsl:template>
  
  <xsl:template match="k:alt">
    <keycap function="alt">Alt</keycap>+
  </xsl:template>
  
  <xsl:template match="k:left">
    <keycap function="left">Left</keycap>+
  </xsl:template>
  
  <xsl:template match="k:right">
    <keycap function="right">Right</keycap>+
  </xsl:template>
  
  <xsl:template match="k:keyf | k:misc | k:misc-wide">
    <xsl:value-of select="@f"/>
  </xsl:template>
  
  <xsl:template match="k:arrows">
    <xsl:text>arrows</xsl:text>
  </xsl:template>
  
  <xsl:template match="k:up">
    <keycap function="up">Up arrow</keycap>
  </xsl:template>
  
  <xsl:template match="k:down">
    <keycap function="down">Down arrow</keycap>
  </xsl:template>
  
  <xsl:template match="k:wheel">
    <xsl:text>mouse wheel</xsl:text>
  </xsl:template>
  
  <xsl:template match="k:left-drag">
    <xsl:text>mouse drag</xsl:text>
  </xsl:template>
  
  <xsl:template match="k:left-click">
    <xsl:text>click</xsl:text>
  </xsl:template>
  
  <xsl:template match="k:mid-drag">
    <xsl:text>middle button drag</xsl:text>
  </xsl:template>
  
  <xsl:template match="k:mid-click">
    <xsl:text>middle click</xsl:text>
  </xsl:template>
  
  <xsl:template match="k:right-drag">
    <xsl:text>right button drag</xsl:text>
  </xsl:template>
  
  <xsl:template match="k:right-click">
    <xsl:text>right click</xsl:text>
  </xsl:template>
  
</xsl:stylesheet>
