/*******************************************************************************
*
*       This file is part of the General Hidden Markov Model Library,
*       GHMM version __VERSION__, see http://ghmm.org
*
*       Filename: ghmm/ghmm/smap_classify.h
*       Authors:  Bernd Wichern
*
*       Copyright (C) 1998-2004 Alexander Schliep 
*       Copyright (C) 1998-2001 ZAIK/ZPR, Universitaet zu Koeln
*	Copyright (C) 2002-2004 Max-Planck-Institut fuer Molekulare Genetik, 
*                               Berlin
*                                   
*       Contact: schliep@ghmm.org             
*
*       This library is free software; you can redistribute it and/or
*       modify it under the terms of the GNU Library General Public
*       License as published by the Free Software Foundation; either
*       version 2 of the License, or (at your option) any later version.
*
*       This library is distributed in the hope that it will be useful,
*       but WITHOUT ANY WARRANTY; without even the implied warranty of
*       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*       Library General Public License for more details.
*
*       You should have received a copy of the GNU Library General Public
*       License along with this library; if not, write to the Free
*       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*
*       This file is version $Revision: 2275 $ 
*                       from $Date: 2009-04-28 08:21:57 -0400 (Tue, 28 Apr 2009) $
*             last change by $Author: grunau $.
*
*******************************************************************************/

#ifndef GHMM_SMAP_CLASSIFY_H
#define GHMM_SMAP_CLASSIFY_H

#include "ghmmconfig.h"

#ifdef GHMM_OBSOLETE

#include "smodel.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
   Maximum A Posteriori Classification Algorithm (MAPCA).

   \obsolete given a field of models and one sequence and suppose the sequence
   has been produced by one of these models. This algorithm calculates
   for each model the probability, that the seq. comes from the model.
   This bayesian approach uses a prior for the models. If none is specified
   equal prob. is assumed.
   The maps are copied into "result", which has to be of dimension "smo_number"
   Ref.: A. Kehagias: Bayesian Classification of HMM, Math. Comp. Modelling
   (1995)
   @return number of the model, that fits best to the sequence
   @param smo vector of models
   @param result gives the probability for all the models
   @param smo_number number of models
   @param O sequence
   @param T length of the sequence
 */
  int ghmm_smap_classify (ghmm_cmodel ** smo, double *result, int smo_number,
                     double *O, int T);

/**
   Alternative to MAPCA (smap_classify) using Bayes' theorem.

   \obsolete calculate p[m] directly using 
   Bayes' theorem, instead of recursive over t.
   p(m | O) = p(O | m) * p(m) / (sum_i p(O | i) * p(i))
   @return number of the model, that fits best to the sequence
   @param smo vector of models
   @param result gives the probability for all the models
   @param smo_number number of models
   @param O sequence
   @param T length of the sequence
 */
  int ghmm_smap_bayes (ghmm_cmodel ** smo, double *result, int smo_number, double *O,
                  int T);

#ifdef __cplusplus
}
#endif

#endif /* GHMM_OBSOLETE */

#endif                          /* GHMM_SMAP_CLASSIFY_H */
