.\" @(#)$RCSfile: gfal_lseek.man,v $ $Revision: 1.1.1.1 $ $Date: 2003/11/19 12:56:29 $ CERN Jean-Philippe Baud
.\" Copyright (C) 2003 by CERN
.\" All rights reserved
.\"
.TH GFAL_LSEEK 3 "$Date: 2003/11/19 12:56:29 $" GFAL "Library Functions"
.SH NAME
gfal_lseek \- position a file
.SH SYNOPSIS
\fB#include "gfal_api.h"\fR
.sp
.BI "off_t gfal_lseek (int " fd ,
.BI "off_t " offset ,
.BI "int " whence );
.sp
Under Linux, for large files:
.br
.B #define _LARGEFILE64_SOURCE
.br
\fB#include "gfal_api.h"\fR
.sp
.BI "off64_t gfal_lseek64 (int " fd ,
.BI "off64_t " offset ,
.BI "int " whence );
.sp
For large files, under other systems:
.br
\fB#include "gfal_api.h"\fR
.sp
.BI "off64_t gfal_lseek64 (int " fd ,
.BI "off64_t " offset ,
.BI "int " whence );
.SH DESCRIPTION
.B gfal_lseek
positions/repositions to
.I offset
the file associated with the descriptor
.I fd
generated by a previous
.BR gfal_open .
.I whence
indicates how to interpret the
.I offset
value:
.RS
.TP 1.3i
.B SEEK_SET
The offset is set from beginning of file.
.TP
.B SEEK_CUR
The offset is added to current position.
.TP
.B SEEK_END
The offset is added to current file size.
.RE
.sp
.B gfal_lseek64
performs the same function on large files using off64_t rather than off_t.
.SH RETURN VALUE
This routine returns the actual offset from the beginning of the file if the
operation was successful or -1 if the operation failed. In the latter case,
.B errno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B EBADF
.I fd
is not a valid file descriptor.
.TP
.B EINVAL
incorrect value for
.IR whence .
.TP
.B EFBIG
Resulting offset is too big to fit in off_t.
.TP
.B ECOMM
Communication error.
.TP
.B EPROTONOSUPPORT
Access method not supported.
.SH SEE ALSO
.B gfal(3)
