import gtk
import commands



#
# Restricts the given coordinates to visible values.
#
def _crop_coords(x, y, width, height):

    scrwidth = gtk.gdk.screen_width()
    scrheight = gtk.gdk.screen_height()

    x = min(max(0, x), scrwidth - 1)
    y = min(max(0, y), scrheight - 1)
    width = min(scrwidth - x, width)
    height = min(scrheight - y, height)

    return (x, y, width, height)



#
# Captures solid color wallpapers. Requires GNOME.
#
def get_wallcolor(width, height):

    import gconf
    client = gconf.client_get_default()
    client.add_dir("/desktop/gnome/background", gconf.CLIENT_PRELOAD_RECURSIVE)
    value = client.get("/desktop/gnome/background/primary_color")
    color = value.get_string()
    
    pbuf = gtk.gdk.Pixbuf(0, 1, 8, width, height)
    c = gtk.gdk.color_parse(color)
    fillr = (c.red / 256) << 24
    fillg = (c.green / 256) << 16
    fillb = (c.blue / 256) << 8
    fillcolor = fillr | fillg | fillb | 255
    pbuf.fill(fillcolor)

    return pbuf



#
# Captures the wallpaper image by making a screen shot.
#
def get_wallpaper_fallback(x, y, width, height):

    x, y, width, height = _crop_coords(x, y, width, height)
    
    rootwin = gtk.gdk.get_default_root_window()
    pbuf = gtk.gdk.Pixbuf(0, 1, 8, width, height)
    pbuf.get_from_drawable(rootwin, rootwin.get_colormap(),
                           x, y, 0, 0, width, height)

    return pbuf



#
# Captures the wallpaper image by accessing the background pixmap.
#
def get_wallpaper(x, y, width, height):

    x, y, width, height = _crop_coords(x, y, width, height)

    # get wallpaper
    pmap_id = get_wallpaper_id()
    if (hasattr(gtk.gdk, "gdk_pixmap_foreign_new")):
        pmap = gtk.gdk.gdk_pixmap_foreign_new(pmap_id)
    else:
        pmap = gtk.gdk.pixmap_foreign_new(pmap_id)
    pwidth, pheight = pmap.get_size()

    # create pixbuf
    rootwin = gtk.gdk.get_default_root_window()
    pbuf = gtk.gdk.Pixbuf(0, 1, 8, width, height)


    # tile wallpaper over pixbuf
    sx = -(x % pwidth)
    sy = -(y % pheight)
    for x in xrange(sx, width, pwidth):
        for y in xrange(sy, height, pheight):
            dstx = max(0, x)
            dsty = max(0, y)
            srcx = dstx - x
            srcy = dsty - y

            w = min(pwidth - srcx, width - dstx)
            h = min(pheight - srcy, height - dsty)

            pbuf.get_from_drawable(pmap, rootwin.get_colormap(),
                                   srcx, srcy, dstx, dsty, w, h)
        #end for
    #end for

    return pbuf




#
# Returns the ID of the background pixmap.
#
def get_wallpaper_id():

    try:
        root = gtk.gdk.get_default_root_window()
        id = root.property_get("_XROOTPMAP_ID", "PIXMAP")[2][0]
        return long(id)

    except:
        raise NotImplementedError



def watch_bg(observer):

    _BGWATCHER.add_observer(observer)


from BGWatcher import BGWatcher
_BGWATCHER = BGWatcher()
