/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/
#ifndef FREQ_H
#define FREQ_H 1

#ifdef __cplusplus
extern "C" {
#endif

#define NUM_STANDARDS	26

typedef const double * freqlist;

const double chanfreq_0[] = { /* No Standard */
              0.0 
              };

			      /********\
			       * NTSC *
			      \********/
  /* The following countries use, or are  planning to use the NTSC(M) 
   * for both VHF and UHF:
   *     Antigua, Aruba, Bolivia, Canada, Chile, Colombia, Costa Rica,
   *     Cuba, Caracas, Ecuador, Gustemala, Honduras, Japan, Mexico,
   *     Nicuaragua, Panama, Peru, Philippines, Puerto Rico, South Korea,
   *     USA, Venezuela.
   *
   * The following countries use, or are planning to use NTSC(M) for
   *   only VHF broadcast system:
   *     Belize, Bermuda, British Virgin Island, Burma, El Salvador,
   *     Guam, Montserrat, Myanmar, Samoa, St Christopher And Nevis,
   *     Suriname, Taiwan, Trinidad/Tobago.
   */ 

const double chanfreq_1[] = { /* NTSC-M North/South American Antenna */
/* NTSC(M) VHF North/South America */
/* 0-4     */    0.0,    0.0,  55.25,  61.25,  67.25,
/* 5-9     */  77.25,  83.25, 175.25, 181.25, 187.25,
/* 10-13   */ 193.25, 199.25, 205.25, 211.25, 
/* NTSC(M) UHF North/South America */
/* 14-18   */ 471.25, 477.25, 483.25, 489.25, 495.25, 
/* 19-23   */ 501.25, 507.25, 513.25, 519.25, 525.25, 
/* 24-28   */ 531.25, 537.25, 543.25, 549.25, 555.25, 
/* 29-33   */ 561.25, 567.25, 573.25, 579.25, 585.25, 
/* 34-38   */ 591.25, 597.25, 603.25, 609.25, 615.25, 
/* 39-43   */ 621.25, 627.25, 633.25, 639.25, 645.25, 
/* 44-48   */ 651.25, 657.25, 663.25, 669.25, 675.25, 
/* 49-53   */ 681.25, 687.25, 693.25, 699.25, 705.25, 
/* 54-58   */ 711.25, 717.25, 723.25, 729.25, 735.25, 
/* 59-63   */ 741.25, 747.25, 753.25, 759.25, 765.25, 
/* 64-68   */ 771.25, 777.25, 783.25, 789.25, 795.25, 
/* 69      */ 801.25 
              };

const double chanfreq_2[] = { /* NTSC-M North/South American Cable */
/* NTSC(M) Cable TV, North/South America */
/* 0-4     */    0.0,  73.25,  55.25,  61.25,  67.25,
/* 5-9     */  77.25,  83.25, 175.25, 181.25, 187.25,
/* 10-14   */ 193.25, 199.25, 205.25, 211.25, 121.25,
/* 15-19   */ 127.25, 133.25, 139.25, 145.25, 151.25,
/* 20-24   */ 157.25, 163.25, 169.25, 217.25, 223.25,
/* 25-29   */ 229.25, 235.25, 241.25, 247.25, 253.25,
/* 30-34   */ 259.25, 265.25, 271.25, 277.25, 283.25,
/* 35-39   */ 289.25, 295.25, 301.25, 307.25, 313.25,
/* 40-44   */ 319.25, 325.25, 331.25, 337.25, 343.25,
/* 45-49   */ 349.25, 355.25, 361.25, 367.25, 373.25,
/* 50-54   */ 379.25, 385.25, 391.25, 397.25, 403.25,
/* 55-59   */ 409.25, 415.25, 421.25, 427.25, 433.25,
/* 60-64   */ 439.25, 445.25, 451.25, 457.25, 463.25,
/* 65-69   */ 469.25, 475.25, 481.25, 487.25, 493.25,
/* 70-74   */ 499.25, 505.25, 511.25, 517.25, 523.25,
/* 75-79   */ 529.25, 535.25, 541.25, 547.25, 553.25,
/* 80-84   */ 559.25, 565.25, 571.25, 577.25, 583.25,
/* 85-89   */ 589.25, 595.25, 601.25, 607.25, 613.25,
/* 90-94   */ 619.25, 625.25, 631.25, 637.25, 643.25,
/* 95-99   */  91.25,  97.25, 103.25, 109.25, 115.25,
/* 100-104 */ 649.25, 655.25, 661.25, 667.25, 673.25,
/* 105-109 */ 679.25, 685.25, 691.25, 697.25, 703.25,
/* 110-114 */ 709.25, 715.25, 721.25, 727.25, 733.25,
/* 115-119 */ 739.25, 745.25, 751.25, 757.25, 763.25,
/* 120-124 */ 769.25, 775.25, 781.25, 787.25, 793.25,
/* 125     */ 799.25 
              };

const double chanfreq_3[] = { /* NTSC-M Japanese Antenna */
	  /* Channels 11 and 13 have same frequencies !! */
/* NTSC(M) VHF Japan */
/* 0-4     */    0.0,  91.25,  97.25, 103.25, 171.25,
/* 5-9     */ 177.25, 183.25, 189.25, 193.25, 199.25,
/* 10-13   */ 205.15, 211.25, 217.25, 211.25, 
/* NTSC(M) UHF Japan */
/* 14-18   */ 471.25, 477.25, 483.25, 489.25, 495.25, 
/* 19-23   */ 501.25, 507.25, 513.25, 519.25, 525.25, 
/* 24-28   */ 531.25, 537.25, 543.25, 549.25, 555.25, 
/* 29-33   */ 561.25, 567.25, 573.25, 579.25, 585.25, 
/* 34-38   */ 591.25, 597.25, 603.25, 609.25, 615.25, 
/* 39-43   */ 621.25, 627.25, 633.25, 639.25, 645.25, 
/* 44-48   */ 651.25, 663.25, 669.25, 675.25, 681.25, 
/* 49-53   */ 687.25, 693.25, 699.25, 705.25, 711.25, 
/* 54-58   */ 717.25, 723.25, 729.25, 735.25, 741.25,
/* 59-63   */ 747.25, 753.25, 759.25, 765.25, 765.25, 
/* 64-68   */ 771.25, 777.25, 783.25, 789.25, 795.25, 
/* 69      */ 801.25 
              };

const double chanfreq_4[] = { /* NTSC-M Japanese Cable */
/* NTSC(M) Cable TV, Japan */
/* 0-4     */    0.0,  91.25,  97.25, 103.25, 171.25,
/* 5-9     */ 177.25, 183.25, 189.25, 193.25, 199.25,
/* 10-14   */ 205.25, 211.25, 217.25, 109.25, 115.25,
/* 15-19   */ 121.25, 127.25, 133.25, 139.25, 145.25,
/* 20-24   */ 151.25, 157.25, 165.25, 223.25, 231.25,
/* 25-29   */ 237.25, 243.25, 249.25, 253.25, 259.25,
/* 30-34   */ 265.25, 271.25, 277.25, 283.25, 289.25,
/* 35-39   */ 295.25, 301.25, 307.25, 313.25, 319.25,
/* 40-44   */ 325.25, 331.25, 337.25, 343.25, 349.25,
/* 45-49   */ 355.25, 361.25, 367.25, 373.25, 379.25,
/* 50-54   */ 385.25, 391.25, 397.25, 403.25, 409.25,
/* 55-59   */ 415.25, 421.25, 427.25, 433.25, 439.25,
/* 60-63   */ 445.25, 451.25, 457.25, 463.25 
              };

			      /*******\
			       * PAL *
			      \*******/
  /* PAL(B) is used for only VHF transmission, except for Australia. 
   * Australia supports both VHF and UHF transmission.
   *
   * The following countries use PAL(B) for VHF transmission:
   *     Albania, Algeria, Australia, Austria, Bahrain, Bangladesh,
   *     Belgium, Bosnia-Herzegovina, Brunei Darussalam, Cambodia,
   *     Cameroon, Croatia, Cyprus, Denmark, Egypt, Equatorial Guinea,
   *     Ethiopia, Finland, Germany, Ghana, Gibraltar, Greenland,
   *     Ireland, India, Indonesia, Israel, Italy, Jordan, Kenya,
   *     Kuwait, Liberia, Libya, Luxembourg, Malaysia, Maldives,
   *     Malta, Nepal, Netherlands, New Zealand, Nigeria, Norway,
   *     Oman, Pakistan, Papua New Guinea, Portugal, Qatar, 
   *     Sao Tome and Principe, Saudi Arabia, Seychelles, Sierra Leone,
   *     Singapore, Slovenia, Somali, Spain, Sri Lanka, Sudan, Swaziland,
   *     Sweden, Switzerland, Syria, Thailand, Tunisia, Turkey, Uganda,
   *     United Arab Emirates, Yemen.
   *
   * The following countries use PAL(G) for UHF transmission:
   *     Albania, Algeria, Austria, Bahrain, Bosnia, Cambodia, Cameroon,
   *     Crostia, Cyprus, Denmark, Egypt, Ethiopia, Equatorial Guinea,
   *     Finland, Germania, Gilbratar, Greenland, Iceland, Israel, Italy,
   *     Jordan, Kenya, Kuwait, Liberia, Libya, Luxembourg, Malysia,
   *     Monaco, Mozambique, Netherlands, New Zealand, Norway, Oman,
   *     Pakistan, Papua New Guinea, Portugal, Qatar, Romania, Sierra Leone,
   *     Singapore, Slovenia, Somalia, Spain, Sri Lanka, Sudan, Swaziland,
   *     Sweden, Switzerland, Syria, Thailand, Tunisia, Turkey, Yemen,
   *     United Arab Emirates, Zambia, Zimbabwe.
   *
   * Only Belgium uses PAL(H), while Hong Kong and United Kingdom use
   * PAL(I) for UHF transmission.
   ****
   ****
   * PAL(G,H,I)
   * PAL(I) is used for both VHF and UHF transmission. PAL(G) and PAL(H)
   * are used only UHF transmission.
   *
   * The following countries use PAL(I) for VHF tansmission:
   *     Angola, Botswana, Gambia, Guinea-Bissau, Ireland, Lesotho,
   *     Malawi, Namibia, South Africa, Tanzania, United Kingdom,
   *     Zanzibar.
   ****
   ****
   * PAL(D/K) is used for both VHF and UHF transmission. Korea and 
   * Romania only support VHF.
   ****
   ****
   * PAL(M) is used for both VHF and UHF transmission. Only Brazil 
   * use PAL(M).
   ****
   ****
   * PAL(N) is used for both VHF and UHF transmission. Argentina, Paraguay,
   * Uruguay are using PAL(N) for their broadcast TV. Uruguay only support
   * VHF transmission, and Argentina uses a modified PAL(N), called
   * "combination N".
   ****
   */

const double chanfreq_5[] = { /* PAL-B/G Cable */
/* PAL(B,G) Cable */
/* E 2-4   */    0.0,    0.0,  48.25,  55.25,  62.25,
/* E 5-9   */ 175.25, 182.25, 189.25, 196.25, 203.25, 
/* E 10-12 */ 210.25, 217.25, 224.25,
/* S 01-03 */  69.25,  76.25,  83.25,
/* S 1-5   */ 105.25, 112.25, 119.25, 126.25, 133.25,
/* S 6-10  */ 140.75, 147.75, 154.75, 161.75, 168.75,
/* S 11-15 */ 231.25, 238.25, 245.25, 252.25, 259.25,
/* S 16-20 */ 266.25, 273.25, 280.25, 287.25, 294.25, 
/* S 21-25 */ 303.25, 311.25, 319.25, 327.25, 335.25,
/* S 26-30 */ 343.25, 351.25, 359.25, 367.25, 375.25,
/* S 31-35 */ 383.25, 391.25, 399.25, 407.25, 415.25, 
/* S 36-40 */ 423.25, 431.25, 439.25, 447.25, 455.25, 
/* S 41    */ 463.25
              };

const double chanfreq_6[] = { /* PAL-B Europe Antenna 
                                 (except Italy, France, OIRT) */
/* PAL(B) VHF Europe */
/* 2-4     */    0.0,    0.0,  48.25,  55.25,  62.25, 
/* 5-9     */ 175.25, 182.25, 189.25, 196.25, 203.25, 
/* 10-12   */ 210.25, 217.25, 224.25,
/* Skip    */    0.0,    0.0,    0.0,    0.0,    0.0, 
/*   -20   */    0.0,    0.0,    0.0,
/* PAL(B) UHF */
/* 21E-25E */ 471.25, 479.25, 487.25, 495.25, 503.25, 
/* 26E-27E */ 511.25, 519.25, 
/* 28-32   */ 527.25, 534.25, 541.25, 548.25, 555.25, 
/* 33-37   */ 562.25, 569.25, 576.25, 583.25, 590.25, 
/* 38-42   */ 597.25, 604.25, 611.25, 618.25, 625.25, 
/* 43-47   */ 632.25, 639.25, 646.25, 653.25, 660.25, 
/* 48-52   */ 667.25, 674.25, 681.25, 688.25, 695.25, 
/* 53-57   */ 702.25, 709.25, 716.25, 723.25, 730.25,
/* 58-62   */ 737.25, 744.25, 751.25, 758.25, 765.25, 
/* 63-67   */ 772.25, 779.25, 786.25, 793.25, 800.25, 
/* 68-69   */ 807.25, 814.25
	      };


const double chanfreq_7[] = { /* PAL-B Australia Antenna */
/* PAL(B) VHF Australia */
/* 0-4     */  46.25,  57.25,  64.25,  86.25,  95.25, 
/* 5,5A-8  */ 102.25, 138.25, 175.25, 182.25, 189.25, 
/* 9-11    */ 196.25, 209.25, 216.25,
/* Skip    */    0.0,    0.0,    0.0,    0.0,    0.0, 
/*   -20   */    0.0,    0.0,    0.0,
/* PAL(B) UHF */
/* 21E-25E */ 471.25, 479.25, 487.25, 495.25, 503.25, 
/* 26E-27E */ 511.25, 519.25, 
/* 28-32   */ 527.25, 534.25, 541.25, 548.25, 555.25, 
/* 33-37   */ 562.25, 569.25, 576.25, 583.25, 590.25, 
/* 38-42   */ 597.25, 604.25, 611.25, 618.25, 625.25, 
/* 43-47   */ 632.25, 639.25, 646.25, 653.25, 660.25, 
/* 48-52   */ 667.25, 674.25, 681.25, 688.25, 695.25, 
/* 53-57   */ 702.25, 709.25, 716.25, 723.25, 730.25,
/* 58-62   */ 737.25, 744.25, 751.25, 758.25, 765.25, 
/* 63-67   */ 772.25, 779.25, 786.25, 793.25, 800.25, 
/* 68-69   */ 807.25, 814.25
              };

const double chanfreq_8[] = { /* PAL-B+G New Zealand Antenna */
/* PAL(B) VHF New Zealand */
/* 1-4     */    0.0,  45.25,  55.25,  62.25, 175.25, 
/* 5-9     */ 182.25, 189.25, 196.25, 203.25, 210.25, 
/* 10      */ 217.25,
/* Skip    */    0.0,    0.0,    0.0,    0.0,    0.0, 
/*   -20   */    0.0,    0.0,    0.0,    0.0,    0.0,
/* PAL(G,H,I) UHF */
/* 21-25   */ 471.25, 479.25, 487.25, 495.25, 503.25, 
/* 26-30   */ 511.25, 519.25, 527.25, 535.25, 543.25, 
/* 31-35   */ 551.25, 559.25, 567.25, 575.25, 583.25, 
/* 36-40   */ 591.25, 599.25, 607.25, 615.25, 623.25, 
/* 41-45   */ 631.25, 639.25, 647.25, 655.25, 663.25, 
/* 46-50   */ 671.25, 679.25, 687.25, 695.25, 703.25, 
/* 51-55   */ 711.25, 719.25, 727.25, 735.25, 743.25, 
/* 56-60   */ 751.25, 759.25, 767.25, 775.25, 783.25, 
/* 61-65   */ 791.25, 799.25, 807.25, 815.25, 823.25, 
/* 66-70   */ 831.25, 839.25, 847.25, 855.25, 863.25, 
/* 71-75   */ 871.25, 879.25, 887.25, 895.25, 903.25, 
/* 76-79   */ 911.25, 919.25, 927.25, 935.25
              };

const double chanfreq_9[] = { /* PAL-B+G Italy Antenna */
/* PAL(B) VHF Italy */
/* A-E     */  53.75,  62.25,  82.25, 175.25, 183.75,
/* F-H     */ 192.25, 201.25, 210.25, 
/* H1-H2   */ 217.25, 224.25,
/* Skip    */    0.0,    0.0,    0.0,    0.0,    0.0, 
/*   -20   */    0.0,    0.0,    0.0,    0.0,    0.0,
/*         */    0.0,
/* PAL(G,H,I) UHF */
/* 21-25   */ 471.25, 479.25, 487.25, 495.25, 503.25, 
/* 26-30   */ 511.25, 519.25, 527.25, 535.25, 543.25, 
/* 31-35   */ 551.25, 559.25, 567.25, 575.25, 583.25, 
/* 36-40   */ 591.25, 599.25, 607.25, 615.25, 623.25, 
/* 41-45   */ 631.25, 639.25, 647.25, 655.25, 663.25, 
/* 46-50   */ 671.25, 679.25, 687.25, 695.25, 703.25, 
/* 51-55   */ 711.25, 719.25, 727.25, 735.25, 743.25, 
/* 56-60   */ 751.25, 759.25, 767.25, 775.25, 783.25, 
/* 61-65   */ 791.25, 799.25, 807.25, 815.25, 823.25, 
/* 66-70   */ 831.25, 839.25, 847.25, 855.25, 863.25, 
/* 71-75   */ 871.25, 879.25, 887.25, 895.25, 903.25, 
/* 76-79   */ 911.25, 919.25, 927.25, 935.25
	      };

const double chanfreq_10[] = { /* PAL-I Ireland Antenna */
/* PAL(I) VHF Ireland */
/* A-E     */  45.75,  53.75,  61.75, 175.25, 183.25,
/* F-J noI */ 191.25, 199.25, 207.25, 215.25,
/* Skip    */    0.0,    0.0,    0.0,    0.0,    0.0, 
/*   -20   */    0.0,    0.0,    0.0,    0.0,    0.0,
/*         */    0.0,    0.0,
/* PAL(G,H,I) UHF */
/* 21-25   */ 471.25, 479.25, 487.25, 495.25, 503.25, 
/* 26-30   */ 511.25, 519.25, 527.25, 535.25, 543.25, 
/* 31-35   */ 551.25, 559.25, 567.25, 575.25, 583.25, 
/* 36-40   */ 591.25, 599.25, 607.25, 615.25, 623.25, 
/* 41-45   */ 631.25, 639.25, 647.25, 655.25, 663.25, 
/* 46-50   */ 671.25, 679.25, 687.25, 695.25, 703.25, 
/* 51-55   */ 711.25, 719.25, 727.25, 735.25, 743.25, 
/* 56-60   */ 751.25, 759.25, 767.25, 775.25, 783.25, 
/* 61-65   */ 791.25, 799.25, 807.25, 815.25, 823.25, 
/* 66-70   */ 831.25, 839.25, 847.25, 855.25, 863.25, 
/* 71-75   */ 871.25, 879.25, 887.25, 895.25, 903.25, 
/* 76-79   */ 911.25, 919.25, 927.25, 935.25
              };

const double chanfreq_11[] = { /* PAL-I South Africa Antenna */
/* PAL(I) VHF South Africa */
/* 4       */    0.0,    0.0,    0.0,    0.0, 175.25, 
/* 5-9     */ 183.25, 191.25, 199.25, 207.25, 215.25, 
/* 10-13   */ 223.25, 231.25, 239.25, 247.43,
/* Skip    */    0.0,    0.0,    0.0,    0.0,    0.0, 
/*   -20   */    0.0,    0.0,
/* PAL(G,H,I) UHF */
/* 21-25   */ 471.25, 479.25, 487.25, 495.25, 503.25, 
/* 26-30   */ 511.25, 519.25, 527.25, 535.25, 543.25, 
/* 31-35   */ 551.25, 559.25, 567.25, 575.25, 583.25, 
/* 36-40   */ 591.25, 599.25, 607.25, 615.25, 623.25, 
/* 41-45   */ 631.25, 639.25, 647.25, 655.25, 663.25, 
/* 46-50   */ 671.25, 679.25, 687.25, 695.25, 703.25, 
/* 51-55   */ 711.25, 719.25, 727.25, 735.25, 743.25, 
/* 56-60   */ 751.25, 759.25, 767.25, 775.25, 783.25, 
/* 61-65   */ 791.25, 799.25, 807.25, 815.25, 823.25, 
/* 66-70   */ 831.25, 839.25, 847.25, 855.25, 863.25, 
/* 71-75   */ 871.25, 879.25, 887.25, 895.25, 903.25, 
/* 76-79   */ 911.25, 919.25, 927.25, 935.25
              };

const double chanfreq_12[] = { /* PAL-I Angola Antenna */
/* PAL(I) VHF Angola */
/* 1-4     */    0.0,  43.25,  52.25,  60.25, 175.25, 
/* 5-9     */ 193.25, 191.25, 199.25, 207.25, 215.25,
/* Skip    */    0.0,    0.0,    0.0,    0.0,    0.0, 
/*   -20   */    0.0,    0.0,    0.0,    0.0,    0.0,
/*         */    0.0,
/* PAL(G,H,I) UHF */
/* 21-25   */ 471.25, 479.25, 487.25, 495.25, 503.25, 
/* 26-30   */ 511.25, 519.25, 527.25, 535.25, 543.25, 
/* 31-35   */ 551.25, 559.25, 567.25, 575.25, 583.25, 
/* 36-40   */ 591.25, 599.25, 607.25, 615.25, 623.25, 
/* 41-45   */ 631.25, 639.25, 647.25, 655.25, 663.25, 
/* 46-50   */ 671.25, 679.25, 687.25, 695.25, 703.25, 
/* 51-55   */ 711.25, 719.25, 727.25, 735.25, 743.25, 
/* 56-60   */ 751.25, 759.25, 767.25, 775.25, 783.25, 
/* 61-65   */ 791.25, 799.25, 807.25, 815.25, 823.25, 
/* 66-70   */ 831.25, 839.25, 847.25, 855.25, 863.25, 
/* 71-75   */ 871.25, 879.25, 887.25, 895.25, 903.25, 
/* 76-79   */ 911.25, 919.25, 927.25, 935.25
              };

const double chanfreq_13[] = { /* PAL-B+G/H/I Many (Europe and others) */
/* PAL(B) VHF Europe */
/* 2-4     */    0.0,    0.0,  48.25,  55.25,  62.25, 
/* 5-9     */ 175.25, 182.25, 189.25, 196.25, 203.25, 
/* 10-12   */ 210.25, 217.25, 224.25,
/* Skip    */    0.0,    0.0,    0.0,    0.0,    0.0, 
/*   -20   */    0.0,    0.0,    0.0,
/* PAL(G,H,I) UHF */
/* 21-25   */ 471.25, 479.25, 487.25, 495.25, 503.25, 
/* 26-30   */ 511.25, 519.25, 527.25, 535.25, 543.25, 
/* 31-35   */ 551.25, 559.25, 567.25, 575.25, 583.25, 
/* 36-40   */ 591.25, 599.25, 607.25, 615.25, 623.25, 
/* 41-45   */ 631.25, 639.25, 647.25, 655.25, 663.25, 
/* 46-50   */ 671.25, 679.25, 687.25, 695.25, 703.25, 
/* 51-55   */ 711.25, 719.25, 727.25, 735.25, 743.25, 
/* 56-60   */ 751.25, 759.25, 767.25, 775.25, 783.25, 
/* 61-65   */ 791.25, 799.25, 807.25, 815.25, 823.25, 
/* 66-70   */ 831.25, 839.25, 847.25, 855.25, 863.25, 
/* 71-75   */ 871.25, 879.25, 887.25, 895.25, 903.25, 
/* 76-79   */ 911.25, 919.25, 927.25, 935.25
              };

const double chanfreq_14[] = { /* PAL-D/K China Antenna */
/* PAL(D/K) VHF China/Korea/Romania */
/* 1-4     */    0.0,  49.75,  57.75,  65.75,  77.25,  
/* 5-9     */  85.25, 168.25, 176.25, 184.25, 192.25, 
/* 10-12   */ 200.25, 208.25, 216.25,
/* PAL(D/K) UHF */
/* 13-17   */ 471.25, 479.25, 487.25, 493.25, 503.25, 
/* 18-22   */ 511.25, 519.25, 527.25, 535.25, 543.25, 
/* 23-27   */ 551.25, 559.25, 607.25, 615.25, 623.25,
/* 28-32   */ 631.25, 639.25, 647.25, 655.25, 663.25, 
/* 33-37   */ 671.25, 679.25, 687.25, 695.25, 703.25, 
/* 38-42   */ 711.25, 719.25, 727.25, 735.25, 743.25, 
/* 43-47   */ 751.25, 759.25, 767.25, 775.25, 783.25, 
/* 48-52   */ 791.25, 799.25, 807.25, 815.25, 823.25, 
/* 53-57   */ 831.25, 839.25, 847.25, 855.25, 863.25
              };

const double chanfreq_15[] = { /* PAL-D/K+G Romania Antenna */
/* PAL(D/K) VHF China/Korea/Romania */
/* 1-4     */    0.0,  49.75,  57.75,  65.75,  77.25,  
/* 5-9     */  85.25, 168.25, 176.25, 184.25, 192.25, 
/* 10-12   */ 200.25, 208.25, 216.25,
/* Skip    */    0.0,    0.0,    0.0,    0.0,    0.0, 
/*   -20   */    0.0,    0.0,    0.0,
/* PAL(G,H,I) UHF */
/* 21-25   */ 471.25, 479.25, 487.25, 495.25, 503.25, 
/* 26-30   */ 511.25, 519.25, 527.25, 535.25, 543.25, 
/* 31-35   */ 551.25, 559.25, 567.25, 575.25, 583.25, 
/* 36-40   */ 591.25, 599.25, 607.25, 615.25, 623.25, 
/* 41-45   */ 631.25, 639.25, 647.25, 655.25, 663.25, 
/* 46-50   */ 671.25, 679.25, 687.25, 695.25, 703.25, 
/* 51-55   */ 711.25, 719.25, 727.25, 735.25, 743.25, 
/* 56-60   */ 751.25, 759.25, 767.25, 775.25, 783.25, 
/* 61-65   */ 791.25, 799.25, 807.25, 815.25, 823.25, 
/* 66-70   */ 831.25, 839.25, 847.25, 855.25, 863.25, 
/* 71-75   */ 871.25, 879.25, 887.25, 895.25, 903.25, 
/* 76-79   */ 911.25, 919.25, 927.25, 935.25
              };

const double chanfreq_16[] = { /* PAL-D/K+? Korea Antenna */
/* PAL(D/K) VHF China/Korea/Romania */
/* 1-4     */    0.0,  49.75,  57.75,  65.75,  77.25,  
/* 5-9     */  85.25, 168.25, 176.25, 184.25, 192.25, 
/* 10-12   */ 200.25, 208.25, 216.25
              };

const double chanfreq_17[] = { /* PAL-M Brazil Antenna */
/* PAL(M) VHF Brazil */
/* 2-4     */    0.0,    0.0,  55.25,  61.25,  67.25, 
/* 5-9     */  77.25,  83.25, 175.25, 181.25, 187.25, 
/* 10-13   */ 193.25, 199.25, 205.25, 211.25
	      };

const double chanfreq_18[] = { /* PAL-N Argentina/Paraguay/Uruguay Antenna */
/* PAL(N) VHF Argentina/Paraguay/Uruguay */
/* 2-4     */    0.0,    0.0,  55.25,  61.25,  67.25, 
/* 5-9     */  77.25,  83.25, 175.25, 181.25, 187.25, 
/* 10-13   */ 193.25, 199.25, 205.25, 211.25
              };

const double chanfreq_19[] = { /* PAL-N+? Uruguay */
/* PAL(N) VHF Argentina/Paraguay/Uruguay */
/* 2-4     */    0.0,    0.0,  55.25,  61.25,  67.25, 
/* 5-9     */  77.25,  83.25, 175.25, 181.25, 187.25, 
/* 10-13   */ 193.25, 199.25, 205.25, 211.25
              };

const double chanfreq_20[] = { /* PAL-combN Argentina */
/* PAL(N) VHF Argentina/Paraguay/Uruguay */
/* 2-4     */    0.0,    0.0,  55.25,  61.25,  67.25, 
/* 5-9     */  77.25,  83.25, 175.25, 181.25, 187.25, 
/* 10-13   */ 193.25, 199.25, 205.25, 211.25
              };

			     /*********\
			      * SECAM *
			     \*********/
  /* SECAM(B) is used only for VHF transmission.
   *
   * The following countries use SECAM(B) system:
   *     Djibouti, Iran, Iraq, Greece, Lenanon,  Mali, Mauritania, Mauritius,
   *     Morocco.
   ****
   ****
   * SECAM(D)
   *
   * The following countries use SECAM(D) system. SECAM(D) is used only
   * for VHF:
   *     Afganistan, Armenia, Azerbaijan, Belarus, Bulgaria, Czech Republic,
   *     Estonia, Georgia, Hungary, Kazaklhstan, Lithuania, Mogolia,
   *     Moldova, Poland, Russia, Slovak Republic, Ukraine, Vietnam.
   ****
   ****
   * SECAM(G)
   *
   * The following countries use SECAM(G). SECAM(G) is used only for
   * UHF transmission:
   *     Greece, Iran, Iraq, Mali, Mauritius, Morocco, Saudi Arabia.
   ****
   ****
   * SECAM(K)
   *
   * The following countries use SECAM(K). SECAM(K) is used only for
   * UHF transmission:
   *     Armenia, Azerbaidjan, Bulgaria, Czech Republic, Estonia, Georgia,
   *     Hungary, Kazakhstan, Lithuania, Madagascar, Moldova, Poland,
   *     Russia, Slovak Republic, Ukraine, Vietnam.
   ****
   ****
   * SECAM(K1)
   *
   * The following countries use SECAM(K1). SECAM(K1) is used for both VHF
   * and UHF transmission unless only VHF or UHF is supported (as indicated
   * by V or U).
   *     Benin, Burkina Faso, Burundi, Cape Verde, Central African Republic,
   *     Chad, Comoros, Congo, Djibouti(V), Gabon, Madagascar(V), Niger,
   *     Rwanda, Senegal, Togo, Zaire.
   ****
   ****
   * SECAM(L)
   *
   * Only France uses SECAM(L). SECAM(L) is used for both VHF and UHF
   * transmission.
   */

const double chanfreq_21[] = { /* SECAM(L) France Antenna */
/* SECAM(L) VHF France */
/* A-1     */  47.75,  55.75,  63.75,  60.50, 176.00,
/* 2-6     */ 184.00, 192.00, 200.00, 208.00, 216.00,
/* Skip    */    0.0,    0.0,    0.0,    0.0,    0.0, 
/*   -20   */    0.0,    0.0,    0.0,    0.0,    0.0,
/*         */    0.0,
/* SECAM(G,H,I,K1,L) */
/* 21-25   */ 471.25, 479.25, 487.25, 495.25, 503.25, 
/* 26-30   */ 511.25, 519.25, 527.25, 535.25, 543.25, 
/* 31-35   */ 551.25, 559.25, 567.25, 575.25, 583.25, 
/* 36-40   */ 591.25, 599.25, 607.25, 615.25, 623.25, 
/* 41-45   */ 631.25, 639.25, 647.25, 655.25, 663.25, 
/* 46-50   */ 671.25, 679.25, 687.25, 695.25, 703.25,
/* 51-55   */ 711.25, 719.25, 727.25, 735.25, 743.25, 
/* 56-60   */ 751.25, 759.25, 767.25, 775.25, 783.25, 
/* 61-65   */ 791.25, 799.25, 807.25, 815.25, 823.25, 
/* 66-69   */ 831.25, 839.25, 847.25, 855.25 
              };

const double chanfreq_22[] = { /* SECAM(B+G,H,I,K1,L) Italy Antenna */
/* SECAM(B) Italy */
/* A-E    */   53.75,  62.25,  82.25, 175.25, 183.75,
/* F-H1   */  192.25, 201.25, 210.25, 217.25,
/* Skip    */    0.0,    0.0,    0.0,    0.0,    0.0, 
/*   -20   */    0.0,    0.0,    0.0,    0.0,    0.0,
/*         */    0.0,    0.0,
/* SECAM(G,H,I,K1,L) */
/* 21-25   */ 471.25, 479.25, 487.25, 495.25, 503.25, 
/* 26-30   */ 511.25, 519.25, 527.25, 535.25, 543.25, 
/* 31-35   */ 551.25, 559.25, 567.25, 575.25, 583.25, 
/* 36-40   */ 591.25, 599.25, 607.25, 615.25, 623.25, 
/* 41-45   */ 631.25, 639.25, 647.25, 655.25, 663.25, 
/* 46-50   */ 671.25, 679.25, 687.25, 695.25, 703.25,
/* 51-55   */ 711.25, 719.25, 727.25, 735.25, 743.25, 
/* 56-60   */ 751.25, 759.25, 767.25, 775.25, 783.25, 
/* 61-65   */ 791.25, 799.25, 807.25, 815.25, 823.25, 
/* 66-69   */ 831.25, 839.25, 847.25, 855.25 
              };

const double chanfreq_23[] = { /* SECAM(B+G) Greece/Iran/Morocco Antenna */
/* Skip -3 */    0.0,    0.0,    0.0,    0.0,
/* SECAM(B) VHF Morocco */
/* 4-8     */ 163.25, 171.25, 179.25, 187.25, 195.25,
/* 9-10    */ 203.25, 211.25,
/* Skip    */    0.0,    0.0,    0.0,    0.0,    0.0, 
/*   -20   */    0.0,    0.0,    0.0,    0.0,    0.0,
/* SECAM(G,H,I,K1,L) */
/* 21-25   */ 471.25, 479.25, 487.25, 495.25, 503.25, 
/* 26-30   */ 511.25, 519.25, 527.25, 535.25, 543.25, 
/* 31-35   */ 551.25, 559.25, 567.25, 575.25, 583.25, 
/* 36-40   */ 591.25, 599.25, 607.25, 615.25, 623.25, 
/* 41-45   */ 631.25, 639.25, 647.25, 655.25, 663.25, 
/* 46-50   */ 671.25, 679.25, 687.25, 695.25, 703.25,
/* 51-55   */ 711.25, 719.25, 727.25, 735.25, 743.25, 
/* 56-60   */ 751.25, 759.25, 767.25, 775.25, 783.25, 
/* 61-65   */ 791.25, 799.25, 807.25, 815.25, 823.25, 
/* 66-69   */ 831.25, 839.25, 847.25, 855.25 
              };

const double chanfreq_24[] = { /* SECAM(D+K) Armenia/Russia/Vietnam Antenna */
              0.0
              };

const double chanfreq_25[] = { /* SECAM(K1) Togo/Niger/Congo Antenna */
/* Skip -3 */    0.0,    0.0,    0.0,    0.0,
/* SECAM(K1) (Outre-Mer) */
/* K 4-8  */  175.25, 183.25, 191.25, 199.25, 207.25, 
/* K 9    */  215.25,
/* Skip    */    0.0,    0.0,    0.0,    0.0,    0.0, 
/*   -20   */    0.0,    0.0,    0.0,    0.0,    0.0,
/*         */    0.0,
/* SECAM(G,H,I,K1,L) */
/* 21-25   */ 471.25, 479.25, 487.25, 495.25, 503.25, 
/* 26-30   */ 511.25, 519.25, 527.25, 535.25, 543.25, 
/* 31-35   */ 551.25, 559.25, 567.25, 575.25, 583.25, 
/* 36-40   */ 591.25, 599.25, 607.25, 615.25, 623.25, 
/* 41-45   */ 631.25, 639.25, 647.25, 655.25, 663.25, 
/* 46-50   */ 671.25, 679.25, 687.25, 695.25, 703.25,
/* 51-55   */ 711.25, 719.25, 727.25, 735.25, 743.25, 
/* 56-60   */ 751.25, 759.25, 767.25, 775.25, 783.25, 
/* 61-65   */ 791.25, 799.25, 807.25, 815.25, 823.25, 
/* 66-69   */ 831.25, 839.25, 847.25, 855.25 
              };

const freqlist tvtype_chanfreq[NUM_STANDARDS] = { 
/* None   */  chanfreq_0,
              chanfreq_1, /* NTSC-M North/South American Antenna */
	      chanfreq_2, /* NTSC-M North/South American Cable */
	      chanfreq_3, /* NTSC-M Japanese Antenna */
	      chanfreq_4, /* NTSC-M Japanese Cable */
              chanfreq_5, /* PAL-B/G Cable */
	      chanfreq_6, /* PAL-B Europe Ant. (except Italy, France, OIRT) */
	      chanfreq_7, /* PAL-B Australia Antenna */
	      chanfreq_8, /* PAL-B+G New Zealand Antenna */
	      chanfreq_9, /* PAL-B+G Italy Antenna */
	      chanfreq_10,/* PAL-I Ireland Antenna */
	      chanfreq_11,/* PAL-I South Africa Antenna */
	      chanfreq_12,/* PAL-I Angola Antenna */
	      chanfreq_13,/* PAL-B+G/H/I Many (Europe and others) */
	      chanfreq_14,/* PAL-D/K China Antenna */
	      chanfreq_15,/* PAL-D/K+G Romania Antenna */
	      chanfreq_16,/* PAL-D/K+? Korea Antenna */
	      chanfreq_17,/* PAL-M Brazil Antenna */
	      chanfreq_18,/* PAL-N Argentina/Paraguay/Uruguay Antenna */
	      chanfreq_19,/* PAL-N+? Uruguay */
	      chanfreq_20,/* PAL-combN Argentina */
              chanfreq_21,/* SECAM(L) France Antenna */
	      chanfreq_22,/* SECAM(B+G,H,I,K1,L) Italy Antenna */
	      chanfreq_23,/* SECAM(B+G) Greece/Iran/Morocco Antenna */
	      chanfreq_24,/* SECAM(D+K) Armenia/Russia/Vietnam Antenna */
	      chanfreq_25 /* SECAM(K1) Togo/Niger/Congo Antenna */
	      };

const int tvtype_chanmax[NUM_STANDARDS] = {
/* None   */  128, 
              70,         /* NTSC-M North/South American Antenna */
	      126,        /* NTSC-M North/South American Cable */
	      70,         /* NTSC-M Japanese Antenna */
	      64,         /* NTSC-M Japanese Cable */
              56,         /* PAL-B/G Cable */
	      70,         /* PAL-B Europe Ant. (except Italy, France, OIRT) */
	      70,         /* PAL-B Australia Antenna */
	      80,         /* PAL-B+G New Zealand Antenna */
	      80,         /* PAL-B+G Italy Antenna */
	      80,         /* PAL-I Ireland Antenna */
	      80,         /* PAL-I South Africa Antenna */
	      80,         /* PAL-I Angola Antenna */
	      80,         /* PAL-B+G/H/I Many (Europe and others) */
	      58,         /* PAL-D/K China Antenna */
	      80,         /* PAL-D/K+G Romania Antenna */
	      13,         /* PAL-D/K+? Korea Antenna */
	      14,         /* PAL-M Brazil Antenna */
	      14,         /* PAL-N Argentina/Paraguay/Uruguay Antenna */
	      14,         /* PAL-N+? Uruguay */
	      14,         /* PAL-combN Argentina */
              70,         /* SECAM(L) France Antenna */
	      70,         /* SECAM(B+G,H,I,K1,L) Italy Antenna */
	      70,         /* SECAM(B+G) Greece/Iran/Morocco Antenna */
	      0,          /* SECAM(D+K) Armenia/Russia/Vietnam Antenna */
	      70          /* SECAM(K1) Togo/Niger/Congo Antenna */
	      };

const int tvtype_format[NUM_STANDARDS] = {
/* None   */  0,
              1,          /* NTSC-M North/South American Antenna */
	      1,          /* NTSC-M North/South American Cable */
	      2,          /* NTSC-M Japanese Antenna */ 
	      2,          /* NTSC-M Japanese Cable */
              3,          /* PAL-B/G Cable */
	      3,          /* PAL-B Europe Ant. (except Italy, France, OIRT) */
	      3,          /* PAL-B Australia Antenna */
	      3,          /* PAL-B+G New Zealand Antenna */
	      3,          /* PAL-B+G Italy Antenna */
	      3,          /* PAL-I Ireland Antenna */
	      3,          /* PAL-I South Africa Antenna */
	      3,          /* PAL-I Angola Antenna */
	      3,          /* PAL-B+G/H/I Many (Europe and others) */
	      3,          /* PAL-D/K China Antenna */
	      3,          /* PAL-D/K+G Romania Antenna */
              3,          /* PAL-D/K+? Korea Antenna */
              4,          /* PAL-M Brazil Antenna */
	      5,          /* PAL-N Argentina/Paraguay/Uruguay Antenna */
	      5,          /* PAL-N+? Uruguay */
	      7,          /* PAL-combN Argentina */
              6,          /* SECAM(L) France Antenna */ 
	      6,          /* SECAM(B+G,H,I,K1,L) Italy Antenna */
	      6,          /* SECAM(B+G) Greece/Iran/Morocco Antenna */
	      6,          /* SECAM(D+K) Armenia/Russia/Vietnam Antenna */
	      6           /* SECAM(K1) Togo/Niger/Congo Antenna */
              };

char *tvtype_names[NUM_STANDARDS];

#ifdef __cplusplus
}
#endif


#endif

