/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

#include "gatos.h"
#include "version.h"


void PrintHelpMessage();

int main(int argc, char **argv) {
  int ctr;

  bindtextdomain(PACKAGE, GATOS_LOCALEDIR);
  textdomain(PACKAGE);

  gatos_init(GATOS_READ_BUFFER|GATOS_WRITE_BUFFER);

  if(argc < 2)  {
    PrintHelpMessage();
    exit(1);
    }
  for(ctr=1; ctr<argc; ctr++) {
    if(argv[ctr][0] == '-') {
      if(argv[ctr][1] == '-') {
	if(!strcmp(argv[ctr], "--help")) PrintHelpMessage();
	else if(!strcmp(argv[ctr], "--version"))
		printf(_("atitv - gatos %s\n"), GATOS_VERSION_STRING);
	else {
	  fprintf(stderr, _("Error: unknown option \"%s\"\n"), argv[ctr]);
	  PrintHelpMessage();
	  }
	}
      else {
	int v;
	if(strlen(argv[ctr]) != 2) {
	  fprintf(stderr, _("Error: unknown option \"%s\"\n"), argv[ctr]);
	  PrintHelpMessage();
	  }
	if(argv[ctr][1] == 'h') PrintHelpMessage();
	else if(argv[ctr][1] == 'm') {
	  if(argc < ctr+2)  {
	    fprintf(stderr, _("Error: -m switch needs 1 option\n"));
	    PrintHelpMessage();
	    }
	  v = strtol(argv[ctr+1], NULL, 10);
	  if(v<=0) {
	    if(argv[ctr+1][0] == 'c' || argv[ctr+1][0] == 'C') v=2;
	    else if(argv[ctr+1][0] == 's' || argv[ctr+1][0] == 'S') v=1;
	    else if(argv[ctr+1][0] == 't' || argv[ctr+1][0] == 'T') v=3;
	    else {
	      fprintf(stderr, _("Error: No such mux input \"%s\"\n"), argv[ctr+1]);
	      PrintHelpMessage();
	      }
	    }
	  gatos_setmux(v-1);
	  ctr+=1;
	  }
	else if(argv[ctr][1] == 'v') {
	  if(argc < ctr+2)  {
	    fprintf(stderr, _("Error: -v switch needs 1 option\n"));
	    PrintHelpMessage();
	    }
	  v = strtol(argv[ctr+1], NULL, 10);
	  gatos_setvolume(v);
	  ctr+=1;
	  }
	else if(argv[ctr][1] == 's') {
	  if(argc < ctr+3)  {
	    fprintf(stderr, _("Error: -s switch needs 2 options\n"));
	    PrintHelpMessage();
	    }
	  gatos_setcapturesize(atol(argv[ctr+1]), atol(argv[ctr+2]));
	  ctr+=2;
	  }
	else if(argv[ctr][1] == 'c') {
	  if(argc < ctr+2)  {
	    fprintf(stderr, _("Error: -c switch needs 1 option\n"));
	    PrintHelpMessage();
	    }
	  v = strtol(argv[ctr+1], NULL, 10);
	  if(v<=0) {
	    int ctr2;
	    for(ctr2=0; (v<=0) && ctr2<gatos_numchans(); ++ctr2) {
	      if(!strcasecmp(argv[ctr+1], gatos_channame(ctr2))) v=ctr2+1;
	      }
	    if(v<=0) {
	      fprintf(stderr, _("Error: No such channel \"%s\"\n"), argv[ctr+1]);
	      PrintHelpMessage();
	      }
	    }
	  gatos_setmux(2); // TV-Input
	  gatos_setchan(v-1);
	  ctr+=1;
	  }
	}
      }
    else {
      if(!strcmp(argv[ctr], "rec")) {
	if(argc < ctr+3)  {
	  fprintf(stderr, _("Error: rec command needs 2 options\n"));
	  PrintHelpMessage();
	  }
	gatos_enable_capture(1);
	gatos_capture(argv[ctr+2], 0);
	if (gatos.usr1pid) kill(gatos.usr1pid,SIGSTOP) ;
	sleep(strtol(argv[ctr+1], NULL, 10));
	if (gatos.usr1pid) kill(gatos.usr1pid,SIGCONT) ;
	gatos_stop();
	gatos_enable_capture(0);
	ctr+=2;
	}
      else if(!strcmp(argv[ctr], "snap")) {
	if(argc < ctr+2)  {
	  fprintf(stderr, _("Error: snap command needs 1 option\n"));
	  PrintHelpMessage();
	  }
	gatos_enable_capture(1);
	if (gatos.usr1pid) kill(gatos.usr1pid,SIGSTOP) ;
	usleep(50000);
	if (gatos.usr1pid) kill(gatos.usr1pid,SIGSTOP) ;
	gatos_enable_capture(0);
	if (gatos.usr1pid) kill(gatos.usr1pid,SIGSTOP) ;
	usleep(50000);
	if (gatos.usr1pid) kill(gatos.usr1pid,SIGSTOP) ;
	{ int h = gatos.xcapt, v = gatos.ycapt;
	  unsigned char *rgb; FILE *fl;
	  rgb = (unsigned char *)malloc(3*h*v);
	  gatos_rgbcapture(rgb);
	  fl = fopen(argv[ctr+1], "w");
	  fprintf(fl,"P6\n%d %d\n255\n",h,v) ;
	  fwrite(rgb, 3, h*v, fl);
	  fclose(fl); 
	  free(rgb);
	  }
	ctr+=1;
	}
/*
      else if(!strcmp(argv[ctr], "tvout")) {
	if(argc < ctr+2 || (strcasecmp(argv[ctr+1], "on")
		&& strcasecmp(argv[ctr+1], "off")))  {
	  gatos_settvout(1-gatos_tvout());
	  }
	else {
	  if(!strcasecmp(argv[ctr+1], "on")) {
	    gatos_settvout(1); ++ctr;
	    }
	  else if(!strcasecmp(argv[ctr+1], "off")) {
	    gatos_settvout(0); ++ctr;
	    }
	  else {
	    fprintf(stderr, _("Error: bad command in bad place \"%s\"\n"), argv[ctr+1]);
	    PrintHelpMessage();
	    }
	  }
	}
*/
      else {
	fprintf(stderr, _("Error: unknown command \"%s\"\n"), argv[ctr]);
	PrintHelpMessage();
	}
      }
    }
  gatos_terminate();
  return 0;
  }

void PrintHelpMessage() {
  printf(_("USAGE: atitv [options] <command> [[options] <command>]...\n"));
  printf(_("\nOptions:\n"));
  printf(_("  -h --help:      Get help (this message).\n"));
  printf(_("  --version:      Get version info.\n"));
/*  printf(_("  -l <line>:      Specify which mixer line ATI card is connected to.\n")); */
  printf(_("  -m <mux>:       Specify which input to use (Composite, SVHS or TV).\n"));
  printf(_("  -v <volume>:    Set volume.\n"));
  printf(_("  -c <channel>:   Set channel.\n"));
  printf(_("  -s <xs> <ys>:   Set capture size.\n"));
  printf(_("\nCommands:\n"));
  printf(_("  rec <n> <f>:    record yuv file for n seconds to filename f.\n"));
  printf(_("  snap <f>:       capture a single ppm frame to filename f.\n"));
/*  printf(_("  tvout [on|off]: Turn tv-out signal on/off [not yet functional].\n")); */
  printf(_("\nFor Example:\n"));
  printf(_("  atitv -c 10 rec 10 f1.yuv -c 11 rec 10 f2.yuv\n"));
  printf(_("    -This will change to channel 10, record 10 seconds to \"f1.yuv\"\n"));
  printf(_("     then change to channel 11 and record 10 seconds to \"f2.yuv\"\n"));
  printf(_("  atitv -m SVHS snap pic.ppm\n"));
  printf(_("    -This will change to the SVHS connector and capture one frame\n"));
  printf(_("     to \"pic.ppm\"\n"));
  gatos_terminate();
  exit(1);
  }
