/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.impl.commands;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.DefaultMdacContextualCommand;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.ITransaction;
import com.modeliosoft.modelio.api.model.InvalidTransactionException;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.modelingwizard.impl.engine.InterfaceImplementer;

public class UpdateClassesFromInterface
extends DefaultMdacContextualCommand {
    public void actionPerformed(ObList<IElement> selectedElements, IMdac mdac) {
        InterfaceImplementer interfaceManager = new InterfaceImplementer();
        IModelingSession session = mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("Update classes from interface");
        try {
            try {
                boolean hasDoneWork = false;
                for (IElement theElement : selectedElements) {
                    IInterface theInterface = (IInterface)theElement;
                    boolean newResult = interfaceManager.updateImplementingClassifiers(session, theInterface);
                    boolean bl = hasDoneWork = hasDoneWork || newResult;
                }
                if (hasDoneWork) {
                    session.commit(transaction);
                    transaction = null;
                }
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    session.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    public boolean accept(ObList<IElement> selectedElements, IMdac mdac) {
        for (IElement theElement : selectedElements) {
            IInterface theInterface = (IInterface)theElement;
            if (theInterface.getImplementedLink().size() != 0) continue;
            return false;
        }
        return selectedElements.size() != 0;
    }

    public boolean isActiveFor(ObList<IElement> selectedElements, IMdac mdac) {
        return true;
    }
}

