#!/usr/bin/perl
# ftpwatch - Simple script to notify you of changes on ftp servers
# Copyright (C) 1997 Hakan Ardo <hakan@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

$Tmp="/tmp/ftpwatch.$$";

$passive=0;
$DiffOpt='';
foreach (@ARGV) {
    if (/^-d/) {
        s/^-d/-/;
        $DiffOpt.="$_ ";
    }
    if (/^-p/) {
        $passive=1;
    }
}

use Net::FTP;

#open (PAS, "</etc/passwd");
while (@pw = getpwent) {
    ($EMail, $p, $uid, $gid, $name, $dir, $sh)=@pw[0, 1, 2, 3, 5, 7, 8];
    next unless ($EMail eq $ENV{'USER'} || $EMail eq $ENV{'LOGNAME'});

    $ConfDir="$dir/.ftpwatch";
    $Tmp="$ConfDir/ftpwatch.tmp.$$";

    if ((-f "$dir/.ftpwatchrc") && !(-d $ConfDir)) {system("mkdir $ConfDir");}
    open (C, "<$dir/.ftpwatchrc");    
    while (<C>) {
        if (/^([^:]+):?(.{0,1}):(.+)$/) {
            $sv=$1; $rc=$2; $dir=$3; $file=undef;

            my $ftp = Net::FTP->new($sv, Debug => 0, Passive=>$passive);
            if (!$ftp) {print stderr "Connect failed: '$@'\n"; next}
            if (!$ftp->login) {print stderr "Login failed: '$@'\n"; next}
            if (!$ftp->cwd($dir))  {
              if ($dir =~ /^(.*)\/([^\/]+)$/) {
                $dir=$1; $file=$2;
                if (!$ftp->cwd($dir))  {
                  print stderr "No such dir: '$dir'\n"; next
                }
              } else {
                print stderr "No such dir: '$dir'\n"; next
              }
            }

            
            open (T, ">$Tmp.2");
            my @dr;
            if ($rc eq "R") {@dr=$ftp->dir("-R")}
            else {
              if (defined $file) {@dr=$ftp->dir($file)}
              else {@dr=$ftp->dir;}
            }

            foreach (@dr) {
              if (/^[\-dl]/ | (/^\// && /:\s*$/) && !/\s+\.\.?\s*$/ && 
                  !/^\-+\-$/) {
                s/^G//g;
                print T $_,"\n";
              }
            }
            close (F); close(T);
            $ftp->quit;

            $cf="$sv$dir$rc"; 
            if (defined $file) {$cf.="/$file";}
            $cf=~s/\//_/g; $cf="$ConfDir/$cf";

            system ("diff $DiffOpt $cf $Tmp.2 > $Tmp.3");
            system ("cp $Tmp.2 $cf");

            ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,
             $mtime,$ctime,$blksize,$blocks) = stat("$Tmp.3");
            if ($size > 0) {
                system ("mail -s \"Ftp Update: $sv$dir\" $EMail< $Tmp.3");
            }
        }
        system("rm $Tmp*");
    }
}
