<?xml version="1.0" encoding="UTF-8"?>
<!--
  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with
  this work for additional information regarding copyright ownership.
  The ASF licenses this file to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->
<!-- $Id: fo-page-sequence-splitter.xsl 430134 2006-08-09 20:20:35Z jeremias $ -->
<!-- Description: Splits an FO file into multiple FO files at page-sequence boundaries. -->
<!-- Note: Requires Xalan-J! -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fo="http://www.w3.org/1999/XSL/Format" 
    xmlns:redirect="http://xml.apache.org/xalan/redirect" 
    extension-element-prefixes="redirect">

  <xsl:template match="fo:page-sequence">
    <redirect:write select="concat('page-sequence-', position(), '.fo')">
      <fo:root>
        <xsl:apply-templates select="../fo:layout-master-set"/>
        <xsl:apply-templates select="../fo:declarations"/>
        <xsl:copy>
          <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
      </fo:root>
    </redirect:write>
  </xsl:template>

  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
