/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameDeclaration;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.typeresolution.TypeHelper;

public class UseStringBufferLength
extends AbstractRule {
    private Set<VariableNameDeclaration> alreadySeen = new HashSet<VariableNameDeclaration>();

    public Object visit(ASTCompilationUnit acu, Object data) {
        this.alreadySeen.clear();
        return super.visit(acu, data);
    }

    public Object visit(ASTName decl, Object data) {
        if (!decl.getImage().endsWith("toString")) {
            return data;
        }
        NameDeclaration nd = decl.getNameDeclaration();
        if (!(nd instanceof VariableNameDeclaration)) {
            return data;
        }
        VariableNameDeclaration vnd = (VariableNameDeclaration)nd;
        if (this.alreadySeen.contains(vnd) || !TypeHelper.isA(vnd, StringBuffer.class)) {
            return data;
        }
        this.alreadySeen.add(vnd);
        SimpleNode parent = (SimpleNode)decl.jjtGetParent().jjtGetParent();
        for (int jx = 0; jx < parent.jjtGetNumChildren(); ++jx) {
            SimpleNode achild = (SimpleNode)parent.jjtGetChild(jx);
            if (!this.isViolation(parent, achild)) continue;
            this.addViolation(data, decl);
        }
        return data;
    }

    private boolean isViolation(SimpleNode parent, SimpleNode achild) {
        if ("equals".equals(achild.getImage())) {
            List<ASTLiteral> literals = parent.findChildrenOfType(ASTLiteral.class);
            return !literals.isEmpty() && "\"\"".equals(((SimpleNode)literals.get(0)).getImage());
        }
        return "length".equals(achild.getImage());
    }
}

