#!/bin/bash

set -e

cleanup () {
    set +e
    echo "Clean up environment"
    pkill -P $PYPID
}
trap cleanup 0 2 3 15

PYPID=""

# Python 2 tests
for py in $(pyversions -i) $(py3versions -i); do
    echo "run test with $($py --version)"
    $py debian/tests/simpleapp/app.py&
    PYPID=$!

    sleep 3

    echo "Try to get one row of the sample data"
    curl -s http://localhost:4000/ | grep "Simple todo B"
    test $? -eq 0 && echo "OK" 
    sleep 1
    cleanup
    sleep 1
done
