__fish_complete_mysql mysql

complete -c mysql -f

complete -c mysql -s I -s \? -l help -d 'Display a help message'
complete -c mysql -l abort-source-on-error -d 'Abort source filename operations in case of errors'
complete -c mysql -l auto-rehash -d 'Enable automatic rehashing'
complete -c mysql -l auto-vertical-output -d 'Automatically switch to vertical output'
complete -c mysql -s B -l batch -d 'Batch mode results'
complete -c mysql -l binary-mode -d 'Binary input mode'
complete -c mysql -l character-sets-dir -x -a "(__fish_complete_directories)" -d 'Set directory where character sets are installed'
complete -c mysql -l column-names -d 'Write column names in results'
complete -c mysql -s m -l column-type-info -d 'Display result set metadata'
complete -c mysql -s c -l comments -d 'Preserve comments in statements'
complete -c mysql -l skip-comments -d 'Discard comments in statements'
complete -c mysql -s C -l compress -d 'Compress all information'
complete -c mysql -l connect-timeout -x -d 'Set the number of seconds before connection timeout'

complete -c mysql -s \# -l debug -d 'Write a debugging log'
complete -c mysql -l debug-check -d 'Print some debugging information'
complete -c mysql -s T -l debug-info -d 'Prints debugging information and memory and CPU usage'
complete -c mysql -l default-auth -x -d 'Default authentication client-side plugin'
complete -c mysql -l default-character-set -x -d 'Use charset_name as the default character set'
complete -c mysql -l defaults-extra-file -F -d 'Read default options from file after global defaults'
complete -c mysql -l defaults-file -F -d 'Read default options from file overriding global defaults'
complete -c mysql -l defaults-group-suffix -x -d 'Read groups that have the given suffix'
complete -c mysql -l delimiter -x -d 'Set the statement delimiter'
complete -c mysql -l disable-named-commands -d 'Disable named commands'
complete -c mysql -s e -l execute -x -d 'Execute the statement'
complete -c mysql -s f -l force -d 'Continue even if an SQL error occurs'
complete -c mysql -s h -l host -x -a "(__fish_print_hostnames)" -d 'Connect to the server on the given host'
complete -c mysql -s H -l html -d 'Produce HTML output'
complete -c mysql -s i -l ignore-spaces -d 'Ignore spaces after function names'
complete -c mysql -l init-command -x -d 'SQL Command to execute when connecting to the server'
complete -c mysql -l line-numbers -d 'Write line numbers for errors'
complete -c mysql -l local-infile -a '0 1' -d 'Enable or disable LOCAL capability for LOAD DATA INFILE'
complete -c mysql -l max-allowed-packet -x -d 'Set the maximum packet length'
complete -c mysql -l max-join-size -x -d 'Set the automatic limit for rows in a join'
complete -c mysql -s G -l named-commands -d 'Enable named mysql commands'
complete -c mysql -l skip-named-commands -d 'Disable named commands'
complete -c mysql -l net-buffer-length -x -d 'Set the buffer size for TCP/IP and socket communication'
complete -c mysql -s A -l no-auto-rehash -l skip-auto-rehash -l disable-auto-rehash -d 'Disable automatic rehashing'
complete -c mysql -s b -l no-beep -d 'Do not beep when errors occur'
complete -c mysql -l no-defaults -d 'Do not read default options from any option file'
complete -c mysql -s o -l one-database -d 'Ignore statements for other databases than the chosen one'
complete -c mysql -l pager -d 'Use the given command for paging query output'
complete -c mysql -l skip-pager -d 'Disable paging'
complete -c mysql -s p -l password -d 'Password to use when connecting (empty for prompt)'
complete -c mysql -s W -l pipe -d 'Connect to the server via a named pipe'
complete -c mysql -l plugin-dir -x -a "(__fish_complete_directories)" -d 'Directory for client-side plugins'
complete -c mysql -s P -l port -x -d 'The port to use for the connection'
complete -c mysql -l print-defaults -d 'Print the program argument list'
complete -c mysql -l progress-reports -d 'Get progress reports for long running commands'
complete -c mysql -l skip-progress-reports -d 'Disable progress reports for long running commands'
complete -c mysql -l prompt -x -d 'Set the prompt to the specified format'
complete -c mysql -l protocol -x -a 'TCP SOCKET PIPE MEMORY' -d 'The connection protocol to use'
complete -c mysql -s q -l quick -d 'Print each row as it is received'
complete -c mysql -s r -l raw -d 'Disables character escaping'
complete -c mysql -l reconnect -d 'Try to reconnect when connection gets lost'
complete -c mysql -l skip-reconnect -l disable-reconnect -d 'Do not try to reconnect when connection gets lost'
complete -c mysql -s U -l safe-updates -l i-am-a-dummy -d 'Allow only those statements that specify which rows to modify'
complete -c mysql -l secure-auth -d 'Do not send passwords to the server in old format'
complete -c mysql -l select-limit -x -d 'Set automatic limit for SELECT when using --safe-updates'
complete -c mysql -l server-arg -x -d 'Send a parameter to the embedded server'
complete -c mysql -l show-warnings -d 'Cause warnings to be shown'
complete -c mysql -l sigint-ignore -d 'Ignore SIGINT signals'
complete -c mysql -s s -l silent -d 'Silent mode'
complete -c mysql -s N -l skip-column-names -d 'Do not write column names in results'
complete -c mysql -s L -l skip-line-numbers -d 'Do not write line numbers for errors'
complete -c mysql -s S -l socket -F -d 'For connections to localhost the socket file or named pipe'
complete -c mysql -l ssl -d 'Enable SSL for connection'
complete -c mysql -l skip-ssl -d 'Disable SSL for connection'
complete -c mysql -l ssl-ca -F -d 'CA file in PEM format'
complete -c mysql -l ssl-capath -x -a "(__fish_complete_directories)" -d 'CA directory'
complete -c mysql -l ssl-cert -F -d 'X509 cert in PEM format'
complete -c mysql -l ssl-cipher -x -d 'SSL cipher to use'
complete -c mysql -l ssl-key -F -d 'X509 key in PEM format'
complete -c mysql -l ssl-crl -F -d 'Certificate revocation list'
complete -c mysql -l ssl-crlpath -x -a "(__fish_complete_directories)" -d 'Certificate revocation list path'
complete -c mysql -l ssl-verify-server-cert -d 'Verify server\'s "Common Name"'
complete -c mysql -s t -l table -d 'Display output in table format'
complete -c mysql -l tee -F -d 'Append a copy of output to the given file'
complete -c mysql -s n -l unbuffered -d 'Flush the buffer after each query'
complete -c mysql -s u -l user -x -d 'User name to use when connecting'
complete -c mysql -s v -l verbose -d 'Verbose mode'
complete -c mysql -s V -l version -d 'Display version information'
complete -c mysql -s E -l vertical -d 'Print query output rows vertically'
complete -c mysql -s w -l wait -d 'If the connection cannot be established, wait and retry'
complete -c mysql -s X -l xml -d 'Produce XML output'
