/* $Id: arch_ppi.c,v 1.11 2009-01-28 12:59:16 potyra Exp $ 
 *
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

struct {
	uint8_t portB;
} NAME;

#endif /* STATE */
#ifdef BEHAVIOR

static void
NAME_(inb)(struct cpssp *css, unsigned char *valp)
{
	/*
	 * 82371AB, Page 83.
	 */
	*valp = 0x00;
	*valp |= css->NAME.portB & 0x0f;
	*valp |= NAME_(in4_get)(css) << 4;
	*valp |= NAME_(in5_get)(css) << 5;
#if 0
	if (io_parity_error) {
		*valp |= 0x40;
	}
	if (mem_parity_error) {
		*valp |= 0x80;
	}
#endif
}

static void
NAME_(outb)(struct cpssp *css, unsigned char val)
{
	/*
	 * 82371AB, Page 83.
	 */
	val &= 0x0f; /* Masking "read-only" bits. */

	css->NAME.portB = val;

	NAME_(out0_set)(css, (val >> 0) & 1);
	NAME_(out1_set)(css, (val >> 1) & 1);

#if 0
	if (val & 0x04) {
		/* mem parity off */
	} else {
		/* mem parity on */
	}
#endif
#if 0
	if (val & 0x08) {
		/* io parity off */
	} else {
		/* io parity on */
	}
#endif
}

static void
NAME_(reset)(struct cpssp *css)
{
	css->NAME.portB = 0;
}

static void
NAME_(init)(struct cpssp *css)
{
	/* Nothing to do... */
}

#endif /* BEHAVIOR */
