/*
 * $Id: sig_floppy.h,v 1.4 2012-03-06 14:46:49 siflkres Exp $
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_FLOPPY_H_INCLUDED
#define __SIG_FLOPPY_H_INCLUDED

#include <inttypes.h>

#include "sig_gen.h"

struct sig_floppy_funcs {
	int (*wp)(void *cpssp);
	int (*read)(void *cpssp, unsigned int blk,
			uint8_t *data, uint8_t *trackp, uint8_t *sectorp);
	int (*write)(void *cpssp, unsigned int blk,
			const uint8_t *data, uint8_t track, uint8_t sector);
};

struct sig_floppy {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_floppy_funcs *f;
	} member[10];
	int member_count;
};

struct sig_floppy_merge {
	struct sig_floppy *s0;
	struct sig_floppy *s1;
};

extern int
sig_floppy_wp(struct sig_floppy *b, void *s);
extern int
sig_floppy_read(struct sig_floppy *b, void *s,
		unsigned int blk,
		uint8_t *data, uint8_t *trackp, uint8_t *sectorp);
extern int
sig_floppy_write(struct sig_floppy *b, void *s,
		unsigned int blk,
		const uint8_t *data, uint8_t track, uint8_t sector);

extern void
sig_floppy_connect(struct sig_floppy *sig,
		void *s, const struct sig_floppy_funcs *f);
extern void
sig_floppy_disconnect(struct sig_floppy *sig,
	        void *s);

extern struct sig_floppy_merge *
sig_floppy_merge(struct sig_floppy *s0,
		struct sig_floppy *s1);
extern void
sig_floppy_split(struct sig_floppy_merge *m);

extern struct sig_floppy *
sig_floppy_create(const char *name);
extern void
sig_floppy_destroy(struct sig_floppy *sig);

extern void
sig_floppy_suspend(struct sig_floppy *b, FILE *fSig);
extern void
sig_floppy_resume(struct sig_floppy *b, FILE *fSig);

#endif /* __SIG_FLOPPY_H_INCLUDED */
