// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file key.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__KEY_HPP
#define FAST_DDS_GENERATED__KEY_HPP

#include <cstdint>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(KEY_SOURCE)
#define KEY_DllAPI __declspec( dllexport )
#else
#define KEY_DllAPI __declspec( dllimport )
#endif // KEY_SOURCE
#else
#define KEY_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define KEY_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure KeyedShortStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedShortStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedShortStruct that will be copied.
     */
    eProsima_user_DllExport KeyedShortStruct(
            const KeyedShortStruct& x)
    {
                    m_key_short = x.m_key_short;

                    m_var_short = x.m_var_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedShortStruct that will be copied.
     */
    eProsima_user_DllExport KeyedShortStruct(
            KeyedShortStruct&& x) noexcept
    {
        m_key_short = x.m_key_short;
        m_var_short = x.m_var_short;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedShortStruct that will be copied.
     */
    eProsima_user_DllExport KeyedShortStruct& operator =(
            const KeyedShortStruct& x)
    {

                    m_key_short = x.m_key_short;

                    m_var_short = x.m_var_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedShortStruct that will be copied.
     */
    eProsima_user_DllExport KeyedShortStruct& operator =(
            KeyedShortStruct&& x) noexcept
    {

        m_key_short = x.m_key_short;
        m_var_short = x.m_var_short;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedShortStruct& x) const
    {
        return (m_key_short == x.m_key_short &&
           m_var_short == x.m_var_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedShortStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_short
     * @param _key_short New value for member key_short
     */
    eProsima_user_DllExport void key_short(
            int16_t _key_short)
    {
        m_key_short = _key_short;
    }

    /*!
     * @brief This function returns the value of member key_short
     * @return Value of member key_short
     */
    eProsima_user_DllExport int16_t key_short() const
    {
        return m_key_short;
    }

    /*!
     * @brief This function returns a reference to member key_short
     * @return Reference to member key_short
     */
    eProsima_user_DllExport int16_t& key_short()
    {
        return m_key_short;
    }


    /*!
     * @brief This function sets a value in member var_short
     * @param _var_short New value for member var_short
     */
    eProsima_user_DllExport void var_short(
            int16_t _var_short)
    {
        m_var_short = _var_short;
    }

    /*!
     * @brief This function returns the value of member var_short
     * @return Value of member var_short
     */
    eProsima_user_DllExport int16_t var_short() const
    {
        return m_var_short;
    }

    /*!
     * @brief This function returns a reference to member var_short
     * @return Reference to member var_short
     */
    eProsima_user_DllExport int16_t& var_short()
    {
        return m_var_short;
    }



private:

    int16_t m_key_short{0};
    int16_t m_var_short{0};

};
/*!
 * @brief This class represents the structure KeyedUShortStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedUShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedUShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedUShortStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedUShortStruct that will be copied.
     */
    eProsima_user_DllExport KeyedUShortStruct(
            const KeyedUShortStruct& x)
    {
                    m_key_ushort = x.m_key_ushort;

                    m_var_ushort = x.m_var_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedUShortStruct that will be copied.
     */
    eProsima_user_DllExport KeyedUShortStruct(
            KeyedUShortStruct&& x) noexcept
    {
        m_key_ushort = x.m_key_ushort;
        m_var_ushort = x.m_var_ushort;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedUShortStruct that will be copied.
     */
    eProsima_user_DllExport KeyedUShortStruct& operator =(
            const KeyedUShortStruct& x)
    {

                    m_key_ushort = x.m_key_ushort;

                    m_var_ushort = x.m_var_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedUShortStruct that will be copied.
     */
    eProsima_user_DllExport KeyedUShortStruct& operator =(
            KeyedUShortStruct&& x) noexcept
    {

        m_key_ushort = x.m_key_ushort;
        m_var_ushort = x.m_var_ushort;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedUShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedUShortStruct& x) const
    {
        return (m_key_ushort == x.m_key_ushort &&
           m_var_ushort == x.m_var_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedUShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedUShortStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_ushort
     * @param _key_ushort New value for member key_ushort
     */
    eProsima_user_DllExport void key_ushort(
            uint16_t _key_ushort)
    {
        m_key_ushort = _key_ushort;
    }

    /*!
     * @brief This function returns the value of member key_ushort
     * @return Value of member key_ushort
     */
    eProsima_user_DllExport uint16_t key_ushort() const
    {
        return m_key_ushort;
    }

    /*!
     * @brief This function returns a reference to member key_ushort
     * @return Reference to member key_ushort
     */
    eProsima_user_DllExport uint16_t& key_ushort()
    {
        return m_key_ushort;
    }


    /*!
     * @brief This function sets a value in member var_ushort
     * @param _var_ushort New value for member var_ushort
     */
    eProsima_user_DllExport void var_ushort(
            uint16_t _var_ushort)
    {
        m_var_ushort = _var_ushort;
    }

    /*!
     * @brief This function returns the value of member var_ushort
     * @return Value of member var_ushort
     */
    eProsima_user_DllExport uint16_t var_ushort() const
    {
        return m_var_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_ushort
     * @return Reference to member var_ushort
     */
    eProsima_user_DllExport uint16_t& var_ushort()
    {
        return m_var_ushort;
    }



private:

    uint16_t m_key_ushort{0};
    uint16_t m_var_ushort{0};

};
/*!
 * @brief This class represents the structure KeyedLongStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedLongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedLongStruct(
            const KeyedLongStruct& x)
    {
                    m_key_long = x.m_key_long;

                    m_var_long = x.m_var_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedLongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedLongStruct(
            KeyedLongStruct&& x) noexcept
    {
        m_key_long = x.m_key_long;
        m_var_long = x.m_var_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedLongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedLongStruct& operator =(
            const KeyedLongStruct& x)
    {

                    m_key_long = x.m_key_long;

                    m_var_long = x.m_var_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedLongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedLongStruct& operator =(
            KeyedLongStruct&& x) noexcept
    {

        m_key_long = x.m_key_long;
        m_var_long = x.m_var_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedLongStruct& x) const
    {
        return (m_key_long == x.m_key_long &&
           m_var_long == x.m_var_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_long
     * @param _key_long New value for member key_long
     */
    eProsima_user_DllExport void key_long(
            int32_t _key_long)
    {
        m_key_long = _key_long;
    }

    /*!
     * @brief This function returns the value of member key_long
     * @return Value of member key_long
     */
    eProsima_user_DllExport int32_t key_long() const
    {
        return m_key_long;
    }

    /*!
     * @brief This function returns a reference to member key_long
     * @return Reference to member key_long
     */
    eProsima_user_DllExport int32_t& key_long()
    {
        return m_key_long;
    }


    /*!
     * @brief This function sets a value in member var_long
     * @param _var_long New value for member var_long
     */
    eProsima_user_DllExport void var_long(
            int32_t _var_long)
    {
        m_var_long = _var_long;
    }

    /*!
     * @brief This function returns the value of member var_long
     * @return Value of member var_long
     */
    eProsima_user_DllExport int32_t var_long() const
    {
        return m_var_long;
    }

    /*!
     * @brief This function returns a reference to member var_long
     * @return Reference to member var_long
     */
    eProsima_user_DllExport int32_t& var_long()
    {
        return m_var_long;
    }



private:

    int32_t m_key_long{0};
    int32_t m_var_long{0};

};
/*!
 * @brief This class represents the structure KeyedULongStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedULongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedULongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedULongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedULongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedULongStruct(
            const KeyedULongStruct& x)
    {
                    m_key_ulong = x.m_key_ulong;

                    m_var_ulong = x.m_var_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedULongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedULongStruct(
            KeyedULongStruct&& x) noexcept
    {
        m_key_ulong = x.m_key_ulong;
        m_var_ulong = x.m_var_ulong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedULongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedULongStruct& operator =(
            const KeyedULongStruct& x)
    {

                    m_key_ulong = x.m_key_ulong;

                    m_var_ulong = x.m_var_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedULongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedULongStruct& operator =(
            KeyedULongStruct&& x) noexcept
    {

        m_key_ulong = x.m_key_ulong;
        m_var_ulong = x.m_var_ulong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedULongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedULongStruct& x) const
    {
        return (m_key_ulong == x.m_key_ulong &&
           m_var_ulong == x.m_var_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedULongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedULongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_ulong
     * @param _key_ulong New value for member key_ulong
     */
    eProsima_user_DllExport void key_ulong(
            uint32_t _key_ulong)
    {
        m_key_ulong = _key_ulong;
    }

    /*!
     * @brief This function returns the value of member key_ulong
     * @return Value of member key_ulong
     */
    eProsima_user_DllExport uint32_t key_ulong() const
    {
        return m_key_ulong;
    }

    /*!
     * @brief This function returns a reference to member key_ulong
     * @return Reference to member key_ulong
     */
    eProsima_user_DllExport uint32_t& key_ulong()
    {
        return m_key_ulong;
    }


    /*!
     * @brief This function sets a value in member var_ulong
     * @param _var_ulong New value for member var_ulong
     */
    eProsima_user_DllExport void var_ulong(
            uint32_t _var_ulong)
    {
        m_var_ulong = _var_ulong;
    }

    /*!
     * @brief This function returns the value of member var_ulong
     * @return Value of member var_ulong
     */
    eProsima_user_DllExport uint32_t var_ulong() const
    {
        return m_var_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_ulong
     * @return Reference to member var_ulong
     */
    eProsima_user_DllExport uint32_t& var_ulong()
    {
        return m_var_ulong;
    }



private:

    uint32_t m_key_ulong{0};
    uint32_t m_var_ulong{0};

};
/*!
 * @brief This class represents the structure KeyedLongLongStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedLongLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedLongLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedLongLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedLongLongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedLongLongStruct(
            const KeyedLongLongStruct& x)
    {
                    m_key_longlong = x.m_key_longlong;

                    m_var_longlong = x.m_var_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedLongLongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedLongLongStruct(
            KeyedLongLongStruct&& x) noexcept
    {
        m_key_longlong = x.m_key_longlong;
        m_var_longlong = x.m_var_longlong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedLongLongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedLongLongStruct& operator =(
            const KeyedLongLongStruct& x)
    {

                    m_key_longlong = x.m_key_longlong;

                    m_var_longlong = x.m_var_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedLongLongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedLongLongStruct& operator =(
            KeyedLongLongStruct&& x) noexcept
    {

        m_key_longlong = x.m_key_longlong;
        m_var_longlong = x.m_var_longlong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedLongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedLongLongStruct& x) const
    {
        return (m_key_longlong == x.m_key_longlong &&
           m_var_longlong == x.m_var_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedLongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedLongLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_longlong
     * @param _key_longlong New value for member key_longlong
     */
    eProsima_user_DllExport void key_longlong(
            int64_t _key_longlong)
    {
        m_key_longlong = _key_longlong;
    }

    /*!
     * @brief This function returns the value of member key_longlong
     * @return Value of member key_longlong
     */
    eProsima_user_DllExport int64_t key_longlong() const
    {
        return m_key_longlong;
    }

    /*!
     * @brief This function returns a reference to member key_longlong
     * @return Reference to member key_longlong
     */
    eProsima_user_DllExport int64_t& key_longlong()
    {
        return m_key_longlong;
    }


    /*!
     * @brief This function sets a value in member var_longlong
     * @param _var_longlong New value for member var_longlong
     */
    eProsima_user_DllExport void var_longlong(
            int64_t _var_longlong)
    {
        m_var_longlong = _var_longlong;
    }

    /*!
     * @brief This function returns the value of member var_longlong
     * @return Value of member var_longlong
     */
    eProsima_user_DllExport int64_t var_longlong() const
    {
        return m_var_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_longlong
     * @return Reference to member var_longlong
     */
    eProsima_user_DllExport int64_t& var_longlong()
    {
        return m_var_longlong;
    }



private:

    int64_t m_key_longlong{0};
    int64_t m_var_longlong{0};

};
/*!
 * @brief This class represents the structure KeyedULongLongStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedULongLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedULongLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedULongLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedULongLongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedULongLongStruct(
            const KeyedULongLongStruct& x)
    {
                    m_key_ulonglong = x.m_key_ulonglong;

                    m_var_ulonglong = x.m_var_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedULongLongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedULongLongStruct(
            KeyedULongLongStruct&& x) noexcept
    {
        m_key_ulonglong = x.m_key_ulonglong;
        m_var_ulonglong = x.m_var_ulonglong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedULongLongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedULongLongStruct& operator =(
            const KeyedULongLongStruct& x)
    {

                    m_key_ulonglong = x.m_key_ulonglong;

                    m_var_ulonglong = x.m_var_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedULongLongStruct that will be copied.
     */
    eProsima_user_DllExport KeyedULongLongStruct& operator =(
            KeyedULongLongStruct&& x) noexcept
    {

        m_key_ulonglong = x.m_key_ulonglong;
        m_var_ulonglong = x.m_var_ulonglong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedULongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedULongLongStruct& x) const
    {
        return (m_key_ulonglong == x.m_key_ulonglong &&
           m_var_ulonglong == x.m_var_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedULongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedULongLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_ulonglong
     * @param _key_ulonglong New value for member key_ulonglong
     */
    eProsima_user_DllExport void key_ulonglong(
            uint64_t _key_ulonglong)
    {
        m_key_ulonglong = _key_ulonglong;
    }

    /*!
     * @brief This function returns the value of member key_ulonglong
     * @return Value of member key_ulonglong
     */
    eProsima_user_DllExport uint64_t key_ulonglong() const
    {
        return m_key_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member key_ulonglong
     * @return Reference to member key_ulonglong
     */
    eProsima_user_DllExport uint64_t& key_ulonglong()
    {
        return m_key_ulonglong;
    }


    /*!
     * @brief This function sets a value in member var_ulonglong
     * @param _var_ulonglong New value for member var_ulonglong
     */
    eProsima_user_DllExport void var_ulonglong(
            uint64_t _var_ulonglong)
    {
        m_var_ulonglong = _var_ulonglong;
    }

    /*!
     * @brief This function returns the value of member var_ulonglong
     * @return Value of member var_ulonglong
     */
    eProsima_user_DllExport uint64_t var_ulonglong() const
    {
        return m_var_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_ulonglong
     * @return Reference to member var_ulonglong
     */
    eProsima_user_DllExport uint64_t& var_ulonglong()
    {
        return m_var_ulonglong;
    }



private:

    uint64_t m_key_ulonglong{0};
    uint64_t m_var_ulonglong{0};

};
/*!
 * @brief This class represents the structure KeyedFloatStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedFloatStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedFloatStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedFloatStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedFloatStruct that will be copied.
     */
    eProsima_user_DllExport KeyedFloatStruct(
            const KeyedFloatStruct& x)
    {
                    m_key_float = x.m_key_float;

                    m_var_float = x.m_var_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedFloatStruct that will be copied.
     */
    eProsima_user_DllExport KeyedFloatStruct(
            KeyedFloatStruct&& x) noexcept
    {
        m_key_float = x.m_key_float;
        m_var_float = x.m_var_float;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedFloatStruct that will be copied.
     */
    eProsima_user_DllExport KeyedFloatStruct& operator =(
            const KeyedFloatStruct& x)
    {

                    m_key_float = x.m_key_float;

                    m_var_float = x.m_var_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedFloatStruct that will be copied.
     */
    eProsima_user_DllExport KeyedFloatStruct& operator =(
            KeyedFloatStruct&& x) noexcept
    {

        m_key_float = x.m_key_float;
        m_var_float = x.m_var_float;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedFloatStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedFloatStruct& x) const
    {
        return (m_key_float == x.m_key_float &&
           m_var_float == x.m_var_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedFloatStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedFloatStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_float
     * @param _key_float New value for member key_float
     */
    eProsima_user_DllExport void key_float(
            float _key_float)
    {
        m_key_float = _key_float;
    }

    /*!
     * @brief This function returns the value of member key_float
     * @return Value of member key_float
     */
    eProsima_user_DllExport float key_float() const
    {
        return m_key_float;
    }

    /*!
     * @brief This function returns a reference to member key_float
     * @return Reference to member key_float
     */
    eProsima_user_DllExport float& key_float()
    {
        return m_key_float;
    }


    /*!
     * @brief This function sets a value in member var_float
     * @param _var_float New value for member var_float
     */
    eProsima_user_DllExport void var_float(
            float _var_float)
    {
        m_var_float = _var_float;
    }

    /*!
     * @brief This function returns the value of member var_float
     * @return Value of member var_float
     */
    eProsima_user_DllExport float var_float() const
    {
        return m_var_float;
    }

    /*!
     * @brief This function returns a reference to member var_float
     * @return Reference to member var_float
     */
    eProsima_user_DllExport float& var_float()
    {
        return m_var_float;
    }



private:

    float m_key_float{0.0};
    float m_var_float{0.0};

};
/*!
 * @brief This class represents the structure KeyedDoubleStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedDoubleStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedDoubleStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedDoubleStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedDoubleStruct that will be copied.
     */
    eProsima_user_DllExport KeyedDoubleStruct(
            const KeyedDoubleStruct& x)
    {
                    m_key_double = x.m_key_double;

                    m_var_double = x.m_var_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedDoubleStruct that will be copied.
     */
    eProsima_user_DllExport KeyedDoubleStruct(
            KeyedDoubleStruct&& x) noexcept
    {
        m_key_double = x.m_key_double;
        m_var_double = x.m_var_double;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedDoubleStruct that will be copied.
     */
    eProsima_user_DllExport KeyedDoubleStruct& operator =(
            const KeyedDoubleStruct& x)
    {

                    m_key_double = x.m_key_double;

                    m_var_double = x.m_var_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedDoubleStruct that will be copied.
     */
    eProsima_user_DllExport KeyedDoubleStruct& operator =(
            KeyedDoubleStruct&& x) noexcept
    {

        m_key_double = x.m_key_double;
        m_var_double = x.m_var_double;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedDoubleStruct& x) const
    {
        return (m_key_double == x.m_key_double &&
           m_var_double == x.m_var_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedDoubleStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_double
     * @param _key_double New value for member key_double
     */
    eProsima_user_DllExport void key_double(
            double _key_double)
    {
        m_key_double = _key_double;
    }

    /*!
     * @brief This function returns the value of member key_double
     * @return Value of member key_double
     */
    eProsima_user_DllExport double key_double() const
    {
        return m_key_double;
    }

    /*!
     * @brief This function returns a reference to member key_double
     * @return Reference to member key_double
     */
    eProsima_user_DllExport double& key_double()
    {
        return m_key_double;
    }


    /*!
     * @brief This function sets a value in member var_double
     * @param _var_double New value for member var_double
     */
    eProsima_user_DllExport void var_double(
            double _var_double)
    {
        m_var_double = _var_double;
    }

    /*!
     * @brief This function returns the value of member var_double
     * @return Value of member var_double
     */
    eProsima_user_DllExport double var_double() const
    {
        return m_var_double;
    }

    /*!
     * @brief This function returns a reference to member var_double
     * @return Reference to member var_double
     */
    eProsima_user_DllExport double& var_double()
    {
        return m_var_double;
    }



private:

    double m_key_double{0.0};
    double m_var_double{0.0};

};
/*!
 * @brief This class represents the structure KeyedLongDoubleStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedLongDoubleStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedLongDoubleStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedLongDoubleStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport KeyedLongDoubleStruct(
            const KeyedLongDoubleStruct& x)
    {
                    m_key_longdouble = x.m_key_longdouble;

                    m_var_longdouble = x.m_var_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport KeyedLongDoubleStruct(
            KeyedLongDoubleStruct&& x) noexcept
    {
        m_key_longdouble = x.m_key_longdouble;
        m_var_longdouble = x.m_var_longdouble;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport KeyedLongDoubleStruct& operator =(
            const KeyedLongDoubleStruct& x)
    {

                    m_key_longdouble = x.m_key_longdouble;

                    m_var_longdouble = x.m_var_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport KeyedLongDoubleStruct& operator =(
            KeyedLongDoubleStruct&& x) noexcept
    {

        m_key_longdouble = x.m_key_longdouble;
        m_var_longdouble = x.m_var_longdouble;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedLongDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedLongDoubleStruct& x) const
    {
        return (m_key_longdouble == x.m_key_longdouble &&
           m_var_longdouble == x.m_var_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedLongDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedLongDoubleStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_longdouble
     * @param _key_longdouble New value for member key_longdouble
     */
    eProsima_user_DllExport void key_longdouble(
            long double _key_longdouble)
    {
        m_key_longdouble = _key_longdouble;
    }

    /*!
     * @brief This function returns the value of member key_longdouble
     * @return Value of member key_longdouble
     */
    eProsima_user_DllExport long double key_longdouble() const
    {
        return m_key_longdouble;
    }

    /*!
     * @brief This function returns a reference to member key_longdouble
     * @return Reference to member key_longdouble
     */
    eProsima_user_DllExport long double& key_longdouble()
    {
        return m_key_longdouble;
    }


    /*!
     * @brief This function sets a value in member var_longdouble
     * @param _var_longdouble New value for member var_longdouble
     */
    eProsima_user_DllExport void var_longdouble(
            long double _var_longdouble)
    {
        m_var_longdouble = _var_longdouble;
    }

    /*!
     * @brief This function returns the value of member var_longdouble
     * @return Value of member var_longdouble
     */
    eProsima_user_DllExport long double var_longdouble() const
    {
        return m_var_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_longdouble
     * @return Reference to member var_longdouble
     */
    eProsima_user_DllExport long double& var_longdouble()
    {
        return m_var_longdouble;
    }



private:

    long double m_key_longdouble{0.0};
    long double m_var_longdouble{0.0};

};
/*!
 * @brief This class represents the structure KeyedBooleanStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedBooleanStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedBooleanStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedBooleanStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedBooleanStruct that will be copied.
     */
    eProsima_user_DllExport KeyedBooleanStruct(
            const KeyedBooleanStruct& x)
    {
                    m_key_boolean = x.m_key_boolean;

                    m_var_boolean = x.m_var_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedBooleanStruct that will be copied.
     */
    eProsima_user_DllExport KeyedBooleanStruct(
            KeyedBooleanStruct&& x) noexcept
    {
        m_key_boolean = x.m_key_boolean;
        m_var_boolean = x.m_var_boolean;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedBooleanStruct that will be copied.
     */
    eProsima_user_DllExport KeyedBooleanStruct& operator =(
            const KeyedBooleanStruct& x)
    {

                    m_key_boolean = x.m_key_boolean;

                    m_var_boolean = x.m_var_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedBooleanStruct that will be copied.
     */
    eProsima_user_DllExport KeyedBooleanStruct& operator =(
            KeyedBooleanStruct&& x) noexcept
    {

        m_key_boolean = x.m_key_boolean;
        m_var_boolean = x.m_var_boolean;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedBooleanStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedBooleanStruct& x) const
    {
        return (m_key_boolean == x.m_key_boolean &&
           m_var_boolean == x.m_var_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedBooleanStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedBooleanStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_boolean
     * @param _key_boolean New value for member key_boolean
     */
    eProsima_user_DllExport void key_boolean(
            bool _key_boolean)
    {
        m_key_boolean = _key_boolean;
    }

    /*!
     * @brief This function returns the value of member key_boolean
     * @return Value of member key_boolean
     */
    eProsima_user_DllExport bool key_boolean() const
    {
        return m_key_boolean;
    }

    /*!
     * @brief This function returns a reference to member key_boolean
     * @return Reference to member key_boolean
     */
    eProsima_user_DllExport bool& key_boolean()
    {
        return m_key_boolean;
    }


    /*!
     * @brief This function sets a value in member var_boolean
     * @param _var_boolean New value for member var_boolean
     */
    eProsima_user_DllExport void var_boolean(
            bool _var_boolean)
    {
        m_var_boolean = _var_boolean;
    }

    /*!
     * @brief This function returns the value of member var_boolean
     * @return Value of member var_boolean
     */
    eProsima_user_DllExport bool var_boolean() const
    {
        return m_var_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_boolean
     * @return Reference to member var_boolean
     */
    eProsima_user_DllExport bool& var_boolean()
    {
        return m_var_boolean;
    }



private:

    bool m_key_boolean{false};
    bool m_var_boolean{false};

};
/*!
 * @brief This class represents the structure KeyedOctetStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedOctetStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedOctetStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedOctetStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedOctetStruct that will be copied.
     */
    eProsima_user_DllExport KeyedOctetStruct(
            const KeyedOctetStruct& x)
    {
                    m_key_octet = x.m_key_octet;

                    m_var_octet = x.m_var_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedOctetStruct that will be copied.
     */
    eProsima_user_DllExport KeyedOctetStruct(
            KeyedOctetStruct&& x) noexcept
    {
        m_key_octet = x.m_key_octet;
        m_var_octet = x.m_var_octet;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedOctetStruct that will be copied.
     */
    eProsima_user_DllExport KeyedOctetStruct& operator =(
            const KeyedOctetStruct& x)
    {

                    m_key_octet = x.m_key_octet;

                    m_var_octet = x.m_var_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedOctetStruct that will be copied.
     */
    eProsima_user_DllExport KeyedOctetStruct& operator =(
            KeyedOctetStruct&& x) noexcept
    {

        m_key_octet = x.m_key_octet;
        m_var_octet = x.m_var_octet;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedOctetStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedOctetStruct& x) const
    {
        return (m_key_octet == x.m_key_octet &&
           m_var_octet == x.m_var_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedOctetStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedOctetStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_octet
     * @param _key_octet New value for member key_octet
     */
    eProsima_user_DllExport void key_octet(
            uint8_t _key_octet)
    {
        m_key_octet = _key_octet;
    }

    /*!
     * @brief This function returns the value of member key_octet
     * @return Value of member key_octet
     */
    eProsima_user_DllExport uint8_t key_octet() const
    {
        return m_key_octet;
    }

    /*!
     * @brief This function returns a reference to member key_octet
     * @return Reference to member key_octet
     */
    eProsima_user_DllExport uint8_t& key_octet()
    {
        return m_key_octet;
    }


    /*!
     * @brief This function sets a value in member var_octet
     * @param _var_octet New value for member var_octet
     */
    eProsima_user_DllExport void var_octet(
            uint8_t _var_octet)
    {
        m_var_octet = _var_octet;
    }

    /*!
     * @brief This function returns the value of member var_octet
     * @return Value of member var_octet
     */
    eProsima_user_DllExport uint8_t var_octet() const
    {
        return m_var_octet;
    }

    /*!
     * @brief This function returns a reference to member var_octet
     * @return Reference to member var_octet
     */
    eProsima_user_DllExport uint8_t& var_octet()
    {
        return m_var_octet;
    }



private:

    uint8_t m_key_octet{0};
    uint8_t m_var_octet{0};

};
/*!
 * @brief This class represents the structure KeyedCharStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedCharStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedCharStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedCharStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedCharStruct that will be copied.
     */
    eProsima_user_DllExport KeyedCharStruct(
            const KeyedCharStruct& x)
    {
                    m_key_char8 = x.m_key_char8;

                    m_var_char8 = x.m_var_char8;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedCharStruct that will be copied.
     */
    eProsima_user_DllExport KeyedCharStruct(
            KeyedCharStruct&& x) noexcept
    {
        m_key_char8 = x.m_key_char8;
        m_var_char8 = x.m_var_char8;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedCharStruct that will be copied.
     */
    eProsima_user_DllExport KeyedCharStruct& operator =(
            const KeyedCharStruct& x)
    {

                    m_key_char8 = x.m_key_char8;

                    m_var_char8 = x.m_var_char8;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedCharStruct that will be copied.
     */
    eProsima_user_DllExport KeyedCharStruct& operator =(
            KeyedCharStruct&& x) noexcept
    {

        m_key_char8 = x.m_key_char8;
        m_var_char8 = x.m_var_char8;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedCharStruct& x) const
    {
        return (m_key_char8 == x.m_key_char8 &&
           m_var_char8 == x.m_var_char8);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedCharStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_char8
     * @param _key_char8 New value for member key_char8
     */
    eProsima_user_DllExport void key_char8(
            char _key_char8)
    {
        m_key_char8 = _key_char8;
    }

    /*!
     * @brief This function returns the value of member key_char8
     * @return Value of member key_char8
     */
    eProsima_user_DllExport char key_char8() const
    {
        return m_key_char8;
    }

    /*!
     * @brief This function returns a reference to member key_char8
     * @return Reference to member key_char8
     */
    eProsima_user_DllExport char& key_char8()
    {
        return m_key_char8;
    }


    /*!
     * @brief This function sets a value in member var_char8
     * @param _var_char8 New value for member var_char8
     */
    eProsima_user_DllExport void var_char8(
            char _var_char8)
    {
        m_var_char8 = _var_char8;
    }

    /*!
     * @brief This function returns the value of member var_char8
     * @return Value of member var_char8
     */
    eProsima_user_DllExport char var_char8() const
    {
        return m_var_char8;
    }

    /*!
     * @brief This function returns a reference to member var_char8
     * @return Reference to member var_char8
     */
    eProsima_user_DllExport char& var_char8()
    {
        return m_var_char8;
    }



private:

    char m_key_char8{0};
    char m_var_char8{0};

};
/*!
 * @brief This class represents the structure KeyedWCharStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedWCharStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedWCharStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedWCharStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedWCharStruct that will be copied.
     */
    eProsima_user_DllExport KeyedWCharStruct(
            const KeyedWCharStruct& x)
    {
                    m_key_char16 = x.m_key_char16;

                    m_var_char16 = x.m_var_char16;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedWCharStruct that will be copied.
     */
    eProsima_user_DllExport KeyedWCharStruct(
            KeyedWCharStruct&& x) noexcept
    {
        m_key_char16 = x.m_key_char16;
        m_var_char16 = x.m_var_char16;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedWCharStruct that will be copied.
     */
    eProsima_user_DllExport KeyedWCharStruct& operator =(
            const KeyedWCharStruct& x)
    {

                    m_key_char16 = x.m_key_char16;

                    m_var_char16 = x.m_var_char16;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedWCharStruct that will be copied.
     */
    eProsima_user_DllExport KeyedWCharStruct& operator =(
            KeyedWCharStruct&& x) noexcept
    {

        m_key_char16 = x.m_key_char16;
        m_var_char16 = x.m_var_char16;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedWCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedWCharStruct& x) const
    {
        return (m_key_char16 == x.m_key_char16 &&
           m_var_char16 == x.m_var_char16);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedWCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedWCharStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_char16
     * @param _key_char16 New value for member key_char16
     */
    eProsima_user_DllExport void key_char16(
            wchar_t _key_char16)
    {
        m_key_char16 = _key_char16;
    }

    /*!
     * @brief This function returns the value of member key_char16
     * @return Value of member key_char16
     */
    eProsima_user_DllExport wchar_t key_char16() const
    {
        return m_key_char16;
    }

    /*!
     * @brief This function returns a reference to member key_char16
     * @return Reference to member key_char16
     */
    eProsima_user_DllExport wchar_t& key_char16()
    {
        return m_key_char16;
    }


    /*!
     * @brief This function sets a value in member var_char16
     * @param _var_char16 New value for member var_char16
     */
    eProsima_user_DllExport void var_char16(
            wchar_t _var_char16)
    {
        m_var_char16 = _var_char16;
    }

    /*!
     * @brief This function returns the value of member var_char16
     * @return Value of member var_char16
     */
    eProsima_user_DllExport wchar_t var_char16() const
    {
        return m_var_char16;
    }

    /*!
     * @brief This function returns a reference to member var_char16
     * @return Reference to member var_char16
     */
    eProsima_user_DllExport wchar_t& var_char16()
    {
        return m_var_char16;
    }



private:

    wchar_t m_key_char16{0};
    wchar_t m_var_char16{0};

};
/*!
 * @brief This class represents the structure KeyedEmptyStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedEmptyStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedEmptyStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedEmptyStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedEmptyStruct that will be copied.
     */
    eProsima_user_DllExport KeyedEmptyStruct(
            const KeyedEmptyStruct& x)
    {
                    m_key_short = x.m_key_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedEmptyStruct that will be copied.
     */
    eProsima_user_DllExport KeyedEmptyStruct(
            KeyedEmptyStruct&& x) noexcept
    {
        m_key_short = x.m_key_short;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedEmptyStruct that will be copied.
     */
    eProsima_user_DllExport KeyedEmptyStruct& operator =(
            const KeyedEmptyStruct& x)
    {

                    m_key_short = x.m_key_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedEmptyStruct that will be copied.
     */
    eProsima_user_DllExport KeyedEmptyStruct& operator =(
            KeyedEmptyStruct&& x) noexcept
    {

        m_key_short = x.m_key_short;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedEmptyStruct& x) const
    {
        return (m_key_short == x.m_key_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedEmptyStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_short
     * @param _key_short New value for member key_short
     */
    eProsima_user_DllExport void key_short(
            int16_t _key_short)
    {
        m_key_short = _key_short;
    }

    /*!
     * @brief This function returns the value of member key_short
     * @return Value of member key_short
     */
    eProsima_user_DllExport int16_t key_short() const
    {
        return m_key_short;
    }

    /*!
     * @brief This function returns a reference to member key_short
     * @return Reference to member key_short
     */
    eProsima_user_DllExport int16_t& key_short()
    {
        return m_key_short;
    }



private:

    int16_t m_key_short{0};

};
/*!
 * @brief This class represents the structure KeyedEmptyInheritanceStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedEmptyInheritanceStruct : public KeyedEmptyStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedEmptyInheritanceStruct()
        : KeyedEmptyStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedEmptyInheritanceStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport KeyedEmptyInheritanceStruct(
            const KeyedEmptyInheritanceStruct& x)
        : KeyedEmptyStruct(x)
    {
                    m_key_str = x.m_key_str;

                    m_var_str = x.m_var_str;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport KeyedEmptyInheritanceStruct(
            KeyedEmptyInheritanceStruct&& x) noexcept
        : KeyedEmptyStruct(std::move(x))

    {
        m_key_str = std::move(x.m_key_str);
        m_var_str = std::move(x.m_var_str);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport KeyedEmptyInheritanceStruct& operator =(
            const KeyedEmptyInheritanceStruct& x)
    {
        KeyedEmptyStruct::operator =(x);

                    m_key_str = x.m_key_str;

                    m_var_str = x.m_var_str;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport KeyedEmptyInheritanceStruct& operator =(
            KeyedEmptyInheritanceStruct&& x) noexcept
    {
        KeyedEmptyStruct::operator =(std::move(x));

        m_key_str = std::move(x.m_key_str);
        m_var_str = std::move(x.m_var_str);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedEmptyInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedEmptyInheritanceStruct& x) const
    {
        if (KeyedEmptyStruct::operator !=(x))
                {
                    return false;
                }
        return (m_key_str == x.m_key_str &&
           m_var_str == x.m_var_str);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedEmptyInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedEmptyInheritanceStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member key_str
     * @param _key_str New value to be copied in member key_str
     */
    eProsima_user_DllExport void key_str(
            const std::string& _key_str)
    {
        m_key_str = _key_str;
    }

    /*!
     * @brief This function moves the value in member key_str
     * @param _key_str New value to be moved in member key_str
     */
    eProsima_user_DllExport void key_str(
            std::string&& _key_str)
    {
        m_key_str = std::move(_key_str);
    }

    /*!
     * @brief This function returns a constant reference to member key_str
     * @return Constant reference to member key_str
     */
    eProsima_user_DllExport const std::string& key_str() const
    {
        return m_key_str;
    }

    /*!
     * @brief This function returns a reference to member key_str
     * @return Reference to member key_str
     */
    eProsima_user_DllExport std::string& key_str()
    {
        return m_key_str;
    }


    /*!
     * @brief This function copies the value in member var_str
     * @param _var_str New value to be copied in member var_str
     */
    eProsima_user_DllExport void var_str(
            const std::string& _var_str)
    {
        m_var_str = _var_str;
    }

    /*!
     * @brief This function moves the value in member var_str
     * @param _var_str New value to be moved in member var_str
     */
    eProsima_user_DllExport void var_str(
            std::string&& _var_str)
    {
        m_var_str = std::move(_var_str);
    }

    /*!
     * @brief This function returns a constant reference to member var_str
     * @return Constant reference to member var_str
     */
    eProsima_user_DllExport const std::string& var_str() const
    {
        return m_var_str;
    }

    /*!
     * @brief This function returns a reference to member var_str
     * @return Reference to member var_str
     */
    eProsima_user_DllExport std::string& var_str()
    {
        return m_var_str;
    }



private:

    std::string m_key_str;
    std::string m_var_str;

};
/*!
 * @brief This class represents the structure KeyedInheritanceStruct defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedInheritanceStruct : public KeyedShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedInheritanceStruct()
        : KeyedShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedInheritanceStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport KeyedInheritanceStruct(
            const KeyedInheritanceStruct& x)
        : KeyedShortStruct(x)
    {
                    m_key_str = x.m_key_str;

                    m_var_str = x.m_var_str;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport KeyedInheritanceStruct(
            KeyedInheritanceStruct&& x) noexcept
        : KeyedShortStruct(std::move(x))

    {
        m_key_str = std::move(x.m_key_str);
        m_var_str = std::move(x.m_var_str);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport KeyedInheritanceStruct& operator =(
            const KeyedInheritanceStruct& x)
    {
        KeyedShortStruct::operator =(x);

                    m_key_str = x.m_key_str;

                    m_var_str = x.m_var_str;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport KeyedInheritanceStruct& operator =(
            KeyedInheritanceStruct&& x) noexcept
    {
        KeyedShortStruct::operator =(std::move(x));

        m_key_str = std::move(x.m_key_str);
        m_var_str = std::move(x.m_var_str);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedInheritanceStruct& x) const
    {
        if (KeyedShortStruct::operator !=(x))
                {
                    return false;
                }
        return (m_key_str == x.m_key_str &&
           m_var_str == x.m_var_str);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedInheritanceStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member key_str
     * @param _key_str New value to be copied in member key_str
     */
    eProsima_user_DllExport void key_str(
            const std::string& _key_str)
    {
        m_key_str = _key_str;
    }

    /*!
     * @brief This function moves the value in member key_str
     * @param _key_str New value to be moved in member key_str
     */
    eProsima_user_DllExport void key_str(
            std::string&& _key_str)
    {
        m_key_str = std::move(_key_str);
    }

    /*!
     * @brief This function returns a constant reference to member key_str
     * @return Constant reference to member key_str
     */
    eProsima_user_DllExport const std::string& key_str() const
    {
        return m_key_str;
    }

    /*!
     * @brief This function returns a reference to member key_str
     * @return Reference to member key_str
     */
    eProsima_user_DllExport std::string& key_str()
    {
        return m_key_str;
    }


    /*!
     * @brief This function copies the value in member var_str
     * @param _var_str New value to be copied in member var_str
     */
    eProsima_user_DllExport void var_str(
            const std::string& _var_str)
    {
        m_var_str = _var_str;
    }

    /*!
     * @brief This function moves the value in member var_str
     * @param _var_str New value to be moved in member var_str
     */
    eProsima_user_DllExport void var_str(
            std::string&& _var_str)
    {
        m_var_str = std::move(_var_str);
    }

    /*!
     * @brief This function returns a constant reference to member var_str
     * @return Constant reference to member var_str
     */
    eProsima_user_DllExport const std::string& var_str() const
    {
        return m_var_str;
    }

    /*!
     * @brief This function returns a reference to member var_str
     * @return Reference to member var_str
     */
    eProsima_user_DllExport std::string& var_str()
    {
        return m_var_str;
    }



private:

    std::string m_key_str;
    std::string m_var_str;

};
/*!
 * @brief This class represents the structure InheritanceKeyedEmptyStruct defined by the user in the IDL file.
 * @ingroup key
 */
class InheritanceKeyedEmptyStruct : public KeyedShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport InheritanceKeyedEmptyStruct()
        : KeyedShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~InheritanceKeyedEmptyStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object InheritanceKeyedEmptyStruct that will be copied.
     */
    eProsima_user_DllExport InheritanceKeyedEmptyStruct(
            const InheritanceKeyedEmptyStruct& x)
        : KeyedShortStruct(x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object InheritanceKeyedEmptyStruct that will be copied.
     */
    eProsima_user_DllExport InheritanceKeyedEmptyStruct(
            InheritanceKeyedEmptyStruct&& x) noexcept
        : KeyedShortStruct(std::move(x))

    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object InheritanceKeyedEmptyStruct that will be copied.
     */
    eProsima_user_DllExport InheritanceKeyedEmptyStruct& operator =(
            const InheritanceKeyedEmptyStruct& x)
    {
        KeyedShortStruct::operator =(x);

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object InheritanceKeyedEmptyStruct that will be copied.
     */
    eProsima_user_DllExport InheritanceKeyedEmptyStruct& operator =(
            InheritanceKeyedEmptyStruct&& x) noexcept
    {
        KeyedShortStruct::operator =(std::move(x));

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x InheritanceKeyedEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InheritanceKeyedEmptyStruct& x) const
    {
        if (KeyedShortStruct::operator !=(x))
                {
                    return false;
                }
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x InheritanceKeyedEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InheritanceKeyedEmptyStruct& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure KeyedFinal defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedFinal
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedFinal()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedFinal()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedFinal that will be copied.
     */
    eProsima_user_DllExport KeyedFinal(
            const KeyedFinal& x)
    {
                    m_key_long = x.m_key_long;

                    m_key_short = x.m_key_short;

                    m_key_string = x.m_key_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedFinal that will be copied.
     */
    eProsima_user_DllExport KeyedFinal(
            KeyedFinal&& x) noexcept
    {
        m_key_long = x.m_key_long;
        m_key_short = x.m_key_short;
        m_key_string = std::move(x.m_key_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedFinal that will be copied.
     */
    eProsima_user_DllExport KeyedFinal& operator =(
            const KeyedFinal& x)
    {

                    m_key_long = x.m_key_long;

                    m_key_short = x.m_key_short;

                    m_key_string = x.m_key_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedFinal that will be copied.
     */
    eProsima_user_DllExport KeyedFinal& operator =(
            KeyedFinal&& x) noexcept
    {

        m_key_long = x.m_key_long;
        m_key_short = x.m_key_short;
        m_key_string = std::move(x.m_key_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedFinal object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedFinal& x) const
    {
        return (m_key_long == x.m_key_long &&
           m_key_short == x.m_key_short &&
           m_key_string == x.m_key_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedFinal object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedFinal& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_long
     * @param _key_long New value for member key_long
     */
    eProsima_user_DllExport void key_long(
            int32_t _key_long)
    {
        m_key_long = _key_long;
    }

    /*!
     * @brief This function returns the value of member key_long
     * @return Value of member key_long
     */
    eProsima_user_DllExport int32_t key_long() const
    {
        return m_key_long;
    }

    /*!
     * @brief This function returns a reference to member key_long
     * @return Reference to member key_long
     */
    eProsima_user_DllExport int32_t& key_long()
    {
        return m_key_long;
    }


    /*!
     * @brief This function sets a value in member key_short
     * @param _key_short New value for member key_short
     */
    eProsima_user_DllExport void key_short(
            int16_t _key_short)
    {
        m_key_short = _key_short;
    }

    /*!
     * @brief This function returns the value of member key_short
     * @return Value of member key_short
     */
    eProsima_user_DllExport int16_t key_short() const
    {
        return m_key_short;
    }

    /*!
     * @brief This function returns a reference to member key_short
     * @return Reference to member key_short
     */
    eProsima_user_DllExport int16_t& key_short()
    {
        return m_key_short;
    }


    /*!
     * @brief This function copies the value in member key_string
     * @param _key_string New value to be copied in member key_string
     */
    eProsima_user_DllExport void key_string(
            const std::string& _key_string)
    {
        m_key_string = _key_string;
    }

    /*!
     * @brief This function moves the value in member key_string
     * @param _key_string New value to be moved in member key_string
     */
    eProsima_user_DllExport void key_string(
            std::string&& _key_string)
    {
        m_key_string = std::move(_key_string);
    }

    /*!
     * @brief This function returns a constant reference to member key_string
     * @return Constant reference to member key_string
     */
    eProsima_user_DllExport const std::string& key_string() const
    {
        return m_key_string;
    }

    /*!
     * @brief This function returns a reference to member key_string
     * @return Reference to member key_string
     */
    eProsima_user_DllExport std::string& key_string()
    {
        return m_key_string;
    }



private:

    int32_t m_key_long{0};
    int16_t m_key_short{0};
    std::string m_key_string;

};
/*!
 * @brief This class represents the structure KeyedAppendable defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedAppendable
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedAppendable()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedAppendable()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedAppendable that will be copied.
     */
    eProsima_user_DllExport KeyedAppendable(
            const KeyedAppendable& x)
    {
                    m_key_long = x.m_key_long;

                    m_key_short = x.m_key_short;

                    m_key_string = x.m_key_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedAppendable that will be copied.
     */
    eProsima_user_DllExport KeyedAppendable(
            KeyedAppendable&& x) noexcept
    {
        m_key_long = x.m_key_long;
        m_key_short = x.m_key_short;
        m_key_string = std::move(x.m_key_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedAppendable that will be copied.
     */
    eProsima_user_DllExport KeyedAppendable& operator =(
            const KeyedAppendable& x)
    {

                    m_key_long = x.m_key_long;

                    m_key_short = x.m_key_short;

                    m_key_string = x.m_key_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedAppendable that will be copied.
     */
    eProsima_user_DllExport KeyedAppendable& operator =(
            KeyedAppendable&& x) noexcept
    {

        m_key_long = x.m_key_long;
        m_key_short = x.m_key_short;
        m_key_string = std::move(x.m_key_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedAppendable object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedAppendable& x) const
    {
        return (m_key_long == x.m_key_long &&
           m_key_short == x.m_key_short &&
           m_key_string == x.m_key_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedAppendable object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedAppendable& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_long
     * @param _key_long New value for member key_long
     */
    eProsima_user_DllExport void key_long(
            int32_t _key_long)
    {
        m_key_long = _key_long;
    }

    /*!
     * @brief This function returns the value of member key_long
     * @return Value of member key_long
     */
    eProsima_user_DllExport int32_t key_long() const
    {
        return m_key_long;
    }

    /*!
     * @brief This function returns a reference to member key_long
     * @return Reference to member key_long
     */
    eProsima_user_DllExport int32_t& key_long()
    {
        return m_key_long;
    }


    /*!
     * @brief This function sets a value in member key_short
     * @param _key_short New value for member key_short
     */
    eProsima_user_DllExport void key_short(
            int16_t _key_short)
    {
        m_key_short = _key_short;
    }

    /*!
     * @brief This function returns the value of member key_short
     * @return Value of member key_short
     */
    eProsima_user_DllExport int16_t key_short() const
    {
        return m_key_short;
    }

    /*!
     * @brief This function returns a reference to member key_short
     * @return Reference to member key_short
     */
    eProsima_user_DllExport int16_t& key_short()
    {
        return m_key_short;
    }


    /*!
     * @brief This function copies the value in member key_string
     * @param _key_string New value to be copied in member key_string
     */
    eProsima_user_DllExport void key_string(
            const std::string& _key_string)
    {
        m_key_string = _key_string;
    }

    /*!
     * @brief This function moves the value in member key_string
     * @param _key_string New value to be moved in member key_string
     */
    eProsima_user_DllExport void key_string(
            std::string&& _key_string)
    {
        m_key_string = std::move(_key_string);
    }

    /*!
     * @brief This function returns a constant reference to member key_string
     * @return Constant reference to member key_string
     */
    eProsima_user_DllExport const std::string& key_string() const
    {
        return m_key_string;
    }

    /*!
     * @brief This function returns a reference to member key_string
     * @return Reference to member key_string
     */
    eProsima_user_DllExport std::string& key_string()
    {
        return m_key_string;
    }



private:

    int32_t m_key_long{0};
    int16_t m_key_short{0};
    std::string m_key_string;

};
/*!
 * @brief This class represents the structure KeyedMutable defined by the user in the IDL file.
 * @ingroup key
 */
class KeyedMutable
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport KeyedMutable()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~KeyedMutable()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object KeyedMutable that will be copied.
     */
    eProsima_user_DllExport KeyedMutable(
            const KeyedMutable& x)
    {
                    m_key_long = x.m_key_long;

                    m_key_short = x.m_key_short;

                    m_key_string = x.m_key_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object KeyedMutable that will be copied.
     */
    eProsima_user_DllExport KeyedMutable(
            KeyedMutable&& x) noexcept
    {
        m_key_long = x.m_key_long;
        m_key_short = x.m_key_short;
        m_key_string = std::move(x.m_key_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object KeyedMutable that will be copied.
     */
    eProsima_user_DllExport KeyedMutable& operator =(
            const KeyedMutable& x)
    {

                    m_key_long = x.m_key_long;

                    m_key_short = x.m_key_short;

                    m_key_string = x.m_key_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object KeyedMutable that will be copied.
     */
    eProsima_user_DllExport KeyedMutable& operator =(
            KeyedMutable&& x) noexcept
    {

        m_key_long = x.m_key_long;
        m_key_short = x.m_key_short;
        m_key_string = std::move(x.m_key_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedMutable object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const KeyedMutable& x) const
    {
        return (m_key_long == x.m_key_long &&
           m_key_short == x.m_key_short &&
           m_key_string == x.m_key_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x KeyedMutable object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const KeyedMutable& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member key_long
     * @param _key_long New value for member key_long
     */
    eProsima_user_DllExport void key_long(
            int32_t _key_long)
    {
        m_key_long = _key_long;
    }

    /*!
     * @brief This function returns the value of member key_long
     * @return Value of member key_long
     */
    eProsima_user_DllExport int32_t key_long() const
    {
        return m_key_long;
    }

    /*!
     * @brief This function returns a reference to member key_long
     * @return Reference to member key_long
     */
    eProsima_user_DllExport int32_t& key_long()
    {
        return m_key_long;
    }


    /*!
     * @brief This function sets a value in member key_short
     * @param _key_short New value for member key_short
     */
    eProsima_user_DllExport void key_short(
            int16_t _key_short)
    {
        m_key_short = _key_short;
    }

    /*!
     * @brief This function returns the value of member key_short
     * @return Value of member key_short
     */
    eProsima_user_DllExport int16_t key_short() const
    {
        return m_key_short;
    }

    /*!
     * @brief This function returns a reference to member key_short
     * @return Reference to member key_short
     */
    eProsima_user_DllExport int16_t& key_short()
    {
        return m_key_short;
    }


    /*!
     * @brief This function copies the value in member key_string
     * @param _key_string New value to be copied in member key_string
     */
    eProsima_user_DllExport void key_string(
            const std::string& _key_string)
    {
        m_key_string = _key_string;
    }

    /*!
     * @brief This function moves the value in member key_string
     * @param _key_string New value to be moved in member key_string
     */
    eProsima_user_DllExport void key_string(
            std::string&& _key_string)
    {
        m_key_string = std::move(_key_string);
    }

    /*!
     * @brief This function returns a constant reference to member key_string
     * @return Constant reference to member key_string
     */
    eProsima_user_DllExport const std::string& key_string() const
    {
        return m_key_string;
    }

    /*!
     * @brief This function returns a reference to member key_string
     * @return Reference to member key_string
     */
    eProsima_user_DllExport std::string& key_string()
    {
        return m_key_string;
    }



private:

    int32_t m_key_long{0};
    int16_t m_key_short{0};
    std::string m_key_string;

};

#endif // _FAST_DDS_GENERATED_KEY_HPP_


