# О версиях FastAPI

**FastAPI** уже используется в продакшене во многих приложениях и системах. Покрытие тестами поддерживается на уровне 100%. Однако его разработка все еще продолжается.

Часто добавляются новые функции, регулярно исправляются баги, код продолжает постоянно совершенствоваться.

По указанным причинам текущие версии до сих пор `0.x.x`. Это говорит о том, что каждая версия может содержать обратно несовместимые изменения, следуя <a href="https://semver.org/" class="external-link" target="_blank">соглашению о Семантическом Версионировании</a>.

Уже сейчас вы можете создавать приложения в продакшене, используя **FastAPI**  (и скорее всего так и делаете), главное убедиться в том, что вы используете версию, которая корректно работает с вашим кодом.

## Закрепите вашу версию `fastapi`

Первым делом вам следует "закрепить" конкретную последнюю используемую версию **FastAPI**, которая корректно работает с вашим приложением.

Например, в своём приложении вы используете версию `0.45.0`.

Если вы используете файл `requirements.txt`, вы можете указать версию следующим способом:

```txt
fastapi==0.45.0
```

это означает, что вы будете использовать именно версию `0.45.0`.

Или вы можете закрепить версию следующим способом:

```txt
fastapi>=0.45.0,<0.46.0
```

это значит, что вы используете версии `0.45.0` или выше, но меньше чем `0.46.0`. Например, версия `0.45.2` все еще будет подходить.

Если вы используете любой другой инструмент для управления зависимостями, например Poetry, Pipenv или др., у них у всех имеется способ определения специфической версии для ваших пакетов.

## Доступные версии

Вы можете посмотреть доступные версии (например, проверить последнюю на данный момент) в [примечаниях к выпуску](../release-notes.md){.internal-link target=_blank}.

## О версиях

Следуя соглашению о Семантическом Версионировании, любые версии ниже `1.0.0` потенциально могут добавить обратно несовместимые изменения.

FastAPI следует соглашению в том, что любые изменения "ПАТЧ"-версии предназначены для исправления багов и внесения обратно совместимых изменений.

!!! Подсказка
    "ПАТЧ" - это последнее число. Например, в `0.2.3`, ПАТЧ-версия - это `3`.

Итак, вы можете закрепить версию следующим образом:

```txt
fastapi>=0.45.0,<0.46.0
```

Обратно несовместимые изменения и новые функции добавляются в "МИНОРНЫЕ" версии.

!!! Подсказка
    "МИНОРНАЯ" версия - это число в середине. Например, в `0.2.3` МИНОРНАЯ версия - это `2`.

## Обновление версий FastAPI

Вам следует добавить тесты для вашего приложения.

С помощью **FastAPI** это очень просто (благодаря Starlette), см. документацию: [Тестирование](../tutorial/testing.md){.internal-link target=_blank}

После создания тестов вы можете обновить свою версию **FastAPI** до более новой. После этого следует убедиться, что ваш код работает корректно, запустив тесты.

Если все работает корректно, или после внесения необходимых изменений все ваши тесты проходят, только тогда вы можете закрепить вашу новую версию `fastapi`.

## О Starlette

Не следует закреплять версию `starlette`.

Разные версии **FastAPI** будут использовать более новые версии Starlette.

Так что решение об используемой версии Starlette, вы можете оставить **FastAPI**.

## О Pydantic

Pydantic включает свои собственные тесты для **FastAPI**, так что новые версии Pydantic (выше `1.0.0`) всегда совместимы с FastAPI.

Вы можете закрепить любую версию Pydantic, которая вам подходит, выше `1.0.0` и ниже `2.0.0`.

Например:

```txt
pydantic>=1.2.0,<2.0.0
```
