// -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
// vi: set et ts=4 sw=2 sts=2:
//
// WARNING
// This file is automatically generated by gaussradau.mac! Don't edit by hand!
#ifndef DUNE_GEOMETRY_QUADRATURE_GaussRadauRight_HH
#define DUNE_GEOMETRY_QUADRATURE_GaussRadauRight_HH

#ifndef DUNE_INCLUDING_IMPLEMENTATION
#error This is a private header that should not be included directly.
#error Use #include <dune/geometry/quadraturerules.hh> instead.
#endif

namespace Dune {

  /************************************************
   * Quadraturerule for 1d line
   *************************************************/

  template<typename ct, int dim>
  class GaussRadauRightQuadratureRule;

  template<typename ct>
  using GaussRadauRightQuadratureRule1D = GaussRadauRightQuadratureRule<ct,1>;

  template<typename ct>
  class GaussRadauRightQuadratureRule<ct,1> : public QuadratureRule<ct,1>
  {
  public:
    /** brief The highest quadrature order available */
    enum { highest_order=30 };

  private:
    friend class QuadratureRuleFactory<ct,1>;
    GaussRadauRightQuadratureRule (int p);
    ~GaussRadauRightQuadratureRule(){}
  };

  //! internal Helper template for the initialization of the quadrature rules
  template<typename ct,
      bool fundamental = std::is_floating_point<ct>::value>
  struct GaussRadauRightQuadratureInitHelper;

  template<typename ct>
  struct GaussRadauRightQuadratureInitHelper<ct, true> {
    static void init(int p,
                     std::vector< FieldVector<ct, 1> > & _points,
                     std::vector< ct > & _weight,
                     int & delivered_order);
  };

  template<typename ct>
  struct GaussRadauRightQuadratureInitHelper<ct, false> {
    static void init(int p,
                     std::vector< FieldVector<ct, 1> > & _points,
                     std::vector< ct > & _weight,
                     int & delivered_order);
  };

  // for fundamental types
  template<typename ct>
  void GaussRadauRightQuadratureInitHelper<ct,true>::init(int p,
         std::vector< FieldVector<ct, 1> > & _points,
         std::vector< ct > & _weight,
         int & delivered_order)
  {
    switch(p)
    {
    case 0 :
      delivered_order = 0;
      _points.resize(1);
      _weight.resize(1);
      _points[0] = 1.0;
      _weight[0] = 1.0;
      break;

    // order 1,2
    case 1 :
    case 2 :
      delivered_order = 2;
      _points.resize(2);
      _weight.resize(2);
      _points[0] = 1.0;
      _weight[0] = 0.25;
      _points[1] = 0.3333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333;
      _weight[1] = 0.75;
      break;

    // order 3,4
    case 3 :
    case 4 :
      delivered_order = 4;
      _points.resize(3);
      _weight.resize(3);
      _points[0] = 1.0;
      _weight[0] = 0.1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
      _points[1] = 0.1550510257216821901802715925294108608034052519343329871567307432749039622542684973460140566895359765;
      _weight[1] = 0.3764030627004672750500754423692807946676125699817591630990918731319177672928523603738927935248711045;
      _points[2] = 0.6449489742783178098197284074705891391965947480656670128432692567250960377457315026539859433104640234;
      _weight[2] = 0.5124858261884216138388134465196080942212763189071297257897970157569711215960365285149960953640177843;
      break;

    // order 5,6
    case 5 :
    case 6 :
      delivered_order = 6;
      _points.resize(4);
      _weight.resize(4);
      _points[0] = 1.0;
      _weight[0] = 0.0625;
      _points[1] = 0.08858795951270394739554614376945619688572933192274956543116369516997648742681009672521930761610157857;
      _weight[1] = 0.2204622111767683752754784720371859890529167281230873116876396332191458306523173431813869747371986422;
      _points[2] = 0.7876594617608470560252418898759996233480800585109738408854524491392307168918253691359860554930833447;
      _weight[2] = 0.3288443199800597439442892210727968317490234075874455536546030877312606057631737874914764364720579267;
      _points[3] = 0.4094668644407347108649262520688298940519048952805623079690981414050785099670788198530803511765293624;
      _weight[3] = 0.388193468843171880780232306890017179198059864289467134657757279049593563584508869327136588790743431;
      break;

    // order 7,8
    case 7 :
    case 8 :
      delivered_order = 8;
      _points.resize(5);
      _weight.resize(5);
      _points[0] = 1.0;
      _weight[0] = 0.03999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999;
      _points[1] = 0.05710419611451768219312119255411562123507794559875016432780829293093467820207316458611381681984273686;
      _weight[1] = 0.1437135607912259413234122198541102271589229617318809184244815352000477933742653045394234927685913557;
      _points[2] = 0.8602401356562194478479129188751197667383780225872255049242335941839742579301655644134901549264276106;
      _weight[2] = 0.2231039010835707444025602182285893596530132769666542171491954357318447595238752822393854332837929434;
      _points[3] = 0.2768430136381238276800459976856251411108891696950304683494420488311213396837080367725415285640511308;
      _weight[3] = 0.28135601514946206019217265034065989120000299266737412219813168211940937087419012854107836846850562;
      _points[4] = 0.5835904323689168200566976686629172486934326398967716401762938418317475019618310120056322774674562993;
      _weight[4] = 0.3118265229757412540818549115766405219880607686340907422281913469486980762276692846801127054791100807;
      break;

    // order 9,10
    case 9 :
    case 10 :
      delivered_order = 10;
      _points.resize(6);
      _weight.resize(6);
      _points[0] = 0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999;
      _weight[0] = 0.02777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777;
      _points[1] = 0.03980985705146874234080669009333316770426265422838516194640774820496474562617430685450225908318456723;
      _weight[1] = 0.1007941926267404201046003778745677818586739544978990469020905175031896616185019326523859081070179564;
      _points[2] = 0.9014649142011735738765011021122473096194864304517102005637358130565651259599860618861752355046079331;
      _weight[2] = 0.15982037661025548327288999189811797479611146812876839180378402272111432088446591677960283187954084;
      _points[3] = 0.1980134178736081725357921367952962360381863588337888792083291768272087117286465026597729214141553943;
      _weight[3] = 0.2084506671559538694797031913713231216677075046880940122344846434185750632010718140854202072910519794;
      _points[4] = 0.6954642733536360945146148237211671613940015549986483590851972611325288138368238668739250465460035524;
      _weight[4] = 0.2426935942344849580799139577934448339939675840621020934694189186061539713876707499244320986309746931;
      _points[5] = 0.4379748102473861440050125200052288525167902742147401264690572735060053301210965344528972647247758255;
      _weight[5] = 0.2604633915947874912851147032847685099057617108453586778124441199731892051305118087803811763136367531;
      break;

    // order 11,12
    case 11 :
    case 12 :
      delivered_order = 12;
      _points.resize(7);
      _weight.resize(7);
      _points[0] = 1.0;
      _weight[0] = 0.02040816326530612244897959183673469387755102040816326530612244897959183673469387755102040816326530612;
      _points[1] = 0.0293164271597848919720502769131649103737303925637149277869106839449360382416657787486309483651843695;
      _weight[1] = 0.07449423555601031793324878020916692097532644942393942434007237049841313043955906688474729498373429045;
      _points[2] = 0.9269456713197411148518739658196820110561724195422832527244670796566452024525282438143394800135873915;
      _weight[2] = 0.1196137446126562028935387403847763008302627238892853476612432820588170328039983753965707678098696572;
      _points[3] = 0.148078599668484291849976852495979212230248774808594461412594641801598386090878321806369397661747576;
      _weight[3] = 0.1591021157336507408724352172349341821081630163278709547082536480846529383453687327524900611444633129;
      _points[4] = 0.7692338620300545009168833601156454518371421433222954161669481696365481305739532856852002115427743676;
      _weight[4] = 0.1904749368221155769029691739380627618671473914712524715596097410083045379273763891870770560020639449;
      _points[5] = 0.3369846902811542990970529720807757051975687500284733471225629680736913505127840608524091411736544825;
      _weight[5] = 0.2123518895029778041991540195751041223560385606946763943251267338610614147090378494828338349159860945;
      _points[6] = 0.5586715187715501320813933418055219400743682889654078255557472261173501228974210783238200520122825819;
      _weight[6] = 0.2235549145072832347496744768212210179855108377848121420995717755091591090399657087452605769806173937;
      break;

    // order 13,14
    case 13 :
    case 14 :
      delivered_order = 14;
      _points.resize(8);
      _weight.resize(8);
      _points[0] = 1.0;
      _weight[0] = 0.015625;
      _points[1] = 0.02247938643871249810882549957084505992217390723560038985928427605875857575812188014380655937699869041;
      _weight[1] = 0.05725440737212859967117686425977936825057099397716932914168114853242340872092305631760230041130854427;
      _points[2] = 0.9437374394630778535343478089676888242202344852553769164275572083026057856516616966519018212670469614;
      _weight[2] = 0.092679077401489639270364486349647736830932563674935858313467408965379128989721699937903158856790959;
      _points[3] = 0.1146790531609042319096402370675146270777298245319719453889897349515683398313771981082383887487264663;
      _weight[3] = 0.1248239506649324816289346467565124312159878101369501620465085111501266363843363392424861677155123433;
      _points[4] = 0.819759308263107635012420057190818215457939379194529844677374444720182011832042478974289957052318717;
      _weight[4] = 0.1520653103233925644878716457001354421902137069080648805811724927448463625325070164171434664138434795;
      _points[5] = 0.2657898227845894684767893916933899974369968814056098940206796867530550186172425454664726006420981075;
      _weight[5] = 0.1735073978172506401143379592110741293229628009936786196599092457283690261775051724258224098007456587;
      _points[6] = 0.6473752828868303626260922298287587971919781169427252176007906613661670650910811632587999055012469012;
      _weight[6] = 0.188258772694559278286064630720786335118640532533949995543333201250716465965606978691283022057567494;
      _points[7] = 0.4528463736694446169985514423476511453596140721008524586919906545143298698851397040631574340782308226;
      _weight[7] = 0.1957860837262467965412497670020645570706915917752511547139279916281389712293997369677594747442315208;
      break;

    // order 15,16
    case 15 :
    case 16 :
      delivered_order = 16;
      _points.resize(9);
      _weight.resize(9);
      _points[0] = 1.0;
      _weight[0] = 0.01234567901234567901234567901234567901234567901234567901234567901234567901234567901234567901234567901;
      _points[1] = 0.01777991514736345181320510103767906126648839823850043366560783167875924757578300659726427675032243894;
      _weight[1] = 0.04535725246164145850644674920795090340044910382256608423236014041761080705247011291369808019791001464;
      _points[2] = 0.9553660447100301492668789781416922384764228669900323904483832488568928548867910582521230305572279596;
      _weight[2] = 0.07382700952315769290979424990076684192644119748373204166495034257132170235826067178423603914263698819;
      _points[3] = 0.09132360789979395600374145807454135310704047574456766876687017263479530047915987523538037892138190674;
      _weight[3] = 0.1002766490122759787105825452084585374837100645139951717640162083073491273282749948425325106489951269;
      _points[4] = 0.8556337429578544285147814797717850302864781605395751604095670933496281754845563783672978210969088188;
      _weight[4] = 0.1235946891022965261806198974844998620884284109101835335540040960997860637405727093530324964819711671;
      _points[5] = 0.2143084793956307583575412675816703226744297175224765908137326191408580982640893227912904964441607054;
      _weight[5] = 0.1431933481786155855733528188760054645853142508187793084336149756313973598558725153845647136386781611;
      _points[6] = 0.7131752428555694810513137602509073414468837909454265589730704929652137959347225387189767846054023754;
      _weight[6] = 0.1584218878352189891690004248211828904282803901135082813370203191442722409397377362074389726296125592;
      _points[7] = 0.371932164583272302430853960482629244668100063377480677867638541249730350859486812775129485772654593;
      _weight[7] = 0.1688469834879647929018621198957803825501226794932222463313217885924663693432674422816562201729896321;
      _points[8] = 0.5451866848034266490322722299532130551329800560537052249374829413005927647507051249095965493813529665;
      _weight[8] = 0.1741365013864832970359955155930094385249082238316676536703664502234506503691981382204952880748606714;
      break;

    // order 17,18
    case 17 :
    case 18 :
      delivered_order = 18;
      _points.resize(10);
      _weight.resize(10);
      _points[0] = 1.0;
      _weight[0] = 0.01;
      _points[1] = 0.01441240964887654863282674081081323941174473105657808607075067912813887583460044894395069303727210116;
      _weight[1] = 0.03680850274337924946552564703952257250633407560110190885784111690017778477215458793270183849421941181;
      _points[2] = 0.9637421871167905390588356992319185479241288771581362138479503914355973155457527404910756919669630462;
      _weight[2] = 0.06014833527874081575865526135099759590938724369183571272716692583091329962913008482323531114050148899;
      _points[3] = 0.07438738970919604463591818595599858508097691328473519842679960274501992379023428096791242945498303363;
      _weight[3] = 0.08218800636846073785084083445387855020451656194507156599834064798783462171005161946359655246906025996;
      _points[4] = 0.8819210212100012998077148880052647763071205854487038619129766513283089105657085985563097864503385464;
      _weight[4] = 0.1021350659395003377778943361115165106736257210286962005068043553499340322306121690246726114965883931;
      _points[5] = 0.1761166561629952818631757460725685864113860479693058739346483371718478923148052033071589166216033503;
      _weight[5] = 0.1195967158571898566882859830801363758258364741540254585528364764210946139183141897137094066862003184;
      _points[6] = 0.7628230151850396146826933071467255329235111827037380779911005908346167214808478679770430364298828452;
      _weight[6] = 0.1340974189205893480292772376310295553451252092166458466844053839661648602000224960759896073212453487;
      _points[7] = 0.3096675799276378170596204672294840488163890844971259245735924385417910631238453492458723772259274575;
      _weight[7] = 0.1453050824164591555734315389815310253381621189272259396591735666935382783811527201352568817760678677;
      _points[8] = 0.6181172346952940246392297516035044802806674046397913475060393055585778777428482116865746364861237203;
      _weight[8] = 0.1529296438622113105081377377003979801780786241826203904279240012042738305695686747214466554361694378;
      _points[9] = 0.4619704010810109348831431086805643081072330679787275209992998979929435248645151935609445375900637938;
      _weight[9] = 0.1567912286134691883479514236509898340189339712527769765855075256460686785889934581093911351799474732;
      break;

    // order 19,20
    case 19 :
    case 20 :
      delivered_order = 20;
      _points.resize(11);
      _weight.resize(11);
      _points[0] = 0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999;
      _weight[0] = 0.008264462809917355371900826446280991735537190082644628099173553719008264462809917355371900826446280991;
      _points[1] = 0.01191761343241559690974558695898597603002784725837485802027599304441351971793953552093495537698887495;
      _weight[1] = 0.03046254890606556735360916344416515441920593612889634378768602325986918684909318284948512089071412454;
      _points[2] = 0.9699709678385135029569356423655920593053451564625792084689040051698797214284804451045965026202723376;
      _weight[2] = 0.04992304095398403194787673479012341784951435295822716798886200345394064771188529448902933415752225152;
      _points[3] = 0.06173207187714812552262936719425014145287208036190213218470079750300542267782554988602355308971116546;
      _weight[3] = 0.06851684106660112815507694029022108631584560319435756477685101885640953683767976717173664864587875312;
      _points[4] = 0.9017109877901467703487989784097679814681176760729360475326567373055975858521386207932416878958506861;
      _weight[4] = 0.08565880960332991824335632452114911543009060544673768448218195768393830581589904069386788764433631681;
      _points[5] = 0.1471114496430702404275994355798195021337713619059297805712867093259790600660861446700545255054338431;
      _weight[5] = 0.1010815542700122091749658771329642516494277755940245416341823725777740925226297436637027602819852004;
      _points[6] = 0.8009789210368988451379463016172425246730022622599153383117418553952368566445573598703594633591531735;
      _weight[6] = 0.1144330619244883122008416155631972831221456389832920628771016872588315039886167750369068708206089062;
      _points[7] = 0.2611596760084562402660516580548457231986357161379567253035521310935009972624582003737324443405623491;
      _weight[7] = 0.12546268884856419732457013381672775718613069695897309262354779249129469297632546407602624370590123;
      _points[8] = 0.6759444616766651073571505089347614715039952762295357455139412301626256578790308622295455518800017057;
      _weight[8] = 0.1339335430948420889033190816775717752086008360038592987740894422858598943031122752005614670488956897;
      _points[9] = 0.3946398468857868429619521050776075022149391536489841976946611563878829320916183985232456263028812026;
      _weight[9] = 0.1396806665516915225944810978601028731857924475265701484072617959266351875863206717620061077170286754;
      _points[10] = 0.5367387657156606328730951777118890227811982315666478711601841465166401511417696449330275943910494234;
      _weight[10] = 0.142582781970503668730002204457496293897708917122417466549062352486438686945627867701305658260682571;
      break;

    // order 21,22
    case 21 :
    case 22 :
      delivered_order = 22;
      _points.resize(12);
      _weight.resize(12);
      _points[0] = 0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999;
      _weight[0] = 0.006944444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444;
      _points[1] = 0.01001828046168040584302472986780478481479194051621623866216912370277685746144514894811474690557217898;
      _weight[1] = 0.02562404960363464873401147256755191359698912179586886783614733167396359699140406477146628165245745726;
      _points[2] = 0.9747263796024796502466688135383708980845368176554858005326201789921787651358684645855413515511531779;
      _weight[2] = 0.04208606746934048812078982684064078598356207668454606077811004135971778814182424352552804186759516359;
      _points[3] = 0.05203545112718055258354269577296432244718592505838183555552881934330327851280895562528383296766154587;
      _weight[3] = 0.05795374014586919637517095413584668388777153128408424542984574266464927148200496692165819750039770507;
      _points[4] = 0.9169583865525948532931346270180274177520051095629925713521035439862432832098136415299370694612456097;
      _weight[4] = 0.07278183442699756426127382735286559431255511311081887313664967558148928208419907103707790861347367931;
      _points[5] = 0.1246192251444430737352995872639092292474441300880058562471871920162296059349519090766521215975420845;
      _weight[5] = 0.08638531965665428215303288348279335482371411193381952188479961232975350369852446186555482138789619392;
      _points[6] = 0.8308248996228185740305665439056567039439893043182143500186679333872078183180614211671796544755957774;
      _weight[6] = 0.09849926741304481732802481898451691715880480601630014213517520121230333584098958189070626683477635742;
      _points[7] = 0.2228406070438378555078314534573627644117252503274297081643638173616062308369832016150585853516004853;
      _weight[7] = 0.1089344395130962194243737410114312720559919702231833101252380994924976153392527006073200151967269551;
      _points[8] = 0.7222032848909679255633213078046109071372364455125913944559779818780897684066745302575181714890353344;
      _weight[8] = 0.1175015575724929196743169929697715883009119236048689568907922000277105361992896721300643435454773039;
      _points[9] = 0.3400081579146651882336052338970175277313293398208505803470934737382842096120712309333935896431331419;
      _weight[9] = 0.1240607804020049797015365535394355200719995254498010043949067360502230324581192591300795635289312217;
      _points[10] = 0.5984972797671391832277207136730435902749187521976111511339511314695356530954712310305911412553938959;
      _weight[10] = 0.1284956690763538880639871267992001336436691476013189170108039583312533699461672093381787487185684594;
      _points[11] = 0.4681376130895840420831103807577535932852717675509161657042498476028053990410676565350775613890232895;
      _weight[11] = 0.1307328302760665517190373578715017917195862278509456559330869568319942233737803243379213667092550587;
      break;

    // order 23,24
    case 23 :
    case 24 :
      delivered_order = 24;
      _points.resize(13);
      _weight.resize(13);
      _points[0] = 0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999;
      _weight[0] = 0.005917159763313609467455621301775147928994082840236686390532544378698224852071005917159763313609467455;
      _points[1] = 0.008539054988427419368664460877839802806090414566577746496257927301230364575762166797509842961307629102;
      _weight[1] = 0.02185145163395103741442669230253126228354537862132045649291743515926153592140670516392700801272894985;
      _points[2] = 0.9784379368341496390919069169169960383680691296676253661798930654904321350621424594217105164689234998;
      _weight[2] = 0.03595120814624776446987687028207407841501895536660169592463294449355425288370779064245312669926985388;
      _points[3] = 0.04444646315540772302546679878555276624130930378899710999139642043436028639661647795803987919635307505;
      _weight[3] = 0.04963390344092354299236819387388759872276531452267544246797332700574719345537345645571951255905295405;
      _points[4] = 0.9289421012644110178488101551343152998504932414769823471037599293899243740926428914029706095801991064;
      _weight[4] = 0.06255191716557617906688464398784008656184274649282227400711808747510050471677954744690856656060123432;
      _points[5] = 0.1068544908834766576341067704324992625897998143695000275580631125622836143405186814627639697793505873;
      _weight[5] = 0.07457547504500010257574593212085472848830959655207242548776306668431488289996654073064815660600252619;
      _points[6] = 0.8545525437649358807902119164056171284859595037395583869615217146999851616473022152580139867380827058;
      _weight[6] = 0.08550173023530832123187933725608529010988327742650916870829611194441770373681670809118932944409747882;
      _points[7] = 0.1921510545298540409910572562286133303827013670215218660373964882963368867384002033277468512639620346;
      _weight[7] = 0.09518685777981586612737991037293691958788184471208789194562638680044365745312132402614513871070282189;
      _points[8] = 0.7595988895252270537426025740434203419422064350885379264310222786423119973912528922496277727549814325;
      _weight[8] = 0.1034803057279385373155662804144384374750427276214146948478010879630533907564801063538733440312738658;
      _points[9] = 0.2953808842625802216229168343760149059398907133108521080514580880514097551832904806231230987696368169;
      _weight[9] = 0.1102671146442257323455385820995765357020738630479430106311100293991178535583726917255962453649948882;
      _points[10] = 0.64960065027725499276629172334298057222565311827730373485571958964856442485986620008885607294565333;
      _weight[10] = 0.1154444314434977170061018793339061362073895171982322864758099735381130891596922281273366371689249657;
      _points[11] = 0.4105450812014576824890343505593324118433186951909181754985565958109519682767226149737373217217664214;
      _weight[11] = 0.1189392738303560156713425945898368420344422709752939545408915255899383006020911343567290538236643372;
      _points[12] = 0.5309508493128176706289302428968181393245082635016252048349547896722090314354827164359000778197833607;
      _weight[12] = 0.1206991711438455743154334620642569364828104246227900120795274795682394100041207609623141177050766563;
      break;

    // order 25,26
    case 25 :
    case 26 :
      delivered_order = 26;
      _points.resize(14);
      _weight.resize(14);
      _points[0] = 0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999;
      _weight[0] = 0.00510204081632653061224489795918367346938775510204081632653061224489795918367346938775510204081632653;
      _points[1] = 0.007364651026089321650691498413822343611205715616446000420689416452269750033894550997416319128445293682;
      _weight[1] = 0.01885358163494845713873136414594165020975759392510590592315060034299193800069304020789391250755439251;
      _points[2] = 0.9813896349890121485602806221597123115526801027908002379955097186555535838880620308147789489545503323;
      _weight[2] = 0.03106100845388573008306645823341460455969559499141094108084012625707654955896377969536296135374710094;
      _points[3] = 0.0383981387396783503768325248641416859178298341363546876124160117982427806914025897403499913466209422;
      _weight[3] = 0.04297026772149020154465386554328283974483688526109607883477417143735728532178658495401673766981052349;
      _points[4] = 0.9385244591007310123976333867652993517339853062062887126354508873721247374248021832126814047065480952;
      _weight[4] = 0.05430386137218141341336046761449170556749717283973110242510925951515177257930583451532790775304492282;
      _points[5] = 0.09259522469900263528289137543861635588927985865429292632366593235281921073136849542406090039759718099;
      _weight[5] = 0.06496983436867117390371286857296886542757042851651763549881540867872262529279047866030734246306485196;
      _points[6] = 0.8736948213066894193677145671317438911733815349203347594446961615475144054728685418531116734022398623;
      _weight[6] = 0.07481026967656067797526041847298687382328381103405386550842777879482025911405057274802766818691774256;
      _points[7] = 0.1672510113915577314955224787593571163747337087390977895834969262324481399932617359780977489832830798;
      _weight[7] = 0.08371486394554313949505113851903285254546037528256798216114894580640831517395702564992236389997285344;
      _points[8] = 0.7901570282734374855528633324993759322704266136136999317134349971780526905331558640579365443870029771;
      _weight[8] = 0.0915635010628648270619336510514316864439809227594628152951066579840052366089190074610930288816591208;
      _points[9] = 0.2586235407057625165897907328226910025245301373917701116571591768242959721348720274973743055115115388;
      _weight[9] = 0.09826275922649121516230654596477485524374871885835884725402164208061259270491076568978920429932178543;
      _points[10] = 0.6921010017196016568970419516876697301808911008718652877381506074556730863418738419796277914411356902;
      _weight[10] = 0.1037248816675878363340414432447055349260953854618612465467764711248264947647953780386198366283149413;
      _points[11] = 0.3621313972822388004086812982273215588635004488227823666951627890767765685364866146107646481156613177;
      _weight[11] = 0.1078835503023094256905937230574369840724121681977091473649374022846524089107794784879188404811405312;
      _points[12] = 0.5844439640213404555042208478109107062952661618107888083023659837678484044838564429563713070829009515;
      _weight[12] = 0.1106849057497854744658358415102718135678259837364580620549598005910175475300839492981459854834952701;
      _points[13] = 0.472584386004117725175094642678597272871548735684737639137060650545639928993354340136687675801761997;
      _weight[13] = 0.1120946740013538971192073161100760603984472040336255537254011228574590152552906352058191083511396366;
      break;

    // order 27,28
    case 27 :
    case 28 :
      delivered_order = 28;
      _points.resize(15);
      _weight.resize(15);
      _points[0] = 0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999;
      _weight[0] = 0.004444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444;
      _points[1] = 0.006416760792818456810820464094507178865719839912244884307238769932733545613705239155655121904187696819;
      _weight[1] = 0.01643219579229676612652142641153073057741290693423739200638154484999854248273452294729310561302604524;
      _points[2] = 0.9837752340986002382812280091410008568029060918346814026541382401229231239358663224051124039381821714;
      _weight[2] = 0.02710139002432224716910711840089438470564976679454870725896584731580262535409379031752562837870266878;
      _points[3] = 0.03350140453201314003596392857057248161039076925284236707232192332100661384915949406912586179668631268;
      _weight[3] = 0.03755419638025321986648583269569141758805153698961255144076732637991919601646605173770385110166578307;
      _points[4] = 0.9463027000602753835334059434247240449122575138455164975479188348405641933767500076215855613747667663;
      _weight[4] = 0.04756479973024044960192386331729517468694216465472046057613808264784485886335468527107776368357517029;
      _points[5] = 0.08098549968195518439245130773998218722766514758665499507829939127797017196531825081787486655370779525;
      _weight[5] = 0.0570676017448763765065377912843275486532773680936293313767427911822960640342192529908062097810219568;
      _points[6] = 0.8893428088195155396908716609464895647037628629053267599145054482375380565684526275834413083786664628;
      _weight[6] = 0.0659377312524758160931310789717671834328714396438875129556617113002714624562014461183427180565642943;
      _points[7] = 0.1468048676812137299236601652607991515599694654279756227180485513313137055587256285457460550167373564;
      _weight[7] = 0.07408976350173362696234102937128255487413805694748258883130522716337536508449919660779818071285032187;
      _points[8] = 0.8153897394434746419730742186120575147090134055115116514499564217599632405912766985454621567772925719;
      _weight[8] = 0.08142723865191631472436612291392116582120502240478308220490604700601857925394464346640601462002559893;
      _points[9] = 0.2280842706492579915346440986199429719415777248320505178336090146170398503780540680375636284189205414;
      _weight[9] = 0.08787443632122384283515522023795954919820258839409278348995177107324231289791167390445951868050365719;
      _points[10] = 0.727676452889264685436026727990331696616560168524648660087480949596545653110467939930929401900062142;
      _weight[10] = 0.0933575729197254540418975518996095015505528049870462214693890052089200962043726360505074761465047243;
      _points[11] = 0.3212717439889361744023403974130354496573046310098509725155244153528428571119004042632189220394104757;
      _weight[11] = 0.09781875152255805823677830878766431530678913099926441455902384806443677576510945244842491271878973857;
      _points[12] = 0.6300366883704039578844805941314332791605030321087179470245277359365694220786253960307680873297618342;
      _weight[12] = 0.1012075935153092149363516552173900812119855087993622184426068461562271888887057964368860900909478014;
      _points[13] = 0.4222946573075702578404089875181026958217938762273438789639540713852576268236287646690911714244228904;
      _weight[13] = 0.1034879801247768777395136608932904389620559700843852088264115370008206803210070375686989446492003508;
      _points[14] = 0.5267378613398730320537269448128829953760927123999441876600624391842836631760001928071840738368501546;
      _weight[14] = 0.1046343040738472907154448951529315089864212898285030821173039702063818079329353696896251413221774439;
      break;

    // order 29,30
    case 29 :
    case 30 :
      delivered_order = 30;
      _points.resize(16);
      _weight.resize(16);
      _points[0] = 1.0;
      _weight[0] = 0.003906249999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999;
      _points[1] = 0.005640688972511709757506466579444200966084106988131147967978335138218141575736364048915697203589669807;
      _weight[1] = 0.01444856950840716424575961150167959664768321485447374308786815965237503412236544031701308852051345129;
      _points[2] = 0.9857305452631742252659006330591292421044806623979681396367496904534811104340037194340828859918697398;
      _weight[2] = 0.02385111347384286023258796121105761215940712748373347733951249612012262824249209179131707229548989037;
      _points[3] = 0.02948229864794248663164098471800370918700961303166077760161299352098320969659464315137326588996550641;
      _weight[3] = 0.0330947543050682173723367824140129988109765140797056057089486775834419651379958009126595489547599592;
      _points[4] = 0.9527004099058333143380442075242620935055589938201492599119746533434704857023258451913238950513425185;
      _weight[4] = 0.04199264072248258900350601284912850274175530373827143449384382997141429563265696715138196207857827561;
      _points[5] = 0.07141295311515884005478390174673491912187290234227435678431701381106489005946195046185073236066258137;
      _weight[5] = 0.05049783981089195436218504141066416942898549189111011390903678585931367460678472505588559551870946612;
      _points[6] = 0.9022867006793780266312385046620090802654876855849468717160511280017608939616471254566098257665163887;
      _weight[6] = 0.05851017655193002851526082850951591652992414137147165348431935555746818051798695168136190985636111654;
      _points[7] = 0.1298310255535910559712545380942899123177230784713915452688927991403297243171614954096840860975794642;
      _weight[7] = 0.06596284996653406672246151063058849160747151189927306232812579118709032621265417948009199088684731203;
      _points[8] = 0.8364309606056101239755590856541831966144050516279921337789774230212989904851294862915904006631825436;
      _weight[8] = 0.07277777261010112143531914999678279515995507797472250238664229606324038347926030123455318661603847499;
      _points[9] = 0.2024927550501040475682199883202304426029145838857816183098197713593869872838287905637745131407654631;
      _weight[9] = 0.07889346090210101014257961013735628556027751692815831358281184285722704118272376932178081897027333611;
      _points[10] = 0.7576647390313427119970742777402853179406886187590936481745381257951925531912300645820920629808513944;
      _weight[10] = 0.08424819892496124501819105207923275942561890638984801295494652596992252939263197128583747944314191086;
      _points[11] = 0.2866060862575270599840260454843964124631835183282258747277172597764764143673373926548361027887495961;
      _weight[11] = 0.0887923963763697559481752588801875527471665581288797954926123946185668633418713757400843776997412092;
      _points[12] = 0.6690151950299598765386956390531395651245327979857527236420750144055549199665133052913040313820535801;
      _weight[12] = 0.09248089074433267978323239376056093439894591473240448144120626047437788156837996046854633882875631641;
      _points[13] = 0.3789386886469780381065290091427738514254527443330112900124820663975192124536679674713512968590311795;
      _weight[13] = 0.09527914712767754441311796762044089051519985174582994892126109353070075332923324694354921353229351015;
      _points[14] = 0.5738891609066858806714538552375264393339926267874317142496528265661645824810184689905478175189410146;
      _weight[14] = 0.09715954485578392167168809787195218347038559646446468604327985098793468776901949385191763241792479535;
      _points[15] = 0.4759423084632348605725889920158496815427420479142534143461931573336140130566014455167924185629638753;
      _weight[15] = 0.09810439411951584113359872112683931079624727231765316882558463956680375546394372476401978438057097569;
      break;

    default :
      DUNE_THROW(QuadratureOrderOutOfRange, "Quadrature rule " << p << " not supported!");
    }
  }

  // for non-fundamental types: assign numbers as strings
  template<typename ct>
  void GaussRadauRightQuadratureInitHelper<ct,false>::init(int p,
         std::vector< FieldVector<ct, 1> > & _points,
         std::vector< ct > & _weight,
         int & delivered_order)
  {
    switch(p)
    {
    case 0 :
      delivered_order = 0;
      _points.resize(1);
      _weight.resize(1);
      _points[0] = ct("1.0");
      _weight[0] = ct("1.0");
      break;

    // order 1,2
    case 1 :
    case 2 :
      delivered_order = 2;
      _points.resize(2);
      _weight.resize(2);
      _points[0] = ct("1.0");
      _weight[0] = ct("0.25");
      _points[1] = ct("0.3333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333");
      _weight[1] = ct("0.75");
      break;

    // order 3,4
    case 3 :
    case 4 :
      delivered_order = 4;
      _points.resize(3);
      _weight.resize(3);
      _points[0] = ct("1.0");
      _weight[0] = ct("0.1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111");
      _points[1] = ct("0.1550510257216821901802715925294108608034052519343329871567307432749039622542684973460140566895359765");
      _weight[1] = ct("0.3764030627004672750500754423692807946676125699817591630990918731319177672928523603738927935248711045");
      _points[2] = ct("0.6449489742783178098197284074705891391965947480656670128432692567250960377457315026539859433104640234");
      _weight[2] = ct("0.5124858261884216138388134465196080942212763189071297257897970157569711215960365285149960953640177843");
      break;

    // order 5,6
    case 5 :
    case 6 :
      delivered_order = 6;
      _points.resize(4);
      _weight.resize(4);
      _points[0] = ct("1.0");
      _weight[0] = ct("0.0625");
      _points[1] = ct("0.08858795951270394739554614376945619688572933192274956543116369516997648742681009672521930761610157857");
      _weight[1] = ct("0.2204622111767683752754784720371859890529167281230873116876396332191458306523173431813869747371986422");
      _points[2] = ct("0.7876594617608470560252418898759996233480800585109738408854524491392307168918253691359860554930833447");
      _weight[2] = ct("0.3288443199800597439442892210727968317490234075874455536546030877312606057631737874914764364720579267");
      _points[3] = ct("0.4094668644407347108649262520688298940519048952805623079690981414050785099670788198530803511765293624");
      _weight[3] = ct("0.388193468843171880780232306890017179198059864289467134657757279049593563584508869327136588790743431");
      break;

    // order 7,8
    case 7 :
    case 8 :
      delivered_order = 8;
      _points.resize(5);
      _weight.resize(5);
      _points[0] = ct("1.0");
      _weight[0] = ct("0.03999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999");
      _points[1] = ct("0.05710419611451768219312119255411562123507794559875016432780829293093467820207316458611381681984273686");
      _weight[1] = ct("0.1437135607912259413234122198541102271589229617318809184244815352000477933742653045394234927685913557");
      _points[2] = ct("0.8602401356562194478479129188751197667383780225872255049242335941839742579301655644134901549264276106");
      _weight[2] = ct("0.2231039010835707444025602182285893596530132769666542171491954357318447595238752822393854332837929434");
      _points[3] = ct("0.2768430136381238276800459976856251411108891696950304683494420488311213396837080367725415285640511308");
      _weight[3] = ct("0.28135601514946206019217265034065989120000299266737412219813168211940937087419012854107836846850562");
      _points[4] = ct("0.5835904323689168200566976686629172486934326398967716401762938418317475019618310120056322774674562993");
      _weight[4] = ct("0.3118265229757412540818549115766405219880607686340907422281913469486980762276692846801127054791100807");
      break;

    // order 9,10
    case 9 :
    case 10 :
      delivered_order = 10;
      _points.resize(6);
      _weight.resize(6);
      _points[0] = ct("0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999");
      _weight[0] = ct("0.02777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777");
      _points[1] = ct("0.03980985705146874234080669009333316770426265422838516194640774820496474562617430685450225908318456723");
      _weight[1] = ct("0.1007941926267404201046003778745677818586739544978990469020905175031896616185019326523859081070179564");
      _points[2] = ct("0.9014649142011735738765011021122473096194864304517102005637358130565651259599860618861752355046079331");
      _weight[2] = ct("0.15982037661025548327288999189811797479611146812876839180378402272111432088446591677960283187954084");
      _points[3] = ct("0.1980134178736081725357921367952962360381863588337888792083291768272087117286465026597729214141553943");
      _weight[3] = ct("0.2084506671559538694797031913713231216677075046880940122344846434185750632010718140854202072910519794");
      _points[4] = ct("0.6954642733536360945146148237211671613940015549986483590851972611325288138368238668739250465460035524");
      _weight[4] = ct("0.2426935942344849580799139577934448339939675840621020934694189186061539713876707499244320986309746931");
      _points[5] = ct("0.4379748102473861440050125200052288525167902742147401264690572735060053301210965344528972647247758255");
      _weight[5] = ct("0.2604633915947874912851147032847685099057617108453586778124441199731892051305118087803811763136367531");
      break;

    // order 11,12
    case 11 :
    case 12 :
      delivered_order = 12;
      _points.resize(7);
      _weight.resize(7);
      _points[0] = ct("1.0");
      _weight[0] = ct("0.02040816326530612244897959183673469387755102040816326530612244897959183673469387755102040816326530612");
      _points[1] = ct("0.0293164271597848919720502769131649103737303925637149277869106839449360382416657787486309483651843695");
      _weight[1] = ct("0.07449423555601031793324878020916692097532644942393942434007237049841313043955906688474729498373429045");
      _points[2] = ct("0.9269456713197411148518739658196820110561724195422832527244670796566452024525282438143394800135873915");
      _weight[2] = ct("0.1196137446126562028935387403847763008302627238892853476612432820588170328039983753965707678098696572");
      _points[3] = ct("0.148078599668484291849976852495979212230248774808594461412594641801598386090878321806369397661747576");
      _weight[3] = ct("0.1591021157336507408724352172349341821081630163278709547082536480846529383453687327524900611444633129");
      _points[4] = ct("0.7692338620300545009168833601156454518371421433222954161669481696365481305739532856852002115427743676");
      _weight[4] = ct("0.1904749368221155769029691739380627618671473914712524715596097410083045379273763891870770560020639449");
      _points[5] = ct("0.3369846902811542990970529720807757051975687500284733471225629680736913505127840608524091411736544825");
      _weight[5] = ct("0.2123518895029778041991540195751041223560385606946763943251267338610614147090378494828338349159860945");
      _points[6] = ct("0.5586715187715501320813933418055219400743682889654078255557472261173501228974210783238200520122825819");
      _weight[6] = ct("0.2235549145072832347496744768212210179855108377848121420995717755091591090399657087452605769806173937");
      break;

    // order 13,14
    case 13 :
    case 14 :
      delivered_order = 14;
      _points.resize(8);
      _weight.resize(8);
      _points[0] = ct("1.0");
      _weight[0] = ct("0.015625");
      _points[1] = ct("0.02247938643871249810882549957084505992217390723560038985928427605875857575812188014380655937699869041");
      _weight[1] = ct("0.05725440737212859967117686425977936825057099397716932914168114853242340872092305631760230041130854427");
      _points[2] = ct("0.9437374394630778535343478089676888242202344852553769164275572083026057856516616966519018212670469614");
      _weight[2] = ct("0.092679077401489639270364486349647736830932563674935858313467408965379128989721699937903158856790959");
      _points[3] = ct("0.1146790531609042319096402370675146270777298245319719453889897349515683398313771981082383887487264663");
      _weight[3] = ct("0.1248239506649324816289346467565124312159878101369501620465085111501266363843363392424861677155123433");
      _points[4] = ct("0.819759308263107635012420057190818215457939379194529844677374444720182011832042478974289957052318717");
      _weight[4] = ct("0.1520653103233925644878716457001354421902137069080648805811724927448463625325070164171434664138434795");
      _points[5] = ct("0.2657898227845894684767893916933899974369968814056098940206796867530550186172425454664726006420981075");
      _weight[5] = ct("0.1735073978172506401143379592110741293229628009936786196599092457283690261775051724258224098007456587");
      _points[6] = ct("0.6473752828868303626260922298287587971919781169427252176007906613661670650910811632587999055012469012");
      _weight[6] = ct("0.188258772694559278286064630720786335118640532533949995543333201250716465965606978691283022057567494");
      _points[7] = ct("0.4528463736694446169985514423476511453596140721008524586919906545143298698851397040631574340782308226");
      _weight[7] = ct("0.1957860837262467965412497670020645570706915917752511547139279916281389712293997369677594747442315208");
      break;

    // order 15,16
    case 15 :
    case 16 :
      delivered_order = 16;
      _points.resize(9);
      _weight.resize(9);
      _points[0] = ct("1.0");
      _weight[0] = ct("0.01234567901234567901234567901234567901234567901234567901234567901234567901234567901234567901234567901");
      _points[1] = ct("0.01777991514736345181320510103767906126648839823850043366560783167875924757578300659726427675032243894");
      _weight[1] = ct("0.04535725246164145850644674920795090340044910382256608423236014041761080705247011291369808019791001464");
      _points[2] = ct("0.9553660447100301492668789781416922384764228669900323904483832488568928548867910582521230305572279596");
      _weight[2] = ct("0.07382700952315769290979424990076684192644119748373204166495034257132170235826067178423603914263698819");
      _points[3] = ct("0.09132360789979395600374145807454135310704047574456766876687017263479530047915987523538037892138190674");
      _weight[3] = ct("0.1002766490122759787105825452084585374837100645139951717640162083073491273282749948425325106489951269");
      _points[4] = ct("0.8556337429578544285147814797717850302864781605395751604095670933496281754845563783672978210969088188");
      _weight[4] = ct("0.1235946891022965261806198974844998620884284109101835335540040960997860637405727093530324964819711671");
      _points[5] = ct("0.2143084793956307583575412675816703226744297175224765908137326191408580982640893227912904964441607054");
      _weight[5] = ct("0.1431933481786155855733528188760054645853142508187793084336149756313973598558725153845647136386781611");
      _points[6] = ct("0.7131752428555694810513137602509073414468837909454265589730704929652137959347225387189767846054023754");
      _weight[6] = ct("0.1584218878352189891690004248211828904282803901135082813370203191442722409397377362074389726296125592");
      _points[7] = ct("0.371932164583272302430853960482629244668100063377480677867638541249730350859486812775129485772654593");
      _weight[7] = ct("0.1688469834879647929018621198957803825501226794932222463313217885924663693432674422816562201729896321");
      _points[8] = ct("0.5451866848034266490322722299532130551329800560537052249374829413005927647507051249095965493813529665");
      _weight[8] = ct("0.1741365013864832970359955155930094385249082238316676536703664502234506503691981382204952880748606714");
      break;

    // order 17,18
    case 17 :
    case 18 :
      delivered_order = 18;
      _points.resize(10);
      _weight.resize(10);
      _points[0] = ct("1.0");
      _weight[0] = ct("0.01");
      _points[1] = ct("0.01441240964887654863282674081081323941174473105657808607075067912813887583460044894395069303727210116");
      _weight[1] = ct("0.03680850274337924946552564703952257250633407560110190885784111690017778477215458793270183849421941181");
      _points[2] = ct("0.9637421871167905390588356992319185479241288771581362138479503914355973155457527404910756919669630462");
      _weight[2] = ct("0.06014833527874081575865526135099759590938724369183571272716692583091329962913008482323531114050148899");
      _points[3] = ct("0.07438738970919604463591818595599858508097691328473519842679960274501992379023428096791242945498303363");
      _weight[3] = ct("0.08218800636846073785084083445387855020451656194507156599834064798783462171005161946359655246906025996");
      _points[4] = ct("0.8819210212100012998077148880052647763071205854487038619129766513283089105657085985563097864503385464");
      _weight[4] = ct("0.1021350659395003377778943361115165106736257210286962005068043553499340322306121690246726114965883931");
      _points[5] = ct("0.1761166561629952818631757460725685864113860479693058739346483371718478923148052033071589166216033503");
      _weight[5] = ct("0.1195967158571898566882859830801363758258364741540254585528364764210946139183141897137094066862003184");
      _points[6] = ct("0.7628230151850396146826933071467255329235111827037380779911005908346167214808478679770430364298828452");
      _weight[6] = ct("0.1340974189205893480292772376310295553451252092166458466844053839661648602000224960759896073212453487");
      _points[7] = ct("0.3096675799276378170596204672294840488163890844971259245735924385417910631238453492458723772259274575");
      _weight[7] = ct("0.1453050824164591555734315389815310253381621189272259396591735666935382783811527201352568817760678677");
      _points[8] = ct("0.6181172346952940246392297516035044802806674046397913475060393055585778777428482116865746364861237203");
      _weight[8] = ct("0.1529296438622113105081377377003979801780786241826203904279240012042738305695686747214466554361694378");
      _points[9] = ct("0.4619704010810109348831431086805643081072330679787275209992998979929435248645151935609445375900637938");
      _weight[9] = ct("0.1567912286134691883479514236509898340189339712527769765855075256460686785889934581093911351799474732");
      break;

    // order 19,20
    case 19 :
    case 20 :
      delivered_order = 20;
      _points.resize(11);
      _weight.resize(11);
      _points[0] = ct("0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999");
      _weight[0] = ct("0.008264462809917355371900826446280991735537190082644628099173553719008264462809917355371900826446280991");
      _points[1] = ct("0.01191761343241559690974558695898597603002784725837485802027599304441351971793953552093495537698887495");
      _weight[1] = ct("0.03046254890606556735360916344416515441920593612889634378768602325986918684909318284948512089071412454");
      _points[2] = ct("0.9699709678385135029569356423655920593053451564625792084689040051698797214284804451045965026202723376");
      _weight[2] = ct("0.04992304095398403194787673479012341784951435295822716798886200345394064771188529448902933415752225152");
      _points[3] = ct("0.06173207187714812552262936719425014145287208036190213218470079750300542267782554988602355308971116546");
      _weight[3] = ct("0.06851684106660112815507694029022108631584560319435756477685101885640953683767976717173664864587875312");
      _points[4] = ct("0.9017109877901467703487989784097679814681176760729360475326567373055975858521386207932416878958506861");
      _weight[4] = ct("0.08565880960332991824335632452114911543009060544673768448218195768393830581589904069386788764433631681");
      _points[5] = ct("0.1471114496430702404275994355798195021337713619059297805712867093259790600660861446700545255054338431");
      _weight[5] = ct("0.1010815542700122091749658771329642516494277755940245416341823725777740925226297436637027602819852004");
      _points[6] = ct("0.8009789210368988451379463016172425246730022622599153383117418553952368566445573598703594633591531735");
      _weight[6] = ct("0.1144330619244883122008416155631972831221456389832920628771016872588315039886167750369068708206089062");
      _points[7] = ct("0.2611596760084562402660516580548457231986357161379567253035521310935009972624582003737324443405623491");
      _weight[7] = ct("0.12546268884856419732457013381672775718613069695897309262354779249129469297632546407602624370590123");
      _points[8] = ct("0.6759444616766651073571505089347614715039952762295357455139412301626256578790308622295455518800017057");
      _weight[8] = ct("0.1339335430948420889033190816775717752086008360038592987740894422858598943031122752005614670488956897");
      _points[9] = ct("0.3946398468857868429619521050776075022149391536489841976946611563878829320916183985232456263028812026");
      _weight[9] = ct("0.1396806665516915225944810978601028731857924475265701484072617959266351875863206717620061077170286754");
      _points[10] = ct("0.5367387657156606328730951777118890227811982315666478711601841465166401511417696449330275943910494234");
      _weight[10] = ct("0.142582781970503668730002204457496293897708917122417466549062352486438686945627867701305658260682571");
      break;

    // order 21,22
    case 21 :
    case 22 :
      delivered_order = 22;
      _points.resize(12);
      _weight.resize(12);
      _points[0] = ct("0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999");
      _weight[0] = ct("0.006944444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444");
      _points[1] = ct("0.01001828046168040584302472986780478481479194051621623866216912370277685746144514894811474690557217898");
      _weight[1] = ct("0.02562404960363464873401147256755191359698912179586886783614733167396359699140406477146628165245745726");
      _points[2] = ct("0.9747263796024796502466688135383708980845368176554858005326201789921787651358684645855413515511531779");
      _weight[2] = ct("0.04208606746934048812078982684064078598356207668454606077811004135971778814182424352552804186759516359");
      _points[3] = ct("0.05203545112718055258354269577296432244718592505838183555552881934330327851280895562528383296766154587");
      _weight[3] = ct("0.05795374014586919637517095413584668388777153128408424542984574266464927148200496692165819750039770507");
      _points[4] = ct("0.9169583865525948532931346270180274177520051095629925713521035439862432832098136415299370694612456097");
      _weight[4] = ct("0.07278183442699756426127382735286559431255511311081887313664967558148928208419907103707790861347367931");
      _points[5] = ct("0.1246192251444430737352995872639092292474441300880058562471871920162296059349519090766521215975420845");
      _weight[5] = ct("0.08638531965665428215303288348279335482371411193381952188479961232975350369852446186555482138789619392");
      _points[6] = ct("0.8308248996228185740305665439056567039439893043182143500186679333872078183180614211671796544755957774");
      _weight[6] = ct("0.09849926741304481732802481898451691715880480601630014213517520121230333584098958189070626683477635742");
      _points[7] = ct("0.2228406070438378555078314534573627644117252503274297081643638173616062308369832016150585853516004853");
      _weight[7] = ct("0.1089344395130962194243737410114312720559919702231833101252380994924976153392527006073200151967269551");
      _points[8] = ct("0.7222032848909679255633213078046109071372364455125913944559779818780897684066745302575181714890353344");
      _weight[8] = ct("0.1175015575724929196743169929697715883009119236048689568907922000277105361992896721300643435454773039");
      _points[9] = ct("0.3400081579146651882336052338970175277313293398208505803470934737382842096120712309333935896431331419");
      _weight[9] = ct("0.1240607804020049797015365535394355200719995254498010043949067360502230324581192591300795635289312217");
      _points[10] = ct("0.5984972797671391832277207136730435902749187521976111511339511314695356530954712310305911412553938959");
      _weight[10] = ct("0.1284956690763538880639871267992001336436691476013189170108039583312533699461672093381787487185684594");
      _points[11] = ct("0.4681376130895840420831103807577535932852717675509161657042498476028053990410676565350775613890232895");
      _weight[11] = ct("0.1307328302760665517190373578715017917195862278509456559330869568319942233737803243379213667092550587");
      break;

    // order 23,24
    case 23 :
    case 24 :
      delivered_order = 24;
      _points.resize(13);
      _weight.resize(13);
      _points[0] = ct("0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999");
      _weight[0] = ct("0.005917159763313609467455621301775147928994082840236686390532544378698224852071005917159763313609467455");
      _points[1] = ct("0.008539054988427419368664460877839802806090414566577746496257927301230364575762166797509842961307629102");
      _weight[1] = ct("0.02185145163395103741442669230253126228354537862132045649291743515926153592140670516392700801272894985");
      _points[2] = ct("0.9784379368341496390919069169169960383680691296676253661798930654904321350621424594217105164689234998");
      _weight[2] = ct("0.03595120814624776446987687028207407841501895536660169592463294449355425288370779064245312669926985388");
      _points[3] = ct("0.04444646315540772302546679878555276624130930378899710999139642043436028639661647795803987919635307505");
      _weight[3] = ct("0.04963390344092354299236819387388759872276531452267544246797332700574719345537345645571951255905295405");
      _points[4] = ct("0.9289421012644110178488101551343152998504932414769823471037599293899243740926428914029706095801991064");
      _weight[4] = ct("0.06255191716557617906688464398784008656184274649282227400711808747510050471677954744690856656060123432");
      _points[5] = ct("0.1068544908834766576341067704324992625897998143695000275580631125622836143405186814627639697793505873");
      _weight[5] = ct("0.07457547504500010257574593212085472848830959655207242548776306668431488289996654073064815660600252619");
      _points[6] = ct("0.8545525437649358807902119164056171284859595037395583869615217146999851616473022152580139867380827058");
      _weight[6] = ct("0.08550173023530832123187933725608529010988327742650916870829611194441770373681670809118932944409747882");
      _points[7] = ct("0.1921510545298540409910572562286133303827013670215218660373964882963368867384002033277468512639620346");
      _weight[7] = ct("0.09518685777981586612737991037293691958788184471208789194562638680044365745312132402614513871070282189");
      _points[8] = ct("0.7595988895252270537426025740434203419422064350885379264310222786423119973912528922496277727549814325");
      _weight[8] = ct("0.1034803057279385373155662804144384374750427276214146948478010879630533907564801063538733440312738658");
      _points[9] = ct("0.2953808842625802216229168343760149059398907133108521080514580880514097551832904806231230987696368169");
      _weight[9] = ct("0.1102671146442257323455385820995765357020738630479430106311100293991178535583726917255962453649948882");
      _points[10] = ct("0.64960065027725499276629172334298057222565311827730373485571958964856442485986620008885607294565333");
      _weight[10] = ct("0.1154444314434977170061018793339061362073895171982322864758099735381130891596922281273366371689249657");
      _points[11] = ct("0.4105450812014576824890343505593324118433186951909181754985565958109519682767226149737373217217664214");
      _weight[11] = ct("0.1189392738303560156713425945898368420344422709752939545408915255899383006020911343567290538236643372");
      _points[12] = ct("0.5309508493128176706289302428968181393245082635016252048349547896722090314354827164359000778197833607");
      _weight[12] = ct("0.1206991711438455743154334620642569364828104246227900120795274795682394100041207609623141177050766563");
      break;

    // order 25,26
    case 25 :
    case 26 :
      delivered_order = 26;
      _points.resize(14);
      _weight.resize(14);
      _points[0] = ct("0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999");
      _weight[0] = ct("0.00510204081632653061224489795918367346938775510204081632653061224489795918367346938775510204081632653");
      _points[1] = ct("0.007364651026089321650691498413822343611205715616446000420689416452269750033894550997416319128445293682");
      _weight[1] = ct("0.01885358163494845713873136414594165020975759392510590592315060034299193800069304020789391250755439251");
      _points[2] = ct("0.9813896349890121485602806221597123115526801027908002379955097186555535838880620308147789489545503323");
      _weight[2] = ct("0.03106100845388573008306645823341460455969559499141094108084012625707654955896377969536296135374710094");
      _points[3] = ct("0.0383981387396783503768325248641416859178298341363546876124160117982427806914025897403499913466209422");
      _weight[3] = ct("0.04297026772149020154465386554328283974483688526109607883477417143735728532178658495401673766981052349");
      _points[4] = ct("0.9385244591007310123976333867652993517339853062062887126354508873721247374248021832126814047065480952");
      _weight[4] = ct("0.05430386137218141341336046761449170556749717283973110242510925951515177257930583451532790775304492282");
      _points[5] = ct("0.09259522469900263528289137543861635588927985865429292632366593235281921073136849542406090039759718099");
      _weight[5] = ct("0.06496983436867117390371286857296886542757042851651763549881540867872262529279047866030734246306485196");
      _points[6] = ct("0.8736948213066894193677145671317438911733815349203347594446961615475144054728685418531116734022398623");
      _weight[6] = ct("0.07481026967656067797526041847298687382328381103405386550842777879482025911405057274802766818691774256");
      _points[7] = ct("0.1672510113915577314955224787593571163747337087390977895834969262324481399932617359780977489832830798");
      _weight[7] = ct("0.08371486394554313949505113851903285254546037528256798216114894580640831517395702564992236389997285344");
      _points[8] = ct("0.7901570282734374855528633324993759322704266136136999317134349971780526905331558640579365443870029771");
      _weight[8] = ct("0.0915635010628648270619336510514316864439809227594628152951066579840052366089190074610930288816591208");
      _points[9] = ct("0.2586235407057625165897907328226910025245301373917701116571591768242959721348720274973743055115115388");
      _weight[9] = ct("0.09826275922649121516230654596477485524374871885835884725402164208061259270491076568978920429932178543");
      _points[10] = ct("0.6921010017196016568970419516876697301808911008718652877381506074556730863418738419796277914411356902");
      _weight[10] = ct("0.1037248816675878363340414432447055349260953854618612465467764711248264947647953780386198366283149413");
      _points[11] = ct("0.3621313972822388004086812982273215588635004488227823666951627890767765685364866146107646481156613177");
      _weight[11] = ct("0.1078835503023094256905937230574369840724121681977091473649374022846524089107794784879188404811405312");
      _points[12] = ct("0.5844439640213404555042208478109107062952661618107888083023659837678484044838564429563713070829009515");
      _weight[12] = ct("0.1106849057497854744658358415102718135678259837364580620549598005910175475300839492981459854834952701");
      _points[13] = ct("0.472584386004117725175094642678597272871548735684737639137060650545639928993354340136687675801761997");
      _weight[13] = ct("0.1120946740013538971192073161100760603984472040336255537254011228574590152552906352058191083511396366");
      break;

    // order 27,28
    case 27 :
    case 28 :
      delivered_order = 28;
      _points.resize(15);
      _weight.resize(15);
      _points[0] = ct("0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999");
      _weight[0] = ct("0.004444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444");
      _points[1] = ct("0.006416760792818456810820464094507178865719839912244884307238769932733545613705239155655121904187696819");
      _weight[1] = ct("0.01643219579229676612652142641153073057741290693423739200638154484999854248273452294729310561302604524");
      _points[2] = ct("0.9837752340986002382812280091410008568029060918346814026541382401229231239358663224051124039381821714");
      _weight[2] = ct("0.02710139002432224716910711840089438470564976679454870725896584731580262535409379031752562837870266878");
      _points[3] = ct("0.03350140453201314003596392857057248161039076925284236707232192332100661384915949406912586179668631268");
      _weight[3] = ct("0.03755419638025321986648583269569141758805153698961255144076732637991919601646605173770385110166578307");
      _points[4] = ct("0.9463027000602753835334059434247240449122575138455164975479188348405641933767500076215855613747667663");
      _weight[4] = ct("0.04756479973024044960192386331729517468694216465472046057613808264784485886335468527107776368357517029");
      _points[5] = ct("0.08098549968195518439245130773998218722766514758665499507829939127797017196531825081787486655370779525");
      _weight[5] = ct("0.0570676017448763765065377912843275486532773680936293313767427911822960640342192529908062097810219568");
      _points[6] = ct("0.8893428088195155396908716609464895647037628629053267599145054482375380565684526275834413083786664628");
      _weight[6] = ct("0.0659377312524758160931310789717671834328714396438875129556617113002714624562014461183427180565642943");
      _points[7] = ct("0.1468048676812137299236601652607991515599694654279756227180485513313137055587256285457460550167373564");
      _weight[7] = ct("0.07408976350173362696234102937128255487413805694748258883130522716337536508449919660779818071285032187");
      _points[8] = ct("0.8153897394434746419730742186120575147090134055115116514499564217599632405912766985454621567772925719");
      _weight[8] = ct("0.08142723865191631472436612291392116582120502240478308220490604700601857925394464346640601462002559893");
      _points[9] = ct("0.2280842706492579915346440986199429719415777248320505178336090146170398503780540680375636284189205414");
      _weight[9] = ct("0.08787443632122384283515522023795954919820258839409278348995177107324231289791167390445951868050365719");
      _points[10] = ct("0.727676452889264685436026727990331696616560168524648660087480949596545653110467939930929401900062142");
      _weight[10] = ct("0.0933575729197254540418975518996095015505528049870462214693890052089200962043726360505074761465047243");
      _points[11] = ct("0.3212717439889361744023403974130354496573046310098509725155244153528428571119004042632189220394104757");
      _weight[11] = ct("0.09781875152255805823677830878766431530678913099926441455902384806443677576510945244842491271878973857");
      _points[12] = ct("0.6300366883704039578844805941314332791605030321087179470245277359365694220786253960307680873297618342");
      _weight[12] = ct("0.1012075935153092149363516552173900812119855087993622184426068461562271888887057964368860900909478014");
      _points[13] = ct("0.4222946573075702578404089875181026958217938762273438789639540713852576268236287646690911714244228904");
      _weight[13] = ct("0.1034879801247768777395136608932904389620559700843852088264115370008206803210070375686989446492003508");
      _points[14] = ct("0.5267378613398730320537269448128829953760927123999441876600624391842836631760001928071840738368501546");
      _weight[14] = ct("0.1046343040738472907154448951529315089864212898285030821173039702063818079329353696896251413221774439");
      break;

    // order 29,30
    case 29 :
    case 30 :
      delivered_order = 30;
      _points.resize(16);
      _weight.resize(16);
      _points[0] = ct("1.0");
      _weight[0] = ct("0.003906249999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999");
      _points[1] = ct("0.005640688972511709757506466579444200966084106988131147967978335138218141575736364048915697203589669807");
      _weight[1] = ct("0.01444856950840716424575961150167959664768321485447374308786815965237503412236544031701308852051345129");
      _points[2] = ct("0.9857305452631742252659006330591292421044806623979681396367496904534811104340037194340828859918697398");
      _weight[2] = ct("0.02385111347384286023258796121105761215940712748373347733951249612012262824249209179131707229548989037");
      _points[3] = ct("0.02948229864794248663164098471800370918700961303166077760161299352098320969659464315137326588996550641");
      _weight[3] = ct("0.0330947543050682173723367824140129988109765140797056057089486775834419651379958009126595489547599592");
      _points[4] = ct("0.9527004099058333143380442075242620935055589938201492599119746533434704857023258451913238950513425185");
      _weight[4] = ct("0.04199264072248258900350601284912850274175530373827143449384382997141429563265696715138196207857827561");
      _points[5] = ct("0.07141295311515884005478390174673491912187290234227435678431701381106489005946195046185073236066258137");
      _weight[5] = ct("0.05049783981089195436218504141066416942898549189111011390903678585931367460678472505588559551870946612");
      _points[6] = ct("0.9022867006793780266312385046620090802654876855849468717160511280017608939616471254566098257665163887");
      _weight[6] = ct("0.05851017655193002851526082850951591652992414137147165348431935555746818051798695168136190985636111654");
      _points[7] = ct("0.1298310255535910559712545380942899123177230784713915452688927991403297243171614954096840860975794642");
      _weight[7] = ct("0.06596284996653406672246151063058849160747151189927306232812579118709032621265417948009199088684731203");
      _points[8] = ct("0.8364309606056101239755590856541831966144050516279921337789774230212989904851294862915904006631825436");
      _weight[8] = ct("0.07277777261010112143531914999678279515995507797472250238664229606324038347926030123455318661603847499");
      _points[9] = ct("0.2024927550501040475682199883202304426029145838857816183098197713593869872838287905637745131407654631");
      _weight[9] = ct("0.07889346090210101014257961013735628556027751692815831358281184285722704118272376932178081897027333611");
      _points[10] = ct("0.7576647390313427119970742777402853179406886187590936481745381257951925531912300645820920629808513944");
      _weight[10] = ct("0.08424819892496124501819105207923275942561890638984801295494652596992252939263197128583747944314191086");
      _points[11] = ct("0.2866060862575270599840260454843964124631835183282258747277172597764764143673373926548361027887495961");
      _weight[11] = ct("0.0887923963763697559481752588801875527471665581288797954926123946185668633418713757400843776997412092");
      _points[12] = ct("0.6690151950299598765386956390531395651245327979857527236420750144055549199665133052913040313820535801");
      _weight[12] = ct("0.09248089074433267978323239376056093439894591473240448144120626047437788156837996046854633882875631641");
      _points[13] = ct("0.3789386886469780381065290091427738514254527443330112900124820663975192124536679674713512968590311795");
      _weight[13] = ct("0.09527914712767754441311796762044089051519985174582994892126109353070075332923324694354921353229351015");
      _points[14] = ct("0.5738891609066858806714538552375264393339926267874317142496528265661645824810184689905478175189410146");
      _weight[14] = ct("0.09715954485578392167168809787195218347038559646446468604327985098793468776901949385191763241792479535");
      _points[15] = ct("0.4759423084632348605725889920158496815427420479142534143461931573336140130566014455167924185629638753");
      _weight[15] = ct("0.09810439411951584113359872112683931079624727231765316882558463956680375546394372476401978438057097569");
      break;

    default :
      DUNE_THROW(QuadratureOrderOutOfRange, "Quadrature rule " << p << " not supported!");
    }
  }


  template<typename ct>
  GaussRadauRightQuadratureRule<ct,1>::GaussRadauRightQuadratureRule (int p)
      : QuadratureRule<ct,1>(GeometryTypes::line)
  {
    //! set up quadrature of given order in d dimensions
    std::vector< FieldVector<ct,1> > _points;
    std::vector< ct > _weight;

    int deliveredOrder_;

    GaussRadauRightQuadratureInitHelper<ct>::init(p, _points, _weight, deliveredOrder_);

    this->delivered_order = deliveredOrder_;
    assert(_points.size() == _weight.size());
    for (size_t i = 0; i < _points.size(); i++)
      this->push_back(QuadraturePoint<ct,1>(_points[i], _weight[i]));
  }

} // namespace Dune

#endif // DUNE_GEOMETRY_QUADRATURE_GaussRadauRight_HH
