/*
 * Copyright (C) 2007-2009 KenD00
 * 
 * This file is part of DumpHD.
 * 
 * DumpHD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package dumphd.util;

/**
 * Exception thrown when a parser error occurs during parsing a MPEG-2 Transport Stream.
 * 
 * @author KenD00
 */
public class TSParserException extends Exception {

   public TSParserException() {
      super();
   }

   public TSParserException(String message) {
      super(message);
   }

   public TSParserException(String message, Throwable cause) {
      super(message, cause);
   }

   public TSParserException(Throwable cause) {
      super(cause);
   }


}
