/* doscan - Denial Of Service Capable Auditing of Networks
 * Copyright (C) 2003 Florian Weimer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef OPT_H
#define OPT_H

#include "ticks.h"

extern const char *opt_program;
/* the name of the program */

extern int opt_verbose;
/* control verbose mode */

extern unsigned opt_port;
/* the remote port to connect to */

extern ticks_t opt_connect_timeout;
/* in milliseconds, default is 30000 */

extern ticks_t opt_read_timeout;
/* in milliseconds, default is 30000 */

extern ticks_t opt_write_timeout;
/* in milliseconds, default is 30000 */

extern unsigned opt_fd_count;
/* number of sockets to create, default is 50 */

extern unsigned opt_add_burst;
/* number of sockets to open at once, default is 10 */

extern unsigned opt_add_timeout;
/* timeout after add in milliseconds, default is 20 */

extern int opt_net_errors;
/* shall we include errors related to the network? */

extern int opt_no_epoll;
/* do not use epoll even if it is available */

extern int opt_indicator;
/* shall we display a progress indicator? */

extern unsigned opt_banner_size;
/* how many bytes shall we read from the other host */

extern const char *opt_receive;
/* argument to the --receive option */

extern const char *opt_send;
/* argument to the --send option */

extern const char *opt_output;
/* output format specifier */

extern const char *opt_protocol;
/* the protocol module to use for scanning */

extern const char *opt_output_style;
/* the output style (sort order) */

#endif /* OPT_H */

/* arch-tag: 3cbfec35-b860-4fde-9cf0-0697abab41b1
 */
