# -*- coding: utf-8 -*-
"""This module provides the following constants:

* DOLFIN_EPS = 3.0e-16
* DOLFIN_EPS_LARGE = 1e-14
* DOLFIN_SQRT_EPS = 1e-8
* DOLFIN_PI = 3.141592653589793238462

* FENICS_EPS = 3.0e-16
* FENICS_EPS_LARGE = 1e-14
* FENICS_SQRT_EPS = 1e-8
* FENICS_PI = 3.141592653589793238462
"""

__all__ = ['DOLFIN_EPS', 'DOLFIN_EPS_LARGE', 'DOLFIN_SQRT_EPS', 'DOLFIN_PI',
           'FENICS_EPS', 'FENICS_EPS_LARGE', 'FENICS_SQRT_EPS', 'FENICS_PI']

from dolfin.cpp import DOLFIN_EPS, DOLFIN_EPS_LARGE, DOLFIN_SQRT_EPS, DOLFIN_PI
from dolfin.cpp import FENICS_EPS, FENICS_EPS_LARGE, FENICS_SQRT_EPS, FENICS_PI
