# Authors:
#     Endi S. Dewata <edewata@redhat.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Copyright (C) 2017 Red Hat, Inc.
# All rights reserved.
#

from __future__ import absolute_import
import os
from lxml import etree

import pki


class UpdateAJPLoopbackAddress(
        pki.server.upgrade.PKIServerUpgradeScriptlet):

    def __init__(self):
        super(UpdateAJPLoopbackAddress, self).__init__()
        self.message = 'Update AJP loopback address'

        self.parser = etree.XMLParser(remove_blank_text=True)

    def upgrade_instance(self, instance):

        server_xml = os.path.join(instance.conf_dir, 'server.xml')
        self.backup(server_xml)

        document = etree.parse(server_xml, self.parser)

        server = document.getroot()
        connectors = server.findall('.//Connector')

        # replace IPv4- or IPv6-specific AJP loopback address with localhost
        for connector in connectors:

            protocol = connector.get('protocol')
            if protocol != 'AJP/1.3':
                continue

            address = connector.get('address')
            if address != '127.0.0.1' and address != '::1':
                continue

            connector.set('address', 'localhost')

        with open(server_xml, 'wb') as f:
            document.write(f, pretty_print=True, encoding='utf-8')
