/* dockmanager-common.c generated by valac 0.11.6, the Vala compiler
 * generated from dockmanager-common.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <gio/gio.h>
#include <dbus/dbus.h>


#define DOCK_MANAGER_TYPE_DAEMON_INTERFACE (dock_manager_daemon_interface_get_type ())
#define DOCK_MANAGER_DAEMON_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCK_MANAGER_TYPE_DAEMON_INTERFACE, DockManagerDaemonInterface))
#define DOCK_MANAGER_IS_DAEMON_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCK_MANAGER_TYPE_DAEMON_INTERFACE))
#define DOCK_MANAGER_DAEMON_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DOCK_MANAGER_TYPE_DAEMON_INTERFACE, DockManagerDaemonInterfaceIface))

typedef struct _DockManagerDaemonInterface DockManagerDaemonInterface;
typedef struct _DockManagerDaemonInterfaceIface DockManagerDaemonInterfaceIface;

#define DOCK_MANAGER_TYPE_HELPER_INFO (dock_manager_helper_info_get_type ())
typedef struct _DockManagerHelperInfo DockManagerHelperInfo;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _DockManagerDaemonInterfaceDBusProxy DockManagerDaemonInterfaceDBusProxy;
typedef DBusGProxyClass DockManagerDaemonInterfaceDBusProxyClass;
typedef struct _DockManagerDaemonInterfaceDBusProxyInstallHelperData DockManagerDaemonInterfaceDBusProxyInstallHelperData;

struct _DockManagerHelperInfo {
	gchar* path;
	gchar* name;
	gchar* description;
	gchar* icon_name;
	gchar* app_name;
	gchar* dbus_name;
	gboolean app_available;
	gboolean enabled;
	gboolean running;
};

struct _DockManagerDaemonInterfaceIface {
	GTypeInterface parent_iface;
	DockManagerHelperInfo* (*get_all_helpers) (DockManagerDaemonInterface* self, int* result_length1, GError** error);
	void (*enable_helper) (DockManagerDaemonInterface* self, const gchar* path, GError** error);
	void (*disable_helper) (DockManagerDaemonInterface* self, const gchar* path, GError** error);
	void (*restart_all) (DockManagerDaemonInterface* self, GError** error);
	void (*install_helper) (DockManagerDaemonInterface* self, const gchar* filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*install_helper_finish) (DockManagerDaemonInterface* self, GAsyncResult* _res_, GError** error);
	void (*show_preferences) (DockManagerDaemonInterface* self, GError** error);
	void (*embed_preferences) (DockManagerDaemonInterface* self, gint64 xid, GHashTable* hints, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _DockManagerDaemonInterfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _DockManagerDaemonInterfaceDBusProxyInstallHelperData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};



#define DOCK_MANAGER_DBUS_UNIQUE_NAME "net.launchpad.DockManager.Daemon"
#define DOCK_MANAGER_DBUS_INTERFACE_NAME "net.launchpad.DockManager.Daemon"
#define DOCK_MANAGER_DBUS_OBJECT_PATH_NAME "/net/launchpad/DockManager/Daemon"
DockManagerDaemonInterface* dock_manager_daemon_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType dock_manager_helper_info_get_type (void) G_GNUC_CONST;
DockManagerHelperInfo* dock_manager_helper_info_dup (const DockManagerHelperInfo* self);
void dock_manager_helper_info_free (DockManagerHelperInfo* self);
void dock_manager_helper_info_copy (const DockManagerHelperInfo* self, DockManagerHelperInfo* dest);
void dock_manager_helper_info_destroy (DockManagerHelperInfo* self);
GType dock_manager_daemon_interface_get_type (void) G_GNUC_CONST;
DockManagerHelperInfo* dock_manager_daemon_interface_get_all_helpers (DockManagerDaemonInterface* self, int* result_length1, GError** error);
void dock_manager_daemon_interface_enable_helper (DockManagerDaemonInterface* self, const gchar* path, GError** error);
void dock_manager_daemon_interface_disable_helper (DockManagerDaemonInterface* self, const gchar* path, GError** error);
void dock_manager_daemon_interface_restart_all (DockManagerDaemonInterface* self, GError** error);
void dock_manager_daemon_interface_install_helper (DockManagerDaemonInterface* self, const gchar* filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean dock_manager_daemon_interface_install_helper_finish (DockManagerDaemonInterface* self, GAsyncResult* _res_, GError** error);
void dock_manager_daemon_interface_show_preferences (DockManagerDaemonInterface* self, GError** error);
void dock_manager_daemon_interface_embed_preferences (DockManagerDaemonInterface* self, gint64 xid, GHashTable* hints, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void dock_manager_daemon_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dock_manager_daemon_interface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dock_manager_daemon_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dock_manager_daemon_interface_introspect (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_daemon_interface_property_get_all (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message);
static void _vala_DockManagerHelperInfo_array_free (DockManagerHelperInfo* array, gint array_length);
static DBusHandlerResult _dbus_dock_manager_daemon_interface_get_all_helpers (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_daemon_interface_enable_helper (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_daemon_interface_disable_helper (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_daemon_interface_restart_all (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_daemon_interface_install_helper (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dock_manager_daemon_interface_install_helper_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static DBusHandlerResult _dbus_dock_manager_daemon_interface_show_preferences (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dock_manager_daemon_interface_embed_preferences (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dock_manager_daemon_interface_helper_list_changed (GObject* _sender, DBusConnection* _connection);
static void _dbus_dock_manager_daemon_interface_helper_state_changed (GObject* _sender, const gchar* path, gboolean enabled, gboolean running, DBusConnection* _connection);
GType dock_manager_daemon_interface_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_dock_manager_daemon_interface_helper_list_changed (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dock_manager_daemon_interface_helper_state_changed (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dock_manager_daemon_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	DOCK_MANAGER_DAEMON_INTERFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static DockManagerHelperInfo* dock_manager_daemon_interface_dbus_proxy_get_all_helpers (DockManagerDaemonInterface* self, int* result_length1, GError** error);
static void dock_manager_daemon_interface_dbus_proxy_enable_helper (DockManagerDaemonInterface* self, const gchar* path, GError** error);
static void dock_manager_daemon_interface_dbus_proxy_disable_helper (DockManagerDaemonInterface* self, const gchar* path, GError** error);
static void dock_manager_daemon_interface_dbus_proxy_restart_all (DockManagerDaemonInterface* self, GError** error);
static void dock_manager_daemon_interface_dbus_proxy_install_helper_async (DockManagerDaemonInterface* self, const gchar* filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void dock_manager_daemon_interface_dbus_proxy_install_helper_ready (DBusPendingCall* pending, void* user_data);
static gboolean dock_manager_daemon_interface_dbus_proxy_install_helper_finish (DockManagerDaemonInterface* self, GAsyncResult* _res_, GError** error);
static void dock_manager_daemon_interface_dbus_proxy_show_preferences (DockManagerDaemonInterface* self, GError** error);
static void dock_manager_daemon_interface_dbus_proxy_embed_preferences (DockManagerDaemonInterface* self, gint64 xid, GHashTable* hints, GError** error);
static void dock_manager_daemon_interface_dbus_proxy_dock_manager_daemon_interface__interface_init (DockManagerDaemonInterfaceIface* iface);
static void _vala_dock_manager_daemon_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dock_manager_daemon_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const DBusObjectPathVTable _dock_manager_daemon_interface_dbus_path_vtable = {_dock_manager_daemon_interface_dbus_unregister, dock_manager_daemon_interface_dbus_message};
static const _DBusObjectVTable _dock_manager_daemon_interface_dbus_vtable = {dock_manager_daemon_interface_dbus_register_object};

DockManagerHelperInfo* dock_manager_daemon_interface_get_all_helpers (DockManagerDaemonInterface* self, int* result_length1, GError** error) {
	return DOCK_MANAGER_DAEMON_INTERFACE_GET_INTERFACE (self)->get_all_helpers (self, result_length1, error);
}


void dock_manager_daemon_interface_enable_helper (DockManagerDaemonInterface* self, const gchar* path, GError** error) {
	DOCK_MANAGER_DAEMON_INTERFACE_GET_INTERFACE (self)->enable_helper (self, path, error);
}


void dock_manager_daemon_interface_disable_helper (DockManagerDaemonInterface* self, const gchar* path, GError** error) {
	DOCK_MANAGER_DAEMON_INTERFACE_GET_INTERFACE (self)->disable_helper (self, path, error);
}


void dock_manager_daemon_interface_restart_all (DockManagerDaemonInterface* self, GError** error) {
	DOCK_MANAGER_DAEMON_INTERFACE_GET_INTERFACE (self)->restart_all (self, error);
}


void dock_manager_daemon_interface_install_helper (DockManagerDaemonInterface* self, const gchar* filename, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DOCK_MANAGER_DAEMON_INTERFACE_GET_INTERFACE (self)->install_helper (self, filename, _callback_, _user_data_);
}


gboolean dock_manager_daemon_interface_install_helper_finish (DockManagerDaemonInterface* self, GAsyncResult* _res_, GError** error) {
	return DOCK_MANAGER_DAEMON_INTERFACE_GET_INTERFACE (self)->install_helper_finish (self, _res_, error);
}


void dock_manager_daemon_interface_show_preferences (DockManagerDaemonInterface* self, GError** error) {
	DOCK_MANAGER_DAEMON_INTERFACE_GET_INTERFACE (self)->show_preferences (self, error);
}


void dock_manager_daemon_interface_embed_preferences (DockManagerDaemonInterface* self, gint64 xid, GHashTable* hints, GError** error) {
	DOCK_MANAGER_DAEMON_INTERFACE_GET_INTERFACE (self)->embed_preferences (self, xid, hints, error);
}


static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOOLEAN_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gboolean arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), g_value_get_boolean (param_values + 3), data2);
}


static void dock_manager_daemon_interface_base_init (DockManagerDaemonInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("helper_list_changed", DOCK_MANAGER_TYPE_DAEMON_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("helper_state_changed", DOCK_MANAGER_TYPE_DAEMON_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN_BOOLEAN, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
	}
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _dock_manager_daemon_interface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dock_manager_daemon_interface_introspect (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"net.launchpad.DockManager.Daemon\">\n  <method name=\"GetAllHelpers\">\n    <arg name=\"result\" type=\"a(ssssssbbb)\" direction=\"out\"/>\n  </method>\n  <method name=\"EnableHelper\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"DisableHelper\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"RestartAll\">\n  </method>\n  <method name=\"InstallHelper\">\n    <arg name=\"filename\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"ShowPreferences\">\n  </method>\n  <method name=\"EmbedPreferences\">\n    <arg name=\"xid\" type=\"x\" direction=\"in\"/>\n    <arg name=\"hints\" type=\"a{sv}\" direction=\"in\"/>\n  </method>\n  <signal name=\"HelperListChanged\">\n  </signal>\n  <signal name=\"HelperStateChanged\">\n    <arg name=\"path\" type=\"s\"/>\n    <arg name=\"enabled\" type=\"b\"/>\n    <arg name=\"running\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_daemon_interface_property_get_all (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "net.launchpad.DockManager.Daemon") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _vala_DockManagerHelperInfo_array_free (DockManagerHelperInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dock_manager_helper_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DBusHandlerResult _dbus_dock_manager_daemon_interface_get_all_helpers (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DockManagerHelperInfo* result;
	int result_length1;
	DBusMessage* reply;
	DockManagerHelperInfo* _tmp1_;
	DBusMessageIter _tmp2_;
	int _tmp3_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dock_manager_daemon_interface_get_all_helpers (self, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "(ssssssbbb)", &_tmp2_);
	for (_tmp3_ = 0; _tmp3_ < result_length1; _tmp3_++) {
		DBusMessageIter _tmp4_;
		const char* _tmp5_;
		const char* _tmp6_;
		const char* _tmp7_;
		const char* _tmp8_;
		const char* _tmp9_;
		const char* _tmp10_;
		dbus_bool_t _tmp11_;
		dbus_bool_t _tmp12_;
		dbus_bool_t _tmp13_;
		dbus_message_iter_open_container (&_tmp2_, DBUS_TYPE_STRUCT, NULL, &_tmp4_);
		_tmp5_ = (*_tmp1_).path;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_STRING, &_tmp5_);
		_tmp6_ = (*_tmp1_).name;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_STRING, &_tmp6_);
		_tmp7_ = (*_tmp1_).description;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_STRING, &_tmp7_);
		_tmp8_ = (*_tmp1_).icon_name;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_STRING, &_tmp8_);
		_tmp9_ = (*_tmp1_).app_name;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_STRING, &_tmp9_);
		_tmp10_ = (*_tmp1_).dbus_name;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_STRING, &_tmp10_);
		_tmp11_ = (*_tmp1_).app_available;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_BOOLEAN, &_tmp11_);
		_tmp12_ = (*_tmp1_).enabled;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_BOOLEAN, &_tmp12_);
		_tmp13_ = (*_tmp1_).running;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_BOOLEAN, &_tmp13_);
		dbus_message_iter_close_container (&_tmp2_, &_tmp4_);
		_tmp1_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp2_);
	 result = (_vala_DockManagerHelperInfo_array_free ( result,  result_length1), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_daemon_interface_enable_helper (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gchar* path = NULL;
	const char* _tmp14_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp14_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp14_);
	dock_manager_daemon_interface_enable_helper (self, path, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (path);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_daemon_interface_disable_helper (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gchar* path = NULL;
	const char* _tmp15_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp15_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp15_);
	dock_manager_daemon_interface_disable_helper (self, path, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (path);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_daemon_interface_restart_all (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dock_manager_daemon_interface_restart_all (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_daemon_interface_install_helper (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gchar* filename = NULL;
	const char* _tmp16_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp16_);
	dbus_message_iter_next (&iter);
	filename = g_strdup (_tmp16_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	dock_manager_daemon_interface_install_helper (self, filename, (GAsyncReadyCallback) _dbus_dock_manager_daemon_interface_install_helper_ready, _user_data_);
	_g_free0 (filename);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_dock_manager_daemon_interface_install_helper_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp17_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result = dock_manager_daemon_interface_install_helper_finish ((DockManagerDaemonInterface*) source_object, _res_, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp17_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp17_);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


static DBusHandlerResult _dbus_dock_manager_daemon_interface_show_preferences (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dock_manager_daemon_interface_show_preferences (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dock_manager_daemon_interface_embed_preferences (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gint64 xid = 0LL;
	dbus_int64_t _tmp18_;
	GHashTable* hints = NULL;
	GHashTable* _tmp19_;
	DBusMessageIter _tmp20_;
	DBusMessageIter _tmp21_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "xa{sv}")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp18_);
	dbus_message_iter_next (&iter);
	xid = _tmp18_;
	_tmp19_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	dbus_message_iter_recurse (&iter, &_tmp20_);
	while (dbus_message_iter_get_arg_type (&_tmp20_)) {
		gchar* _key;
		GValue* _value;
		const char* _tmp22_;
		GValue _tmp23_ = {0};
		DBusMessageIter _tmp24_;
		dbus_message_iter_recurse (&_tmp20_, &_tmp21_);
		dbus_message_iter_get_basic (&_tmp21_, &_tmp22_);
		dbus_message_iter_next (&_tmp21_);
		_key = g_strdup (_tmp22_);
		dbus_message_iter_recurse (&_tmp21_, &_tmp24_);
		if (dbus_message_iter_get_arg_type (&_tmp24_) == DBUS_TYPE_BYTE) {
			guint8 _tmp25_;
			dbus_message_iter_get_basic (&_tmp24_, &_tmp25_);
			g_value_init (&_tmp23_, G_TYPE_UCHAR);
			g_value_set_uchar (&_tmp23_, _tmp25_);
		} else if (dbus_message_iter_get_arg_type (&_tmp24_) == DBUS_TYPE_BOOLEAN) {
			dbus_bool_t _tmp26_;
			dbus_message_iter_get_basic (&_tmp24_, &_tmp26_);
			g_value_init (&_tmp23_, G_TYPE_BOOLEAN);
			g_value_set_boolean (&_tmp23_, _tmp26_);
		} else if (dbus_message_iter_get_arg_type (&_tmp24_) == DBUS_TYPE_INT16) {
			dbus_int16_t _tmp27_;
			dbus_message_iter_get_basic (&_tmp24_, &_tmp27_);
			g_value_init (&_tmp23_, G_TYPE_INT);
			g_value_set_int (&_tmp23_, _tmp27_);
		} else if (dbus_message_iter_get_arg_type (&_tmp24_) == DBUS_TYPE_UINT16) {
			dbus_uint16_t _tmp28_;
			dbus_message_iter_get_basic (&_tmp24_, &_tmp28_);
			g_value_init (&_tmp23_, G_TYPE_UINT);
			g_value_set_uint (&_tmp23_, _tmp28_);
		} else if (dbus_message_iter_get_arg_type (&_tmp24_) == DBUS_TYPE_INT32) {
			dbus_int32_t _tmp29_;
			dbus_message_iter_get_basic (&_tmp24_, &_tmp29_);
			g_value_init (&_tmp23_, G_TYPE_INT);
			g_value_set_int (&_tmp23_, _tmp29_);
		} else if (dbus_message_iter_get_arg_type (&_tmp24_) == DBUS_TYPE_UINT32) {
			dbus_uint32_t _tmp30_;
			dbus_message_iter_get_basic (&_tmp24_, &_tmp30_);
			g_value_init (&_tmp23_, G_TYPE_UINT);
			g_value_set_uint (&_tmp23_, _tmp30_);
		} else if (dbus_message_iter_get_arg_type (&_tmp24_) == DBUS_TYPE_INT64) {
			dbus_int64_t _tmp31_;
			dbus_message_iter_get_basic (&_tmp24_, &_tmp31_);
			g_value_init (&_tmp23_, G_TYPE_INT64);
			g_value_set_int64 (&_tmp23_, _tmp31_);
		} else if (dbus_message_iter_get_arg_type (&_tmp24_) == DBUS_TYPE_UINT64) {
			dbus_uint64_t _tmp32_;
			dbus_message_iter_get_basic (&_tmp24_, &_tmp32_);
			g_value_init (&_tmp23_, G_TYPE_UINT64);
			g_value_set_uint64 (&_tmp23_, _tmp32_);
		} else if (dbus_message_iter_get_arg_type (&_tmp24_) == DBUS_TYPE_DOUBLE) {
			double _tmp33_;
			dbus_message_iter_get_basic (&_tmp24_, &_tmp33_);
			g_value_init (&_tmp23_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp23_, _tmp33_);
		} else if (dbus_message_iter_get_arg_type (&_tmp24_) == DBUS_TYPE_STRING) {
			const char* _tmp34_;
			dbus_message_iter_get_basic (&_tmp24_, &_tmp34_);
			g_value_init (&_tmp23_, G_TYPE_STRING);
			g_value_take_string (&_tmp23_, g_strdup (_tmp34_));
		} else if (dbus_message_iter_get_arg_type (&_tmp24_) == DBUS_TYPE_OBJECT_PATH) {
			const char* _tmp35_;
			dbus_message_iter_get_basic (&_tmp24_, &_tmp35_);
			g_value_init (&_tmp23_, G_TYPE_STRING);
			g_value_take_string (&_tmp23_, g_strdup (_tmp35_));
		} else if (dbus_message_iter_get_arg_type (&_tmp24_) == DBUS_TYPE_SIGNATURE) {
			const char* _tmp36_;
			dbus_message_iter_get_basic (&_tmp24_, &_tmp36_);
			g_value_init (&_tmp23_, G_TYPE_STRING);
			g_value_take_string (&_tmp23_, g_strdup (_tmp36_));
		} else if ((dbus_message_iter_get_arg_type (&_tmp24_) == DBUS_TYPE_ARRAY) && (dbus_message_iter_get_element_type (&_tmp24_) == DBUS_TYPE_STRING)) {
			const gchar** _tmp37_;
			int _tmp37__length;
			int _tmp37__size;
			int _tmp37__length1;
			DBusMessageIter _tmp38_;
			_tmp37_ = g_new (const gchar*, 5);
			_tmp37__length = 0;
			_tmp37__size = 4;
			_tmp37__length1 = 0;
			dbus_message_iter_recurse (&_tmp24_, &_tmp38_);
			for (; dbus_message_iter_get_arg_type (&_tmp38_); _tmp37__length1++) {
				const char* _tmp39_;
				if (_tmp37__size == _tmp37__length) {
					_tmp37__size = 2 * _tmp37__size;
					_tmp37_ = g_renew (const gchar*, _tmp37_, _tmp37__size + 1);
				}
				dbus_message_iter_get_basic (&_tmp38_, &_tmp39_);
				dbus_message_iter_next (&_tmp38_);
				_tmp37_[_tmp37__length++] = g_strdup (_tmp39_);
			}
			_tmp37_[_tmp37__length] = NULL;
			g_value_init (&_tmp23_, G_TYPE_STRV);
			g_value_take_boxed (&_tmp23_, _tmp37_);
		}
		dbus_message_iter_next (&_tmp21_);
		_value = g_memdup (&_tmp23_, sizeof (GValue));
		g_hash_table_insert (_tmp19_, _key, _value);
		dbus_message_iter_next (&_tmp20_);
	}
	dbus_message_iter_next (&iter);
	hints = _tmp19_;
	dock_manager_daemon_interface_embed_preferences (self, xid, hints, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_hash_table_unref0 (hints);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dock_manager_daemon_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dock_manager_daemon_interface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_dock_manager_daemon_interface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "net.launchpad.DockManager.Daemon", "GetAllHelpers")) {
		result = _dbus_dock_manager_daemon_interface_get_all_helpers (object, connection, message);
	} else if (dbus_message_is_method_call (message, "net.launchpad.DockManager.Daemon", "EnableHelper")) {
		result = _dbus_dock_manager_daemon_interface_enable_helper (object, connection, message);
	} else if (dbus_message_is_method_call (message, "net.launchpad.DockManager.Daemon", "DisableHelper")) {
		result = _dbus_dock_manager_daemon_interface_disable_helper (object, connection, message);
	} else if (dbus_message_is_method_call (message, "net.launchpad.DockManager.Daemon", "RestartAll")) {
		result = _dbus_dock_manager_daemon_interface_restart_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "net.launchpad.DockManager.Daemon", "InstallHelper")) {
		result = _dbus_dock_manager_daemon_interface_install_helper (object, connection, message);
	} else if (dbus_message_is_method_call (message, "net.launchpad.DockManager.Daemon", "ShowPreferences")) {
		result = _dbus_dock_manager_daemon_interface_show_preferences (object, connection, message);
	} else if (dbus_message_is_method_call (message, "net.launchpad.DockManager.Daemon", "EmbedPreferences")) {
		result = _dbus_dock_manager_daemon_interface_embed_preferences (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dock_manager_daemon_interface_helper_list_changed (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "net.launchpad.DockManager.Daemon", "HelperListChanged");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dock_manager_daemon_interface_helper_state_changed (GObject* _sender, const gchar* path, gboolean enabled, gboolean running, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp40_;
	dbus_bool_t _tmp41_;
	dbus_bool_t _tmp42_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "net.launchpad.DockManager.Daemon", "HelperStateChanged");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp40_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp40_);
	_tmp41_ = enabled;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp41_);
	_tmp42_ = running;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp42_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dock_manager_daemon_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dock_manager_daemon_interface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "helper-list-changed", (GCallback) _dbus_dock_manager_daemon_interface_helper_list_changed, connection);
	g_signal_connect (object, "helper-state-changed", (GCallback) _dbus_dock_manager_daemon_interface_helper_state_changed, connection);
}


GType dock_manager_daemon_interface_get_type (void) {
	static volatile gsize dock_manager_daemon_interface_type_id__volatile = 0;
	if (g_once_init_enter (&dock_manager_daemon_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DockManagerDaemonInterfaceIface), (GBaseInitFunc) dock_manager_daemon_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dock_manager_daemon_interface_type_id;
		dock_manager_daemon_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "DockManagerDaemonInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dock_manager_daemon_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dock_manager_daemon_interface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &dock_manager_daemon_interface_dbus_proxy_get_type);
		g_type_set_qdata (dock_manager_daemon_interface_type_id, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dock_manager_daemon_interface_dbus_vtable));
		g_once_init_leave (&dock_manager_daemon_interface_type_id__volatile, dock_manager_daemon_interface_type_id);
	}
	return dock_manager_daemon_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DockManagerDaemonInterfaceDBusProxy, dock_manager_daemon_interface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DOCK_MANAGER_TYPE_DAEMON_INTERFACE, dock_manager_daemon_interface_dbus_proxy_dock_manager_daemon_interface__interface_init) );
DockManagerDaemonInterface* dock_manager_daemon_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DockManagerDaemonInterface* self;
	self = g_object_new (dock_manager_daemon_interface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "net.launchpad.DockManager.Daemon", NULL);
	return self;
}


static GObject* dock_manager_daemon_interface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (dock_manager_daemon_interface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dock_manager_daemon_interface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s',interface='net.launchpad.DockManager.Daemon'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_dock_manager_daemon_interface_helper_list_changed (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "helper-list-changed");
}


static void _dbus_handle_dock_manager_daemon_interface_helper_state_changed (DockManagerDaemonInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gchar* path = NULL;
	const char* _tmp0_;
	gboolean enabled = FALSE;
	dbus_bool_t _tmp1_;
	gboolean running = FALSE;
	dbus_bool_t _tmp2_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "sbb")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	enabled = _tmp1_;
	dbus_message_iter_get_basic (&iter, &_tmp2_);
	dbus_message_iter_next (&iter);
	running = _tmp2_;
	g_signal_emit_by_name (self, "helper-state-changed", path, enabled, running);
	_g_free0 (path);
}


DBusHandlerResult dock_manager_daemon_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "net.launchpad.DockManager.Daemon", "HelperListChanged")) {
			_dbus_handle_dock_manager_daemon_interface_helper_list_changed (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "net.launchpad.DockManager.Daemon", "HelperStateChanged")) {
			_dbus_handle_dock_manager_daemon_interface_helper_state_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dock_manager_daemon_interface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((DockManagerDaemonInterfaceDBusProxy*) self)->disposed) {
		return;
	}
	((DockManagerDaemonInterfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dock_manager_daemon_interface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dock_manager_daemon_interface_dbus_proxy_parent_class)->dispose (self);
}


static void dock_manager_daemon_interface_dbus_proxy_class_init (DockManagerDaemonInterfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = dock_manager_daemon_interface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = dock_manager_daemon_interface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_dock_manager_daemon_interface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dock_manager_daemon_interface_dbus_proxy_set_property;
}


static void dock_manager_daemon_interface_dbus_proxy_init (DockManagerDaemonInterfaceDBusProxy* self) {
}


static DockManagerHelperInfo* dock_manager_daemon_interface_dbus_proxy_get_all_helpers (DockManagerDaemonInterface* self, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	DockManagerHelperInfo* _result;
	int _result_length1;
	DockManagerHelperInfo* _tmp3_;
	int _tmp3__length;
	int _tmp3__size;
	int _tmp3__length1;
	DBusMessageIter _tmp4_;
	if (((DockManagerDaemonInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "net.launchpad.DockManager.Daemon", "GetAllHelpers");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp16_;
			_edomain = DBUS_GERROR;
			_tmp16_ = _dbus_error.name + 27;
			if (strcmp (_tmp16_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp16_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp16_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp16_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp16_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp16_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp16_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp16_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp16_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp16_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp16_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp16_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp16_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp16_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp16_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp16_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp16_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp16_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp16_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp16_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp16_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp16_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp16_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp16_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp16_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp16_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp16_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp16_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp16_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp16_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp16_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp16_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp16_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "a(ssssssbbb)")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "a(ssssssbbb)", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp3_ = g_new (DockManagerHelperInfo, 5);
	_tmp3__length = 0;
	_tmp3__size = 4;
	_tmp3__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp4_);
	for (; dbus_message_iter_get_arg_type (&_tmp4_); _tmp3__length1++) {
		DockManagerHelperInfo _tmp5_;
		DBusMessageIter _tmp6_;
		const char* _tmp7_;
		const char* _tmp8_;
		const char* _tmp9_;
		const char* _tmp10_;
		const char* _tmp11_;
		const char* _tmp12_;
		dbus_bool_t _tmp13_;
		dbus_bool_t _tmp14_;
		dbus_bool_t _tmp15_;
		if (_tmp3__size == _tmp3__length) {
			_tmp3__size = 2 * _tmp3__size;
			_tmp3_ = g_renew (DockManagerHelperInfo, _tmp3_, _tmp3__size + 1);
		}
		dbus_message_iter_recurse (&_tmp4_, &_tmp6_);
		dbus_message_iter_get_basic (&_tmp6_, &_tmp7_);
		dbus_message_iter_next (&_tmp6_);
		_tmp5_.path = g_strdup (_tmp7_);
		dbus_message_iter_get_basic (&_tmp6_, &_tmp8_);
		dbus_message_iter_next (&_tmp6_);
		_tmp5_.name = g_strdup (_tmp8_);
		dbus_message_iter_get_basic (&_tmp6_, &_tmp9_);
		dbus_message_iter_next (&_tmp6_);
		_tmp5_.description = g_strdup (_tmp9_);
		dbus_message_iter_get_basic (&_tmp6_, &_tmp10_);
		dbus_message_iter_next (&_tmp6_);
		_tmp5_.icon_name = g_strdup (_tmp10_);
		dbus_message_iter_get_basic (&_tmp6_, &_tmp11_);
		dbus_message_iter_next (&_tmp6_);
		_tmp5_.app_name = g_strdup (_tmp11_);
		dbus_message_iter_get_basic (&_tmp6_, &_tmp12_);
		dbus_message_iter_next (&_tmp6_);
		_tmp5_.dbus_name = g_strdup (_tmp12_);
		dbus_message_iter_get_basic (&_tmp6_, &_tmp13_);
		dbus_message_iter_next (&_tmp6_);
		_tmp5_.app_available = _tmp13_;
		dbus_message_iter_get_basic (&_tmp6_, &_tmp14_);
		dbus_message_iter_next (&_tmp6_);
		_tmp5_.enabled = _tmp14_;
		dbus_message_iter_get_basic (&_tmp6_, &_tmp15_);
		dbus_message_iter_next (&_tmp6_);
		_tmp5_.running = _tmp15_;
		dbus_message_iter_next (&_tmp4_);
		_tmp3_[_tmp3__length++] = _tmp5_;
	}
	_result_length1 = _tmp3__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp3_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void dock_manager_daemon_interface_dbus_proxy_enable_helper (DockManagerDaemonInterface* self, const gchar* path, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp17_;
	if (((DockManagerDaemonInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "net.launchpad.DockManager.Daemon", "EnableHelper");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp17_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp17_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp18_;
			_edomain = DBUS_GERROR;
			_tmp18_ = _dbus_error.name + 27;
			if (strcmp (_tmp18_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp18_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp18_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp18_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp18_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp18_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp18_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp18_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp18_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp18_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp18_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp18_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp18_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp18_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp18_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp18_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp18_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp18_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp18_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp18_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp18_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp18_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp18_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp18_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp18_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp18_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp18_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp18_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp18_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp18_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp18_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp18_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp18_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void dock_manager_daemon_interface_dbus_proxy_disable_helper (DockManagerDaemonInterface* self, const gchar* path, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp19_;
	if (((DockManagerDaemonInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "net.launchpad.DockManager.Daemon", "DisableHelper");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp19_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp19_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp20_;
			_edomain = DBUS_GERROR;
			_tmp20_ = _dbus_error.name + 27;
			if (strcmp (_tmp20_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp20_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp20_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp20_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp20_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp20_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp20_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp20_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp20_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp20_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp20_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp20_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp20_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp20_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp20_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp20_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp20_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp20_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp20_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp20_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp20_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp20_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp20_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp20_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp20_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp20_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp20_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp20_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp20_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp20_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp20_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp20_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp20_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void dock_manager_daemon_interface_dbus_proxy_restart_all (DockManagerDaemonInterface* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((DockManagerDaemonInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "net.launchpad.DockManager.Daemon", "RestartAll");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp21_;
			_edomain = DBUS_GERROR;
			_tmp21_ = _dbus_error.name + 27;
			if (strcmp (_tmp21_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp21_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp21_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp21_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp21_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp21_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp21_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp21_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp21_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp21_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp21_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp21_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp21_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp21_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp21_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp21_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp21_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp21_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp21_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp21_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp21_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp21_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp21_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp21_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp21_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp21_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp21_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp21_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp21_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp21_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp21_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp21_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp21_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void dock_manager_daemon_interface_dbus_proxy_install_helper_async (DockManagerDaemonInterface* self, const gchar* filename, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp22_;
	DockManagerDaemonInterfaceDBusProxyInstallHelperData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "net.launchpad.DockManager.Daemon", "InstallHelper");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp22_ = filename;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp22_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (DockManagerDaemonInterfaceDBusProxyInstallHelperData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, dock_manager_daemon_interface_dbus_proxy_install_helper_ready, _data_, NULL);
}


static void dock_manager_daemon_interface_dbus_proxy_install_helper_ready (DBusPendingCall* pending, void* user_data) {
	DockManagerDaemonInterfaceDBusProxyInstallHelperData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (DockManagerDaemonInterfaceDBusProxyInstallHelperData, _data_);
	dbus_pending_call_unref (pending);
}


static gboolean dock_manager_daemon_interface_dbus_proxy_install_helper_finish (DockManagerDaemonInterface* self, GAsyncResult* _res_, GError** error) {
	DockManagerDaemonInterfaceDBusProxyInstallHelperData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	gboolean _result;
	dbus_bool_t _tmp26_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp24_;
			_edomain = DBUS_GERROR;
			_tmp24_ = _dbus_error.name + 27;
			if (strcmp (_tmp24_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp24_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp24_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp24_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp24_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp24_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp24_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp24_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp24_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp24_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp24_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp24_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp24_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp24_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp24_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp24_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp24_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp24_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp24_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp24_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp24_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp24_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp24_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp24_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp24_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp24_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp24_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp24_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp24_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp24_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp24_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp24_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp24_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "b")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "b", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp26_);
	dbus_message_iter_next (&_iter);
	_result = _tmp26_;
	dbus_message_unref (_reply);
	return _result;
}


static void dock_manager_daemon_interface_dbus_proxy_show_preferences (DockManagerDaemonInterface* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((DockManagerDaemonInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "net.launchpad.DockManager.Daemon", "ShowPreferences");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp27_;
			_edomain = DBUS_GERROR;
			_tmp27_ = _dbus_error.name + 27;
			if (strcmp (_tmp27_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp27_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp27_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp27_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp27_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp27_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp27_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp27_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp27_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp27_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp27_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp27_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp27_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp27_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp27_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp27_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp27_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp27_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp27_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp27_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp27_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp27_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp27_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp27_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp27_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp27_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp27_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp27_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp27_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp27_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp27_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp27_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp27_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void dock_manager_daemon_interface_dbus_proxy_embed_preferences (DockManagerDaemonInterface* self, gint64 xid, GHashTable* hints, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_int64_t _tmp28_;
	DBusMessageIter _tmp29_, _tmp30_;
	GHashTableIter _tmp31_;
	gpointer _tmp32_, _tmp33_;
	if (((DockManagerDaemonInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "net.launchpad.DockManager.Daemon", "EmbedPreferences");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp28_ = xid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT64, &_tmp28_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "{sv}", &_tmp29_);
	g_hash_table_iter_init (&_tmp31_, hints);
	while (g_hash_table_iter_next (&_tmp31_, &_tmp32_, &_tmp33_)) {
		gchar* _key;
		GValue* _value;
		const char* _tmp34_;
		DBusMessageIter _tmp35_;
		dbus_message_iter_open_container (&_tmp29_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp30_);
		_key = (gchar*) _tmp32_;
		_value = (GValue*) _tmp33_;
		_tmp34_ = _key;
		dbus_message_iter_append_basic (&_tmp30_, DBUS_TYPE_STRING, &_tmp34_);
		if (G_VALUE_TYPE (_value) == G_TYPE_UCHAR) {
			guint8 _tmp36_;
			dbus_message_iter_open_container (&_tmp30_, DBUS_TYPE_VARIANT, "y", &_tmp35_);
			_tmp36_ = g_value_get_uchar (_value);
			dbus_message_iter_append_basic (&_tmp35_, DBUS_TYPE_BYTE, &_tmp36_);
			dbus_message_iter_close_container (&_tmp30_, &_tmp35_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_BOOLEAN) {
			dbus_bool_t _tmp37_;
			dbus_message_iter_open_container (&_tmp30_, DBUS_TYPE_VARIANT, "b", &_tmp35_);
			_tmp37_ = g_value_get_boolean (_value);
			dbus_message_iter_append_basic (&_tmp35_, DBUS_TYPE_BOOLEAN, &_tmp37_);
			dbus_message_iter_close_container (&_tmp30_, &_tmp35_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_INT) {
			dbus_int32_t _tmp38_;
			dbus_message_iter_open_container (&_tmp30_, DBUS_TYPE_VARIANT, "i", &_tmp35_);
			_tmp38_ = g_value_get_int (_value);
			dbus_message_iter_append_basic (&_tmp35_, DBUS_TYPE_INT32, &_tmp38_);
			dbus_message_iter_close_container (&_tmp30_, &_tmp35_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT) {
			dbus_uint32_t _tmp39_;
			dbus_message_iter_open_container (&_tmp30_, DBUS_TYPE_VARIANT, "u", &_tmp35_);
			_tmp39_ = g_value_get_uint (_value);
			dbus_message_iter_append_basic (&_tmp35_, DBUS_TYPE_UINT32, &_tmp39_);
			dbus_message_iter_close_container (&_tmp30_, &_tmp35_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_INT64) {
			dbus_int64_t _tmp40_;
			dbus_message_iter_open_container (&_tmp30_, DBUS_TYPE_VARIANT, "x", &_tmp35_);
			_tmp40_ = g_value_get_int64 (_value);
			dbus_message_iter_append_basic (&_tmp35_, DBUS_TYPE_INT64, &_tmp40_);
			dbus_message_iter_close_container (&_tmp30_, &_tmp35_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT64) {
			dbus_uint64_t _tmp41_;
			dbus_message_iter_open_container (&_tmp30_, DBUS_TYPE_VARIANT, "t", &_tmp35_);
			_tmp41_ = g_value_get_uint64 (_value);
			dbus_message_iter_append_basic (&_tmp35_, DBUS_TYPE_UINT64, &_tmp41_);
			dbus_message_iter_close_container (&_tmp30_, &_tmp35_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_DOUBLE) {
			double _tmp42_;
			dbus_message_iter_open_container (&_tmp30_, DBUS_TYPE_VARIANT, "d", &_tmp35_);
			_tmp42_ = g_value_get_double (_value);
			dbus_message_iter_append_basic (&_tmp35_, DBUS_TYPE_DOUBLE, &_tmp42_);
			dbus_message_iter_close_container (&_tmp30_, &_tmp35_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_STRING) {
			const char* _tmp43_;
			dbus_message_iter_open_container (&_tmp30_, DBUS_TYPE_VARIANT, "s", &_tmp35_);
			_tmp43_ = g_value_get_string (_value);
			dbus_message_iter_append_basic (&_tmp35_, DBUS_TYPE_STRING, &_tmp43_);
			dbus_message_iter_close_container (&_tmp30_, &_tmp35_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_STRV) {
			const gchar** _tmp44_;
			DBusMessageIter _tmp45_;
			int _tmp46_;
			dbus_message_iter_open_container (&_tmp30_, DBUS_TYPE_VARIANT, "as", &_tmp35_);
			_tmp44_ = g_value_get_boxed (_value);
			dbus_message_iter_open_container (&_tmp35_, DBUS_TYPE_ARRAY, "s", &_tmp45_);
			for (_tmp46_ = 0; _tmp46_ < g_strv_length (g_value_get_boxed (_value)); _tmp46_++) {
				const char* _tmp47_;
				_tmp47_ = *_tmp44_;
				dbus_message_iter_append_basic (&_tmp45_, DBUS_TYPE_STRING, &_tmp47_);
				_tmp44_++;
			}
			dbus_message_iter_close_container (&_tmp35_, &_tmp45_);
			dbus_message_iter_close_container (&_tmp30_, &_tmp35_);
		}
		dbus_message_iter_close_container (&_tmp29_, &_tmp30_);
	}
	dbus_message_iter_close_container (&_iter, &_tmp29_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp48_;
			_edomain = DBUS_GERROR;
			_tmp48_ = _dbus_error.name + 27;
			if (strcmp (_tmp48_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp48_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp48_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp48_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp48_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp48_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp48_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp48_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp48_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp48_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp48_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp48_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp48_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp48_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp48_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp48_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp48_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp48_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp48_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp48_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp48_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp48_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp48_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp48_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp48_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp48_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp48_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp48_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp48_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp48_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp48_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp48_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp48_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void dock_manager_daemon_interface_dbus_proxy_dock_manager_daemon_interface__interface_init (DockManagerDaemonInterfaceIface* iface) {
	iface->get_all_helpers = dock_manager_daemon_interface_dbus_proxy_get_all_helpers;
	iface->enable_helper = dock_manager_daemon_interface_dbus_proxy_enable_helper;
	iface->disable_helper = dock_manager_daemon_interface_dbus_proxy_disable_helper;
	iface->restart_all = dock_manager_daemon_interface_dbus_proxy_restart_all;
	iface->install_helper = dock_manager_daemon_interface_dbus_proxy_install_helper_async;
	iface->install_helper_finish = dock_manager_daemon_interface_dbus_proxy_install_helper_finish;
	iface->show_preferences = dock_manager_daemon_interface_dbus_proxy_show_preferences;
	iface->embed_preferences = dock_manager_daemon_interface_dbus_proxy_embed_preferences;
}


static void _vala_dock_manager_daemon_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void _vala_dock_manager_daemon_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


void dock_manager_helper_info_copy (const DockManagerHelperInfo* self, DockManagerHelperInfo* dest) {
	dest->path = g_strdup (self->path);
	dest->name = g_strdup (self->name);
	dest->description = g_strdup (self->description);
	dest->icon_name = g_strdup (self->icon_name);
	dest->app_name = g_strdup (self->app_name);
	dest->dbus_name = g_strdup (self->dbus_name);
	dest->app_available = self->app_available;
	dest->enabled = self->enabled;
	dest->running = self->running;
}


void dock_manager_helper_info_destroy (DockManagerHelperInfo* self) {
	_g_free0 (self->path);
	_g_free0 (self->name);
	_g_free0 (self->description);
	_g_free0 (self->icon_name);
	_g_free0 (self->app_name);
	_g_free0 (self->dbus_name);
}


DockManagerHelperInfo* dock_manager_helper_info_dup (const DockManagerHelperInfo* self) {
	DockManagerHelperInfo* dup;
	dup = g_new0 (DockManagerHelperInfo, 1);
	dock_manager_helper_info_copy (self, dup);
	return dup;
}


void dock_manager_helper_info_free (DockManagerHelperInfo* self) {
	dock_manager_helper_info_destroy (self);
	g_free (self);
}


GType dock_manager_helper_info_get_type (void) {
	static volatile gsize dock_manager_helper_info_type_id__volatile = 0;
	if (g_once_init_enter (&dock_manager_helper_info_type_id__volatile)) {
		GType dock_manager_helper_info_type_id;
		dock_manager_helper_info_type_id = g_boxed_type_register_static ("DockManagerHelperInfo", (GBoxedCopyFunc) dock_manager_helper_info_dup, (GBoxedFreeFunc) dock_manager_helper_info_free);
		g_once_init_leave (&dock_manager_helper_info_type_id__volatile, dock_manager_helper_info_type_id);
	}
	return dock_manager_helper_info_type_id__volatile;
}



