#!/usr/bin/env perl

# Copyright (c) 2016 DeNA Co., Ltd.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to
# deal in the Software without restriction, including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.

use strict;
use warnings;
use Path::Tiny;

my @mruby_files = @ARGV;

my $out = << 'EOF';
/*
 * DO NOT EDIT! generated by embed_mruby_code.pl
 * Please refer to the respective source files for copyright information.
 */

EOF

for my $path (map { path($_) } grep { $_ =~ /\.rb$/ } @mruby_files) {
    my @lines = $path->lines({ chomp => 1 });

    my $in_license = 1;
    @lines = grep { $in_license = 0 if $_ !~ /^#/; ! $in_license } @lines;
    @lines = grep { $_ =~ /\S/ } @lines;
    @lines = map {
        s/\x5c/\\\\/g;
        s/\x22/\\"/g;
        $_;
    } @lines;

    $out .= "/* $path */\n";
    $out .= "#define H2O_MRUBY_CODE_@{[ uc($path->basename('.rb')) ]} \\\n";
    $out .= join("\n", map { '"' . $_ . '\\n" \\' } @lines);
    $out .= "\n\n";
}
print $out;
