/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __ui_list
#define __ui_list

#include "fader.h"
#include "filled_button.h"
#include "checkbutton.h"
#include "font_editor.h"
#include "field.h"
#include "label.h"
#include "label_field_slider.h"

struct curve_editor;

struct attack_val : val_handler<float> {
  void operator() (const float& f);
};

struct decay_val : val_handler<float> {
  void operator() (const float& f);
};

struct note_volume_val : val_handler<float> {
  void operator() (const float& f);
};

struct pitch_bend_val : val_handler<int> {
  void operator() (const int& f);
};

template <typename T> struct min_max_clicked : click_listener, change_listener<field> {
  label_field_slider<T>& lfs;
  min_max_clicked (label_field_slider<T>& _lfs);
  void clicked (button& b);
  void changed (field& f);
};


struct din;

struct voice__listener : state_listener {
  void changed (checkbutton& cb);
};

struct gater__listener : state_listener {
  void changed (checkbutton& cb);
};

struct delay__listener : state_listener {
  void changed (checkbutton& cb);
};

struct compress__listener : state_listener {
  void changed (checkbutton& cb);
};

struct ui_list : ui {

  std::vector<ui*> uis;
  ui *current, *prev;

  curve_editor* crved;

  font_editor fed;

  static const int MAX_EDITORS = 7;
  static const int key [MAX_EDITORS];
  static ui* ed [MAX_EDITORS];

  float esct;

  ui_list ();

  void set_current (ui* u, int ised = 1);
  bool set_editor (const std::string& name, int screen);

  bool handle_input ();
  void draw ();

  // gui widgets
  //
  std::vector<widget*> widgets;

  checkbutton w_voice;
  voice__listener vlis;
  fader fdr_voice;

  checkbutton w_gater;
  gater__listener glis;
  fader fdr_gater;
  void flash_gater ();

  checkbutton w_delay;
  delay__listener dlis;
  fader fdr_delay;

  checkbutton w_compress;
  compress__listener clis;

  attack_val atv;
  decay_val dkv;
  pitch_bend_val pbv;
  note_volume_val nvv;

  label d_parameters;
  label_field_slider<float> lfs_attack_time;
  label_field_slider<float> lfs_decay_time;
  label_field_slider<int> lfs_pitch_bend;
  label_field_slider<float> lfs_note_volume;

  label d_min_max;
  label mml_min, mml_max;
  field mmf_min, mmf_max;
  static widget* mm_last;
  min_max_clicked<float> lmm_attack, lmm_decay;
  min_max_clicked<int> lmm_pitch_bend;
  min_max_clicked<float> lmm_note_volume;

  void setup_widgets ();
  void update_widgets ();
  float eval_fade (fader& fdr, checkbutton& cb);
  widget* get_widget (const std::string& name);

  ~ui_list ();
};

template <typename T> void widget_load (const std::string& name, T** pw, int n);
template <typename T> void widget_save (const std::string& name, T** pw, int n);

#endif
