/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __color
#define __color

#include "dingl.h"
#include "random.h"

struct color {
  float r, g, b;
  color& operator*= (float v) {
    r *= v;
    g *= v;
    b *= v;
    return *this;
  }
  color (float rr = 0, float gg = 0, float bb = 0) {
    r = rr;
    g = gg;
    b = bb;
  }
  color (const color& t, const color& s) {
		r = t.r - s.r;
		g = t.g - s.g;
		b = t.b - s.b;
	}
  
};

inline void hex2rgb (unsigned char hr, unsigned char hg, unsigned char hb, double& r, double& g, double& b) {
  const unsigned char ff = 0xff;
  const double ff1 = 1.0 / ff;
  r = hr * ff1;
  g = hg * ff1;
  b = hb * ff1;
}

inline void set_rnd_color (float& r, float& g, float& b, float m0 = 0, float m1 = 1) {
	rnd<float> rd (m0, m1);
	r = rd(); g = rd (); b = rd ();
}

inline void setcolor (unsigned char hr, unsigned char hg, unsigned char hb, float a = 1) {
  double r, g, b;
  hex2rgb (hr, hg, hb, r, g, b);
  glColor4f (r, g, b, a);
}


inline void blend_color (const color& source, const color& target, color& result, float amount) {
	color delta (target, source);
	delta *= amount; 
	result.r = source.r + delta.r; 
	result.g = source.g + delta.g;
	result.b = source.b + delta.b;
}

#endif
