/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __box_selector
#define __box_selector

#include "box.h"
#include <GL/gl.h>

template <class T> struct box_selector {

  box<T> region;
  int exists;

  void begin (T x, T y) {
    region.left = x;
    region.bottom = y;
    exists = 1;
  }

  void update (T x, T y) {
    region.right = x;
    region.top = y;

  }

  void end () {
    region.calc ();
    exists = 0;
  }

  void draw () {
    glColor3f (1, 1, 1);
    if (exists) {
      glBegin (GL_LINE_LOOP);
        glVertex2i (region.left, region.bottom);
        glVertex2i (region.right, region.bottom);
        glVertex2i (region.right, region.top);
        glVertex2i (region.left, region.top);
      glEnd ();
    }
  }

  int handle_input (T x, T y) {
    extern int lmb;
    if (lmb) {
      if (!exists) {
        begin (x, y);
        return 0;
      } else {
        update (x, y);
        return 0;
      }
    } else if (exists) {
      end ();
      return 1;
    }
    return 0;
  }

};

#endif
