/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#include "osc.h"
#include "din.h"
#include "console.h"
#include "command.h"
#include "tokenizer.h"
#include "tcl_interp.h"
#include <sys/time.h>

using namespace std;

extern cmdlist cmdlst;

bool oserver::operator() (tokenizer& tz) {

  string port; tz >> port;

  int pt = atoi (port.c_str());

  const int MIN_VALID_PORT = 1024;
  if (pt < MIN_VALID_PORT) {
    cons << console::red << "bad port number: " << pt << ", minimum valid port = " << MIN_VALID_PORT << eol;
    return false;
  }

  float msecs; tz >> msecs;
  if (msecs <= 0) msecs = 1;

  if (server) {
    cons << console::yellow << "closing osc server" << eol;
    lo_server_free (server);
  }

  server = lo_server_new (port.c_str(), 0);
  lo_server_add_method (server, 0, 0, command_handler, 0);

  lo_fd = lo_server_get_socket_fd (server);
  if (lo_fd) {
    cons << console::green << "server started at " << port << ", command timeout is " << msecs << " msecs." << eol;
    tv.tv_sec = 0;
    tv.tv_usec = (__suseconds_t ) (msecs * 1000);
    enabled = true;
    msg = true;
    return true;
  } else cout << "could not create server" << endl;

  return false;

}

void oserver::handle_requests () {
  if (lo_fd > 0) {
    FD_ZERO (&rfds);
    FD_SET (lo_fd, &rfds);
    int retval = select (lo_fd + 1, &rfds, 0, 0, &tv);
    if (retval == -1) return;
    lo_server_recv_noblock (server, 0);
  }
}

void oserver::toggle () {
  enabled = !enabled;
}

oserver::~oserver () {
  if (server) lo_server_free (server);
}

int command_handler (const char *path, const char *types, lo_arg **argv, int argc, void *data, void *user_data) {
  cons (path);
  return 1;
}

bool oconnect::operator() (tokenizer& tz) {

  string ip, port;
  tz >> ip >> port;

  client = lo_address_new (ip.c_str(), port.c_str());
  if (!client) {
    cons << console::red << "failed to connect: " << ip << " at " << port << eol;
    return false;
  } else cons << console::green << "connected to: " << ip << " at " << port << eol;
  return true;
}

bool osend::operator() (tokenizer& tz) {
  if (client) {
    string cmd (tz.cur2end ());
    lo_send (client, cmd.c_str(), "s", cmd.c_str());
    return true;
  } else {
    cons << console::red << "connect to osc server first" << eol;
    return false;
  }
}

void osc () {

  extern oserver srv;
  srv.handle_requests ();

}


