/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __RANGE
#define __RANGE

#include "box.h"
#include "note.h"
#include "color.h"
#include <string>
#include <map>

struct range {

  //
  // a range of tones from one note to another (both included).
  // the tones between the notes are the microtones.
  //

  box<int> extents; // range extents ie rectangle

  note notes[2]; // end notes

  std::string intervals[2]; // interval names of end notes (see ~/.din/*.tuning files)

  enum {NONE = -1, LEFT, RIGHT, BOTH};
  int key;

  float delta_octave_position; // difference of octave position of the end notes
  float delta_step; // difference of step values ie pitch/frequency of the end notes (see note.h)

  void calc (int octave, float start, std::map<std::string, float>& _intervals);

  // draw labels
  std::string octave;
  static const int spacer = 5;
  static int char_height, ybot1, ybot2, ytop1, ytop2;
  void draw_labels (int label_what = LEFT, int show_frequency = 0);


};

#endif
