/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __line
#define __line

#include <vector>
#include "point.h"

struct line {
  std::vector< point<int> > points;
  line () {}
  line (const std::vector< point<int> >& pts) : points(pts) {}
  line (const std::vector< point<float> >& pts) {
    points.clear ();
    for (unsigned int i = 0, j = pts.size(); i < j; ++i) {
      points.push_back (point<int>((int)pts[i].x, (int)pts[i].y));
    }
  }
  void draw ();
  void set (int i, int x, int y);
  void insert (int i, int x, int y);
  int remove (int i);
};

#endif
